"use strict";
var __extends = (this && this.__extends) || function (d, b) {
  for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
  function __() { this.constructor = d; }
  d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
function ts() {
  return new Date().YYYYMMDDHHMMSSmmm() + " : ";
}
function ts1() {
  return new Date().YYYYMMDDHHMMSSmmm();
}
const fs = require("fs");
const SoapService = require('../lib/SoapService');
const utils_1 = require('../lib/utils');
const url = require('url');
//const v4l2ctl_1 = require('../lib/v4l2ctl'); /* v4l2ctl_1 only for camera */
//const child_process_1 = require('child_process');
const utils = utils_1.Utils.utils;
const util = require('util'); // inspect
var MediaService = (function (_super) {
  __extends(MediaService, _super);
  function MediaService(config, server, LE880process) {
    _super.call(this, config, server, LE880process);
    this.webserver = server;
    //this.ffmpeg_process = null;
    //this.ffmpeg_responses = [];
    this.media_service = require('./stubs/media_service.js').MediaService;
    this.LE880process = LE880process;
    this.serviceOptions = {
      path: '/onvif/media_service',
      services: this.media_service,
      xml: fs.readFileSync('./wsdl/media_service.wsdl', 'utf8'),
      wsdlPath: 'wsdl/media_service.wsdl',
      uri: 'wsdl/media_service.wsdl',
      //forceSoap12Headers: true,
      onReady: function () {
        utils.log.info(ts() + 'media_service.js onReady');
      }
    };
    this.extendService();
  }
  MediaService.prototype.starting = function () {
    /*
    var _this = this;
    var listeners = this.webserver.listeners('request').slice();
    this.webserver.removeAllListeners('request');
    this.webserver.addListener('request', function (request, response, next) {
      utils.log.debug('media_service.js web request received : %s', request.url);
      var uri = url.parse(request.url, true);
      var action = uri.pathname;
      for (var i = 0, len = listeners.length; i < len; i++) {
        listeners[i].call(_this, request, response, next);
      }
    }); // this.webserver.addListener
    */
  }; // MediaService.prototype.starting
  MediaService.prototype.extendService = function () {
    let _this = this;
    let port = this.media_service.MediaService.Media;
    let ONVIF = null;
    if (fs.existsSync("/home/pi/LE880-Profile-T/json/ONVIF.json")) {
      ONVIF = require('/home/pi/LE880-Profile-T/json/ONVIF.json');
    }
    //utils.log.debug(ts()+'media_service.js port: ' + util.inspect(port, {showHidden: false, depth: null}));
    let LE880processOptions = this.LE880process.options;
    let LE880processSettings = this.LE880process.settings;
    let LE880process = this.LE880process;
    let h264Profiles = ['Baseline', 'Constrained Baseline', 'Main', 'High'];
    //utils.log.debug(ts()+'media_service.js h264Profiles: ' + util.inspect(h264Profiles));
    let configUser = require(process.cwd() + "/LE880userConfig.json");
    h264Profiles.splice(1, 1);
    //
    // use small size for logo, 1 fps for image
    //
    let ip = utils.getIpAddress().split(".");
    let videoSource = {
      attributes: {
        token: "video_src_token"
      },
      Framerate: (ONVIF) ? ONVIF.Media.Video.FrameRate : 30,
      //Resolution: { Width: 320, Height: 240 }
      Resolution: {
        Width: (ONVIF) ? ONVIF.Media.Video.Width : 320,
        Height: (ONVIF) ? ONVIF.Media.Video.Height : 240
      }
    };
    let videoSourceConfiguration = {
      attributes: {
        token: "video_src_config_token",
      },
      Name: "Primary Source",
      UseCount: 0,
      SourceToken: "video_src_token",
      //Bounds: { attributes: { x: 0, y: 0, width: 320, height: 240 } }
      Bounds: {
        attributes: {
          x: 0,
          y: 0,
          width: (ONVIF) ? ONVIF.Media.Video.Width : 320,
          height: (ONVIF) ? ONVIF.Media.Video.Height : 240
        }
      }
    };
    let videoSourceConfigurationOptions = {
      attributes: {
        MaximumNumberOfProfiles: 1
      },
      BoundsRange: {
        XRange: {
          Min: 0,
          Max: 0
        },
        YRange: {
          Min: 0,
          Max: 0
        },
        WidthRange: {
          //Min: (ONVIF) ? ONVIF.Media.Video.Width : 320,
          Min: 320,
          Max: (ONVIF) ? ONVIF.Media.Video.Width : 320
        },
        HeightRange: {
          //Min: (ONVIF) ? ONVIF.Media.Video.Height : 240,
          Min: 240,
          Max: (ONVIF) ? ONVIF.Media.Video.Height : 240
        }
      },
      VideoSourceTokensAvailable: "video_src_token",

    }
    let videoEncoderConfiguration = {
      attributes: {
        token: "video_encoder_config_token",
        GuaranteedFrameRate: (ONVIF) ? ONVIF.Media.Video.GuaranteedFrameRate : true,
      },
      Name: "H264",
      UseCount: 0,
      Encoding: (ONVIF) ? ONVIF.Media.Video.Encoding : "H264",
      Resolution: {
        //Width: 320, Height: 240
        Width: (ONVIF) ? ONVIF.Media.Video.Width : 320,
        Height: (ONVIF) ? ONVIF.Media.Video.Height : 240
      },
      Quality: 1,
      //Quality: 0,
      //RateControl: { FrameRateLimit: 1, EncodingInterval: 1, BitrateLimit: 60 },
      /*RateControl: {
        FrameRateLimit: (ONVIF) ? ONVIF.Media.Video.FrameRateLimit : 30,
        //EncodingInterval: (ONVIF) ? ONVIF.Media.Video.EncodingInterval : 1,
        //BitrateLimit: (ONVIF) ? ONVIF.Media.Video.BitrateLimit : 4096
      },*/
      /*
      H264: {
        GovLength: (ONVIF) ? ONVIF.Media.Video.GovLength : 60,
        H264Profile: (ONVIF) ? ONVIF.Media.Video.H264Profile : "Baseline"
      },*/

      Multicast: {
        Address: {
          Type: "IPv4",
          //IPv4Address: "0.0.0.0"
          IPv4Address: `239.${ip[1]}.${ip[2]}.${ip[3]}`
        }, //65535
        Port: 55050,
        TTL: 30,
        AutoStart: true
      },
      SessionTimeout: "PT1000S"
    };
    let JPEGEncoderConfiguration = {
      attributes: {
        token: "video_encoder_config_token",
        GuaranteedFrameRate: (ONVIF) ? ONVIF.Media.Video.GuaranteedFrameRate : true,
      },
      Name: "JPEG",
      UseCount: 0,
      Encoding: "JPEG",
      Resolution: {
        //Width: 320, Height: 240
        Width: (ONVIF) ? ONVIF.Media.Video.Width : 320,
        Height: (ONVIF) ? ONVIF.Media.Video.Height : 240
      },
      Quality: 1,
      SessionTimeout: "PT1000S"
    };
    let videoEncoderMulticastConfiguration = {
      attributes: {
        token: "video_encoder_multicast_config_token",
        GuaranteedFrameRate: (ONVIF) ? ONVIF.Media.Video.GuaranteedFrameRate : true,
      },
      Name: "H264",
      UseCount: 0,
      Encoding: (ONVIF) ? ONVIF.Media.Video.Encoding : "H264",
      Resolution: {
        //Width: 320, Height: 240
        Width: (ONVIF) ? ONVIF.Media.Video.Width : 320,
        Height: (ONVIF) ? ONVIF.Media.Video.Height : 240
      },
      Quality: 1,
      //Quality: 0,
      //RateControl: { FrameRateLimit: 1, EncodingInterval: 1, BitrateLimit: 60 },
      RateControl: {
        FrameRateLimit: (ONVIF) ? ONVIF.Media.Video.FrameRateLimit : 30,
        //EncodingInterval: (ONVIF) ? ONVIF.Media.Video.EncodingInterval : 1,
        //BitrateLimit: (ONVIF) ? ONVIF.Media.Video.BitrateLimit : 4096
      },
      H264: {
        GovLength: (ONVIF) ? ONVIF.Media.Video.GovLength : 60,
        H264Profile: (ONVIF) ? ONVIF.Media.Video.H264Profile : "Baseline"
      },
      Multicast: {
        Address: {
          Type: "IPv4",
          //IPv4Address: "0.0.0.0"
          IPv4Address: `239.${ip[1]}.${ip[2]}.${ip[3]}`
        }, //65535
        Port: 55050,
        TTL: 30,
        AutoStart: true
      },
      SessionTimeout: "PT1000S"
    };
    let videoEncoderSecondaryConfiguration = {
      attributes: {
        token: "video_encoder_secondary_config_token",
        GuaranteedFrameRate: (ONVIF) ? ONVIF.Media.Video.GuaranteedFrameRate : true,
      },
      Name: "H264 SECONDARY",
      UseCount: 0,
      Encoding: (ONVIF) ? ONVIF.Media.Video.Encoding : "H264",
      Resolution: {
        Width: 320,
        Height: 240
      },
      Multicast: {
        Address: {
          Type: "IPv4",
          //IPv4Address: "0.0.0.0"
          IPv4Address: `239.${ip[1]}.${ip[2]}.${ip[3]}`
        }, //65535
        Port: 55060,
        TTL: 30,
        AutoStart: true
      },
      Quality: 1,
      SessionTimeout: "PT1000S"
    };
    let videoEncoderConfigurationOptions = {
      attributes: {
        GuaranteedFrameRateSupported: true
      },
      QualityRange: {
        Min: 0,
        Max: (ONVIF) ? ONVIF.Media.Video.QualityLimit : 1
      },

      H264: {
        //ResolutionsAvailable: { Width: 320, Height: 240 },
        ResolutionsAvailable: {
          Width: (ONVIF) ? ONVIF.Media.Video.Width : 320,
          Height: (ONVIF) ? ONVIF.Media.Video.Height : 240
        },
        GovLengthRange: {
          Min: 0,
          Max: (ONVIF) ? ONVIF.Media.Video.GovLengthLimit : 100
        },
        FrameRateRange: {
          Min: 0,
          Max: (ONVIF) ? ONVIF.Media.Video.FrameRateLimit : 30
        },
        EncodingIntervalRange: {
          Min: 0,
          Max: (ONVIF) ? ONVIF.Media.Video.EncodingIntervalLimit : 1
        },
        H264ProfilesSupported: (ONVIF) ? ONVIF.Media.Video.H264ProfilesSupported : ["Baseline"]
        //H264ProfilesSupported: [(ONVIF) ? ONVIF.Media.Video.H264Profile : "Baseline"]
      },
      /*
      Extension: {
        H264: {
          //ResolutionsAvailable: { Width: 320, Height: 240 },
          ResolutionsAvailable: {
            Width: (ONVIF) ? ONVIF.Media.Video.Width : 320,
            Height: (ONVIF) ? ONVIF.Media.Video.Height : 240
          },
          GovLengthRange: {
            Min: 0,
            Max: (ONVIF) ? ONVIF.Media.Video.GovLength : 100
          },
          FrameRateRange: {
            Min: 1,
            Max: (ONVIF) ? ONVIF.Media.Video.FrameRateLimit : 30
          },
          EncodingIntervalRange: {
            Min: (ONVIF) ? ONVIF.Media.Video.EncodingInterval : 1,
            Max: (ONVIF) ? ONVIF.Media.Video.EncodingInterval : 1
          },
          H264ProfilesSupported: [(ONVIF) ? ONVIF.Media.Video.H264Profile : "Baseline"],
          BitrateRange: {
            Min: 512,
            Max: (ONVIF) ? ONVIF.Media.Video.BitrateLimit : 4096
          }
        }
      }*/
    };
    let videoEncoderSecondaryConfigurationOptions = {
      attributes: {
        GuaranteedFrameRateSupported: true
      },
      QualityRange: {
        Min: 0,
        Max: (ONVIF) ? ONVIF.Media.Video.QualityLimit : 1
      },

      H264: {
        //ResolutionsAvailable: { Width: 320, Height: 240 },
        ResolutionsAvailable: {
          Width: 320,
          Height: 240
        },
        GovLengthRange: {
          Min: 0,
          Max: (ONVIF) ? ONVIF.Media.Video.GovLengthLimit : 100
        },
        FrameRateRange: {
          Min: 1,
          Max: (ONVIF) ? ONVIF.Media.Video.FrameRateLimit : 30
        },
        EncodingIntervalRange: {
          Min: 0,
          Max: (ONVIF) ? ONVIF.Media.Video.EncodingIntervalLimit : 1
        },
        H264ProfilesSupported: [(ONVIF) ? ONVIF.Media.Video.H264Profile : "Baseline"]
      },
      /*
      Extension: {
        H264: {
          //ResolutionsAvailable: { Width: 320, Height: 240 },
          ResolutionsAvailable: {
            Width: (ONVIF) ? ONVIF.Media.Video.Width : 320,
            Height: (ONVIF) ? ONVIF.Media.Video.Height : 240
          },
          GovLengthRange: {
            Min: 0,
            Max: (ONVIF) ? ONVIF.Media.Video.GovLength : 100
          },
          FrameRateRange: {
            Min: 1,
            Max: (ONVIF) ? ONVIF.Media.Video.FrameRateLimit : 30
          },
          EncodingIntervalRange: {
            Min: (ONVIF) ? ONVIF.Media.Video.EncodingInterval : 1,
            Max: (ONVIF) ? ONVIF.Media.Video.EncodingInterval : 1
          },
          H264ProfilesSupported: [(ONVIF) ? ONVIF.Media.Video.H264Profile : "Baseline"],
          BitrateRange: {
            Min: 512,
            Max: (ONVIF) ? ONVIF.Media.Video.BitrateLimit : 4096
          }
        }
      }*/
    };
    let audioSource = {
      attributes: {
        token: "audio_src_token"
      },
      Channels: 1
    };
    let audioSourceConfiguration = {
      attributes: {
        token: "audio_src_config_token"
      },
      Name: "Primary Source",
      UseCount: 0,
      SourceToken: "audio_src_token"
    }
    let audioSourceConfigurationOptions = {
      InputTokensAvailable: "audio_src_token"
    }

    let audioOutputConfiguration = {
      attributes: {
        token: "audio_output_config_token"
      },
      Name: "Primary Source",
      UseCount: 0,
      OutputToken: "audio_output_token",
      OutputLevel: 1
    }
    /* Onvif Media Service Spec v20.06 section 5.23.27 page 79
    <xs:element name="Encoding" type="tt:AudioEncoding"/>
    <xs:element name="Bitrate" type="xs:int"/>
    <xs:element name="SampleRate" type="xs:int"/>
    <xs:element name="Multicast" type="tt:MulticastConfiguration"/>
    <xs:element name="SessionTimeout" type="xs:duration"/>
    */
    let audioEncoderConfiguration = {
      attributes: {
        token: "audio_encoder_config_token"
      },
      Name: "G711",
      UseCount: 0,
      Encoding: (ONVIF) ? ONVIF.Media.Audio.Encoding.replace("-0", "") : "G711",
      Bitrate: (ONVIF) ? ONVIF.Media.Audio.BitRate : 64,
      SampleRate: (ONVIF) ? ONVIF.Media.Audio.SampleRate : 8,
      Multicast: {
        Address: {
          Type: "IPv4",
          //IPv4Address: "0.0.0.0"
          IPv4Address: `239.${ip[1]}.${ip[2]}.${ip[3]}`
        },
        Port: 55052,
        TTL: 30,
        AutoStart: true
      },
      SessionTimeout: "PT1000S"
    }
    let audioEncoderSecondaryConfiguration = {
      attributes: {
        token: "audio_encoder_secondary_config_token"
      },
      Name: "G711",
      UseCount: 0,
      Encoding: (ONVIF) ? ONVIF.Media.Audio.Encoding.replace("-0", "") : "G711",
      Bitrate: (ONVIF) ? ONVIF.Media.Audio.BitRate : 64,
      SampleRate: (ONVIF) ? ONVIF.Media.Audio.SampleRate : 8,
      Multicast: {
        Address: {
          Type: "IPv4",
          //IPv4Address: "0.0.0.0"
          IPv4Address: `239.${ip[1]}.${ip[2]}.${ip[3]}`
        },
        Port: 55062,
        TTL: 30,
        AutoStart: true
      },
      SessionTimeout: "PT1000S"
    }
    let audioEncoderAACConfiguration = {
      attributes: {
        token: "audio_encoder_aac_config_token"
      },
      Name: "AAC",
      UseCount: 0,
      Encoding: "AAC",
      Bitrate: 192,
      SampleRate: 16,
      SessionTimeout: "PT1000S"
    }
    /*let audioMulticastEncoderConfiguration = {
      attributes: {
        token: "audio_multicast_encoder_config_token"
      },
      Name: "Multicast Microphone Configuration",
      UseCount: 0,
      Encoding: "G711",
      Bitrate: 64,
      SampleRate: 8,
      Multicast: {
        Address: {
          Type: "IPv4",
          IPv4Address: configUser.OutgoingUDPMulticastIP
        },
        Port: configUser.OutgoingUDPMulticastPort,
        TTL: 1,
        AutoStart: true
      },
      SessionTimeout: "PT1000S"
    }*/
    let audioOutput = {
      attributes: {
        token: "audio_output_token"
      }
    }
    let audioOutputConfigurationOptions = {
      OutputTokensAvailable: "audio_output_token",
      OutputLevelRange: {
        Min: 1,
        Max: 1
      }
    }
    let audioDecoderConfiguration = {
      attributes: {
        token: "audio_decoder_token"
      },
      Name: "LE880 Speaker",
      UseCount: 0
    }

    let G711DecOptions = {
      Bitrate: [64],
      SampleRateRange: [8]
    }
    let audioEncoderConfigOptions = {
      Encoding: (ONVIF) ? ONVIF.Media.Audio.Encoding.replace("-0", "") : "G711",
      BitrateList: {
        Items: [(ONVIF) ? ONVIF.Media.Audio.BitRate : 64]
      },
      SampleRateList: {
        Items: [(ONVIF) ? ONVIF.Media.Audio.SampleRate : 8]
      }
    };
    let audioEncoderAACConfigOptions = {
      Encoding: "AAC",
      BitrateList: {
        Items: [192]
      },
      SampleRateList: {
        Items: [16]
      }
    };
    /*
    let profile = {
      Name: "H264 640x480 G711",
      attributes: {
        token: "profile_token",
        fixed: true
      },
      VideoSourceConfiguration: videoSourceConfiguration,
      VideoEncoderConfiguration: videoEncoderConfiguration,
      AudioSourceConfiguration: audioSourceConfiguration,
      AudioEncoderConfiguration: audioEncoderConfiguration,
      Extension: {
        AudioOutputConfiguration: audioOutputConfiguration,
        AudioDecoderConfiguration: audioDecoderConfiguration
      }
    };*/
    let profile = {
      Name: "main",
      attributes: {
        token: "profile_token",
        fixed: true
      },
      VideoSourceConfiguration: videoSourceConfiguration,
      VideoEncoderConfiguration: videoEncoderConfiguration,
      AudioSourceConfiguration: audioSourceConfiguration,
      AudioEncoderConfiguration: audioEncoderConfiguration,
      Extension: {
        AudioOutputConfiguration: audioOutputConfiguration,
        AudioDecoderConfiguration: audioDecoderConfiguration
      }
    };
    //Extension: {
    //  AudioOutputConfiguration: audioOutputConfiguration,
    //    AudioDecoderConfiguration: audioDecoderConfiguration
    //}
    let profileSecondary = {
      Name: "H264 320x240 G711",
      attributes: {
        token: "profile_secondary_token",
        fixed: true
      },
      VideoSourceConfiguration: videoSourceConfiguration,
      VideoEncoderConfiguration: videoEncoderSecondaryConfiguration,
      AudioSourceConfiguration: audioSourceConfiguration,
      AudioEncoderConfiguration: audioEncoderSecondaryConfiguration,
      Extension: {
        AudioOutputConfiguration: audioOutputConfiguration,
        AudioDecoderConfiguration: audioDecoderConfiguration
      }
    };
    /*
    let profileAAC = {
      Name: "H264 640x480 AAC",
      attributes: {
        token: "profile_aac_token",
        fixed: true
      },
      VideoSourceConfiguration: videoSourceConfiguration,
      VideoEncoderConfiguration: videoEncoderConfiguration,
      AudioSourceConfiguration: audioSourceConfiguration,
      AudioEncoderConfiguration: audioEncoderAACConfiguration,
      Extension: {
        AudioOutputConfiguration: audioOutputConfiguration,
        AudioDecoderConfiguration: audioDecoderConfiguration
      }
    };*/
    /*let profileMulticast = {
      Name: "Multicast Profile",
      attributes: {
        token: "profile_multicast_token",
        fixed: true
      },
      VideoSourceConfiguration: videoSourceConfiguration,
      AudioSourceConfiguration: audioSourceConfiguration,
      VideoEncoderConfiguration: videoMulticastEncoderConfiguration,
      AudioEncoderConfiguration: audioMulticastEncoderConfiguration
    };*/
    configUser = null;
    port.GetServiceCapabilities = function (args) {
      let GetServiceCapabilitiesResponse = {
        Capabilities: {
          attributes: {
            SnapshotUri: true,
            Rotation: false,
            VideoSourceMode: false,
            OSD: false
          },
          ProfileCapabilities: {
            attributes: {
              MaximumNumberOfProfiles: 2
            }
          },
          StreamingCapabilities: {
            attributes: {
              RTP_RTSP_TCP: true,
              //RTPMulticast: _this.config.MulticastEnabled,
              RTPMulticast: true,
              RTP_TCP: true,
              NonAggregateControl: true,
              NoRTSPStreaming: true,
            }
          }
        }
      };
      return GetServiceCapabilitiesResponse;
    };
    port.GetStreamUri = function (args) {
      //utils.log.detail(ts() + "media_service.js port.GetStreamUri args: " + JSON.stringify(args));
      let rtspAddress = utils.getIpAddress();
      let configUser = require(process.cwd() + "/LE880userConfig.json");
      let Protocol;
      if (args.StreamSetup && args.StreamSetup.Transport && args.StreamSetup.Transport.Protocol) {
        Protocol = args.StreamSetup.Transport.Protocol;
      }

      let URIStream = (args.StreamSetup && args.StreamSetup.Stream) ? args.StreamSetup.Stream : "RTP-Unicast";
      /* must use actual device IP address and not 127.0.0.1
            if (_this.config.RTSPAddress.length > 0){
                rtspAddress = _this.config.RTSPAddress;
      }
      */
      let GetStreamUriResponse = {
        //("rtsp://"  + rtspAddress + ":" + _this.config.RTSPPort + "/"  + _this.config.RTSPName),
        MediaUri: {
          Uri:  //"rtsp://" + rtspAddress + ":" + _this.config.RTSPPort + "/" + _this.config.RTSPName,
            (
              Protocol == "UDP" ? "rtsp://" + rtspAddress + ":" + configUser.RTSPPort + "/" + _this.config.RTSPName :
                //Protocol == "UDP" ? "rtsp://" + rtspAddress + ":" + configUser.RTSPPort + "/" + "udp" :
                //"rtsp://" + rtspAddress + ":8554/test" :
                (URIStream == "RTP-Multicast" && _this.config.MulticastEnabled ?
                  "rtsp://" + rtspAddress + ":" + configUser.RTSPPort + "/" + _this.config.RTSPMulticastName :
                  "rtsp://" + rtspAddress + ":" + configUser.RTSPPort + "/" + _this.config.RTSPName
                )
            ),
          //"rtsp://192.167.0.94:8554/test")),
          InvalidAfterConnect: false,
          InvalidAfterReboot: false,
          Timeout: "PT0S"
        }
      };

      // {"GetStreamUri":{"Protocol":"RtspOverHttp","ProfileToken":"profile_token"}}
      //if (args.ProfileToken && args.ProfileToken == "profile_token" && Protocol == "HTTP") GetStreamUriResponse.MediaUri.Uri = "rtsp://" + rtspAddress + ":" + configUser.RTSPPort + "/rtsp-over-http"
      //if (args.ProfileToken && args.ProfileToken == "profile_token" && Protocol == "HTTP") GetStreamUriResponse.MediaUri.Uri = "http://" + rtspAddress + ":80" + "/rtsp-over-http"
      //if (args.ProfileToken && args.ProfileToken == "profile_token" && (Protocol == "RTSP" || Protocol == "HTTP")) GetStreamUriResponse.MediaUri.Uri = "rtsp://" + rtspAddress + ":" + configUser.RTSPPort + "/main"
      if (args.ProfileToken && args.ProfileToken == "profile_secondary_token") GetStreamUriResponse.MediaUri.Uri = "rtsp://" + rtspAddress + ":" + configUser.RTSPPort + "/sub"
      if (args.ProfileToken && args.ProfileToken == "profile_token" && Protocol == "HTTP") GetStreamUriResponse.MediaUri.Uri = "http://" + rtspAddress + "/" + _this.config.RTSPName
      if (args.ProfileToken && args.ProfileToken == "profile_secondary_token" && Protocol == "HTTP") GetStreamUriResponse.MediaUri.Uri = "http://" + rtspAddress + "/sub"
      if (configUser.VMSConfiguration == "envysion") {
        GetStreamUriResponse["MediaUri"] = "rtsp://" + rtspAddress + ":" + "554" + "/" + _this.config.RTSPName
      }
      console.log(GetStreamUriResponse);
      configUser = null;
      return GetStreamUriResponse;
    };
    port.GetProfile = function (args) {
      //console.log(JSON.stringify(args));
      //let GetProfileResponse = {};
      if (args.ProfileToken == "profile_token") GetProfileResponse = { Profile: profile };
      else if (args.ProfileToken == "profile_secondary_token") GetProfileResponse = { Profile: profileSecondary };

      let GetProfileResponse = { Profile: profile };
      return GetProfileResponse;
    };
    port.GetProfiles = function (args) {
      let GetProfilesResponse = { Profiles: [profile, profileSecondary] };
      //let GetProfilesResponse = { Profiles: [profile] };
      return GetProfilesResponse;
    };
    /*
    port.CreateProfile = function (args) {
      //utils.log.detail(`port.CreateProfile args: ${JSON.stringify(args)}`);
      let CreateProfileResponse = { Profile: profile };
      return CreateProfileResponse;
    };*/
    port.DeleteProfile = function (args) {
      let DeleteProfileResponse = {};
      return DeleteProfileResponse;
    };
    port.GetVideoSources = function (args) {
      //utils.log.detail(`port.GetVideoSources args: ${JSON.stringify(args)}`);
      let GetVideoSourcesResponse = { VideoSources: [videoSource] };
      return GetVideoSourcesResponse;
    };
    port.GetVideoSourceConfigurations = function (args) {
      //utils.log.detail(`port.GetVideoSourceConfigurations args: ${JSON.stringify(args)}`);
      let GetVideoSourceConfigurationsResponse = { Configurations: [videoSourceConfiguration] };
      return GetVideoSourceConfigurationsResponse;
    };
    port.GetVideoSourceConfiguration = function (args) {
      //utils.log.detail(`port.GetVideoSourceConfiguration args: ${JSON.stringify(args)}`);
      let GetVideoSourceConfigurationResponse = { Configuration: videoSourceConfiguration };
      return GetVideoSourceConfigurationResponse;
    };
    port.GetVideoSourceConfigurationOptions = function (args) {
      //utils.log.detail(`port.GetVideoSourceConfigurationOptions args: ${JSON.stringify(args)}`);
      let GetVideoSourceConfigurationOptionsResponse = { Options: videoSourceConfigurationOptions }
      return GetVideoSourceConfigurationOptionsResponse;
    }
    port.GetVideoEncoderConfigurations = function (args) {
      //utils.log.detail(`port.GetVideoEncoderConfigurations args: ${JSON.stringify(args)}`);
      let GetVideoEncoderConfigurationsResponse = { Configurations: [videoEncoderConfiguration, JPEGEncoderConfiguration, videoEncoderSecondaryConfiguration] }; //videoEncoderSecondaryConfiguration videoEncoderMulticastConfiguration
      return GetVideoEncoderConfigurationsResponse;
    };
    port.GetVideoEncoderConfiguration = function (args) {
      //utils.log.detail(`port.GetVideoEncoderConfiguration args: ${JSON.stringify(args)}`);
      if (args.ConfigurationToken == "video_encoder_config_token") return { Configuration: videoEncoderConfiguration };
      //if (args.ConfigurationToken == "video_encoder_multicast_config_token") return { Configuration: videoEncoderMulticastConfiguration };
      else if (args.ConfigurationToken == "jpeg_encoder_config_token") return { Configuration: JPEGEncoderConfiguration };
      else if (args.ConfigurationToken == "video_encoder_secondary_config_token") return { Configuration: videoEncoderSecondaryConfiguration };
      let GetVideoEncoderConfigurationResponse = {};
      return GetVideoEncoderConfigurationResponse;
    };
    port.SetVideoEncoderConfiguration = function (args) {
      //utils.log.detail(`port.SetVideoEncoderConfiguration args: ${JSON.stringify(args)}`);
      let SetVideoEncoderConfigurationResponse = {
        Configuration: videoEncoderConfiguration,
        ForcePersistence: true
      };
      return SetVideoEncoderConfigurationResponse;
    };
    port.GetVideoEncoderConfigurationOptions = function (args) {
      utils.log.detail(`port.GetVideoEncoderConfigurationOptions args: ${JSON.stringify(args)}`);
      if (args && args.ConfigurationToken && args.ConfigurationToken == "video_encoder_config_token") return { Options: videoEncoderConfigurationOptions };
      if (args && args.ConfigurationToken && args.ConfigurationToken == "video_encoder_secondary_config_token") return { Options: videoEncoderSecondaryConfigurationOptions };
      let GetVideoEncoderConfigurationOptionsResponse = {};
      return GetVideoEncoderConfigurationOptionsResponse;
    };
    port.GetGuaranteedNumberOfVideoEncoderInstances = function (args) {
      let GetGuaranteedNumberOfVideoEncoderInstancesResponse = {
        //TotalNumber: 1,
        //H264: 1
      };
      return GetGuaranteedNumberOfVideoEncoderInstancesResponse;
    };
    port.GetSnapshotUri = function (args) { //https://10.10.10.57/images/invertedLogo.png
      let GetSnapshotUriResponse = {
        MediaUri: {
          Uri: "http://" + utils.getIpAddress() + ":" + _this.config.OnvifServicePort + "/snapshot",
          InvalidAfterConnect: false,
          InvalidAfterReboot: false,
          Timeout: "PT0S"
        }
      };
      return GetSnapshotUriResponse;
    };
    port.GetAudioSources = function (args /*, cb, headers*/) {
      //utils.log.detail(`port.GetAudioSources args: ${JSON.stringify(args)}`);
      let GetAudioSourcesResponse = { AudioSources: [audioSource] };
      return GetAudioSourcesResponse;
    };
    port.GetAudioSourceConfigurations = function (args) {
      //utils.log.detail(`port.GetAudioSourceConfigurations args: ${JSON.stringify(args)}`);
      let GetAudioSourceConfigurationsResponse = { Configurations: [audioSourceConfiguration] };
      return GetAudioSourceConfigurationsResponse;
    };
    port.GetAudioSourceConfiguration = function (args) {
      //utils.log.detail(`port.GetAudioSourceConfiguration args: ${JSON.stringify(args)}`);
      let GetAudioSourceConfigurationResponse = { Configurations: audioSourceConfiguration };
      return GetAudioSourceConfigurationResponse;
    };
    port.GetAudioEncoderConfigurationOptions = function (args) {
      //utils.log.detail(`port.GetAudioEncoderConfigurationOptions args: ${JSON.stringify(args)}`);
      let GetAudioEncoderConfigurationOptionsResponse = {
        Options: { Options: [audioEncoderConfigOptions] } //audioEncoderAACConfigOptions
      };
      return GetAudioEncoderConfigurationOptionsResponse;
    };
    port.GetAudioEncoderConfiguration = function (args /*, cb, headers*/) {
      //if (args && args.ConfigurationToken && args.ConfigurationToken == "audio_encoder_aac_config_token") return { Configuration: audioEncoderAACConfiguration };
      //utils.log.detail(`port.GetAudioEncoderConfiguration args: ${JSON.stringify(args)}`);
      //if (args && args.ConfigurationToken && args.ConfigurationToken == "audio_encoder_aac_config_token") return { Configuration: audioEncoderAACConfiguration };
      if (args && args.ConfigurationToken && args.ConfigurationToken == "audio_encoder_config_token") return { Configuration: audioEncoderConfiguration };
      if (args && args.ConfigurationToken && args.ConfigurationToken == "audio_encoder_secondary_config_token") return { Configuration: audioEncoderSecondaryConfiguration };
      let GetAudioEncoderConfigurationResponse = {}
      return GetAudioEncoderConfigurationResponse;
    };
    port.GetAudioEncoderConfigurations = function (args /*, cb, headers*/) {
      //utils.log.detail(`port.GetAudioEncoderConfigurations args: ${JSON.stringify(args)}`);
      let GetAudioEncoderConfigurationsResponse = { Configurations: [audioEncoderConfiguration, audioEncoderSecondaryConfiguration] } // audioEncoderAACConfiguration
      return GetAudioEncoderConfigurationsResponse;
    };
    port.GetAudioOutputs = function (args) {
      //utils.log.detail(`port.GetAudioOutputs args: ${JSON.stringify(args)}`);
      let GetAudioOutputsResponse = { AudioOutputs: [audioOutput] };
      return GetAudioOutputsResponse;
    };
    port.GetAudioOutputConfigurations = function (args /*, cb, headers*/) {
      //utils.log.detail(`port.GetAudioOutputConfigurations args: ${JSON.stringify(args)}`);
      let GetAudioOutputConfigurationsResponse = {
        Configurations: [audioOutputConfiguration]
      };
      return GetAudioOutputConfigurationsResponse;
    };
    port.GetAudioOutputConfigurationOptions = function (args) {
      //utils.log.detail(`port.GetAudioOutputConfigurationOptions args: ${JSON.stringify(args)}`);
      let GetAudioOutputConfigurationOptionsResponse = { Options: audioOutputConfigurationOptions };
      return GetAudioOutputConfigurationOptionsResponse;
    };

    port.GetAudioSourceConfigurationOptions = function (args) {
      //utils.log.detail(`port.GetAudioSourceConfigurationOptions args: ${JSON.stringify(args)}`);
      let GetAudioSourceConfigurationOptionsResponse = { Options: audioSourceConfigurationOptions };
      return GetAudioSourceConfigurationOptionsResponse;
    };
    port.GetAudioOutputConfiguration = function (args /*, cb, headers*/) {
      //utils.log.detail(`port.GetAudioOutputConfiguration args: ${JSON.stringify(args)}`);
      let GetAudioOutputConfigurationResponse = { Configuration: audioOutputConfiguration };
      return GetAudioOutputConfigurationResponse;
    };

    port.GetAudioDecoderConfigurationOptions = function (args) {
      //utils.log.detail(`port.GetAudioDecoderConfigurationOptions args: ${JSON.stringify(args)}`);
      let GetAudioDecoderConfigurationOptionsResponse = { Options: { G711DecOptions: G711DecOptions } };
      return GetAudioDecoderConfigurationOptionsResponse;
    };
    port.GetAudioDecoderConfiguration = function (args) {
      //utils.log.detail(`port.GetAudioDecoderConfiguration args: ${JSON.stringify(args)}`);
      let GetAudioDecoderConfigurationResponse = { Configuration: audioDecoderConfiguration };
      return GetAudioDecoderConfigurationResponse;
    };
    port.GetAudioDecoderConfigurations = function (args) {
      //utils.log.detail(`port.GetAudioDecoderConfigurations args: ${JSON.stringify(args)}`);
      let GetAudioDecoderConfigurationsResponse = { Configurations: [audioDecoderConfiguration] };
      return GetAudioDecoderConfigurationsResponse;
    };
    port.SetAudioEncoderConfiguration = function (args) {
      //utils.log.detail(`port.SetAudioEncoderConfiguration args: ${JSON.stringify(args)}`);
      let SetAudioEncoderConfigurationResponse = { Configuration: audioEncoderConfiguration };
      return SetAudioEncoderConfigurationResponse;
    };
    port.SetAudioOutputConfiguration = function (args) {
      //utils.log.detail(`port.SetAudioOutputConfiguration args: ${JSON.stringify(args)}`);
      let SetAudioOutputConfigurationResponse = { Configuration: audioOutputConfiguration };
      return SetAudioOutputConfigurationResponse;
    };
    port.SetAudioDecoderConfiguration = function (args) {
      //utils.log.detail(`port.SetAudioDecoderConfiguration args: ${JSON.stringify(args)}`);
      let SetAudioDecoderConfigurationResponse = {
        Configuration: audioDecoderConfiguration,
        ForcePersistence: true
      };
      return SetAudioDecoderConfigurationResponse;
    };
    port.GetCompatibleVideoEncoderConfigurations = function (args /*, cb, headers*/) {
      //utils.log.detail(`port.GetCompatibleVideoEncoderConfigurations args: ${JSON.stringify(args)}`);
      let GetCompatibleVideoEncoderConfigurationsResponse = { Configurations: [videoEncoderConfiguration] };
      return GetCompatibleVideoEncoderConfigurationsResponse;
    };
    port.GetCompatibleVideoSourceConfigurations = function (args /*, cb, headers*/) {
      //utils.log.detail(`port.GetCompatibleVideoSourceConfigurations args: ${JSON.stringify(args)}`);
      let GetCompatibleVideoSourceConfigurationsResponse = { Configurations: [videoSourceConfiguration] };
      return GetCompatibleVideoSourceConfigurationsResponse;
    };
    port.GetCompatibleAudioEncoderConfigurations = function (args /*, cb, headers*/) {
      let GetCompatibleAudioEncoderConfigurationsResponse = { Configurations: [audioEncoderConfiguration] };
      return GetCompatibleAudioEncoderConfigurationsResponse;
    };
    port.GetCompatibleAudioSourceConfigurations = function (args /*, cb, headers*/) {
      let GetCompatibleAudioSourceConfigurationsResponse = { Configurations: [audioSourceConfiguration] };
      return GetCompatibleAudioSourceConfigurationsResponse;
    };
    port.GetCompatibleAudioOutputConfigurations = function (args /*, cb, headers*/) {
      let GetCompatibleAudioOutputConfigurationsResponse = { Configurations: [audioOutputConfiguration] };
      return GetCompatibleAudioOutputConfigurationsResponse;
    };
    port.GetCompatibleAudioDecoderConfigurations = function (args /*, cb, headers*/) {
      let GetCompatibleAudioDecoderConfigurationsResponse = { Configurations: [audioDecoderConfiguration] };
      return GetCompatibleAudioDecoderConfigurationsResponse;
    };
    port.AddAudioOutputConfiguration = function (args /*, cb, headers*/) {
      //utils.log.detail(`port.AddAudioOutputConfiguration args: ${JSON.stringify(args)}`);
      let AddAudioOutputConfigurationResponse = {};
      return AddAudioOutputConfigurationResponse;
    },
      port.StartMulticastStreaming = function (args /*, cb, headers*/) {
        //let configUser = require(process.cwd() + "/LE880userConfig.json");
        //let config = require(process.cwd() + "/LE880factoryConfig.json");
        //let cmd = 'su - pi -c "ps aux"';
        let cmd = `sudo ${process.cwd()}/scripts/multicast_enable.sh`;
        exec(cmd, (error, stdout, stderr) => {
          if (error) {
            utils.log.error(ts() + `media_service.js port.StartMulticastStreaming audio UDPMulticast ERROR error: ${error.message}, cmd: ` + cmd);
          }
          if (stderr) {
            utils.log.error(ts() + `media_service.js port.StartMulticastStreaming audio UDPMulticast ERROR stderr: ${stderr}, cmd: ` + cmd);
          }
          utils.log.info(ts() + `media_service.js port.StartMulticastStreaming audio UDPMulticast stdout: ${stdout}, cmd: ` + cmd);
        });

        /*
        try {
          out = execSync(cmd).toString();
          //utils.log.info(ts()+'LE880main.js UserChangeSettings UDPMulticast audio cmd: ' + cmd + ', out: ' + out);
        }
        catch (error) {
          utils.log.warn(ts() + 'media_service.js port.StartMulticastStreaming audio UDPMulticast PROCESS NOT FOUND cmd:' + cmd + ', error.toString(): ' + error.toString());
        }
        unique = `udpsink host=${configUser.OutgoingUDPMulticastIP} auto-multicast=true port=${configUser.OutgoingUDPMulticastPort}`;
        if (out.indexOf(unique) >= 0) {
          utils.log.info(ts() + "media_service.js port.StartMulticastStreaming audio UDPMulticast on unique: " + unique);
        } else {
          let cmd = "gst-launch-1.0 pulsesrc device=alsa_input.platform-soc_sound.analog-stereo volume=1.0 ! ";
          cmd += "mulawenc ! ";
          cmd += "rtppcmupay ! ";
          cmd += `udpsink host=${configUser.OutgoingUDPMulticastIP} auto-multicast=true port=${configUser.OutgoingUDPMulticastPort} sync=false async=false`;
          cmd += " >> /home/pi/LE880-Profile-T/LOG/LE880-rtsp-multicast.log 2>&1 &";
          let cmdMulticast = 'sudo su - pi -c "' + cmd + '"';
          exec(cmdMulticast, (error, stdout, stderr) => {
            if (error) {
              utils.log.error(ts() + `media_service.js port.StartMulticastStreaming audio UDPMulticast ERROR error: ${error.message}, cmd: ` + cmd);
            }
            if (stderr) {
              utils.log.error(ts() + `media_service.js port.StartMulticastStreaming audio UDPMulticast ERROR stderr: ${stderr}, cmd: ` + cmd);
            }
            utils.log.info(ts() + `media_service.js port.StartMulticastStreaming audio UDPMulticast stdout: ${stdout}, cmd: ` + cmd);
          });
        }
        configUser.OutgoingUDPMulticastAutoStart = "true";
        fs.writeFile(process.cwd() + "/LE880userConfig.json", JSON.stringify(configUser), function writeJSON(err) {
          if (err) return console.log(err);
        });*/
        let StartMulticastStreamingResponse = {};
        return StartMulticastStreamingResponse;
      };
    port.StopMulticastStreaming = function (args /*, cb, headers*/) {
      //let configUser = require(process.cwd() + "/LE880userConfig.json");
      //"sudo ip link set dev eth0 multicast off"
      //ifconfig eth0 -multicast
      //"ifconfig eth0 multicast"
      /*let cmd = `sudo pkill -9 -f 'udpsink host=${configUser.OutgoingUDPMulticastIP} auto-multicast=true port=${configUser.OutgoingUDPMulticastPort} sync=false async=false'`; // rtsp race 
      try {
        execSync(cmd);
        utils.log.info(ts() + 'media_service.js port.StartMulticastStreaming cmd: ' + cmd);
      }
      catch (error) {
        utils.log.info(ts() + 'media_service.js port.StartMulticastStreaming PROCESS NOT FOUND cmd:' + cmd + ', error.toString(): ' + error.toString());
      }
      configUser.OutgoingUDPMulticastAutoStart = "false";
      fs.writeFile(process.cwd() + "/LE880userConfig.json", JSON.stringify(configUser), function writeJSON(err) {
        if (err) return console.log(err);
      });*/
      let StopMulticastStreamingResponse = {};
      return StopMulticastStreamingResponse;
    };
  }; // MediaService.prototype.extendService
  return MediaService;
}(SoapService));
module.exports = MediaService;
