"use strict";
var __extends = (this && this.__extends) || function (d, b) {
  for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
  function __() { this.constructor = d; }
  d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
function ts() {
  return new Date().YYYYMMDDHHMMSSmmm() + " : ";
}
function ts1() {
  return new Date().YYYYMMDDHHMMSSmmm();
}
const fs = require("fs");
const SoapService = require('../lib/SoapService');
const utils_1 = require('../lib/utils');
const url = require('url');
//const v4l2ctl_1 = require('../lib/v4l2ctl'); /* v4l2ctl_1 only for camera */
//const child_process_1 = require('child_process');
const utils = utils_1.Utils.utils;
const util = require('util'); // inspect
var Media2Service = (function (_super) {
  __extends(Media2Service, _super);
  function Media2Service(config, server, LE880process) {
    _super.call(this, config, server, LE880process);
    this.webserver = server;
    this.media2_service = require('./stubs/media2_service.js').Media2Service;
    this.LE880process = LE880process;
    this.serviceOptions = {
      path: '/onvif/media2_service',
      services: this.media2_service,
      xml: fs.readFileSync('./wsdl/media2_service.wsdl', 'utf8'),
      wsdlPath: 'wsdl/media2_service.wsdl',
      uri: 'wsdl/media2_service.wsdl',
      //forceSoap12Headers: true,
      onReady: function () {
        utils.log.info(ts() + 'media2_service.js onReady');
      }
    };
    this.extendService();
  }
  Media2Service.prototype.starting = function () {
    /*
    var _this = this;
    var listeners = this.webserver.listeners('request').slice();
    this.webserver.removeAllListeners('request');
    this.webserver.addListener('request', function (request, response, next) {
      utils.log.debug('media2_service.js web request received : %s', request.url);
      var uri = url.parse(request.url, true);
      var action = uri.pathname;
      for (var i = 0, len = listeners.length; i < len; i++) {
        listeners[i].call(_this, request, response, next);
      }
    }); // this.webserver.addListener
    */
  }; // Media2Service.prototype.starting
  /*
  Media2Service.prototype.deliver_jpg = function (response) {
      try {
          var img = fs.readFileSync('/dev/shm/snapshot.jpg');
          response.writeHead(200, { 'Content-Type': 'image/jpg' });
          response.end(img, 'binary');
      }
      catch (err) {
          utils.log.error(ts()+"media2_service.js Error opening snapshot : %s", err);
          var img = fs.readFileSync('web/snapshot.jpg');
          response.writeHead(200, { 'Content-Type': 'image/jpg' });
          response.end(img, 'binary');
      }
  };
  */
  /*
   Media2Service.prototype.started = function () {
     //this.LE880process.startRtsp();
     utils.log.info(ts() + 'media2_service.js Media2Service.prototype.started this.LE880process.startRtsp()');
   };
   */
  Media2Service.prototype.extendService = function () {
    let _this = this;
    let port = this.media2_service.Media2Service.Media2;
    let ONVIF = null;
    //let h264Profiles = ['Baseline', 'Constrained Baseline', 'Main', 'High'];
    let h264Profiles = ['Baseline', 'Constrained Baseline'];
    if (fs.existsSync("/home/pi/LE880-Profile-T/json/ONVIF.json")) {
      ONVIF = require('/home/pi/LE880-Profile-T/json/ONVIF.json');
    }
    //utils.log.debug(ts()+'media2_service.js port: ' + util.inspect(port, {showHidden: false, depth: null}));
    //let LE880processOptions = this.LE880process.options;
    //let LE880processSettings = this.LE880process.settings;
    //utils.log.debug(ts()+'media2_service.js h264Profiles: ' + util.inspect(h264Profiles));
    let framerates = [10.0]; // 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 
    h264Profiles.splice(1, 1);
    let configUser = require(process.cwd() + "/LE880userConfig.json");
    let ip = utils.getIpAddress().split(".");
    let videoEncoderConfigurationOptions = {
      attributes: {
        GuaranteedFrameRateSupported: true,
        GovLengthRange: {
          Min: 0,
          Max: 100
        },
        //FrameRatesSupported: framerates,
        FrameRatesSupported: [(ONVIF) ? ONVIF.Media.Video.FrameRate.toFixed() : 1.0],
        ConstantBitRateSupported: false,
        ProfilesSupported: (ONVIF) ? ONVIF.Media.Video.H264ProfilesSupported : ["Baseline"],
        // ProfilesSupported: [(ONVIF) ? ONVIF.Media.Video.H264Profile : "Baseline"],
      },
      Encoding: (ONVIF) ? ONVIF.Media.Video.Encoding : "H264",
      QualityRange: {
        Min: 1.0,
        Max: 10.0
      },
      //ResolutionsAvailable: { Width: 320, Height: 240 },
      ResolutionsAvailable: [{
        Width: (ONVIF) ? ONVIF.Media.Video.Width : 320,
        Height: (ONVIF) ? ONVIF.Media.Video.Height : 240
      }, {
        Width: 320,
        Height: 240
      }],
      BitrateRange: {
        Min: 1,
        Max: (ONVIF) ? ONVIF.Media.Video.BitrateLimit : 60
      }
    };
    let JPEGConfigurationOptions = {
      attributes: {
        GuaranteedFrameRateSupported: true,
        GovLengthRange: {
          Min: 0,
          Max: 100
        },
        //FrameRatesSupported: [10.0],
        FrameRatesSupported: [(ONVIF) ? ONVIF.Media.Video.FrameRate.toFixed() : 1.0],
        ConstantBitRateSupported: true,
        ProfilesSupported: (ONVIF) ? ONVIF.Media.Video.H264ProfilesSupported : ["Baseline"],
        // ProfilesSupported: [(ONVIF) ? ONVIF.Media.Video.H264Profile : "Baseline"],
      },
      Encoding: "JPEG",
      QualityRange: {
        Min: 1.0,
        Max: 10.0
      },
      //ResolutionsAvailable: { Width: 320, Height: 240 },
      ResolutionsAvailable: [{
        Width: (ONVIF) ? ONVIF.Media.Video.Width : 320,
        Height: (ONVIF) ? ONVIF.Media.Video.Height : 240
      }, {
        Width: 320,
        Height: 240
      }],
      BitrateRange: {
        Min: 1,
        Max: (ONVIF) ? ONVIF.Media.Video.BitrateLimit : 60
      }
    };
    let videoEncoderSecondaryConfigurationOptions = {
      attributes: {
        GuaranteedFrameRateSupported: true,
        GovLengthRange: {
          Min: 0,
          Max: 60
        },
        FrameRatesSupported: [(ONVIF) ? ONVIF.Media.Video.FrameRate.toFixed() : 1.0],
        ConstantBitRateSupported: true,
        ProfilesSupported: [(ONVIF) ? ONVIF.Media.Video.H264Profile : "Baseline"],
      },
      Encoding: (ONVIF) ? ONVIF.Media.Video.Encoding : "H264",
      QualityRange: {
        Min: 1.0,
        Max: 10.0
      },
      //ResolutionsAvailable: { Width: 320, Height: 240 },
      ResolutionsAvailable: [{
        Width: 320,
        Height: 240
      }],
      BitrateRange: {
        Min: 1,
        Max: (ONVIF) ? ONVIF.Media.Video.BitrateLimit : 60
      }
    };
    let videoEncoderConfiguration = {
      attributes: {
        token: "video_encoder_config_token",
        GuaranteedFrameRate: (ONVIF) ? ONVIF.Media.Video.GuaranteedFrameRate : true,
        Profile: (ONVIF) ? ONVIF.Media.Video.H264Profile : "Baseline",
        GovLength: (ONVIF) ? ONVIF.Media.Video.GovLength : 60
      },
      Name: "H264",
      Encoding: (ONVIF) ? ONVIF.Media.Video.Encoding : "H264",
      /*Resolution: {
        Width: 320,
        Height: 240
      }, */
      Resolution: {
        Width: (ONVIF) ? ONVIF.Media.Video.Width : 320,
        Height: (ONVIF) ? ONVIF.Media.Video.Height : 240
      },

      RateControl: {
        attributes: {
          ConstantBitRate: false
        },
        FrameRateLimit: (ONVIF) ? ONVIF.Media.Video.FrameRateLimit.toFixed() : 10.0,
        //BitrateLimit: (ONVIF) ? ONVIF.Media.Video.BitrateLimit.toFixed() : 4096
      },
      Multicast: {
        Address: {
          Type: "IPv4",
          //IPv4Address: "0.0.0.0"
          IPv4Address: `239.${ip[1]}.${ip[2]}.${ip[3]}`
        },
        Port: 55050,
        TTL: 30,
        AutoStart: true
      },
      Quality: (ONVIF) ? ONVIF.Media.Video.Quality.toFixed() : 1.0,
    };
    let videoEncoderMulticastConfiguration = {
      attributes: {
        token: "video_encoder_multicast_config_token",
        GuaranteedFrameRate: (ONVIF) ? ONVIF.Media.Video.GuaranteedFrameRate : true,
        Profile: (ONVIF) ? ONVIF.Media.Video.H264Profile : "Baseline",
        GovLength: (ONVIF) ? ONVIF.Media.Video.GovLength : 60
      },
      Name: "H264",
      Encoding: (ONVIF) ? ONVIF.Media.Video.Encoding : "H264",
      /*Resolution: {
        Width: 320,
        Height: 240
      }, */
      Resolution: {
        Width: (ONVIF) ? ONVIF.Media.Video.Width : 320,
        Height: (ONVIF) ? ONVIF.Media.Video.Height : 240
      },

      RateControl: {
        attributes: {
          ConstantBitRate: false
        },
        FrameRateLimit: (ONVIF) ? ONVIF.Media.Video.FrameRateLimit.toFixed() : 10.0,
        //BitrateLimit: (ONVIF) ? ONVIF.Media.Video.BitrateLimit.toFixed() : 4096
      },
      Multicast: {
        Address: {
          Type: "IPv4",
          //IPv4Address: "0.0.0.0"
          IPv4Address: `239.${ip[1]}.${ip[2]}.${ip[3]}`
        },
        Port: 55050,
        TTL: 30,
        AutoStart: true
      },
      Quality: (ONVIF) ? ONVIF.Media.Video.Quality.toFixed() : 1.0,
    };
    let JPEGEncoderConfiguration = {
      attributes: {
        token: "jpeg_encoder_config_token",
        GuaranteedFrameRate: (ONVIF) ? ONVIF.Media.Video.GuaranteedFrameRate : true,
        Profile: (ONVIF) ? ONVIF.Media.Video.H264Profile : "Baseline",
        GovLength: (ONVIF) ? ONVIF.Media.Video.GovLength : 60
      },
      Name: "JPEG",
      Encoding: "JPEG",
      /*Resolution: {
        Width: 320,
        Height: 240
      }, */
      Resolution: {
        Width: (ONVIF) ? ONVIF.Media.Video.Width : 320,
        Height: (ONVIF) ? ONVIF.Media.Video.Height : 240
      },

      RateControl: {
        attributes: {
          ConstantBitRate: false
        },
        FrameRateLimit: (ONVIF) ? ONVIF.Media.Video.FrameRateLimit.toFixed() : 10.0,
        //BitrateLimit: (ONVIF) ? ONVIF.Media.Video.BitrateLimit.toFixed() : 4096
      },
      Quality: (ONVIF) ? ONVIF.Media.Video.Quality.toFixed() : 1.0,
    };
    let videoEncoderSecondaryConfiguration = {
      attributes: {
        token: "video_encoder_secondary_config_token",
        GuaranteedFrameRate: (ONVIF) ? ONVIF.Media.Video.GuaranteedFrameRate : true,
        Profile: (ONVIF) ? ONVIF.Media.Video.H264Profile : "Baseline",
        GovLength: (ONVIF) ? ONVIF.Media.Video.GovLength : 60
      },
      Name: "H264 SECONDARY",
      Encoding: (ONVIF) ? ONVIF.Media.Video.Encoding : "H264",
      Resolution: {
        Width: 320,
        Height: 240
      },
      Multicast: {
        Address: {
          Type: "IPv4",
          //IPv4Address: "0.0.0.0"
          IPv4Address: `239.${ip[1]}.${ip[2]}.${ip[3]}`
        },
        Port: 55060,
        TTL: 30,
        AutoStart: true
      },
      Quality: (ONVIF) ? ONVIF.Media.Video.Quality.toFixed() : 1.0,
    };
    //
    // use small size for logo, 1 fps for image
    //
    let videoSource = {
      attributes: {
        token: "video_src_token"
      },
      Framerate: (ONVIF) ? ONVIF.Media.Video.FrameRate : 30,
      Resolution: {
        Width: (ONVIF) ? ONVIF.Media.Video.Width : 320,
        Height: (ONVIF) ? ONVIF.Media.Video.Height : 240
      }
    };
    let videoSourceConfiguration = {
      Name: "Primary Source",
      attributes: {
        token: "video_src_config_token",
        ViewMode: "lit"
      },
      SourceToken: "video_src_token",
      Bounds: {
        /*attributes: {
          x: 0,
          y: 0,
          width: 320,
          height: 240
        }*/
        attributes: {
          x: 0,
          y: 0,
          width: 640,
          height: 480
        }
      }
    };
    let audioSource = {
      attributes: {
        token: "audio_src_token"
      },
      SampleRate: 8,
      Bitrate: 64
    };
    let audioSourceConfiguration = {
      attributes: {
        token: "audio_src_config_token"
      },
      Name: "Primary Source",
      SourceToken: "audio_src_token"
    }

    let audioEncoderConfiguration = {
      attributes: {
        token: "audio_encoder_config_token"
      },
      Name: "G711",
      //Encoding: (ONVIF) ? ONVIF.Media.Audio.Encoding : "G711-0",
      Encoding: "G711-0",
      Bitrate: (ONVIF) ? ONVIF.Media.Audio.BitRate : 64,
      SampleRate: (ONVIF) ? ONVIF.Media.Audio.SampleRate : 8,
      Multicast: {
        Address: {
          Type: "IPv4",
          //IPv4Address: "0.0.0.0"
          IPv4Address: `239.${ip[1]}.${ip[2]}.${ip[3]}`
        },
        Port: 55052,
        TTL: 30,
        AutoStart: true
      },
      //SampleRate: 16,
    }
    let audioEncoderSecondaryConfiguration = {
      attributes: {
        token: "audio_encoder_secondary_config_token"
      },
      Name: "G711",
      //Encoding: (ONVIF) ? ONVIF.Media.Audio.Encoding : "G711-0",
      Encoding: "G711-0",
      Bitrate: (ONVIF) ? ONVIF.Media.Audio.BitRate : 64,
      SampleRate: (ONVIF) ? ONVIF.Media.Audio.SampleRate : 8,
      Multicast: {
        Address: {
          Type: "IPv4",
          //IPv4Address: "0.0.0.0"
          IPv4Address: `239.${ip[1]}.${ip[2]}.${ip[3]}`
        },
        Port: 55062,
        TTL: 30,
        AutoStart: true
      },
      //SampleRate: 16,
    }
    let audioEncoderAACConfiguration = {
      attributes: {
        token: "audio_encoder_aac_config_token"
      },
      Name: "AAC",
      UseCount: 0,
      Encoding: "AAC",
      Bitrate: 192,
      SampleRate: 16,
      SessionTimeout: "PT1000S"
    }
    let audioEncoderConfigurationOptions = {
      Encoding: (ONVIF) ? ONVIF.Media.Audio.Encoding : "G711-0",
      BitrateList: {
        Items: [(ONVIF) ? ONVIF.Media.Audio.BitRate : 64]
      },
      SampleRateList: {
        Items: [(ONVIF) ? ONVIF.Media.Audio.SampleRate : 8]
      }
    }
    let audioEncoderAACConfigurationOptions = {
      Encoding: "AAC",
      BitrateList: {
        Items: [192]
      },
      SampleRateList: {
        Items: [16]
      }
    }
    /* Onvif Media2 Service Spec v20.06 section 5.23.29 page 80
     * <xs:complexType name="AudioEncoderConfigurationOption">
    <xs:element name="Encoding" type="tt:AudioEncoding"/>
    <xs:element name="BitrateList" type= "tt:IntItems"/>
    <xs:element name="SampleRateList" type= "tt:IntItems"/>
    </xs:complexType>
    */
    //AudioOutput : {
    //attributes : {
    //token : {tt:ReferenceToken}
    //},
    //Name : { xs:string},
    //UseCount : { xs:int}
    //
    //OutputToken : { xs:string},
    //SendPrimacy : { xs:anyURI},
    //OutputLevel : { xs:int}
    //},
    let audioOutputConfiguration = {
      attributes: {
        token: "audio_output_config_token"
      },
      Name: "Primary Source",
      //
      OutputToken: "audio_output_token",
      //SendPrimacy: "www.onvif.org/ver20/HalfDuplex/Client",
      OutputLevel: 1
    }
    let audioDecoderConfiguration = {
      attributes: {
        token: "audio_decoder_token"
      },
      Name: "LE880 Speaker"
    }
    let audioDecoderConfigurationOptions = {
      //Encoding: (ONVIF) ? ONVIF.Media.Audio.Encoding : "G711-0",
      Encoding: "G711-0",
      BitrateList: {
        Items: [(ONVIF) ? ONVIF.Media.Audio.BitRate : 64]
      },
      SampleRateList: {
        Items: [(ONVIF) ? ONVIF.Media.Audio.SampleRate : 8]
      }
    }
    let profile = {
      attributes: {
        token: "profile_token",
        fixed: true
      },
      Name: "H264 640x480",
      Configurations: {
        VideoSource: videoSourceConfiguration,
        AudioSource: audioSourceConfiguration,
        VideoEncoder: videoEncoderConfiguration,
        AudioEncoder: audioEncoderConfiguration,
        AudioOutput: audioOutputConfiguration,
        AudioDecoder: audioDecoderConfiguration,
      }
    };
    
    let profileSecondary = {
      attributes: {
        token: "profile_secondary_token",
        fixed: true
      },
      Name: "H264 320x240",
      Configurations: {
        VideoSource: videoSourceConfiguration,
        AudioSource: audioSourceConfiguration,
        VideoEncoder: videoEncoderSecondaryConfiguration,
        AudioEncoder: audioEncoderConfiguration,
        AudioOutput: audioOutputConfiguration,
        AudioDecoder: audioDecoderConfiguration,
      }
    };
    let profileAAC = {
      Name: "H264 640x480 AAC",
      attributes: {
        token: "profile_aac_token",
        fixed: true
      },
      VideoSourceConfiguration: videoSourceConfiguration,
      VideoEncoderConfiguration: videoEncoderConfiguration,
      AudioSourceConfiguration: audioSourceConfiguration,
      AudioEncoderConfiguration: audioEncoderAACConfiguration,
      Extension: {
        AudioOutputConfiguration: audioOutputConfiguration,
        AudioDecoderConfiguration: audioDecoderConfiguration
      }
    };
    /*let profileMulticast = {
      attributes: {
        token: "profile_multicast_token",
        fixed: true
      },
      Name: "Multicast Audio Profile",
      Configurations: {
        VideoSource: videoSourceConfiguration,
        AudioSource: audioSourceConfiguration,
        VideoEncoder: videoMulticastEncoderConfiguration,
        AudioEncoder: audioMulticastEncoderConfiguration
      }
    };*/
    configUser = null;
    port.GetServiceCapabilities = function (args) {
      let GetServiceCapabilitiesResponse = {
        Capabilities: {
          attributes: {
            SnapshotUri: false,
            Rotation: false,
            VideoSourceMode: false,
            OSD: false,
            TemporaryOSDText: false,
            Mask: false,
            SourceMask: false
          },
          ProfileCapabilities: {
            attributes: {
              MaximumNumberOfProfiles: 2
            }
          },
          StreamingCapabilities: {
            attributes: {
              RTSPStreaming: true,
              //RTPMulticast: _this.config.MulticastEnabled,
              RTPMulticast: true,
              RTP_RTSP_TCP: true,
              NonAggregateControl: true,
              RTSPWebSocketUri: false,
              AutoStartMulticast: true,
              SecureRTSPStreaming: false
            }
          }
        }
      };
      return GetServiceCapabilitiesResponse;
    };
    port.GetStreamUri = function (args) {
      let rtspAddress = utils.getIpAddress();
      let configUser = require(process.cwd() + "/LE880userConfig.json");
      if (args) console.log("GetStreamUri Args: " + JSON.stringify(args));
      let GetStreamUriResponse = {
        Uri: "rtsp://" + rtspAddress + ":" + configUser.RTSPPort + "/" + _this.config.RTSPName
      };
      
      
      //if (args.ProfileToken && args.ProfileToken == "profile_token" && args.Protocol == "RtspOverHttp") GetStreamUriResponse.Uri = "rtsp://" + rtspAddress + ":" + configUser.RTSPPort + "/rtsp-over-http"
      //if (args.ProfileToken && args.ProfileToken == "profile_token" && args.Protocol == "RtspOverHttp") GetStreamUriResponse.Uri = "tcp://" + rtspAddress + ":8080"
      if (args.ProfileToken && args.ProfileToken == "profile_secondary_token") GetStreamUriResponse.Uri = "rtsp://" + rtspAddress + ":" + configUser.RTSPPort + "/sub"
      if (args.ProfileToken && args.ProfileToken == "profile_token" && args.Protocol == "RtspOverHttp") GetStreamUriResponse.Uri = "http://" + rtspAddress + "/main"
      if (args.ProfileToken && args.ProfileToken == "profile_secondary_token" && args.Protocol == "RtspOverHttp") GetStreamUriResponse.Uri = "http://" + rtspAddress + "/sub"
      if (configUser.VMSConfiguration == "envysion") {
        GetStreamUriResponse["Uri"] = "rtsp://" + rtspAddress + ":" + "554" + "/" + _this.config.RTSPName
      }
      //if (args.ProfileToken && (args.ProfileToken == "profile_token" || args.ProfileToken == "profile_secondary_token") && args.Protocol == "RtspOverHttp") GetStreamUriResponse.Uri = "http://" + rtspAddress + ":80" + "/rtsp-over-http"
      console.log(GetStreamUriResponse);
      configUser = null;
      return GetStreamUriResponse;
    };

    port.GetProfiles = function (args) {
      let GetProfilesResponse = {
        Profiles: [profile, profileSecondary] //profileSecondary
      };
      return GetProfilesResponse;
    };
    port.CreateProfile = function (args) {
      let CreateProfileResponse = { Profile: profile };
      return CreateProfileResponse;
    };
    port.DeleteProfile = function (args) {
      let DeleteProfileResponse = {};
      return DeleteProfileResponse;
    };
    port.GetVideoSourceConfigurations = function (args) {
      let GetVideoSourceConfigurationsResponse = { Configurations: [videoSourceConfiguration] };
      return GetVideoSourceConfigurationsResponse;
    };
    port.GetVideoEncoderConfigurations = function (args) {
      //utils.log.detail(`port.GetVideoEncoderConfigurations args: ${JSON.stringify(args)}`);
      let GetVideoEncoderConfigurationsResponse = {
        Configurations: []
      };
      if (args == null || !args.hasOwnProperty("ProfileToken") || args.ProfileToken == "profile_token") {
        if (args == null || !args.hasOwnProperty("ConfigurationToken") || args.ConfigurationToken == "video_encoder_config_token") GetVideoEncoderConfigurationsResponse.Configurations.push(videoEncoderConfiguration);
        //if (args == null || args.ConfigurationToken == "video_encoder_multicast_config_token") GetVideoEncoderConfigurationsResponse.Configurations.push(videoEncoderMulticastConfiguration);
        //if (args == null || !args.hasOwnProperty("ConfigurationToken") || args.ConfigurationToken == "jpeg_encoder_config_token") GetVideoEncoderConfigurationsResponse.Configurations.push(JPEGEncoderConfiguration);
      }
      if (args == null || !args.hasOwnProperty("ProfileToken") || args.ProfileToken == "profile_secondary_token") {
        if (args == null || !args.hasOwnProperty("ConfigurationToken") || args.ConfigurationToken == "video_encoder_secondary_config_token") GetVideoEncoderConfigurationsResponse.Configurations.push(videoEncoderSecondaryConfiguration);
      }

      //let GetVideoEncoderConfigurationsResponse = { Configurations: [videoEncoderConfiguration, JPEGEncoderConfiguration, videoEncoderSecondaryConfiguration] }; //videoEncoderSecondaryConfiguration
      return GetVideoEncoderConfigurationsResponse;
    };
    port.SetVideoEncoderConfiguration = function (args) {
      //utils.log.detail(`port.SetVideoEncoderConfiguration args: ${JSON.stringify(args)}`);
      let SetVideoEncoderConfigurationResponse = { Configuration: videoEncoderConfiguration };
      return SetVideoEncoderConfigurationResponse;
    };
    port.GetVideoEncoderInstances = function (args /*, cb, headers*/) {
      let GetVideoEncoderInstancesResponse = {
        Info: {
          Codec: [{
            Encoding: (ONVIF) ? ONVIF.Media.Video.Encoding : "H264",
            Number: 2
          }],
          Total: 1
        }
      };
      return GetVideoEncoderInstancesResponse;
    };
    port.GetVideoEncoderConfigurationOptions = function (args) {
      utils.log.detail(`port.GetVideoEncoderConfigurationOptions args: ${JSON.stringify(args)}`);
      let GetVideoEncoderConfigurationOptionsResponse = {
        Options: []
      };
      if (args == null || !args.hasOwnProperty("ProfileToken") || !args.ProfileToken || args.ProfileToken == "profile_token") {
        if (args == null || !args.hasOwnProperty("ConfigurationToken") || args.ConfigurationToken == "video_encoder_config_token") GetVideoEncoderConfigurationOptionsResponse.Options.push(videoEncoderConfigurationOptions);
        //if (args == null || !args.hasOwnProperty("ConfigurationToken") || args.ConfigurationToken == "jpeg_encoder_config_token") GetVideoEncoderConfigurationOptionsResponse.Options.push(JPEGConfigurationOptions);
      }
      if (args == null || !args.hasOwnProperty("ProfileToken") || args.ProfileToken == "profile_secondary_token") {
        if (args == null || !args.hasOwnProperty("ConfigurationToken") || args.ConfigurationToken == "video_encoder_secondary_config_token") GetVideoEncoderConfigurationOptionsResponse.Options.push(videoEncoderSecondaryConfigurationOptions);
      }
      //if (args && args.ConfigurationToken && args.ConfigurationToken == "video_encoder_config_token") return { Options: videoEncoderConfigurationOptions };
      //if (args && args.ConfigurationToken && args.ConfigurationToken == "jpeg_encoder_config_token") return { Options: JPEGConfigurationOptions };
      //if (args && args.ConfigurationToken && args.ConfigurationToken == "video_encoder_secondary_config_token") return { Options: videoEncoderSecondaryConfigurationOptions };
      return GetVideoEncoderConfigurationOptionsResponse;
    };
    port.GetSnapshotUri = function (args) {
      let GetSnapshotUriResponse = {
        Media2Uri: {
          Uri: "http://" + utils.getIpAddress() + ":" + _this.config.ServicePort + "/snapshot",
          InvalidAfterConnect: false,
          InvalidAfterReboot: false,
          Timeout: "PT30S"
        }
      };
      return GetSnapshotUriResponse;
    };
    port.GetAudioSourceConfigurations = function (args) {
      let GetAudioSourceConfigurationResponse = { Configurations: audioSourceConfiguration };
      return GetAudioSourceConfigurationResponse;
    };
    port.GetAudioEncoderConfigurationOptions = function (args) {
      let GetAudioEncoderConfigurationOptionsResponse = { Options: [audioEncoderConfigurationOptions] }; //audioEncoderAACConfigurationOptions
      return GetAudioEncoderConfigurationOptionsResponse;
    };
    port.GetAudioEncoderConfigurations = function (args /*, cb, headers*/) {
      console.log("")
      let GetAudioEncoderConfigurationsResponse = {
        Configurations: [] //audioEncoderAACConfiguration
      };
      if (args == null || !args.hasOwnProperty("ProfileToken") || args.ProfileToken == "profile_token") {
        if (args == null || !args.hasOwnProperty("ConfigurationToken") || args.ConfigurationToken == "audio_encoder_config_token") GetAudioEncoderConfigurationsResponse.Configurations.push(audioEncoderConfiguration);
      }
      if (args == null || !args.hasOwnProperty("ProfileToken") || args.ProfileToken == "profile_secondary_token") {
        if (args == null || !args.hasOwnProperty("ConfigurationToken") || args.ConfigurationToken == "audio_encoder_secondary_config_token") GetAudioEncoderConfigurationsResponse.Configurations.push(audioEncoderConfiguration);
      }
      return GetAudioEncoderConfigurationsResponse;
    };
    port.GetAudioOutputConfigurations = function (args /*, cb, headers*/) {
      let GetAudioOutputConfigurationsResponse = {
        Configurations: [audioOutputConfiguration]
        //
      };
      return GetAudioOutputConfigurationsResponse;
    };
    port.GetAudioOutputConfigurationOptions = function (args) {
      let GetAudioOutputConfigurationOptionsResponse = {
        Options: {
          OutputTokensAvailable: "audio_output_token",
          //SendPrimacyOptions: ["www.onvif.org/ver20/HalfDuplex/Client"],
          OutputLevelRange: {
            Min: 1,
            Max: 1
          }
        }

      };
      return GetAudioOutputConfigurationOptionsResponse;
    };
    port.GetAudioSourceConfigurationOptions = function (args) {
      let GetAudioSourceConfigurationOptionsResponse = {
        Options: { InputTokensAvailable: "audio_src_token" }
      };
      return GetAudioSourceConfigurationOptionsResponse;
    };
    port.GetAudioDecoderConfigurationOptions = function (args) {
      let GetAudioDecoderConfigurationOptionsResponse = { Options: audioDecoderConfigurationOptions };
      return GetAudioDecoderConfigurationOptionsResponse;
    };
    port.GetAudioDecoderConfigurations = function (args) {
      let GetAudioDecoderConfigurationsResponse = {
        Configurations: [audioDecoderConfiguration]
      };
      return GetAudioDecoderConfigurationsResponse;
    };
    port.SetAudioEncoderConfiguration = function (args) {
      let SetAudioEncoderConfigurationResponse = { Configuration: audioEncoderConfiguration };
      return SetAudioEncoderConfigurationResponse;
    };
    port.SetAudioOutputConfiguration = function (args) {
      let SetAudioOutputConfigurationResponse = { Configuration: audioOutputConfiguration };
      return SetAudioOutputConfigurationResponse;
    };
    port.SetAudioDecoderConfiguration = function (args) {
      let SetAudioDecoderConfigurationResponse = { Configuration: audioDecoderConfiguration }
      return SetAudioDecoderConfigurationResponse;
    };
    port.AddConfiguration = function (args) {
      let AddConfigurationResponse = {};
      return AddConfigurationResponse;
    };
  }; // Media2Service.prototype.extendService
  return Media2Service;
}(SoapService));
module.exports = Media2Service;
