"use strict";
var __extends = (this && this.__extends) || function (d, b) {
  for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
  function __() { this.constructor = d; }
  d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
function ts() {
  return new Date().YYYYMMDDHHMMSSmmm() + " : ";
}
function ts1() {
  return new Date().YYYYMMDDHHMMSSmmm();
}
function tsONVIF(terminationTime) {
  let date = new Date();
  if (terminationTime) {
    //PT1M60S
    try {
      date.setDate(date.getDate() + 1);
      //date.setTime(3600000);
    } catch (e) {
      console.log(e);
    }
    //date.setSeconds(date.getSeconds + 60);
  }
  let string = date.toISOString();
  date = null;
  return string;
}
const fs = require("fs");
const SoapService = require('../lib/SoapService');
const utils_1 = require('../lib/utils');
const url = require('url');
//const { EventEmitter } = require("node:events");
//const pullPoint = new EventEmitter();
//const v4l2ctl_1 = require('../lib/v4l2ctl'); /* v4l2ctl_1 only for camera */
//const child_process_1 = require('child_process');
const utils = utils_1.Utils.utils;
const util = require('util'); // inspect
const http = require("http");
const { response } = require("express");
const { WSSecurity, createClient } = require("soap");
const { collapseTextChangeRangesAcrossMultipleVersions } = require("typescript");
class Connection {

  constructor(ref) {
    this.ref = ref
    this.messages = [];
    let init = {
      Message: {
        attributes: {
          UtcTime: tsONVIF(),
          PropertyOperation: "Initialized"
        },
        Source: {
          SimpleItem: {
            attributes: {
              Name: "DigitalInputToken",
              Value: "IP1"
            }
          }
        },
        Data: {
          SimpleItem: {
            attributes: {
              Name: "LogicalState",
              Value: false
            }
          }
        }
      }
    }
    this.messages.push(init);
  }
  addMessage(message) {
    this.messages.push(message);
  }
}
class EventContainer {

  constructor() {
    this.connectionsObject = {};
  }
  CreatePullPointSubscription(ref) {
    let currentConnection = new Connection(ref);
    this.connectionsObject[ref] = currentConnection;
  }
}


var EventService = (function (_super) {
  __extends(EventService, _super);
  function EventService(config, server, NotificationClass) {
    _super.call(this, config, server);
    this.webserver = server;
    if (NotificationClass) {
      this.NotificationClass = NotificationClass;
    }
    this.event_service = require('./stubs/event_service.js').EventService;
    this.serviceOptions = {
      path: '/onvif/event_service',
      services: this.event_service,
      xml: fs.readFileSync('./wsdl/event_service.wsdl', 'utf8'),
      wsdlPath: 'wsdl/event_service.wsdl',
      uri: 'wsdl/event_service.wsdl',
      //forceSoap12Headers: true,
      /*ignoredNamespaces: {
        namespaces: ['wstop']
      },*/
      onReady: function () {
        utils.log.info(ts() + 'event_service.js onReady');
      }
    };
    this.extendService();
  }
  /*EventService.prototype.starting = function () {
    var _this = this;
    var listeners = this.webserver.listeners('request').slice();
    this.webserver.removeAllListeners('request');
    this.webserver.addListener('request', function (request, response, next) {
      utils.log.debug('event_service.js web request received : %s', request.url);
      var uri = url.parse(request.url, true);
      var action = uri.pathname;
      for (var i = 0, len = listeners.length; i < len; i++) {
        listeners[i].call(_this, request, response, next);
      }
    }); // this.webserver.addListener
  }; // EventService.prototype.starting
  */
  /*
  EventService.prototype.started = function () {
    utils.log.info(ts() + 'event_service.js EventService.prototype.started this.LE880process.startRtsp()');
  };
  */
  EventService.prototype.extendService = function () {
    //var EventContainer = new EventContainer();
    let _this = this;
    let port = this.event_service.EventService.EventPortType;
    let portPullPointSubscription = this.event_service.EventService.PullPointSubscription;
    let NotificationProducer = this.event_service.EventService.NotificationProducer;
    let SubscriptionManager = this.event_service.EventService.SubscriptionManager;
    let PausableSubscriptionManager = this.event_service.EventService.PausableSubscriptionManager;
    let NotificationClass = this.NotificationClass;
    PausableSubscriptionManager.Renew = function (args /*, cb, headers*/) {
      //console.log("Pausable Subscription Manager Renew");
      var RenewResponse = {};
      return RenewResponse;
    };
    SubscriptionManager.Renew = function (args, cb, headers) {
      //console.log("Subscription Manager Renew args:" + JSON.stringify(args) + " \nHeaders :" + JSON.stringify(headers));
      let RenewResponse = {
        CurrentTime: tsONVIF(),
        TerminationTime: tsONVIF('1')
      };
      return RenewResponse;
    };
    //var Unsubscribe = { };
    SubscriptionManager.Unsubscribe = function (args, cb, headers) {
      console.log("Subscription Manager unsubscribe args:" + JSON.stringify(args) + " \nHeaders :" + JSON.stringify(headers));
      var UnsubscribeResponse = {};
      return UnsubscribeResponse;
    };
    let SubscribeCount = 0;
    NotificationProducer.Subscribe = function (args, cb, headers, req) {
      utils.log.detail(ts() + "NotificationProducer.Subscribe args:" + util.inspect(args));
      utils.log.detail(ts() + "NotificationProducer.Subscribe headers:" + util.inspect(headers));
      utils.log.detail(ts() + "NotificationProducer.Subscribe req:" + util.inspect(req, { sorted: true, depth: 1 }));
      //SubscribeCount++;
      //let CurrentSub = SubscribeCount;
      //?idx=${CurrentSub}`,
      let SubscribeResponse = {
        SubscriptionReference: [{
          Address: `http://${utils.getIpAddress()}:${_this.config.OnvifServicePort}/onvif/event_service`,
          //Address: `http://${utils.getIpAddress()}:${_this.config.OnvifServicePort}/onvif/event_service`,
          //ReferenceParameters: `${CurrentSub}`
        }]
      };
      try {
        return SubscribeResponse;
      } finally {
        if (args && args.ConsumerReference && args.ConsumerReference.Address) {
          const util = require("util");
          //{ endpoint: "http://192.168.1.163:80/onvif/event_service"},
          /*
          SubscriptionReference: {
                  Address: `http://${utils.getIpAddress()}:${_this.config.OnvifServicePort}/onvif/subscription_service`
                },
                Topic: `tns1:Device/Trigger/DigitalInput`,
                ProducerReference: {
                  Address: `http://${utils.getIpAddress()}:${_this.config.OnvifServicePort}/onvif/event_service`
                },
                */
          createClient('./wsdl/notification.wsdl', { endpoint: args.ConsumerReference.Address }, (err, client) => {
            if (err) console.log("ERROR :" + err);
            client.setSecurity(new WSSecurity('admin', 'pass', {
              passwordType: "PasswordDigest",
              hasNonce: true,
              mustUnderstand: true,
              hasTimeStamp: false,
              returnFault: true
            }));
            //ADD TO WSA DESTINATION EPR
            client.addHttpHeader("SOAPAction", "http://docs.oasis-open.org/wsn/bw-2/NotificationConsumer/Notify");
            //{connection: 'keep-alive'}
            client.addHttpHeader("Content-Type", `application/soap+xml; charset=utf-8; action="http://docs.oasis-open.org/wsn/bw-2/NotificationConsumer/Notify"`)
            client.addSoapHeader("connection", 'keep-alive');
            console.log("POST TYPE OF CLIENT_RES " + client.constructor.name);
            console.log(JSON.stringify(client.describe()));
            client.Notify({
              Message: {
                attributes: {
                  UtcTime: tsONVIF(),
                  PropertyOperation: "Initialized"
                },
                "tt:Source": {
                  "tt:SimpleItem": {
                    attributes: {
                      Name: "InputToken",
                      Value: `DI1`
                    }
                  }
                },
                "tt:Data": {
                  "tt:SimpleItem": {
                    attributes: {
                      Name: "LogicalState",
                      Value: false
                    }
                  }
                }
              }
            }, function (err, result, rawResponse, soapHeader, rawRequest) {
              // result is a javascript object
              // rawResponse is the raw xml response string
              // soapHeader is the response soap header as a javascript object
              // rawRequest is the raw xml request string
              console.log("ERR: " + util.inspect(err));
              console.log("result: " + util.inspect(result));
              console.log("rawResponse: " + util.inspect(rawResponse));
              console.log("soapHeader: " + util.inspect(soapHeader));
              console.log("rawRequest: " + util.inspect(rawRequest));
            });
          });
        }
      }
      //return SubscribeResponse;
    };
    port.GetServiceCapabilities = function (args /*, cb, headers*/) {
      let GetServiceCapabilitiesResponse = {
        Capabilities: {
          attributes: {
            WSSubscriptionPolicySupport: false,
            WSPullPointSupport: true,
            WSPausableSubscriptionManagerInterfaceSupport: false,
            MaxNotificationProducers: 1,
            MaxPullPoints: 1,
            PersistentNotificationStorage: false,
            EventBrokerProtocols: "",
            MaxEventBrokers: 1,
            MetadataOverMQTT: false
          }
        }

      };
      return GetServiceCapabilitiesResponse;
    };
    // "tns1:Device/Trigger/Relay"
    // "tns1:Device/Trigger/DigitalInput"

    /*
    TopicSet: [{
          Topic: "tns1:Device/Trigger/DigitalInput",
          'tt:MessageDescription': {
            attributes: {
              IsProperty: true
            },
            'tt:Source': {
              'tt:SimpleItemDescription': {
                attributes: {
                  Name: "InputToken",
                  Type: "tt:ReferenceToken"
                }
              }
            },
            'tt:Data': {
              'tt:SimpleItemDescription': {
                attributes: {
                  Name: "LogicalState",
                  Type: "xs:boolean"
                }
              }
            }
          }
        },
          {
            Topic: "tns1:Device/Trigger/Relay",
            'tt:MessageDescription': {
              attributes: {
                IsProperty: true
              },
              'tt:Source': {
                'tt:SimpleItemDescription': {
                  attributes: {
                    Name: "RelayToken",
                    Type: "tt:ReferenceToken"
                  }
                }
              },
              'tt:Data': {
                'tt:SimpleItemDescription': {
                  attributes: {
                    Name: "LogicalState",
                    Type: "xs:boolean"
                  }
                }
              }
            }
          }],
        */
    //tns1:Device/Trigger/DigitalInput
    port.GetEventProperties = function (args) {
      let GetEventPropertiesResponse = {
        TopicNamespaceLocation: ["http://www.onvif.org/onvif/ver10/topics/topicns.xml"],
        FixedTopicSet: true,
        TopicSet: [{
          "tns1:Device": {
            attributes: {
              "wstop:topic": true
            },
            ":Trigger": {
              attributes: {
                "wstop:topic": true
              },
              ":DigitalInput": {
                attributes: {
                  "wstop:topic": true
                },
                'tt:MessageDescription': {
                  attributes: {
                    IsProperty: true
                  },
                  'tt:Source': {
                    'tt:SimpleItemDescription': {
                      attributes: {
                        Name: "InputToken",
                        Type: "tt:ReferenceToken"
                      }
                    }
                  },
                  'tt:Data': {
                    'tt:SimpleItemDescription': {
                      attributes: {
                        Name: "LogicalState",
                        Type: "xs:boolean"
                      }
                    }
                  }
                }
              },
              ":Relay": {
                'tt:MessageDescription': {
                  attributes: {
                    IsProperty: true
                  },
                  'tt:Source': {
                    'tt:SimpleItemDescription': {
                      attributes: {
                        Name: "RelayToken",
                        Type: "tt:ReferenceToken"
                      }
                    }
                  },
                  'tt:Data': {
                    'tt:SimpleItemDescription': {
                      attributes: {
                        Name: "LogicalState",
                        Type: "xs:boolean"
                      }
                    }
                  }
                }
              }
            }
          }
        }
        ],
        TopicExpressionDialect: ["http://docs.oasis-open.org/wsn/t-1/TopicExpression/Concrete", "http://www.onvif.org/ver10/tev/topicExpression/ConcreteSet"],
        //MessageContentFilterDialect: [""],
        MessageContentFilterDialect: ["http://www.onvif.org/ver10/tev/messageContentFilter/ItemFilter"],
        ProducerPropertiesFilterDialect: ["http://docs.oasis-open.org/wsn/t-1/TopicExpression/Concrete"],
        MessageContentSchemaLocation: ["http://www.onvif.org/onvif/ver10/schema/onvif.xsd"]
      };
      return GetEventPropertiesResponse;
    };

    /*
    port.GetEventProperties = function (args) {
      var GetEventPropertiesResponse = {
        TopicNamespaceLocation: ["http://www.onvif.org/onvif/ver10/topics/topicns.xml"],
        FixedTopicSet: true,
        TopicSet: [{
          "tns1:Device": {
            ":Trigger": {
              ":DigitalInput": {
                attributes: {
                  "wstop:topic": true
                },
                "tt:MessageDescription": {
                  attributes: {
                    IsProperty: true
                  },
                  "tt:Source": {
                    "tt:SimpleItemDescription": {
                      attributes: {
                        Name: "InputToken",
                        Type: "tt:ReferenceToken"
                      }
                    }
                  },
                  "tt:Data": {
                    "tt:SimpleItemDescription": {
                      attributes: {
                        Name: "LogicalState",
                        Type: "xs:boolean"
                      }
                    }
                  }
                }
              }
            }
          }
        }],
        TopicExpressionDialect: ["http://docs.oasis-open.org/wsn/t-1/TopicExpression/Concrete", "http://www.onvif.org/ver10/tev/topicExpression/ConcreteSet"],
        //MessageContentFilterDialect: [""],
        MessageContentFilterDialect: ["http://www.onvif.org/ver10/tev/messageContentFilter/ItemFilter"],
        ProducerPropertiesFilterDialect: ["http://docs.oasis-open.org/wsn/t-1/TopicExpression/Concrete"],
        MessageContentSchemaLocation: ["http://www.onvif.org/onvif/ver10/schema/onvif.xsd"]
      };
      return GetEventPropertiesResponse;
    };*/
    let Subscription = 1;
    port.CreatePullPointSubscription = function (args, cb, headers, req) {
      //utils.log.info(ts() + "CreatePullPointSubscription args:" + JSON.stringify(args));
      //utils.log.info(ts() + "CreatePullPointSubscription headers:" + JSON.stringify(headers));
      //utils.log.info("REQ: " + utils.reduceCircular(req));
      let CreatePullPointSubscriptionResponse = {
        SubscriptionReference: {
          Address: `http://${utils.getIpAddress()}/onvif/event_service?idx=${Subscription}`,
          //Address: `http://${utils.getIpAddress()}/onvif/subscription_service?idx=${Subscription}`,
          ReferenceParameters: Subscription
        },
        CurrentTime: tsONVIF(),
        TerminationTime: tsONVIF('1')
      };
      //EventContainer.CreatePullPointSubscription(Subscription);
      Subscription++;
      return CreatePullPointSubscriptionResponse;
    };
    /*
    port.PullMessages = function (args) {
      utils.log.detail(ts() + "PullMessages args:" + JSON.stringify(args));
      var PullMessagesResponse = {
        Testing: "Better Than Nothing",
      };
      return PullMessagesResponse;
    };
    */
    //
    // PULL POINT SUBSCRIPTION
    //
    let count = 0;
    let value = false;
    portPullPointSubscription.PullMessages = function (args, cb, headers) {
      // PT10S
      //PT00H00M01.007S
      let timeout = 0;
      if (args && args.Timeout) {

        let temp = args.Timeout.replace('PT', '');
        if (temp.includes('H')) {
          temp = temp.split('H')
          //console.log("Temp: " + temp);
          timeout += temp[0] * 3600000
          temp = temp[1]
        }
        if (temp.includes('M')) {
          temp = temp.split('M')
          //console.log("Temp: " + temp);
          timeout += temp[0] * 60000
          temp = temp[1]
        }
        if (temp.includes('S')) {
          temp = temp.split('S')
          //console.log("Temp: " + temp);
          timeout += temp[0] * 1000
          temp = null;
        }
        //console.log("Timeout: " + args.Timeout);
        //let temp = args.Timeout.replace('PT','').replace('S','');
        //console.log ("Timeout Parsed: " + timeout);
        //console.log("Temp: " + temp);
        /*if (!isNaN(temp)){
          timeout = temp * 1000;
        }*/
        //timeout = args.Timeout
      }
      //console.log("Pull Messages timeout: " + timeout + " \nargs: " + JSON.stringify(args));
      let index = -1;
      if (headers && headers.To && headers.To.$value) {
        index = headers.To.$value.split("=").pop();
      }
      //console.log("index = " + index);
      let PullMessagesResponse = NotificationClass.getMessage(index, timeout);
      /*let PullMessagesResponse = {
        CurrentTime: tsONVIF(),
        TerminationTime: tsONVIF('1'),
        NotificationMessage: {
          Topic: "tns1:Device/Trigger/DigitalInput",
          Message: {
            "tt:Message": {
              attributes: {
                UtcTime: tsONVIF(),
                PropertyOperation: "Changed"
              },
              "tt:Source": {
                "tt:SimpleItem": {
                  attributes: {
                    Name: "InputToken",
                    Value: "IP1"
                  }
                }
              },
              "tt:Data": {
                "tt:SimpleItem": {
                  attributes: {
                    Name: "LogicalState",
                    Value: value
                  }
                }
              }
            }
          }
        }
      };
      if (count == 0) {
        PullMessagesResponse = {
          CurrentTime: tsONVIF(),
          TerminationTime: tsONVIF('1'),
          NotificationMessage: {
            Topic: "tns1:Device/Trigger/DigitalInput",
            Message: {
              Message: {
                attributes: {
                  UtcTime: tsONVIF(),
                  PropertyOperation: "Initialized"
                },
                Source: {
                  SimpleItem: {
                    attributes: {
                      Name: "InputToken",
                      Value: "IP1"
                    }
                  }
                },
                Data: {
                  SimpleItem: {
                    attributes: {
                      Name: "LogicalState",
                      Value: false
                    }
                  }
                }
              }
            }
          }
        };
      }
      count++;
      if (count >= 10) {
        value = !value;
        count = 0;
      }
      if (count >= 52) delete PullMessagesResponse["NotificationMessage"]*/
      return PullMessagesResponse;
    };

    //var Seek = { 
    //UtcTime : { xs:dateTime},
    //Reverse : [{ xs:boolean}]
    //
    //};
    portPullPointSubscription.Seek = function (args /*, cb, headers*/) {
      throw NOT_IMPLEMENTED;
      //var SeekResponse = { };
      //return SeekResponse;
    };

    //var SetSynchronizationPoint = { };
    portPullPointSubscription.SetSynchronizationPoint = function (args, cb, headers, req) {
      const url = new URL(req.url, `http://${headers.host}`);
      const index = url.searchParams.get("idx");
      NotificationClass.synchronize(index);
      let SetSynchronizationPointResponse = {};
      return SetSynchronizationPointResponse;
    };

    //var Unsubscribe = { };
    portPullPointSubscription.Unsubscribe = function (args, cb, headers, req) {
      //utils.log.info(ts() + "Unsubscribe args:" + JSON.stringify(args));
      //utils.log.info(ts() + "Unsubscribe headers:" + JSON.stringify(headers));
      // console.log("GET TYPE OF REQ " + req.constructor.name);
      //utils.log.info("REQ: " + utils.reduceCircular(req));
      const url = new URL(req.url, `http://${headers.host}`);
      const index = url.searchParams.get("idx");
      // console.log("GET TYPE OF REQ " + url.constructor.name);
      //console.log("IDX :" + url.searchParams.get("idx"));
      NotificationClass.unsubscribe(index);
      //utils.log.info("URL: " + utils.convertToURL(req.url).search);
      //let url = new URL(req.url);
      //utils.log.info("URL TO JSON: " + JSON.stringify(url.toJSON));
      //utils.log.info("URL SEARCH: " + url.toString);
      let UnsubscribeResponse = {};
      return UnsubscribeResponse;
    };
    //
    //END PULL POINT SUBSCRIPTION
    //

  }; // EventService.prototype.extendService
  return EventService;
}(SoapService));
module.exports = EventService;
