"use strict";
var dgram = require('dgram');
var uuid = require('node-uuid');
var xml2js = require('xml2js');
var utils_1 = require('../lib/utils');
var utils = utils_1.Utils.utils;
const util = require('util'); // inspect
const { existsSync, readFileSync } = require('fs');
function ts() {
    return new Date().YYYYMMDDHHMMSSmmm() + " : ";
}
function ts1() {
    return new Date().YYYYMMDDHHMMSSmmm();
}
var DiscoveryService = (function () {
    function DiscoveryService(config) {
        this.config = config;
    }
    DiscoveryService.prototype.start = function () {
        var _this = this;
        if (process.platform != 'linux') {
            utils.log.info(ts() + "discovery_service.js discovery_service not started (requires linux)");
            return;
        }
        var discover_socket = dgram.createSocket('udp4');
        var reply_socket = dgram.createSocket('udp4');
        delete require.cache[require.resolve(process.cwd() + "/LE880userConfig.json")];
        let configUser = require(process.cwd() + "/LE880userConfig.json");
        /*
        reply_socket.on('message', function (received_msg, rinfo) {
            utils.log.debug(ts()+"discovery_service.js result: " + util.inspect(result, {showHidden: false, depth: null}));
        });*/
        discover_socket.on('error', function (err) {
            console.log(`server error:\n${err.stack}`);
            throw err;
        });
        discover_socket.on('message', function (received_msg, rinfo) {
            //utils.log.debug(ts()+"discovery_service.js Discovery received");
            //utils.log.debug(ts() + "discovery_service.js Discovery received_msg: " + received_msg.toString());
            //utils.log.debug(ts() + "discovery_service.js Discovery received_msg: " + util.inspect(received_msg, { showHidden: false, depth: null }));
            var filtered_msg = received_msg.toString().replace(/xmlns(.*?)=(".*?")/g, '');
            //utils.log.debug(ts() + "discovery_service.js Discovery filtered_msg: " + util.inspect(filtered_msg, { showHidden: false, depth: null }));
            var parseString = xml2js.parseString;
            var strip = xml2js['processors'].stripPrefix;
            parseString(filtered_msg, { tagNameProcessors: [strip] }, function (err, result) {
                //utils.log.debug(ts() + "discovery_service.js result: " + util.inspect(result, { showHidden: false, depth: null }));
                if (!result) return;
                var probe_uuid = "";
                try {
                    probe_uuid = result['Envelope']['Header'][0]['MessageID'][0];
                } catch (err) {
                    probe_uuid = "";
                }
                var probe_type = "";
                try {
                    probe_type = result['Envelope']['Body'][0]['Probe'][0]['Types'][0];
                }
                catch (err) {
                    probe_type = "";
                }
                let model = existsSync('/home/pi/LE880-Profile-T/config/MODEL') ? readFileSync('/home/pi/LE880-Profile-T/config/MODEL').toString().trim() : "LE-880";
                //console.log("PROBE TYPE: " + probe_type);
                if (probe_type === "" || probe_type.indexOf("NetworkVideoTransmitter") > -1 || probe_type.indexOf("Device") > -1) { // || probe_type.indexOf("NetworkVideoTransmitter") > -1
                    /*let reply = '<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n          <SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://www.w3.org/2003/05/soap-envelope\" xmlns:wsa=\"http://schemas.xmlsoap.org/ws/2004/08/addressing\" xmlns:d=\"http://schemas.xmlsoap.org/ws/2005/04/discovery\" xmlns:dn=\"http://www.onvif.org/ver10/network/wsdl\">\n            <SOAP-ENV:Header>\n              <wsa:MessageID>uuid:' +
                     uuid.v1() + 
                     "</wsa:MessageID>\n              <wsa:RelatesTo>" + 
                     probe_uuid + 
                     "</wsa:RelatesTo>\n              <wsa:To SOAP-ENV:mustUnderstand=\"true\">http://schemas.xmlsoap.org/ws/2004/08/addressing/role/anonymous</wsa:To>\n              <wsa:Action SOAP-ENV:mustUnderstand=\"true\">http://schemas.xmlsoap.org/ws/2005/04/discovery/ProbeMatches</wsa:Action>\n              <d:AppSequence SOAP-ENV:mustUnderstand=\"true\" MessageNumber=\"68\" InstanceId=\"1460972484\"/>\n            </SOAP-ENV:Header>\n            <SOAP-ENV:Body>\n              <d:ProbeMatches>\n                <d:ProbeMatch>\n                  <wsa:EndpointReference>\n                    <wsa:Address>urn:uuid:" +
                     utils.uuid5(utils.getIpAddress() + _this.config.OnvifServicePort + _this.config.OnvifRTSPPort) + 
                     "</wsa:Address>\n                  </wsa:EndpointReference>\n                  <d:Types>dn:NetworkVideoTransmitter</d:Types>\n                  <d:Scopes>onvif://www.onvif.org/type/video_encoder onvif://www.onvif.org/type/ptz onvif://www.onvif.org/hardware/RaspberryPI onvif://www.onvif.org/name/PI onvif://www.onvif.org/location/</d:Scopes>\n                  <d:XAddrs>http://" + utils.getIpAddress() + ":" + _this.config.OnvifServicePort + "/onvif/device_service</d:XAddrs>\n                  <d:MetadataVersion>1</d:MetadataVersion>\n              </d:ProbeMatch>\n              </d:ProbeMatches>\n            </SOAP-ENV:Body>\n          </SOAP-ENV:Envelope>";
                    */
                    // ${model.replace('LE', '')}//onvif://www.onvif.org/hardware/LouroeElectronics ${model.replace('LE-', '')}  ,//onvif://www.onvif.org/name/${model}
                    //let oscopes = ["onvif://www.onvif.org/type/video_encoder", "onvif://www.onvif.org/type/audio_encoder", "onvif://www.onvif.org/type/Network_Video_Transmitter", "onvif://www.onvif.org/Profile/Streaming", "onvif://www.onvif.org/Profile/T"]
                    //let scopes = [`onvif://www.onvif.org/hardware/${model}`, `onvif://www.onvif.org/name/LouroeElectronics`, `onvif://www.onvif.org/acc/uuid/${utils.uuid5(utils.getIpAddress(), _this.config.OnvifServicePort, _this.config.OnvifRTSPPort)}`, `onvif://www.onvif.org/acc/mac/${utils.getMac()}`, `onvif://www.onvif.org/location/${configUser.ONVIF.DeviceLocation.replace(" ", "")}`]


                    //"xmlns:SOAP-ENC=\"http://www.w3.org/2003/05/soap-encoding\" " +
                    var reply = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" +
                        "\n          <s:Envelope " +
                        "xmlns:s=\"http://www.w3.org/2003/05/soap-envelope\" " +
                        "xmlns:a=\"http://schemas.xmlsoap.org/ws/2004/08/addressing\" " +
                        "xmlns:d=\"http://schemas.xmlsoap.org/ws/2005/04/discovery\" " +
                        "xmlns:dn=\"http://www.onvif.org/ver10/network/wsdl\" " +
                        "xmlns:tds=\"http://www.onvif.org/ver10/device/wsdl\"" +
                        "> " +
                        "\n            <s:Header>" +
                        `\n              <a:MessageID>uuid:${uuid.v1()}</a:MessageID>` +
                        `\n              <a:RelatesTo>${probe_uuid}</a:RelatesTo>` +
                        "\n              <a:To s:mustUnderstand=\"true\">http://schemas.xmlsoap.org/ws/2004/08/addressing/role/anonymous</a:To>" +
                        "\n              <a:Action s:mustUnderstand=\"true\">http://schemas.xmlsoap.org/ws/2005/04/discovery/ProbeMatches</a:Action>" +
                        //"\n              <a:Action s:mustUnderstand=\"true\">http://schemas.xmlsoap.org/ws/2005/04/discovery/Probe</a:Action>" +
                        "\n              <d:AppSequence s:mustUnderstand=\"true\" MessageNumber=\"2\" InstanceId=\"1460972484\"/>" + //MessageNumber=\"68\"
                        "\n            </s:Header>" +
                        "\n            <s:Body>" +
                        "\n              <d:ProbeMatches>" +
                        "\n                <d:ProbeMatch>" +
                        "\n                  <a:EndpointReference>" +
                        `\n                    <a:Address>urn:uuid:${utils.uuid5(utils.getIpAddress() + _this.config.OnvifServicePort + _this.config.OnvifRTSPPort)}</a:Address>` +
                        "\n                  </a:EndpointReference>" +
                        `\n                  <d:Types xmlns:d="http://schemas.xmlsoap.org/ws/2005/04/discovery" xmlns:tds="http://www.onvif.org/ver10/device/wsdl">tds:Device</d:Types>` +
                        //"  \n                  <d:Types>dn:NetworkVideoTransmitter</d:Types>" + 
                        //`\n                  <d:Types xmlns:d="http://schemas.xmlsoap.org/ws/2005/04/discovery" xmlns:dn="http://www.onvif.org/ver10/network/wsdl">dn:NetworkVideoTransmitter</d:Types>` +
                        //`\n                  <d:Types>${(probe_type.indexOf("Device") > -1) ? 'tds:Device' : 'dn:NetworkVideoTransmitter'}</d:Types>` +
                        "\n                  <d:Scopes>" +
                        "onvif://www.onvif.org/type/video_encoder " +
                        "onvif://www.onvif.org/type/audio_encoder " +
                        "onvif://www.onvif.org/type/Network_Video_Transmitter " +
                        "onvif://www.onvif.org/Profile/Streaming " +
                        "onvif://www.onvif.org/Profile/T " +
                        `onvif://www.onvif.org/hardware/${model} ` +
                        `onvif://www.onvif.org/name/LouroeElectronics ` + // ${model.replace('LE', '')}
                        //`onvif://www.onvif.org/hardware/LouroeElectronics ${model.replace('LE-', '')} ` +
                        //`onvif://www.onvif.org/name/${model} ` +
                        `onvif://www.onvif.org/acc/uuid/${utils.uuid5(utils.getIpAddress() + _this.config.OnvifServicePort + _this.config.OnvifRTSPPort)} ` +
                        `onvif://www.onvif.org/acc/mac/${utils.getMac()} ` +
                        `onvif://www.onvif.org/location/${configUser.ONVIF.DeviceLocation.replace(" ","")}</d:Scopes>` +
                        `\n                  <d:XAddrs>http://${utils.getIpAddress()}:${_this.config.OnvifServicePort}/onvif/device_service</d:XAddrs>` +
                        "\n                  <d:MetadataVersion>1</d:MetadataVersion>" +
                        "\n                </d:ProbeMatch>" +
                        "\n              </d:ProbeMatches>" +
                        "\n            </s:Body>" +
                        "\n          </s:Envelope>";
                    //console.log(reply);
                    var reply_bytes = new Buffer(reply);
                    //console.log(`Length: ${reply_bytes.length} Port: ${rinfo.port} Address: ${rinfo.address}`);
                    return reply_socket.send(reply_bytes, 0, reply_bytes.length, rinfo.port, rinfo.address);
                }
            });
        });
        /*discover_socket.bind(3702, '10.10.10.111', function () {
            //discover_socket.addMembership('10.10.10.111', utils.getIpAddress());
        });*/
        try {
            discover_socket.bind(3702, function () {
                try {
                    discover_socket.addMembership('239.255.255.250', utils.getIpAddress());
                } catch (e) {
                    utils.log.info(ts() + "discovery_service.js discovery_service addMembership failed error: " + e);
                }
            });
        } catch (e) {
            utils.log.info(ts() + "discovery_service.js discovery_service 3702 failed error: " + e);
        }
        /*
         discover_socket.bind(3702,  function () {
            discover_socket.addMembership('239.255.255.250', utils.getIpAddress());
        });/*
        discover_socket.bind(3702, '239.255.255.250', function () {
            discover_socket.addMembership('239.255.255.250', utils.getIpAddress());
        });*/
        utils.log.info(ts() + "discovery_service.js discovery_service started");
    };
    ;
    return DiscoveryService;
}());
module.exports = DiscoveryService;
//# sourceMappingURL=discovery_service.js.map
