"use strict";
var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
function ts() {
    return new Date().YYYYMMDDHHMMSSmmm() + " : ";
}
function ts1() {
    return new Date().YYYYMMDDHHMMSSmmm();
}
let fs = require("fs");
let os = require('os');
let credentials = require("/home/pi/LE880-Profile-T/LE880factoryConfig.json");
let SoapService = require('../lib/SoapService');
let utils_1 = require('../lib/utils');
let ip = require('ip');
let utils = utils_1.Utils.utils;
const { existsSync, readFileSync } = require('fs');
const { execSync } = require('child_process');
let DeviceService = (function (_super) {
    __extends(DeviceService, _super);
    function DeviceService(config, server, callback) {
        //function DeviceService(config, configUser, server, callback) {
        //function DeviceService(config, configUser, server) {
        utils.log.info(ts() + "device_service.js function DeviceService");
        _super.call(this, config, server);
        //_super.call(this, config, configUser, server);
        this.device_service = require('./stubs/device_service.js').DeviceService;
        this.callback = callback;
        this.serviceOptions = {
            path: '/onvif/device_service',
            services: this.device_service,
            xml: fs.readFileSync('./wsdl/device_service.wsdl', 'utf8'),
            wsdlPath: 'wsdl/device_service.wsdl',
            uri: 'wsdl/device_service.wsdl',
            //uri: 'http://www.onvif.org/ver10/device/wsdl',
            /*wsdl_options: { 
                fixedPath: true,
                includePath: "/home/pi/LE880-Profile-T/"
            },*/
            //forceSoap12Headers: true,
            //onReady: function () { return console.log(ts()+'device_service.js device_service started'); }
            onReady: function () {
                return utils.log.info(ts() + 'device_service.js onReady');
            }
        };
        this.extendService();
    }
    DeviceService.prototype.extendService = function () {
        var _this = this;
        var port = this.device_service.DeviceService.Device;
        let Capabilities = null;
        if (fs.existsSync("/home/pi/LE880-Profile-T/json/capabilities.json")) {
            Capabilities = require('/home/pi/LE880-Profile-T/json/capabilities.json');
        }

        port.GetDeviceInformation = function (args) {
            //utils.log.debug(ts() + "device_service.js port.GetDeviceInformation");
            let model = "";
            if (fs.existsSync('/home/pi/LE880-Profile-T/config/MODEL')) {
                model = fs.readFileSync('/home/pi/LE880-Profile-T/config/MODEL').toString().trim();
            } else {
                model = "LE880";
            }
            let GetDeviceInformationResponse = {
                Manufacturer: _this.config.DeviceInformation.Manufacturer,
                Model: model,
                FirmwareVersion: _this.config.DeviceInformation.FirmwareVersion,
                SerialNumber: _this.config.DeviceInformation.SerialNumber,
                HardwareId: _this.config.DeviceInformation.HardwareId
            };
            return GetDeviceInformationResponse;
        };
        port.GetSystemDateAndTime = function (args) {
            //utils.log.debug(ts() + "device_service.js port.GetSystemDateAndTime");
            let now = new Date();
            let offset = now.getTimezoneOffset();
            let abs_offset = Math.abs(offset);
            let hrs_offset = Math.floor(abs_offset / 60);
            let mins_offset = (abs_offset % 60);
            let tz = "UTC" + (offset > 0 ? '-' : '+') + hrs_offset + (mins_offset === 0 ? '' : ':' + mins_offset);
            let NTPStatus = execSync('timedatectl | grep "NTP service"').toString().includes("inactive") ? "Manual" : "NTP"
            let GetSystemDateAndTimeResponse = {
                SystemDateAndTime: {
                    DateTimeType: NTPStatus,
                    DaylightSavings: now.dst(),
                    TimeZone: {
                        TZ: tz
                    },
                    UTCDateTime: {
                        Time: { Hour: now.getUTCHours(), Minute: now.getUTCMinutes(), Second: now.getUTCSeconds() },
                        Date: { Year: now.getUTCFullYear(), Month: now.getUTCMonth() + 1, Day: now.getUTCDate() }
                    },
                    LocalDateTime: {
                        Time: { Hour: now.getHours(), Minute: now.getMinutes(), Second: now.getSeconds() },
                        Date: { Year: now.getFullYear(), Month: now.getMonth() + 1, Day: now.getDate() }
                    },
                    Extension: {}
                }
            };
            return GetSystemDateAndTimeResponse;
        };
        port.SetSystemDateAndTime = function (args) {
            console.log(JSON.stringify(args));
            //{"DateTimeType":"Manual","DaylightSavings":true,"TimeZone":{"TZ":"20:45:52"},"UTCDateTime":{"Time":{"Hour":20,"Minute":45,"Second":4},"Date":{"Year":2023,"Month":9,"Day":1}}}
            let status = (args.DateTimeType == "NTP") ? "true" : "false";
            console.log("DT:" + args.DateTimeType);
            if (args.DateTimeType == "NTP") {
                try {
                    execSync(`sudo timedatectl set-ntp true`)
                } catch (e) {
                    console.log("ERROR: " + e);
                }

            }
            else if (args.hasOwnProperty("UTCDateTime")) {
                let UTC = args.UTCDateTime;
                if (UTC.hasOwnProperty("Time") && UTC.hasOwnProperty("Date"))
                    execSync(`sudo timedatectl set-ntp false ; sudo timedatectl set-time '${UTC.Date.Year}-${UTC.Date.Month}-${UTC.Date.Day} ${UTC.Time.Hour}:${UTC.Time.Minute}:${UTC.Time.Second}' ; sudo timedatectl set-timezone UTC`);
                else if (UTC.hasOwnProperty("Time")) {
                    execSync(`sudo timedatectl set-ntp false ; sudo timedatectl set-time ${UTC.Time.Hour}:${UTC.Time.Minute}:${UTC.Time.Second} ; sudo timedatectl set-timezone UTC`);
                }
            }
            //utils.log.debug(ts() + "device_service.js port.SetSystemDateAndTime");
            let SetSystemDateAndTimeResponse = {};
            return SetSystemDateAndTimeResponse;
        };
        port.SystemReboot = function (args) {
            //utils.log.debug(ts() + "device_service.js port.SystemReboot");
            let SystemRebootResponse = {
                Message: execSync(`echo "Rebooting in two seconds" && sleep 2 && sudo reboot`)
            };
            return SystemRebootResponse;
        };
        port.GetServices = function (args) {
            //utils.log.debug(ts() + "device_service.js port.GetServices");
            let GetServicesResponse = {
                Service: [
                    {
                        Namespace: "http://www.onvif.org/ver10/device/wsdl",
                        XAddr: "http://" + utils.getIpAddress() + ":" + _this.config.OnvifServicePort + "/onvif/device_service",
                        //Capabilities: Capabilities.DeviceServiceCapabilities,
                        Version: {
                            Major: 22,
                            Minor: 12,
                        }
                    },
                    {
                        Namespace: "http://www.onvif.org/ver10/deviceIO/wsdl",
                        XAddr: "http://" + utils.getIpAddress() + ":" + _this.config.OnvifServicePort + "/onvif/deviceIO_service",
                        //Capabilities: Capabilities.DeviceIO,
                        Version: {
                            Major: 21,
                            Minor: 6,
                        }
                    },
                    {
                        Namespace: "http://www.onvif.org/ver10/media/wsdl",
                        XAddr: "http://" + utils.getIpAddress() + ":" + _this.config.OnvifServicePort + "/onvif/media_service",
                        //Capabilities: Capabilities.Media,
                        Version: {
                            Major: 21,
                            Minor: 6,
                        }
                    },
                    {
                        Namespace: "http://www.onvif.org/ver20/media/wsdl",
                        XAddr: "http://" + utils.getIpAddress() + ":" + _this.config.OnvifServicePort + "/onvif/media2_service",
                        //Capabilities: Capabilities.Media,
                        Version: {
                            Major: 22,
                            Minor: 12,
                        }
                    },
                    {
                        Namespace: "http://www.onvif.org/ver10/events/wsdl",
                        XAddr: "http://" + utils.getIpAddress() + ":" + _this.config.OnvifServicePort + "/onvif/event_service",
                        Version: {
                            Major: 22,
                            Minor: 6,
                        }
                    }
                ]
            };
            /*
            if (args.IncludeCapability != true) {
                for (let item of GetServicesResponse.Service) {
                    delete item["Capabilities"];
                }
            }
            */
            //utils.log.debug(ts() + "device_service.js port.GetServicesResponse: " + GetServicesResponse);
            return GetServicesResponse;
        };
        port.GetCapabilities = function (args) {
            //utils.log.debug(ts() + "device_service.js port.GetCapabilities");
            let category;
            if (args && args.Category)
                args.Category;
            //utils.log.debug(ts() + "Capabilities: " + JSON.stringify(args));
            let GetCapabilitiesResponse = {
                Capabilities: {}
            };
            if (category === undefined || category == "All" || category == "Device") {
                GetCapabilitiesResponse.Capabilities["Device"] = Capabilities.Device;
                GetCapabilitiesResponse.Capabilities.Device.XAddr = "http://" + utils.getIpAddress() + ":" + _this.config.OnvifServicePort + "/onvif/device_service";
                /*GetCapabilitiesResponse.Capabilities["Device"] = {
                    XAddr: "http://" + utils.getIpAddress() + ":" + _this.config.OnvifServicePort + "/onvif/device_service",
                    Network: {
                        IPFilter: false,
                        ZeroConfiguration: false,
                        IPVersion6: false,
                        DynDNS: false,
                        Extension: {
                            Dot11Configuration: false,
                            Extension: {}
                        }
                    },
                    System: {
                        DiscoveryResolve: false,
                        DiscoveryBye: false,
                        RemoteDiscovery: false,
                        SystemBackup: false,
                        SystemLogging: false,
                        FirmwareUpgrade: false,
                        SupportedVersions: [
                            {
                                Major: 21,
                                Minor: 5
                            },
                            {
                                Major: 22,
                                Minor: 12
                            }],
                        Extension: {
                            HttpFirmwareUpgrade: false,
                            HttpSystemBackup: false,
                            HttpSystemLogging: false,
                            HttpSupportInformation: false,
                            Extension: {}
                        }
                    },
                    IO: {
                        InputConnectors: 2,
                        //RelayOutputs: 1,
                        RelayOutputs: 1,
                        Extension: {
                            //Auxiliary: false,
                            //AuxiliaryCommands: "",
                            Auxiliary: true,
                            AuxiliaryCommands: "tt:OPLED|On tt:OPLED|Off",
                            Extension: {}
                        }
                    },
                    Security: {
                        "TLS1.1": false,
                        "TLS1.2": false,
                        OnboardKeyGeneration: false,
                        AccessPolicyConfig: false,
                        "X.509Token": false,
                        SAMLToken: false,
                        KerberosToken: false,
                        RELToken: false,
                        Extension: {
                            "TLS1.0": false,
                            Extension: {
                                Dot1X: false,
                                RemoteUserHandling: false
                            }
                        }
                    },
                    Extension: {}
                };*/
            }

            //
            // do NOT send GetCapabilitiesResponse.Capabilities["Events"] unless it is implemented
            //

            if (category == undefined || category == "All" || category == "Events") {
                GetCapabilitiesResponse.Capabilities["Events"] = Capabilities.Events;
                GetCapabilitiesResponse.Capabilities.Events.XAddr = "http://" + utils.getIpAddress() + ":" + _this.config.OnvifServicePort + "/onvif/event_service";
                /*GetCapabilitiesResponse.Capabilities["Events"] = {
                    XAddr: "http://" + utils.getIpAddress() + ":" + _this.config.OnvifServicePort + "/onvif/event_service",
                    WSSubscriptionPolicySupport: false,
                    WSPullPointSupport: false,
                    WSPausableSubscriptionManagerInterfaceSupport: false
                };*/
            }
            /*
                if (category === undefined || category == "All" || category == "Imaging") {
                    GetCapabilitiesResponse.Capabilities["Imaging"] = {
                        XAddr: "http://" + utils.getIpAddress() + ":" + _this.config.OnvifServicePort + "/onvif/imaging_service"
                    };
                }
            */
            if (category === undefined || category == "All" || category == "Media") {
                GetCapabilitiesResponse.Capabilities["Media"] = Capabilities.Media;
                GetCapabilitiesResponse.Capabilities.Media.XAddr = "http://" + utils.getIpAddress() + ":" + _this.config.OnvifServicePort + "/onvif/media_service";
                /*GetCapabilitiesResponse.Capabilities["Media"] = {
                    XAddr: "http://" + utils.getIpAddress() + ":" + _this.config.OnvifServicePort + "/onvif/media_service",
                    StreamingCapabilities: {
                        RTPMulticast: _this.config.MulticastEnabled,
                        RTP_TCP: true,
                        RTP_RTSP_TCP: true,
                    },
                    Extension: {
                        ProfileCapabilities: {
                            MaximumNumberOfProfiles: 1
                        }
                    }
                };*/
            }
            if (category === undefined || category == "All" || category == "DeviceIO" || category == "Extension") {
                GetCapabilitiesResponse.Capabilities["Extension"] = {}
                GetCapabilitiesResponse.Capabilities.Extension.DeviceIO = Capabilities.DeviceIO;
                delete GetCapabilitiesResponse.Capabilities.Extension.DeviceIO["SerialPorts"];
                delete GetCapabilitiesResponse.Capabilities.Extension.DeviceIO["DigitalInputs"];
                GetCapabilitiesResponse.Capabilities.Extension.DeviceIO.XAddr = "http://" + utils.getIpAddress() + ":" + _this.config.OnvifServicePort + "/onvif/deviceIO_service";
                /*GetCapabilitiesResponse.Capabilities["DeviceIO"] = {
                    XAddr: "http://" + utils.getIpAddress() + ":" + _this.config.OnvifServicePort + "/onvif/deviceIO_service",
                    VideoSources: 1,
                    VideoOutputs: 0,
                    AudioSources: 1,
                    AudioOutputs: 1,
                    RelayOutputs: 1
                };*/
            }
            /*
                if (category === undefined || category == "All" || category == "PTZ") {
                    GetCapabilitiesResponse.Capabilities["PTZ"] = {
                        XAddr: "http://" + utils.getIpAddress() + ":" + _this.config.OnvifServicePort + "/onvif/ptz_service"
                    };
                }
                */
            //console.log(GetCapabilitiesResponse);
            return GetCapabilitiesResponse;
        };
        port.GetHostname = function (args) {
            //utils.log.debug(ts() + "device_service.js port.GetHostname");
            let GetHostnameResponse = {
                HostnameInformation: {
                    FromDHCP: false,
                    Name: os.hostname(),
                    Extension: {}
                }
            };
            return GetHostnameResponse;
        };
        port.SetHostname = function (args) {
            //utils.log.debug(ts() + "device_service.js port.SetHostname");
            let SetHostnameResponse = {};
            return SetHostnameResponse;
        };
        port.SetHostnameFromDHCP = function (args) {
            //utils.log.debug(ts() + "device_service.js port.SetHostnameFromDHCP");
            let SetHostnameFromDHCPResponse = {
                RebootNeeded: false
            };
            return SetHostnameFromDHCPResponse;
        };
        port.GetScopes = function (args) {
            //utils.log.debug(ts() + "device_service.js port.GetScopes");
            let configUser = require(process.cwd() + "/LE880userConfig.json");
            let model = existsSync('/home/pi/LE880-Profile-T/config/MODEL') ? readFileSync('/home/pi/LE880-Profile-T/config/MODEL').toString().trim() : "LE-880";
            let GetScopesResponse = { Scopes: [] };
            GetScopesResponse.Scopes.push({
                ScopeDef: "Fixed",
                ScopeItem: `onvif://www.onvif.org/location/${configUser.ONVIF.DeviceLocation}`
            });
            GetScopesResponse.Scopes.push({
                ScopeDef: "Fixed",
                ScopeItem: "onvif://www.onvif.org/type/video_encoder"
            });
            GetScopesResponse.Scopes.push({
                ScopeDef: "Fixed",
                ScopeItem: "onvif://www.onvif.org/type/audio_encoder"
            });
            GetScopesResponse.Scopes.push({
                ScopeDef: "Fixed",
                ScopeItem: "onvif://www.onvif.org/type/Network_Video_Transmitter"
            });
            GetScopesResponse.Scopes.push({
                ScopeDef: "Fixed",
                ScopeItem: "onvif://www.onvif.org/Profile/Streaming"
            });
            GetScopesResponse.Scopes.push({
                ScopeDef: "Fixed",
                ScopeItem: "onvif://www.onvif.org/Profile/T"
            });
            GetScopesResponse.Scopes.push({
                ScopeDef: "Fixed",
                ScopeItem: ("onvif://www.onvif.org/hardware/" + model)
            });
            GetScopesResponse.Scopes.push({
                ScopeDef: "Fixed",
                ScopeItem: ("onvif://www.onvif.org/name/" + _this.config.DeviceInformation.Manufacturer)
            });
            return GetScopesResponse;
        };
        port.GetServiceCapabilities = function (args) {
            //utils.log.debug(ts() + "device_service.js port.GetServiceCapabilities");
            let GetServiceCapabilitiesResponse = {
                Capabilities: {
                    Network: {
                        attributes: {
                            IPFilter: false,
                            ZeroConfiguration: false,
                            IPVersion6: false,
                            DynDNS: false,
                            Dot11Configuration: false,
                            Dot1XConfigurations: 0,
                            HostnameFromDHCP: false,
                            NTP: 0,
                            DHCPv6: false
                        }
                    },
                    Security: {
                        attributes: {
                            "TLS1.0": false,
                            "TLS1.1": false,
                            "TLS1.2": false,
                            OnboardKeyGeneration: false,
                            AccessPolicyConfig: false,
                            DefaultAccessPolicy: false,
                            Dot1X: false,
                            RemoteUserHandling: true,
                            "X.509Token": false,
                            SAMLToken: false,
                            KerberosToken: false,
                            UsernameToken: true,
                            HttpDigest: true,
                            RELToken: false,
                            SupportedEAPMethods: 0,
                            MaxUsers: 1,
                            MaxUserNameLength: 10,
                            MaxPasswordLength: 256
                        }
                    },
                    System: {
                        attributes: {
                            DiscoveryResolve: true,
                            DiscoveryBye: false,
                            RemoteDiscovery: true,
                            SystemBackup: false,
                            SystemLogging: true,
                            FirmwareUpgrade: true,
                            HttpFirmwareUpgrade: false,
                            HttpSystemBackup: false,
                            HttpSystemLogging: false,
                            HttpSupportInformation: false,
                            StorageConfiguration: false
                        }
                    },
                    Misc: {
                        attributes: {
                            AuxiliaryCommands: "tt:OPLED|On tt:OPLED|Off"
                        }
                    }
                }
            };
            return GetServiceCapabilitiesResponse;
        };
        port.GetNTP = function (args) {
            //utils.log.debug(ts() + "device_service.js port.GetNTP");
            //sudo systemctl restart systemd-timesyncd.service
            let GetNTPResponse = {
                NTPInformation: {
                    FromDHCP: false,
                }
            };
            try {
                let ntp = execSync('sudo timedatectl show-timesync --all | grep ServerAddress').toString();
                if (!ntp.includes("Failed")) {
                    ntp = ntp.replace("ServerAddress=", "").trim();
                    GetNTPResponse.NTPInformation["NTPManual"] = {
                        Type: "IPv4",
                        IPv4Address: ntp
                    }
                }
            } catch (e) {
                utils.log.error(`${ts()} device_service.js GetNTP ERROR ASSUMING NOT USING NTP ${e}`);
            }
            utils.log.debug(ts() + "device_service.js port.GetNTP: " + JSON.stringify(GetNTPResponse));
            return GetNTPResponse;
        };
        port.SetNTP = function (args) {
            //utils.log.debug(ts() + "device_service.js port.SetNTP");
            if (args.NTPManual && args.NTPManual.Type == "IPv4") {
                try {
                    let conf = `[Time]\nNTP=${args.NTPManual.IPv4Address}`
                    fs.writeFileSync("/etc/systemd/timesyncd.conf.d/eth0.conf", conf);
                    execSync('sudo systemctl daemon-reload');
                    execSync('sudo systemctl restart systemd-timesyncd');
                } catch (e) {
                    utils.log.error(ts() + "device_service.js port.SetNTP: " + JSON.stringify(args) + " conf: " + JSON.stringify(conf));
                }
            }
            let SetNTPResponse = {};
            return SetNTPResponse;
        };
        port.GetNetworkDefaultGateway = function (args) {
            //utils.log.debug(ts() + "device_service.js port.GetNetworkDefaultGateway");
            //var GetNetworkDefaultGatewayResponse = { };
            let route;
            try {
                route = execSync('sudo ip route show | grep default').toString();
            } catch (e) {
                console.log(e);
            }
            const gateway = route.match(/default via (.*?)\s/)[1];
            let GetNetworkDefaultGatewayResponse = {
                NetworkGateway: {
                    IPv4Address: gateway
                }
            };
            return GetNetworkDefaultGatewayResponse;
        };
        port.SetNetworkDefaultGateway = function (args) {
            //utils.log.debug(ts() + "device_service.js port.SetNetworkDefaultGateway args:" + JSON.stringify(args));
            let SetNetworkDefaultGatewayResponse = {};
            return SetNetworkDefaultGatewayResponse;
        }
        port.GetNetworkInterfaces = function (args) {
            //utils.log.debug(ts() + "device_service.js port.GetNetworkInterfaces");
            let GetNetworkInterfacesResponse = {
                NetworkInterfaces: []
            };
            let nwifs = os.networkInterfaces();
            for (let nwif in nwifs) {
                for (let addr in nwifs[nwif]) {
                    if (nwifs[nwif][addr].family === 'IPv4' && nwif !== 'lo0' && nwif !== 'lo') {
                        let configUser = require(process.cwd() + "/LE880userConfig.json");
                        let mac = (nwifs[nwif][addr].mac).replace(/:/g, '-');
                        let ipv4_addr = nwifs[nwif][addr].address;
                        let netmask = nwifs[nwif][addr].netmask;
                        let prefix_len = ip.subnet(ipv4_addr, netmask).subnetMaskLength;
                        GetNetworkInterfacesResponse.NetworkInterfaces.push({
                            attributes: {
                                token: nwif
                            },
                            Enabled: true,
                            Info: {
                                Name: nwif,
                                HwAddress: mac,
                                MTU: 1500
                            },
                            //Link: {
                            //    OperSettings:{
                            //        AutoNegotiation: true,
                            //        Speed: 100,
                            //        Duplex: "Full"
                            //    }
                            //},
                            IPv4: {
                                Enabled: true,
                                Config: {
                                    Manual: {
                                        Address: ipv4_addr,
                                        PrefixLength: prefix_len
                                    },
                                    DHCP: (configUser.dhcpStaticSelected == "DHCP") ? true : false
                                }
                            }
                        });
                    }
                }
            }
            return GetNetworkInterfacesResponse;
        };
        port.SetNetworkInterfaces = function (args) {
            //utils.log.debug(ts() + "device_service.js port.SetNetworkInterfaces args: " + JSON.stringify(args));
            let SetNetworkInterfacesResponse = {
                RebootNeeded: false
            };
            return SetNetworkInterfacesResponse;
        };
        port.GetNetworkProtocols = function (args) {
            //utils.log.debug(ts() + "device_service.js port.GetNetworkProtocols");
            let configUser = require(process.cwd() + "/LE880userConfig.json");
            let GetNetworkProtocolsResponse = {
                NetworkProtocols: [{
                    Name: "HTTP",
                    Enabled: true,
                    Port: "80",
                }, {
                    Name: "HTTPS",
                    Enabled: false,
                    Port: "443",
                }, {
                    Name: "RTSP",
                    Enabled: true,
                    Port: (configUser.VMSConfiguration == "envysion") ? "554" : _this.config.RTSPPort,
                }]
            };
            return GetNetworkProtocolsResponse;
        };
        port.SendAuxiliaryCommand = function (args) {
            var SendAuxiliaryCommandResponse = {
                AuxiliaryCommandResponse: ["Command Received"]
            };
            return SendAuxiliaryCommandResponse;
        };
        port.GetRelayOutputs = function (args) {
            //utils.log.debug(ts() + "device_service.js port.GetRelayOutputs");
            let GetRelayOutputsResponse = { RelayOutputs: [] };
            for (let i = 0; i < 5; i++) {
                GetRelayOutputsResponse.RelayOutputs.push({
                    attributes: {
                        token: `OP${(i == 0) ? "LED" : i}`
                    },
                    Properties: {
                        Mode: "Bistable",
                        IdleState: "open"
                    }
                })
            }
            /*let GetRelayOutputsResponse = {
                RelayOutputs: [{
                    attributes: {
                        token: "OPLED"
                    },
                    Properties: {
                        Mode: "Bistable",
                        IdleState: "open"
                    }
                }]
            };*/
            console.log(JSON.stringify(GetRelayOutputsResponse));
            return GetRelayOutputsResponse;
        };
        port.SetRelayOutputState = function (args) {
            //utils.log.debug(ts() + "device_service.js port.SetRelayOutputState args: " + JSON.stringify(args));
            let SetRelayOutputStateResponse = {};
            let alertJSON = {
                Alert: "ONVIF",
                "OutputPort": args.RelayOutputToken,
                Status: (args.LogicalState === 'active') ? 1 : 0,
                ts_uSec: ts1()
            };
            fs.writeFileSync(`${process.cwd()}/alertsOut/toggle${args.RelayOutputToken}_${ts1()}.json`, JSON.stringify(alertJSON), (err) => {
                if (err) throw err;
            });
            /*if (_this.callback) {
                if (args.LogicalState === 'active')
                    _this.callback('relayactive', { name: args.RelayOutputToken });
                if (args.LogicalState === 'inactive')
                    _this.callback('relayinactive', { name: args.RelayOutputToken });
            }*/
            return SetRelayOutputStateResponse;
        };
        port.SetRelayOutputSettings = function (args) {
            var SetRelayOutputSettingsResponse = {};
            return SetRelayOutputSettingsResponse;
        }
        port.GetUsers = function (args) {
            //utils.log.debug(ts() + "device_service.js port.GetUsers");
            let GetUsersResponse = {
                User: [{
                    Username: credentials.RTSPUsername,
                    Password: credentials.RTSPPassword,
                    UserLevel: "Administrator"
                }]
            };
            return GetUsersResponse;
        };
        port.SetUser = function (args) {
            //utils.log.debug(ts() + "device_service.js port.SetUser");
            let SetUserResponse = {
                User: {
                    Username: credentials.RTSPUsername,
                    Password: credentials.RTSPPassword,
                    UserLevel: "Administrator"
                }
            };
            return SetUserResponse;
        };
        port.GetDiscoveryMode = function (args) {
            let GetDiscoveryModeResponse = {
                DiscoveryMode: "Discoverable"
            };
            return GetDiscoveryModeResponse;
        };
        port.SetDiscoveryMode = function (args) {
            let SetDiscoveryModeResponse = {};
            return SetDiscoveryModeResponse;
        };
        port.GetDNS = function (args) {
            let cat = execSync('sudo cat /etc/resolv.conf | grep nameserver').toString();
            const dns = cat.match(/nameserver (.*?)\s/)[1];
            console.log(dns)
            let GetDNSResponse = {
                DNSInformation: {
                    FromDHCP: true,
                    DNSManual: [{
                        Type: "IPv4",
                        IPv4Address: dns
                    }],
                    Extension: {}
                }

            };
            return GetDNSResponse;
        };
        port.GetSystemLog = function (args) {
            var GetSystemLogResponse = {
                SystemLog: {
                    String: fs.readFileSync(`${process.cwd()}/LOG/LE880-digital-input.log`).toString()
                }

            };
            return GetSystemLogResponse;
        };
    };
    return DeviceService;
}(SoapService));
module.exports = DeviceService;
