"use strict";
var __extends = (this && this.__extends) || function (d, b) {
  for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
  function __() { this.constructor = d; }
  d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
function ts() {
  return new Date().YYYYMMDDHHMMSSmmm() + " : ";
}
function ts1() {
  return new Date().YYYYMMDDHHMMSSmmm();
}
const fs = require("fs");
const SoapService = require('../lib/SoapService');
const utils_1 = require('../lib/utils');
const url = require('url');
//const v4l2ctl_1 = require('../lib/v4l2ctl'); /* v4l2ctl_1 only for camera */
//const child_process_1 = require('child_process');
const utils = utils_1.Utils.utils;
const util = require('util'); // inspect
var DeviceIOService = (function (_super) {
  __extends(DeviceIOService, _super);
  function DeviceIOService(config, server, LE880process) {
    //utils.log.debug(ts()+"deviceIO_service.js 1 config: " + util.inspect(config, {showHidden: false, depth: null}));
    //utils.log.debug(ts()+"deviceIO_service.js 1 configUser: " + util.inspect(configUser, {showHidden: false, depth: null}));
    //utils.log.debug(ts()+"deviceIO_service.js 1 server: " + util.inspect(server, {showHidden: false, depth: null}));
    //utils.log.debug(ts()+"deviceIO_service.js 1 LE880process: " + util.inspect(LE880process, {showHidden: false, depth: null}));	
    _super.call(this, config, server, LE880process);
    //_super.call(this, config, configUser, server, LE880process);
    //utils.log.debug(ts()+"deviceIO_service.js 2 config: " + util.inspect(config, {showHidden: false, depth: null}));
    //utils.log.debug(ts()+"deviceIO_service.js 2 configUser: " + util.inspect(configUser, {showHidden: false, depth: null}));
    //utils.log.debug(ts()+"deviceIO_service.js 2 server: " + util.inspect(server, {showHidden: false, depth: null}));
    //utils.log.debug(ts()+"deviceIO_service.js 2 LE880process: " + util.inspect(LE880process, {showHidden: false, depth: null}));
    this.webserver = server;
    //this.ffmpeg_process = null;
    //this.ffmpeg_responses = [];
    this.deviceIO_service = require('./stubs/deviceIO_service.js').DeviceIOService;
    this.LE880process = LE880process;
    this.serviceOptions = {
      path: '/onvif/deviceIO_service',
      services: this.deviceIO_service,
      xml: fs.readFileSync('./wsdl/deviceIO_service.wsdl', 'utf8'),
      wsdlPath: 'wsdl/deviceIO_service.wsdl',
      uri: 'wsdl/deviceIO_service.wsdl',
      forceSoap12Headers: true,
      onReady: function () {
        utils.log.info(ts() + 'deviceIO_service.js onReady');
      }
    };
    this.extendService();
  }
  DeviceIOService.prototype.starting = function () {
    /*var _this = this;
    var listeners = this.webserver.listeners('request').slice();
    this.webserver.removeAllListeners('request');
    this.webserver.addListener('request', function (request, response, next) {
      utils.log.debug('deviceIO_service.js web request received : %s', request.url);
      var uri = url.parse(request.url, true);
      var action = uri.pathname;
      for (var i = 0, len = listeners.length; i < len; i++) {
        listeners[i].call(_this, request, response, next);
      }
    }); // this.webserver.addListener
    */
  }; // DeviceIOService.prototype.starting
  /*DeviceIOService.prototype.started = function () {
    //this.LE880process.startRtsp();
    utils.log.info(ts() + 'deviceIO_service.js DeviceIOService.prototype.started this.LE880process.startRtsp()');
  };*/
  DeviceIOService.prototype.extendService = function () {
    var _this = this;
    var port = this.deviceIO_service.DeviceIOService.DeviceIOPort;
    //utils.log.debug(ts()+'deviceIO_service.js port: ' + util.inspect(port, {showHidden: false, depth: null}));
    port.GetServiceCapabilities = function (args) {
      //utils.log.debug(ts() + "deviceIO_service.js port.GetServiceCapabilities");
      var GetServiceCapabilitiesResponse = {
        Capabilities: {
          attributes: {
            VideoSources: 1,
            VideoOutputs: 0,
            AudioSources: 1,
            AudioOutputs: 1,
            RelayOutputs: 5,
            SerialPorts: 0,
            DigitalInputs: 2
          }
        }
      };
      return GetServiceCapabilitiesResponse;
    };
    port.GetDigitalInputs = function (args) {
      //utils.log.debug(ts() + "deviceIO_service.js port.GetDigitalInputs");
      var GetDigitalInputsResponse = {
        DigitalInputs: [{
          attributes: {
            token: "DI1",
            IdleState: "open"
          }
        }, {
          attributes: {
            token: "DI2",
            IdleState: "open"
          }
        }]
      };
      return GetDigitalInputsResponse;
    };
    port.GetRelayOutputs = function (args) {
      //utils.log.debug(ts() + "deviceIO_service.js port.GetRelayOutputs");
      var GetRelayOutputsResponse = {
        RelayOutputs: []
      };
      for (let i = 0; i < 5; i++) {
        GetRelayOutputsResponse.RelayOutputs.push({
          attributes: {
            token: `OP${(i == 0) ? "LED" : i}`
          },
          Properties: {
            Mode: "Bistable",
            IdleState: "open"
          }
        });
      }
      return GetRelayOutputsResponse;
    };
    port.GetRelayOutputOptions = function (args) {
      //utils.log.debug(ts() + "deviceIO_service.js port.GetRelayOutputOptions");
      var GetRelayOutputOptionsResponse = {
        /*RelayOutputOptions: [{
          attributes: {
            token: "OPLED"
          },
          Mode: "Bistable",
          DelayTimes: {
            Items: ["0.5", "1", "2", "60"]
          },
          Discrete: false,
          Extension: {}
        }]*/

      };
      return GetRelayOutputOptionsResponse;
    };
    port.SetRelayOutputState = function (args) {
      //utils.log.debug(ts() + "deviceIO_service.js port.SetRelayOutputState args: " + JSON.stringify(args));
      let SetRelayOutputStateResponse = {};
      let alertJSON = {
        Alert: "ONVIF",
        "OutputPort": args.RelayOutputToken,
        Status: (args.LogicalState === 'active') ? 1 : 0,
        ts_uSec: ts1()
      };
      fs.writeFileSync(`${process.cwd()}/alertsOut/toggle${args.RelayOutputToken}_${ts1()}.json`, JSON.stringify(alertJSON), (err) => {
        if (err) throw err;
      });
      /*
      let alertJSON = {
        Alert: "toggleLED",
        Status: (args.LogicalState === 'active') ? "on" : "off",
        ts_uSec: ts1()
      };
      fs.writeFileSync(`${process.cwd()}/alertsOut/toggleLED_${ts1()}.json`, JSON.stringify(alertJSON), (err) => {
        if (err) throw err;
      });
      if (_this.callback) {
        if (args.LogicalState === 'active')
          _this.callback('relayactive', { name: args.RelayOutputToken });
        if (args.LogicalState === 'inactive')
          _this.callback('relayinactive', { name: args.RelayOutputToken });
      }*/
      return SetRelayOutputStateResponse;
    };
    port.SetRelayOutputSettings = function (args /*, cb, headers*/) {
      var SetRelayOutputSettingsResponse = {};
      return SetRelayOutputSettingsResponse;
    },
      port.GetAudioSources = function (args) {
        var GetAudioSourcesResponse = { Token: "audio_src_token" };
        return GetAudioSourcesResponse;
      };
    port.GetAudioOutputs = function (args) {
      var GetAudioOutputsResponse = { Token: "audio_output_token" };
      return GetAudioOutputsResponse;
    };
    port.GetVideoSources = function (args) {
      var GetVideoSourcesResponse = { Token: "video_src_token" };
      return GetVideoSourcesResponse;
    };

  }; // DeviceIOService.prototype.extendService
  return DeviceIOService;
}(SoapService));
module.exports = DeviceIOService;
