#!/bin/bash
#Script by Jordan Bradshaw
#Purpose to route 80 traffic to our RTSP port
#sudo iptables -t nat -v -D INPUT -n --line-number
#sudo iptables -t nat -v -D PREROUTING -n --line-number
#iptables -t nat -A PREROUTING -i eth0 -p tcp -m tcp --dport 80 -j MARK --set-xmark 0x64/0xffffffff
#iptables -t nat -A PREROUTING -i eth0 -p tcp -m tcp --dport 80 -m mark --mark 0x64 -j DNAT --to-destination :8096
#iptables -t nat -A INPUT -i eth0 -p tcp -m conntrack --ctstate NEW -m tcp --dport 8096 -m mark --mark 0x64 -j ACCEPT
#sudo iptables -t nat -A INPUT -i eth0 -p tcp -m state --state NEW -m tcp --dport 8096 -m mark --mark 0x64 -j ACCEPT
#iptables -t nat -nvL
if ! [[ "$EUID" = 0 ]]; then
    echo "not root"
    exit 1
fi
RTSPPort=$1
iptables -t nat -A PREROUTING -i eth0 -p tcp -m tcp --dport 80 -j MARK --set-xmark 0x64/0xffffffff
iptables -t nat -A PREROUTING -i eth0 -p tcp -m tcp --dport 80 -m mark --mark 0x64 -j DNAT --to-destination :$RTSPPort
iptables -t nat -A INPUT -i eth0 -p tcp -m conntrack --ctstate NEW -m tcp --dport $RTSPPort -m mark --mark 0x64 -j ACCEPT

iptables -t nat -A PREROUTING -i eth0 -p udp --dport 80 -j MARK --set-xmark 0x64/0xffffffff
iptables -t nat -A PREROUTING -i eth0 -p udp -m udp --dport 80 -m mark --mark 0x64 -j DNAT --to-destination :$RTSPPort
iptables -t nat -A INPUT -i eth0 -p udp -m conntrack --ctstate NEW -m udp --dport $RTSPPort -m mark --mark 0x64 -j ACCEPT

#iptables --table nat --append PREROUTING --in-interface eth0
#--protocol udp --destination-port 27000:27031
#--jump DNAT --to-destination 10.66.66.2:27000-27031
