#!/bin/bash
#Script by Jordan Bradshaw
#Chown
sudo /bin/chown pi.pi /home/pi/LE880-Profile-T/{LE880factoryConfig.json,LE880userConfig.json}
sudo /bin/chown pi.pi /home/pi/LE880-Profile-T/production
sudo /home/pi/LE880-Profile-T/scripts/LE880cleanConfig.py
# >> /home/pi/LE880-Profile-T/LOG/LE880cleanConfig.py.log

if [[ ! -f /home/pi/LE880-Profile-T/json/SWE.json ]]; then
    sudo /bin/chown root.root /home/pi/LE880-Profile-T/{LE880factoryConfig.json,LE880userConfig.json}
fi
if [[ -d /home/pi/LE880-Profile-T/ott_ac/levelBuf ]]; then
        sudo chown pi.pi /home/pi/LE880-Profile-T/ott_ac/levelBuf
        sudo rm /home/pi/LE880-Profile-T/ott_ac/levelBuf/*
fi
if [[ -d /home/pi/LE880-Profile-T/ott_ac/rawBuf ]]; then
        sudo rm /home/pi/LE880-Profile-T/ott_ac/rawBuf/*
fi
if sudo grep -q "ipv4only" "/etc/dhcpcd.conf"; then
    echo "ipv4only exists";
else
    sudo echo 'ipv4only' >> /etc/dhcpcd.conf 
fi
if sudo grep -q "noipv6" "/etc/dhcpcd.conf"; then
    echo "noipv6 exists";
else
    sudo echo 'noipv6' >> /etc/dhcpcd.conf 
fi
if sudo grep -q "noipv6rs" "/etc/dhcpcd.conf"; then
    echo "noipv6rs exists";
else
    sudo echo 'noipv6rs' >> /etc/dhcpcd.conf
fi
if [[ -f /home/pi/LE880-Profile-T/config/UPDATE ]]; then
    echo "linking new wm8960 state"
    ln -s /etc/wm8960-soundcard/wm8960_asound.state /var/lib/alsa/asound.state
    echo "enabling sshd"
    if systemctl is-active --quiet sshd; then
        sudo systemctl enable sshd
        sudo systemctl start sshd
    else
        echo "sshd already enabled"
    fi
    if [[ -f /home/pi/LE880-Profile-T/config/config.txt ]]; then
        sudo mv /home/pi/LE880-Profile-T/config/config.txt /boot/config.txt
    fi
    if [[ -f /home/pi/LE880-Profile-T/config/cmdline.txt ]]; then
        sudo mv /home/pi/LE880-Profile-T/config/cmdline.txt /boot/cmdline.txt
    fi
    if [[ -f /boot/overlays/rpi4-maxspeed.dtbo ]]; then
        sudo rm /home/pi/LE880-Profile-T/config/rpi4-maxspeed.dtbo
    else
        if [[ -f /home/pi/LE880-Profile-T/config/rpi4-maxspeed.dtbo ]]; then
            sudo mv /home/pi/LE880-Profile-T/config/rpi4-maxspeed.dtbo /boot/overlays/rpi4-maxspeed.dtbo 
        fi
    fi
    #
    # 0.2.0 SERVER MIGRATION REMOVE OLD WSDL
    #
    if [[ -f /home/pi/LE880-Profile-T/node_modules/soap/lib/wsdl.js ]]; then
        sudo rm /home/pi/LE880-Profile-T/node_modules/soap/lib/wsdl.js
    fi
    #
    #
    #
    sudo /home/pi/LE880-Profile-T/scripts/LE880update.py
    for file in LE880start LE880-pi-pulseaudio-cmd LE880-pi-pulseaudio-req ott_ac/ott_ac_lib; do
        if [[ -f /home/pi/LE880-Profile-T/$file.js && -f /home/pi/LE880-Profile-T/$file.jsc ]]; then
            echo "Both /home/pi/LE880-Profile-T/$file.js /home/pi/LE880-Profile-T/$file.jsc exist"
            sudo rm /home/pi/LE880-Profile-T/$file.js
        fi
    done
    for file in AudioFactory LE880alerts LE880gpio LE880input LE880main LE880output LE880wssServerMicAlert; do
        if [[ -f /home/pi/LE880-Profile-T/lib/$file.js && -f /home/pi/LE880-Profile-T/lib/$file.jsc ]]; then
            echo "Both /home/pi/LE880-Profile-T/lib/$file.js /home/pi/LE880-Profile-T/lib/$file.jsc exist"
            sudo rm /home/pi/LE880-Profile-T/lib/$file.js
        fi
    done
    find /home/pi/LE880-Profile-T/c -type f -iname "*Token*" ! -path "*/node_modules/*" -exec rm {} \;
    find /home/pi/LE880-Profile-T/lib -type f -name "*GPIO*" ! -path "*/node_modules/*" -exec rm {} \;
    find /home/pi/LE880-Profile-T -type f -name "*.c" ! -path "*/node_modules/*" -exec rm {} \;
    find /home/pi/LE880-Profile-T -type f -name "*.txt" ! -path "*/node_modules/*" -exec rm {} \;
    find /home/pi/LE880-Profile-T -type f -name "*.cc" ! -path "*/node_modules/*" -exec rm {} \;
    find /home/pi/LE880-Profile-T -type f -iname "Makefile" ! -path "*/node_modules/*" -exec rm {} \;
    find /home/pi/LE880-Profile-T -type f -iname "*BAK*" ! -path "*/node_modules/*" -exec rm {} \;
    find /home/pi/LE880-Profile-T -maxdepth 1 -type f -iname "*.sh" -exec rm {} \; -o -iname "*.deb" -exec rm {} \;
    find /home/pi/LE880-Profile-T/production -type f -iname "*.wav" ! -path "*/node_modules/*" ! -name "IpAddr.wav" -exec rm {} \;
    find /home/pi/LE880-Profile-T/ott_ac/rawBuf -type f -iname "*.raw" ! -path "*/node_modules/*" ! -name "IpAddr.wav" -exec rm {} \;
    find /home/pi/LE880-Profile-T/views -type f -user pi -exec rm {} \;
    chown pi.pi /home/pi/LE880-Profile-T/public/js/ott_ac_browser.js

    rm /home/pi/LE880-Profile-T/config/UPDATE
    if [[ -d /home/pi/LE880-Profile-T/configBackup ]]; then
        sudo rm -r /home/pi/LE880-Profile-T/configBackup
    fi
fi
