#!/usr/bin/env python3
# Written by Jordan to clean user config && set defaults if they dont exist
# (Not Finished)
import json
import sys
from os.path import exists

configLoc = "/home/pi/LE880-Profile-T/LE880factoryConfig.json"
configUserLoc = "/home/pi/LE880-Profile-T/LE880userConfig.json"
configAuthLoc = "/home/pi/LE880-Profile-T/authUser.json"
FactoryDictionary = {
    "MulticastEnabled" : "true",
    "DeviceType": "speakerMicrophone",
    "AnalyticsEnabled": "true",
    "AnalyticsOnly": "false",
    "Features": {
        "Analytics" : "true",
        "SpeakerMonitor" : "true",
        "MicSetLevel" : "true",
        "RTSP" : "true",
        "RTSPBC" : "false",
        "RTSPSRC" : "true",
        "SIP" : "false",
    },
    "VMSConfiguration": "mirasys",
    "PerformanceTesting": "false",
    "TimeConfiguration": "ntp",
    "NetworkAdapters": ["eth0"],
    "IpAddress": "",
    "IpAddressComment": "set by utils.getIpAddress()",
    "AdminHTTPorHTTPS": "https",
    "AdminServicePort": "443",
    "WSSserverPort": "8443",
    "LE880wssServerMicAlert": "8445",
    "superadmin_first_login": "false",
    "admin_first_login": "false",
    "user_first_login": "false",
    "LOG": "/home/pi/LE880-Profile-T/LOG/",
    "scripts": "/home/pi/LE880-Profile-T/scripts/",
    "swupdateRepoFolder": "/home/pi/LE880-Profile-T/swupdateRepoFolder",
    "alertPlaybackFolder": "/home/pi/LE880-Profile-T/alertPlayback",
    "EnableOnvifServices": "true",
    "OnvifHTTPorHTTPS": "http",
    "OnvifServicePort": "80",
    "IncludeVideoOnvif": ["Video&Audio", "AudioOnly"],
    "IncludeVideoOnvifDefault": "Video&Audio",
    "alertWAV": "/home/pi/LE880-Profile-T/alertWAV",
    "alertPlayback": "/home/pi/LE880-Profile-T/alertPlayback",
    "logLevel": 2,
    "logLevelComment": "## LogLevels are > 1:Error 2:Warning 3:Info 4:Debug 5:Detail",
    "logSoapCalls": "false",
    "logSoapCallsXML": "false",
    "logSoapCallsXMLComment": "see /node_modules/soap/lib.server.js",
    "LE880toVMSAutoStart": "true",
    "VMStoLE880AutoStart": "true",
    "RTSPUsername": "admin",
    "RTSPPassword": "pass",
    "RTSPPort": "8096",
    "RTSPName": "LE880",
    "RTSPMulticastName": "multicast",
    "RTSPNameComment": "for production set by LE880-rtsp-server-02.c for development set by test-launch",
    "RTSPAddress": "127.0.0.1",
    "RTSPAddressComment": "/services/media_service.js utils.getIpAddress()",
    "OutgoingAudioURL": "rtsp://admin:pass@10.10.10.111:8096/LE880",
    "OutgoingAudioURLComment": "use values from this file",
    "IncomingAudioURL": "",
    "IncomingAudioURLComment": "use VMSloopbackURL for loopback",
    "VMSloopbackURL": "rtsp://LE880:LE880@127.0.0.1:8096/LE880",
    "VMSloopbackURLComment": "insert into IncomingAudioURL for loopback",
    "OutgoingUDPMulticastAutoStart": "false",
    "OutgoingUDPMulticastIP": "224.1.2.1",
    "OutgoingUDPMulticastPort": "5555",
    "ONVIF": {
        "DeviceLocation": "",
        "HighPassFilter": "0",
        "HighPassFilter_checked": "disabled",
        "Location": "",
        "LowPassFilter": "0",
        "LowPassFilter_checked": "disabled"
    },
    "RTSPServer": 3,
    "RtspServerComment": "0: disabled, 1: disabled, 2:disabled, 3: gstreamer",
    "DeviceInformation": {
        "Manufacturer": "Louroe Electronics",
        "Model": "LE880",
        "HardwareId": "dev0001",
        "SerialNumber": "engr-0001",
        "FirmwareVersion": "v0.1.2-2022-09-22",
        "License": "not applicable",
    },
    "SIPInformation": {
        "auto_start": "disabled",
        "ip": "",
        "username": "",
        "password": "",
        "control_port": "",
        "rtp_start": "",
        "rtp_end": "",
    },
    "input_record_app": "LE880-record-03",
    "input_record_level": "1",
    "input_record_multiplier": "1.0",
    "input_alert_app": "LE880-mic-set-level-02",
    "input_alert_level": "1",
    "input_alert_multiplier": "1.0",
    "input_vms_app": "LE880-rtsp-server-02",
    "input_vms_level": "70.0",
    "input_vms_multiplier": "1.0",
    "output_vms_app": "LE880-rtsp-server-02",
    "output_vms_level": "5.0",
    "output_vms_multiplier": "7.5",
    "input_intercom_app": "LE880-webrtc-wm8960-pa-ec-00",
    "input_intercom_level": "70.0",
    "input_intercom_multiplier": "1.0",
    "output_intercom_app": "LE880-webrtc-wm8960-pa-ec-00",
    "output_intercom_level": "5.0",
    "output_intercom_multiplier": "5.0",
    "vms_half_full_duplex_state": "full",
    "half_full_duplex_state": "half",
    "vmsEcho": "true",
    "intercomDSP": "true",
    "intercomEcho": "true",
    "intercomRestartLoad": "false",
    "intercomRestartFail": "true",
    "intercomPossibleFail": "false",
    "intercomStarted": "not defined in server",
    "audioCtxRemoteState": "not defined in server",
    "audioCtxLocalState": "not defined in server",
    "AudioOptionsMedia2Encoder": ["mulaw", "aac"],
    "AudioOptionsMedia2EncoderDefault": "mulaw",
    "AudioOptionsStreamingContainer_planned": ["RTP", "RTSP", "UDP", "UDPmulticast", "HTTP", "HTTPS", "TCP"],
    "AudioOptionsStreamingContainer": [
        "RTSP",
        "UDPMulticast",
    ],
    "AudioOptionsStreamingContainerDefault": "RTSP",
    "CameraType": "no_camera",
    "IPReset_pupd_checked": "pu",
    "IPReset_deb_checked": "500",
    "gpio_input_ports": ["IP1", "IP2", "IP3", "IP4"],
    "IP1_pupd_checked": "pu",
    "IP1_deb_checked": "100",
    "IP2_pupd_checked": "pu",
    "IP2_deb_checked": "200",
    "IP3_pupd_checked": "pu",
    "IP3_deb_checked": "300",
    "IP4_pupd_checked": "pu",
    "IP4_deb_checked": "400",
    "gpio_output_ports": ["OPLED", "OP1", "OP2", "OP3", "OP4"],
    "event_to_action_count": "5",
    "OPLED_OL_checked": "low",
    "OP1_OL_checked": "low",
    "OP2_OL_checked": "low",
    "OP3_OL_checked": "low",
    "OP4_OL_checked": "low",
    "OP1_trig_checked": "Alarm",
    "OP1_dest_checked": "OPLED",
    "OP1_active_checked": "enabled",
    "OP1_Duration": "1",
    "OP1_spl_level" : "80",
    "OP1_HTTPS_checked": "disabled",
    "OP1_POST_URL": "https://127.0.0.1/api",
    "OP1_TCP_URL": "10.10.10.127:80",
    "OP1_k1": "k1 custom",
    "OP1_v1": "v1 custom",
    "OP1_k2": "k2 custom",
    "OP1_v2": "v2 custom",
    "OP1_k3": "k3 custom",
    "OP1_v3": "v3 custom",
    "OP1_k4": "k4 custom",
    "OP1_v4": "v4 custom",
    "OP1_tcp1": "Alarm",
    "OP1_tcp2": "Lobby",
    "OP1_mic_alertLevel0": "-25",
    "OP1_mic_alertLevel1": "-50",
    "OP1_mic_alertLevel2": "-75",
    "OP1_recording_checked": "enabled",
    "OP1_recording_duration_before": "5",
    "OP1_recording_duration_after": "5",
    "OP1_playback_checked": "disabled",
    "OP1_playback_file": "disabled",
    "OP1_playback_volume": "1",
    "OP2_trig_checked": "disabled",
    "OP2_dest_checked": "disabled",
    "OP2_active_checked": "disabled",
    "OP2_Duration": "1",
    "OP2_spl_level" : "80",
    "OP2_HTTPS_checked": "disabled",
    "OP2_POST_URL": "https://127.0.0.1/api",
    "OP2_TCP_URL": "localhost:8080",
    "OP2_k1": "k1 custom",
    "OP2_v1": "v1 custom",
    "OP2_k2": "k2 custom",
    "OP2_v2": "v2 custom",
    "OP2_k3": "k3 custom",
    "OP2_v3": "v3 custom",
    "OP2_k4": "k4 custom",
    "OP2_v4": "v4 custom",
    "OP2_tcp1": "tcp1 custom",
    "OP2_tcp2": "tcp2 custom",
    "OP2_mic_alertLevel0": "-25",
    "OP2_mic_alertLevel1": "-50",
    "OP2_mic_alertLevel2": "-75",
    "OP2_recording_checked": "disabled",
    "OP2_recording_duration_before": "5",
    "OP2_recording_duration_after": "5",
    "OP2_playback_checked": "disabled",
    "OP2_playback_file": "disabled",
    "OP2_playback_volume": "1",
    "OP3_trig_checked": "disabled",
    "OP3_dest_checked": "disabled",
    "OP3_active_checked": "disabled",
    "OP3_Duration": "1",
    "OP3_spl_level" : "80",
    "OP3_HTTPS_checked": "disabled",
    "OP3_POST_URL": "https://127.0.0.1/api",
    "OP3_TCP_URL": "localhost:8080",
    "OP3_k1": "k1 custom",
    "OP3_v1": "v1 custom",
    "OP3_k2": "k2 custom",
    "OP3_v2": "v2 custom",
    "OP3_k3": "k3 custom",
    "OP3_v3": "v3 custom",
    "OP3_k4": "k4 custom",
    "OP3_v4": "v4 custom",
    "OP3_tcp1": "tcp1 custom",
    "OP3_tcp2": "tcp2 custom",
    "OP3_mic_alertLevel0": "-25",
    "OP3_mic_alertLevel1": "-50",
    "OP3_mic_alertLevel2": "-75",
    "OP3_recording_checked": "disabled",
    "OP3_recording_duration_before": "5",
    "OP3_recording_duration_after": "5",
    "OP3_playback_checked": "disabled",
    "OP3_playback_file": "disabled",
    "OP3_playback_volume": "1",
    "OP4_trig_checked": "disabled",
    "OP4_dest_checked": "disabled",
    "OP4_active_checked": "disabled",
    "OP4_Duration": "1",
    "OP4_spl_level" : "80",
    "OP4_HTTPS_checked": "disabled",
    "OP4_POST_URL": "https://127.0.0.1/api",
    "OP4_TCP_URL": "localhost:8080",
    "OP4_k1": "k1 custom",
    "OP4_v1": "v1 custom",
    "OP4_k2": "k2 custom",
    "OP4_v2": "v2 custom",
    "OP4_k3": "k3 custom",
    "OP4_v3": "v3 custom",
    "OP4_k4": "k4 custom",
    "OP4_v4": "v4 custom",
    "OP4_tcp1": "tcp1 custom",
    "OP4_tcp2": "tcp2 custom",
    "OP4_mic_alertLevel0": "-25",
    "OP4_mic_alertLevel1": "-50",
    "OP4_mic_alertLevel2": "-75",
    "OP4_recording_checked": "disabled",
    "OP4_recording_duration_before": "5",
    "OP4_recording_duration_after": "5",
    "OP4_playback_checked": "disabled",
    "OP4_playback_file": "disabled",
    "OP4_playback_volume": "1",
    "OP5_trig_checked": "disabled",
    "OP5_dest_checked": "disabled",
    "OP5_active_checked": "disabled",
    "OP5_Duration": "1",
    "OP5_spl_level" : "80",
    "OP5_HTTPS_checked": "disabled",
    "OP5_POST_URL": "https://127.0.0.1/api",
    "OP5_TCP_URL": "localhost:8080",
    "OP5_k1": "k1 custom",
    "OP5_v1": "v1 custom",
    "OP5_k2": "k2 custom",
    "OP5_v2": "v2 custom",
    "OP5_k3": "k3 custom",
    "OP5_v3": "v3 custom",
    "OP5_k4": "k4 custom",
    "OP5_v4": "v4 custom",
    "OP5_tcp1": "tcp1 custom",
    "OP5_tcp2": "tcp2 custom",
    "OP5_mic_alertLevel0": "-25",
    "OP5_mic_alertLevel1": "-50",
    "OP5_mic_alertLevel2": "-75",
    "OP5_recording_checked": "disabled",
    "OP5_recording_duration_before": "5",
    "OP5_recording_duration_after": "5",
    "OP5_playback_checked": "disabled",
    "OP5_playback_file": "disabled",
    "OP5_playback_volume": "1",
    "Reset_to_Factory_Defaults_min": "20",
    "Reboot_min": "2",
    "Reboot_max": "6",
    "dhcpStaticSelected": "DHCP",
    "setStatic": "",
    "setMask": "",
    "setRouter": "",
    "setDNS": "",
}

UserKeys = [
    "DeviceType",
    "VMSConfiguration",
    "superadmin_first_login",
    "admin_first_login",
    "user_first_login",
    "IncludeVideoOnvifDefault",
    "RTSPUsername",
    "RTSPPassword",
    "RTSPPort",
    "RTSPName",
    "RTSPNameComment",
    "OutgoingAudioURL",
    "OutgoingAudioURLComment",
    "IncomingAudioURL",
    "IncomingAudioURLComment",
    "OutgoingUDPMulticastAutoStart",
    "OutgoingUDPMulticastIP",
    "OutgoingUDPMulticastPort",
    "ONVIF",
    "input_vms_level",
    "output_vms_level",
    "input_intercom_level",
    "output_intercom_level",
    "vms_half_full_duplex_state",
    "half_full_duplex_state",
    "vmsEcho",
    "LE880toVMSAutoStart",
    "VMStoLE880AutoStart",
    "intercomRestartLoad",
    "intercomRestartFail",
    "intercomPossibleFail",
    "intercomStarted",
    "intercomEcho",
    "intercomDSP",
    "audioCtxRemoteState",
    "audioCtxLocalState",
    "AudioOptionsStreamingContainerDefault",
    "IPReset_pupd_checked",
    "IPReset_deb_checked",
    "IP1_pupd_checked",
    "IP1_deb_checked",
    "IP2_pupd_checked",
    "IP2_deb_checked",
    "IP3_pupd_checked",
    "IP3_deb_checked",
    "IP4_pupd_checked",
    "IP4_deb_checked",
    "OPLED_OL_checked",
    "OP1_OL_checked",
    "OP2_OL_checked",
    "OP3_OL_checked",
    "OP4_OL_checked",
    "OP1_trig_checked",
    "OP1_dest_checked",
    "OP1_active_checked",
    "OP1_Duration",
    "OP1_spl_level",
    "OP1_HTTPS_checked",
    "OP1_POST_URL",
    "OP1_TCP_URL",
    "OP1_k1",
    "OP1_v1",
    "OP1_k2",
    "OP1_v2",
    "OP1_k3",
    "OP1_v3",
    "OP1_k4",
    "OP1_v4",
    "OP1_tcp1",
    "OP1_tcp2",
    "OP1_mic_alertLevel0",
    "OP1_mic_alertLevel1",
    "OP1_mic_alertLevel2",
    "OP1_recording_checked",
    "OP1_recording_duration_before",
    "OP1_recording_duration_after",
    "OP1_playback_checked",
    "OP1_playback_file",
    "OP1_playback_volume",
    "OP2_trig_checked",
    "OP2_dest_checked",
    "OP2_active_checked",
    "OP2_Duration",
    "OP2_spl_level",
    "OP2_HTTPS_checked",
    "OP2_POST_URL",
    "OP2_TCP_URL",
    "OP2_k1",
    "OP2_v1",
    "OP2_k2",
    "OP2_v2",
    "OP2_k3",
    "OP2_v3",
    "OP2_k4",
    "OP2_v4",
    "OP2_tcp1",
    "OP2_tcp2",
    "OP2_mic_alertLevel0",
    "OP2_mic_alertLevel1",
    "OP2_mic_alertLevel2",
    "OP2_recording_checked",
    "OP2_recording_duration_before",
    "OP2_recording_duration_after",
    "OP2_playback_checked",
    "OP2_playback_file",
    "OP2_playback_volume",
    "OP3_trig_checked",
    "OP3_dest_checked",
    "OP3_active_checked",
    "OP3_Duration",
    "OP3_spl_level",
    "OP3_HTTPS_checked",
    "OP3_POST_URL",
    "OP3_TCP_URL",
    "OP3_k1",
    "OP3_v1",
    "OP3_k2",
    "OP3_v2",
    "OP3_k3",
    "OP3_v3",
    "OP3_k4",
    "OP3_v4",
    "OP3_tcp1",
    "OP3_tcp2",
    "OP3_mic_alertLevel0",
    "OP3_mic_alertLevel1",
    "OP3_mic_alertLevel2",
    "OP3_recording_checked",
    "OP3_recording_duration_before",
    "OP3_recording_duration_after",
    "OP3_playback_checked",
    "OP3_playback_file",
    "OP3_playback_volume",
    "OP4_trig_checked",
    "OP4_dest_checked",
    "OP4_active_checked",
    "OP4_Duration",
    "OP4_spl_level",
    "OP4_HTTPS_checked",
    "OP4_POST_URL",
    "OP4_TCP_URL",
    "OP4_k1",
    "OP4_v1",
    "OP4_k2",
    "OP4_v2",
    "OP4_k3",
    "OP4_v3",
    "OP4_k4",
    "OP4_v4",
    "OP4_tcp1",
    "OP4_tcp2",
    "OP4_mic_alertLevel0",
    "OP4_mic_alertLevel1",
    "OP4_mic_alertLevel2",
    "OP4_recording_checked",
    "OP4_recording_duration_before",
    "OP4_recording_duration_after",
    "OP4_playback_checked",
    "OP4_playback_file",
    "OP4_playback_volume",
    "OP5_trig_checked",
    "OP5_dest_checked",
    "OP5_active_checked",
    "OP5_Duration",
    "OP5_spl_level",
    "OP5_HTTPS_checked",
    "OP5_POST_URL",
    "OP5_TCP_URL",
    "OP5_k1",
    "OP5_v1",
    "OP5_k2",
    "OP5_v2",
    "OP5_k3",
    "OP5_v3",
    "OP5_k4",
    "OP5_v4",
    "OP5_tcp1",
    "OP5_tcp2",
    "OP5_mic_alertLevel0",
    "OP5_mic_alertLevel1",
    "OP5_mic_alertLevel2",
    "OP5_recording_checked",
    "OP5_recording_duration_before",
    "OP5_recording_duration_after",
    "OP5_playback_checked",
    "OP5_playback_file",
    "OP5_playback_volume",
    "dhcpStaticSelected",
    "setStatic",
    "setMask",
    "setRouter",
    "setDNS",
    "SIPInformation",
]
FactoryRmKeys = [
    "OPLED_trig_checked",
    "OPLED_OL_checked",
    "OPLED_dest_checked",
    "OPLED_active_checked",
    "OPLED_Duration",
    "OPLED_HTTPS_checked",
    "OPLED_POST_URL",
    "OPLED_TCP_URL",
    "OPLED_k1",
    "OPLED_v1",
    "OPLED_k2",
    "OPLED_v2",
    "OPLED_k3",
    "OPLED_v3",
    "OPLED_k4",
    "OPLED_v4",
    "OPLED_mic_alertLevel0",
    "OPLED_mic_alertLevel1",
    "OPLED_mic_alertLevel2",
    "OPLED_recording_checked",
    "OPLED_recording_duration_before",
    "OPLED_recording_duration_after",
    "OPLED_playback_checked",
    "OPLED_playback_file",
    "OPLED_playback_volume",
    "VMS",
]
UserRmKeys = [
    "Reset_to_Factory_Defaults_min",
    "Reboot_min",
    "Reboot_max",
    "RTSPNameComment",
    "OutgoingAudioURLComment",
    "IncomingAudioURLComment",
]
UserRequireKeys = [
    "IncludeVideoOnvifDefault",
    "OP1_playback_volume",
    "OP2_playback_volume",
    "OP3_playback_volume",
    "OP4_playback_volume",
    "OP5_playback_volume",
     "OP1_trig_checked",
      "OP2_trig_checked",
       "OP3_trig_checked",
        "OP4_trig_checked",
         "OP5_trig_checked",
]
UserSIPKeys = ["auto_start", "ip", "username", "password", "control_port", "rtp_start", "rtp_end"]
UserONVIFKeys = ["DeviceLocation","HighPassFilter_checked","HighPassFilter","LowPassFilter_checked", "LowPassFilter"]

# configLoc = "~/LE880-Profile-T/LE880factoryConfig.json"
# configUserLoc = "~/LE880-Profile-T/LE880userConfig.json"
authKeys = {"username":"admin","passwordHash":"8bfde9d8d9420219a409919b74d58eb0","browserIDok":"10.10.10.127","browserUAok":"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/100.0.4896.127 Safari/537.36 Edg/100.0.1185.44"}

config = None
configUser = None
configAuth = None
configUserExist = True

#
# TRY TO AnalyticsFiles
#

#
# TRY TO LOAD AUTH
#
try:
    with open(configAuthLoc) as configAuthSource:
        configAuth = json.load(configAuthSource)
        print("Config Auth Existed")
except:
    print("Config Auth Didn't Exist")
    with open(configAuthLoc, "w") as configAuthSource:
        configAuth = authKeys
        configAuthNew = json.dumps(configAuth, indent=2, sort_keys=True)
        configAuthSource.write(configAuthNew)
#
# TRY TO LOAD FACTORY CONFIG
#
try:
    with open(configLoc) as configSource:
        config = json.load(configSource)
        for key in config.keys():
            if not config.get(key):
                config[key] = FactoryDictionary[key]
                print("Key: " +key + " not in keys")
        for key in FactoryRmKeys:
            config.pop(key, None)
except:
    print("Config Factory Didn't Exist")
    with open(configLoc, "w") as configSource:
        config = FactoryDictionary
#
# TRY TO LOAD CONFIG USER
#
try:
    with open(configUserLoc) as configSource:
        configUser = json.load(configSource)
#
# IF User Config Doesn't Exist Preload from Factory
#
except:
    print("Config User Didn't Exist")
    with open(configUserLoc, "w") as configSource:
        configUser = {}
        configUserExist = False

configUserNew = {}
configNew = {}
# print(configUser.keys())

if not configUserExist:
    for key in UserKeys:
        if config.get(key):
            configUser[key] = config[key]

# USER CONFIG
for key in UserKeys:
    if configUser.get(key):
        configUserNew[key] = configUser[key]
    else:
        if key is "SIPInformation":
            configUserNew[key] = {}
        elif key is "ONVIF":
            configUserNew[key] = {}
        else:
            configUserNew[key] = ""
for key in FactoryRmKeys:
    #print(key)
    configUserNew.pop(key, None)
for key in UserRmKeys:
    #print(key)
    configUserNew.pop(key, None)

for key in UserSIPKeys:
    if not configUserNew["SIPInformation"].get(key):
        if key == "auto_start":
            configUserNew["SIPInformation"][key] = "disabled"
        else:
            configUserNew["SIPInformation"][key] = ""

for key in UserONVIFKeys:
    if not configUserNew["ONVIF"].get(key):
        if key == "LowPassFilter_checked":
            configUserNew["ONVIF"][key] = "disabled"
        elif key == "HighPassFilter_checked":
            configUserNew["ONVIF"][key] = "disabled"
        else:
            configUserNew["ONVIF"][key] = ""

for key in UserRequireKeys:
    if configUserNew[key] is "":
        configUserNew[key] = config[key]
#
# IF USER CONFIG DIDNT EXIST FILL WITH FACTORY DEFAULTS
#

configNew = json.dumps(config, indent=2, sort_keys=True)
configNewFile = open("/home/pi/LE880-Profile-T/LE880factoryConfig.json", "w")
configNewFile.write(configNew)

# print(configNew)
configUserNew = json.dumps(configUserNew, indent=2, sort_keys=True)
configUserNewFile = open("/home/pi/LE880-Profile-T/LE880userConfig.json", "w")
# print(configUserNew)
configUserNewFile.write(configUserNew)
