
Object.defineProperty(Date.prototype, 'YYYYMMDDHHMMSSmmm', {
  value: function () {
    function pad2(n) {  // always returns a string
      return (n < 10 ? '00' : '') + n;
    }
    function pad3(n) {  // always returns a string
      return (n < 100 ? '0' : '') + n;
    }
    return this.getFullYear() + '-' +
      pad2(this.getMonth() + 1) + '-' +
      pad2(this.getDate()) + '_' +
      pad2(this.getHours()) + ':' +
      pad2(this.getMinutes()) + ':' +
      pad2(this.getSeconds()) + '.' +
      pad3(this.getMilliseconds());
  }
});
function ts() {
  return new Date().YYYYMMDDHHMMSSmmm() + " : ";
}
window.onload = function () {
  const eUsername = document.getElementById("username");
  eUsername.addEventListener('keydown', (event) => {
    const keyName = event.key;
    if (keyName === 'Control') {
      // do not alert when only Control key is pressed.
      return;
    }
    if (event.ctrlKey) {
      // Even though event.key is not 'Control' (e.g., 'a' is pressed),
      // event.ctrlKey may be true if Ctrl key is pressed at the same time.
      //alert(`Combination of ctrlKey + ${keyName}`);
    } else {
      if (keyName == "Enter") { login(); };
    }
  }, false);
  const ePassword = document.getElementById("password");
  ePassword.addEventListener('keydown', (event) => {
    const keyName = event.key;
    if (keyName === 'Control') {
      // do not alert when only Control key is pressed.
      return;
    }
    if (event.ctrlKey) {
      // Even though event.key is not 'Control' (e.g., 'a' is pressed),
      // event.ctrlKey may be true if Ctrl key is pressed at the same time.
      //alert(`Combination of ctrlKey + ${keyName}`);
    } else {
      if (keyName == "Enter") { login(); };
    }
  }, false);
}
var promiseBrowserID = new Promise(function (resolve, reject) {
  if (typeof RTCPeerConnection == "undefined") {
    console.log(ts() + 'getBrowserID() RTCPeerConnection == "undefined"');
    reject(Error("Error - typeof RTCPeerConnection == undefined"));
  }
  window.RTCPeerConnection = window.RTCPeerConnection || window.mozRTCPeerConnection || window.webkitRTCPeerConnection; //compatibility for Firefox and chrome
  var pc = new RTCPeerConnection({ iceServers: [] }), noop = function () { };
  pc.createDataChannel('');//create a bogus data channel
  pc.createOffer(pc.setLocalDescription.bind(pc), noop);// create offer and set local description
  pc.onicecandidate = function (ice) {
    if (ice && ice.candidate && ice.candidate.candidate) {
      let browserID = ice.candidate.address;
      //In Firefox, this is coming as undefined; so a little HACK here
      if (browserID === undefined) {
        browserID = Date.now().toString(36) + Math.random().toString(36).substring(2);
      }
      //console.log(ts()+"getBrowserID() browserID: " + browserID);
      //console.log(ts()+"getBrowserID() JSON.stringify(ice.candidate): " + JSON.stringify(ice.candidate));	    
      //console.log(ts()+"getBrowserID() JSON.stringify(ice.candidate.address): " + JSON.stringify(ice.candidate.address));
      if (localStorage.getItem('browserID')) {
        browserID = localStorage.getItem('browserID');
      } else {
        localStorage.setItem('browserID', browserID);
      }
      resolve(browserID);
    }
  };
}); // promiseBrowserID
function login() {
  $("#messageBar").css("display", "none");
  $("#messageBar").html("&nbsp;");
  console.log(ts() + "login()");
  var browserUA = null;
  browserUA = navigator.userAgent;
  console.log(ts() + "login() browserUA: " + browserUA);
  var browserID = null;
  promiseBrowserID.then(function (result) {
    browserID = result;
    console.log(ts() + "login() browserID: " + browserID);
    //
    // password must contains 2 of each: lower case, upper case, numbers, special characters
    //
    var n = 2;
    var constructedRegEx = "^(?=(?:.*[0-9]){" + n + ",})(?=(?:.*[a-z]){" + n + ",})(?=(?:.*[A-Z]){" + n + ",})(?=(?:.*[[!@#$%^&*()_+]){" + n + ",}).+$";
    var PasswordRegEx = new RegExp(constructedRegEx, 'm');
    //
    // login request
    //
    var username = $("#username").val();
    var password = $("#password").val();
    if (username.length < 4) {
      console.log(ts() + "login() username length < 4");
      let msg = "Username must be at least 4 characters long.";
      $("#messageBar").css("display", "block");
      $("#messageBar").html(msg);
      return;
    }
    if (!PasswordRegEx.test(password)) {
      console.log(ts() + "login() password test failed");
      let msg = "Password must contain 2 of each: lower case, upper case, numbers, special characters.";
      $("#messageBar").css("display", "block");
      $("#messageBar").html(msg);
      return;
    }
    var passwordHash = hex_md5(password);
    console.log(ts() + "login() passwordHash: " + passwordHash);
    var jsonObj = { "browserID": browserID, "browserUA": browserUA, "username": username.toLowerCase(), "passwordHash": passwordHash };
    console.log(ts() + "login() loginRequest JSON.stringify(jsonObj): " + JSON.stringify(jsonObj));
    $.ajax({
      url: "/loginRequest",
      type: "POST",
      dataType: "json",
      data: jsonObj
    })
      .fail(function (e) {
        console.log(ts() + "login() ERROR loginRequest");
        $("#messageBar").css("display", "block");
        $("#messageBar").html(".fail /loginRequest");
        return;
      })
      .done(function (data) {
        console.log(ts() + "login() .done data: " + data);
        if (data.auth) {
          $("#messageBar").css("display", "block");
          $("#messageBar").html(data.msg);
          if (data.first_login) {
            var first_login = data.first_login;
            console.log(ts() + "login() first_login: " + first_login);
          } else {
            var first_login = "";
          }
          localStorage.browserID = browserID;
          localStorage.browserUA = browserUA;
          $("#browserID").val(browserID);
          $("#browserUA").val(browserUA);
          $("#first_login").val(first_login);
          $("#nextStep").submit();
        } else {
          $("#messageBar").css("display", "block");
          $("#messageBar").html(data.msg);
        }
      });
  }, function (err) {
    console.log(ts() + "ERROR login() promiseBrowserID err: " + err);
    //
    // browser not supported
    //
    console.log(ts() + "login() browser does not support RTCPeerConnection ice.candidate");
    msg = "This browser does not support WebRTC and is not support. Please use Chromium, Chrome, or Firefox.";
    $("#messageBar").css("display", "block");
    $("#messageBar").html(msg);
    var jsonObj = { "msg": msg, "browserUA": browserUA, "username": username, "password": password };
    $.ajax({
      url: "/loginBrowserNotSupported",
      type: "POST",
      dataType: "json",
      data: jsonObj
    })
      .fail(function (e) {
        console.log(ts() + "ERROR login() loginFailed");
      })
      .done(function (data) {
        $("#messageBar").css("display", "block");
        $("#messageBar").html(data.msg);
      });
  });// promiseBrowserID.then
} // login()
