//
// Set this to override the automatic detection in websocketServerConnect()
//
var ws_server;
var ws_port;
//
// Set this to use a specific peer id instead of a random one
//
var default_peer_id = 880; // for LE880
//
// spectrum analyzers and codecs
//
var remoteAnalyzer = true;
//var remoteAnalyzer 	= false;
var streamRemote = null; // LE880
var audioCtxRemote = null;
var gainNodeRemote = null; // use for remote volume
var remoteCodec = "G.711";
//var remoteCodec 	= "";
//var localAnalyzer = true;
var localAnalyzer = false;
var streamLocal = null; // browser
var audioCtxLocal = null;
var gainNodeLocal = null; // use for local volume
//var localCodec 	= "G.711";
var localCodec = "";
/*
adjust spectrum analyzer for codec
G.711 mulaw and alaw 300–3400 Hz
spectrum analyzer bands 1, 2, and 3 show low frequency data that is not in the audio
https://developer.mozilla.org/en-US/docs/Web/API/AnalyserNode/getByteFrequencyData
The frequency data is composed of integers on a scale from 0 to 255.
Each item in the array represents the decibel value for a specific frequency.
The frequencies are spread linearly from 0 to 1/2 of the sample rate.
For example, for 48000 sample rate, the last item of the array will represent the decibel value for 24000 Hz.
G.711 8,000 sample per second
bufferLengthAlt = 128
each band = (8,000/2) / 128 = 31.25 Hz
bands:
1	   31.25
2	   62.50
3	   93.75
4	  125.00
5	  156.25
6	  187.50
7	  218.75
8	  250.00
9	  281.35
10	  312.50
...
*
108	3,375.00
109	3,406.25
...
128	4,000.00
*/
//
// Override with your own STUN servers if you want
//
/*
var rtc_configuration = {iceServers: [{urls: "stun:stun.services.mozilla.com"},
									  {urls: "stun:stun.l.google.com:19302"}]};
*/
//
// local network only for test
//
var rtc_configuration = { "iceServers": [] };
//
// The default constraints that will be attempted. Can be overriden by the user.
//
//var default_constraints = {video: false, audio: true};
var default_constraints = {
	video: false,
	audio: {
		sampleSize: 8,
		//echoCancellation: true
	}
}
var connect_attempts = 0;
var peer_connection;
var send_channel;
var ws_conn;
// Promise for local stream after constraints are approved by the user
var local_stream_promise;
function getOurId() {
	return Math.floor(Math.random() * (9000 - 10) + 10).toString();
}
function resetState() {
	// This will call onServerClose()
	ws_conn.close();
}
function handleIncomingError(error) {
	setError("ERROR: " + error);
	resetState();
}
function getRemoteElement() {
	return document.getElementById("audioPlayerLocalIn");
}
function getLocalElement() {
	return document.getElementById("audioPlayerLocalOut");
}
function setStatus(text) {
	//console.log(ts()+"webrtc: " + text);
	/*
	var span = document.getElementById("status")
	// Don't set the status if it already contains an error
	if (!span.classList.contains('error'))
		span.textContent = text;
	*/
}
function setError(text) {
	console.error(ts() + text);
	//var span = document.getElementById("status")
	//span.textContent = text;
	//span.classList.add('error');
}
function AudioSpectrogram(analyserNode, cvsID) {
	const frqBuf = new Uint8Array(analyserNode.frequencyBinCount); // 1024
	console.log(analyserNode.frequencyBinCount)
	const wfNumPts = 50 * analyserNode.frequencyBinCount / 128; // 400 +ve freq bins
	const wfBufAry = { buffer: frqBuf };
	console.log("NumPTS: " + wfNumPts + " Bin Count: " + analyserNode.frequencyBinCount);
	const wf = new Waterfall(wfBufAry, wfNumPts / 2, wfNumPts / 2, "left", { lineRate: 50, startBin: 20 });
	const canvas = document.getElementById(cvsID);
	const ctx = canvas.getContext("2d", { willReadFrequently: true });
	this.playing = false;
	this.begin = () => {
		wf.start();
		this.playing = true;
		this.drawOnScreen();
	};
	this.halt = () => {
		wf.stop();
		this.playing = false;
	};
	this.drawOnScreen = () => {
		analyserNode.getByteFrequencyData(frqBuf, 0);
		ctx.drawImage(wf.offScreenCvs, 0, 0);
		if (this.playing) requestAnimationFrame(this.drawOnScreen);
	};
}
function resetPlayers() {
	console.log(ts() + "resetPlayers()");
	//document.getElementById('audioPlayerLocalOutMsg').innerHTML = "Browser to LE880 stopped.";
	document.getElementById('audioPlayerLocalInMsg').innerHTML = "LE880 to Browser stopped.";
	// Release the local webcam and mic
	if (local_stream_promise) {
		local_stream_promise.then(stream => {
			if (streamLocal) {
				streamLocal.getTracks().forEach(function (track) { track.stop(); });
				console.log(ts() + "resetPlayers(): streamLocal tracks track.stop()");
			}
		})
	}
	//
	// close local audioCtx and clear spectrogram
	//
	if (typeof audioCtxLocal === 'object') {
		// do nothing if null
	} else {
		audioCtxLocal.close().then(function () {
			var drawVisual;
			var draw = function () {
				drawVisual = requestAnimationFrame(draw);
				var canvasLocal = document.getElementById("audioPlayerLocalOutCanvas");
				var canvasCtxLocal = canvasLocal.getContext("2d");
				var WIDTHLocal = canvasLocal.width;
				var HEIGHTLocal = canvasLocal.height;
				//console.log(ts()+"resetPlayers(): WIDTHLocal = " + WIDTHLocal + ", HEIGHTLocal = " + HEIGHTLocal);
				canvasCtxLocal.fillStyle = 'black';
				canvasCtxLocal.fillRect(0, 0, WIDTHLocal, HEIGHTLocal);
			};
			draw();
		});
	}
	//
	// Reset the local player and stop playing
	//
	/*
		var localElement = getLocalElement();
		//localElement.pause();
		localElement.srcObject = null;
		localElement.src = "";
		localElement.load();
		console.log(ts() + "resetPlayers(): reset local player");
	
		streamLocal = null; // browser
		audioCtxLocal = null;
		gainNodeLocal = null; // use for local volume        
	*/
	//
	// close remote audioCtx and clear spectrogram
	//
	if (typeof audioCtxRemote === 'object') {
		// do nothing if null
	} else {
		audioCtxRemote.close().then(function () {
			let drawVisual;
			let draw = function () {
				drawVisual = requestAnimationFrame(draw);
				let canvasRemote = document.getElementById("audioPlayerLocalInCanvas");
				let canvasCtxRemote = canvasRemote.getContext("2d");
				let WIDTHRemote = canvasRemote.width;
				let HEIGHTRemote = canvasRemote.height;
				//console.log(ts()+"resetPlayers(): WIDTHRemote = " + WIDTHRemote + ", HEIGHTRemote = " + HEIGHTRemote);
				canvasCtxRemote.fillStyle = 'black';
				canvasCtxRemote.fillRect(0, 0, WIDTHRemote, HEIGHTRemote);
			};
			draw();
		});
	}
	//
	// Reset the remote player and stop playing
	//
	let remoteElement = getRemoteElement();
	remoteElement.pause();
	remoteElement.srcObject = null;
	remoteElement.src = "";
	remoteElement.load();
	console.log(ts() + "resetPlayers(): reset remote player");
	streamRemote = null; // LE880
	audioCtxRemote = null;
	gainNodeRemote = null; // use for remote volume
}
// SDP offer received from peer, set remote description and create an answer
function onIncomingSDP(sdp) {
	peer_connection.setRemoteDescription(sdp).then(() => {
		console.log(ts() + "webrtc: Remote SDP set: \n" + JSON.stringify(sdp));
		if (sdp.type != "offer")
			return;
		console.log(ts() + "webrtc: Got SDP offer");
		local_stream_promise.then((streamLocal) => {
			console.log(ts() + "webrtc: Got local stream, creating answer");
			peer_connection.createAnswer()
				.then(onLocalDescription).catch(setError);
		}).catch(setError);
	}).catch(setError);
}
// Local description was set, send it to peer
function onLocalDescription(desc) {
	console.log(ts() + "webrtc: Got local description: \n" + JSON.stringify(desc));
	peer_connection.setLocalDescription(desc).then(function () {
		console.log(ts() + "webrtc: Sending SDP " + desc.type);
		sdp = { 'sdp': peer_connection.localDescription }
		ws_conn.send(JSON.stringify(sdp));
	});
}
function generateOffer() {
	peer_connection.createOffer().then(onLocalDescription).catch(setError);
}
// ICE candidate received from peer, add it to the peer connection
function onIncomingICE(ice) {
	var candidate = new RTCIceCandidate(ice);
	peer_connection.addIceCandidate(candidate).catch(setError);
}
function onServerMessage(event) {
	//console.log(ts()+"webrtc: onServerMessage(event): " + JSON.stringify(event));  
	//console.log(ts()+"webrtc: onServerMessage(event): " + event.data);
	//console.dir(event);
	switch (event.data) {
		case "HELLO":
			console.log(ts() + "webrtc onServerMessage(event): Registered with server, waiting for call");
			return;
		default:
			if (event.data.startsWith("ERROR")) {
				handleIncomingError(event.data);
				return;
			}
			if (event.data.startsWith("OFFER_REQUEST")) {
				// The peer wants us to set up and then send an offer
				if (!peer_connection)
					createCall(null).then(generateOffer);
			}
			else {
				// Handle incoming JSON SDP and ICE messages
				try {
					msg = JSON.parse(event.data);
				} catch (e) {
					if (e instanceof SyntaxError) {
						handleIncomingError("Error parsing incoming JSON: " + event.data);
					} else {
						handleIncomingError("Unknown error parsing response: " + event.data);
					}
					return;
				}
				// Incoming JSON signals the beginning of a call
				if (!peer_connection)
					createCall(msg);
				if (msg.sdp != null) {
					onIncomingSDP(msg.sdp);
				} else if (msg.ice != null) {
					onIncomingICE(msg.ice);
				} else {
					handleIncomingError("Unknown incoming JSON: " + msg);
				}
			}
	}
}
function onServerClose(event) {
	console.log(ts() + "webrtc: Disconnected from server, resetPlayers(), set peer_connection = null");
	resetPlayers();
	if (peer_connection) {
		peer_connection.close();
		peer_connection = null;
	}
	// Reset after a second
	window.setTimeout(websocketServerConnect, 1000);
}
function onServerError(event) {
	setError("Unable to connect to server, did you add an exception for the certificate?")
	// Retry after 3 seconds
	window.setTimeout(websocketServerConnect, 3000);
}
function getLocalStream() {
	// Add local stream
	if (navigator.mediaDevices.getUserMedia) {
		console.log(ts() + "webrtc: navigator.mediaDevices.getUserMedia");
		return navigator.mediaDevices.getUserMedia(default_constraints);
	} else {
		errorUserMediaHandler();
	}
}
function websocketServerConnect() {
	connect_attempts++;
	if (connect_attempts > 3) {
		setError("Too many connection attempts, aborting. Refresh page to try again");
		return;
	}
	// Fetch the peer id to use
	peer_id = default_peer_id || getOurId();
	ws_port = ws_port || '8443';
	if (window.location.protocol.startsWith("file")) {
		ws_server = ws_server || "127.0.0.1";
	} else if (window.location.protocol.startsWith("http")) {
		ws_server = ws_server || window.location.hostname;
	} else {
		throw new Error("Don't know how to connect to the signalling server with uri" + window.location);
	}
	let ws_url = 'wss://' + ws_server + ':' + ws_port
	console.log(ts() + "webrtc websocketServerConnect(): Connecting to server " + ws_url);
	ws_conn = new WebSocket(ws_url);
	/* When connected, immediately register with the server */
	ws_conn.addEventListener('open', (event) => {
		ws_conn.send('HELLO ' + peer_id);
		//console.log(ts()+"webrtc: Registering with server, peer_id: " + peer_id + ", port: " + ws_port);
	});
	ws_conn.addEventListener('error', onServerError);
	ws_conn.addEventListener('message', onServerMessage);
	ws_conn.addEventListener('close', onServerClose);
}
function onRemoteTrack(event) {
	//
	// LE880 to browser (remote w.r.t. browser)
	//
	console.log(ts() + "webrtc: onRemoteTrack(event) JSON.stringify(event): " + JSON.stringify(event));
	if (getRemoteElement().srcObject !== event.streams[0]) {
		console.log(ts() + "webrtc: onRemoteTrack(event) getRemoteElement().srcObject = event.streams[0]");
		getRemoteElement().srcObject = event.streams[0];
		//expand("expand", "audioPlayerLocalIn", "playerContainer");
		//
		// overcome restrction on autoplay
		// https://developers.google.com/web/updates/2017/09/autoplay-policy-changes
		//
		setTimeout(function () {
			//console.log(ts()+"webrtc: onRemoteTrack() getRemoteElement().muted = false");
			//getRemoteElement().muted = false;
			//console.log(ts()+"webrtc: onRemoteTrack() getRemoteElement().play()");
			getRemoteElement().play();
			getRemoteElement().muted = false; // controls display only, does not affect volume
			document.getElementById('audioPlayerLocalInMsg').innerHTML = "LE880 to Browser established.";
			//
			// wait for player to become active before adding event listener
			//
			if (remoteAnalyzer == true) {
				getRemoteElement().addEventListener("volumechange", function (e) {
					let oldVolume = e.target.volume;
					let newVolume = 0 * 1;
					console.log(ts() + "webrtc: Remote player old volume : " + oldVolume);
					let msg = "Volume: " + oldVolume.toFixed(1);
					if (e.target.muted) {
						newVolume = 0 * 1;
						gainNodeRemote.gain.value = newVolume;
						msg += " (Muted)";
					} else {
						newVolume = oldVolume;
						gainNodeRemote.gain.value = newVolume;
						msg += " (Unmuted)";
					}
					//document.getElementById("remoteStatus").innerHTML = msg;
					document.getElementById("audioPlayerLocalInMsg").innerHTML = msg;
				}, true);
				//
				// use AudioContext for volume control and spectrum analyzer
				//
				audioCtxRemote = new (window.AudioContext || window.webkitAudioContext)({ sampleRate: 16000 });
				let analyser = audioCtxRemote.createAnalyser();
				analyser.minDecibels = -92;
				analyser.maxDecibels = 0;
				analyser.smoothingTimeConstant = .82;
				gainNodeRemote = audioCtxRemote.createGain();
				//
				// remote visualization start
				//
				let loopCnt = 0 * 1;
				let canvas = document.getElementById("audioPlayerLocalInCanvas");
				let temp = new AudioSpectrogram(analyser, "audioPlayerLocalInCanvas");
				temp.begin();
				var canvasCtx = canvas.getContext("2d");
				//canvas.setAttribute('width', "480px");
				function visualize() {
					let WIDTH = canvas.width;
					let HEIGHT = canvas.height;
					let drawVisual;
					let visualSetting = "frequencybars";
					//var visualSetting  = "sinewave";
					//console.log(ts()+visualSetting);
					if (visualSetting === "sinewave") {
						analyser.fftSize = 2048;
						var bufferLength = analyser.fftSize;
						//console.log(ts()+bufferLength);
						var dataArray = new Uint8Array(bufferLength);
						canvasCtx.clearRect(0, 0, WIDTH, HEIGHT);
						var draw = function () {
							drawVisual = requestAnimationFrame(draw);
							analyser.getByteTimeDomainData(dataArray);
							canvasCtx.fillStyle = 'rgb(200, 200, 200)';
							canvasCtx.fillRect(0, 0, WIDTH, HEIGHT);
							canvasCtx.lineWidth = 2;
							canvasCtx.strokeStyle = 'rgb(0, 0, 0)';
							canvasCtx.beginPath();
							let sliceWidth = WIDTH * 1.0 / bufferLength;
							var x = 0;
							for (var i = 0; i < bufferLength; i++) {
								var v = dataArray[i] / 128.0;
								var y = v * HEIGHT / 2;
								//console.log(ts()+"remoteAnalyzer sinewave i: " + i + ", v: " + v);
								if (i === 0) {
									canvasCtx.moveTo(x, y);
								} else {
									canvasCtx.lineTo(x, y);
								}
								x += sliceWidth;
							}
							canvasCtx.lineTo(canvas.width, canvas.height / 2);
							canvasCtx.stroke();
						};
						draw();
					} else if (visualSetting == "frequencybars") {
						//analyser.fftSize = 256;
						analyser.fftSize = 128;
						let bufferLengthAlt = analyser.frequencyBinCount;
						console.log(ts() + "webrtc: remote frequencybars bufferLengthAlt: " + bufferLengthAlt);
						let dataArrayAlt = new Uint8Array(bufferLengthAlt);
						canvasCtx.clearRect(0, 0, WIDTH, HEIGHT);
						let drawAlt = function () {
							drawVisual = requestAnimationFrame(drawAlt);
							analyser.getByteFrequencyData(dataArrayAlt);
							/*
							if(loopCnt == 10){
							 
						  if(loopCnt == 0){
							console.log(ts()+"webrtc: remote frequencybars loopCnt: " + loopCnt + ", JSON.stringify(dataArrayAlt): " + JSON.stringify(dataArrayAlt));
							console.log(ts()+"webrtc: remote frequencybars loopCnt: " + loopCnt + ", bufferLengthAlt: " + bufferLengthAlt);
						  }
						    
							loopCnt++;
							}
							*/
							canvasCtx.fillStyle = 'rgb(0, 0, 0)';
							canvasCtx.fillRect(0, 0, WIDTH, HEIGHT);
							let barWidth = (WIDTH / bufferLengthAlt) * 2.5;
							let barHeight;
							let x = 0;
							if (remoteCodec == "G.711") {
								let i_start = 3;
								let i_max = bufferLengthAlt;
							} else {
								let i_start = 0;
								let i_max = bufferLengthAlt;
							}
							for (var i = i_start; i < i_max; i++) {
								//if(i == 3){
								//console.log(ts()+"remoteAnalyzer barHeight dataArrayAlt[" + i + "]: " + dataArrayAlt[i]);
								//}
								barHeight = dataArrayAlt[i];
								//barHeight = dataArrayAlt[i] * 5;
								canvasCtx.fillStyle = 'rgb(' + (barHeight + 100) + ',50,50)';
								canvasCtx.fillRect(x, HEIGHT - barHeight / 2, barWidth, barHeight / 2);
								x += barWidth + 1;
							}
						}; // drawAlt
						drawAlt();
					} else if (visualSetting == "off") {
						canvasCtx.clearRect(0, 0, WIDTH, HEIGHT);
						canvasCtx.fillStyle = "red";
						canvasCtx.fillRect(0, 0, WIDTH, HEIGHT);
					}
				} // visualize()
				if (event.streams[0].getAudioTracks().length) {
					console.log(ts() + "webrtc: remote event.streams[0].getAudioTracks().length = " + event.streams[0].getAudioTracks().length);
					let source = audioCtxRemote.createMediaStreamSource(event.streams[0]);
					console.log(ts() + "webrtc: remote visualization source:" + source.toString());
					source.connect(gainNodeRemote);
					gainNodeRemote.connect(analyser);
					analyser.connect(audioCtxRemote.destination);
					//console.log(ts()+"webrtc: remote gainNodeRemote.gain.minValue = " +  gainNodeRemote.gain.minValue);
					//console.log(ts()+"webrtc: remote gainNodeRemote.gain.maxValue = " +  gainNodeRemote.gain.maxValue);
					console.log(ts() + "webrtc: remote gainNodeRemote.gain.value = " + gainNodeRemote.gain.value);
					//gainNodeRemote.gain.value = 5;
					//console.log(ts()+"webrtc: remote gainNodeRemote.gain.value = " +  gainNodeRemote.gain.value);
					//visualize();
					//
					// set browser mic to very low (0.01) after connection is fully established
					// so admin does not hear the browser mic from the browser speaker
					// display is active
					//
					//getLocalElement().volume = 0.01; // allow display to operate but set volume very low
					//document.getElementById("audioPlayerLocalOutVolume").innerHTML = 0.01;
					//document.getElementById("audioPlayerLocalOutUp").disabled = false;
					//getLocalElement().muted = true; // controls display only, does not change volume
				}
				//
				// remote visualization end
				// 
			} // if(remoteAnalyzer == true)
		}, 1000);
	} // if (getRemoteElement().srcObject !== event.streams[0])
} // onRemoteTrack(event)
function errorUserMediaHandler() {
	setError("Browser doesn't support getUserMedia!");
}
const handleDataChannelOpen = (event) => {
	console.log(ts() + "webrtc: dataChannel.OnOpen", event);
};
const handleDataChannelMessageReceived = (event) => {
	console.log(ts() + "webrtc: dataChannel.OnMessage:", event, event.data.type);
	console.log(ts() + "webrtc: Received data channel message");
	if (typeof event.data === 'string' || event.data instanceof String) {
		console.log(ts() + "webrtc: Incoming string message: " + event.data);
		//textarea = document.getElementById("text")
		//textarea.value = textarea.value + '\n' + event.data
	} else {
		console.log(ts() + "webrtc: Incoming data message");
	}
	send_channel.send("Hi! (from browser)");
};
const handleDataChannelError = (error) => {
	console.log(ts() + "webrtc: dataChannel.OnError:", error);
};
const handleDataChannelClose = (event) => {
	console.log(ts() + "webrtc: dataChannel.OnClose", event);
};
function onDataChannel(event) {
	console.log(ts() + "webrtc: Data channel created");
	let receiveChannel = event.channel;
	receiveChannel.onopen = handleDataChannelOpen;
	receiveChannel.onmessage = handleDataChannelMessageReceived;
	receiveChannel.onerror = handleDataChannelError;
	receiveChannel.onclose = handleDataChannelClose;
}
function createCall(msg) {
	// Reset connection attempts because we connected successfully
	connect_attempts = 0;
	console.log(ts() + "webrtc: Creating RTCPeerConnection");
	peer_connection = new RTCPeerConnection(rtc_configuration);
	send_channel = peer_connection.createDataChannel('label', null);
	send_channel.onopen = handleDataChannelOpen;
	send_channel.onmessage = handleDataChannelMessageReceived;
	send_channel.onerror = handleDataChannelError;
	send_channel.onclose = handleDataChannelClose;
	peer_connection.ondatachannel = onDataChannel;
	peer_connection.ontrack = onRemoteTrack;
	//
	// browser to LE880 (local w.r.t. browser)
	//
	/* Send our video/audio to the other peer */
	local_stream_promise = getLocalStream().then((streamLocal) => {
		console.log(ts() + "webrtc: Adding local stream");
		peer_connection.addStream(streamLocal);
		//	getLocalElement().srcObject = streamLocal;
		//getLocalElement().muted = false; // controls display only, does not change volume
		//	document.getElementById('audioPlayerLocalOutMsg').innerHTML = "Browser to LE880 established.";
		//
		// wait for player to become active before adding event listener
		//
		if (localAnalyzer == true) {
			getLocalElement().addEventListener("volumechange", function (e) {
				let oldVolume = e.target.volume;
				let newVolume = 0 * 1;
				//console.log(ts()+"webrtc: Local player volume : " + oldVolume);
				let msg = "Volume: " + oldVolume.toFixed(1);
				if (e.target.muted) {
					newVolume = 0 * 1;
					gainNodeLocal.gain.value = newVolume;
					msg += " (Muted)";
				} else {
					newVolume = oldVolume;
					gainNodeLocal.gain.value = newVolume;
					msg += " (Unmuted)";
				}
				//document.getElementById("localStatus").innerHTML = msg;
				//document.getElementById("audioPlayerLocalOutMsg").innerHTML = msg;
			}, true);
			//
			// use AudioContext for volume control, and spectrum analyzer
			//
			audioCtxLocal = new (window.AudioContext || window.webkitAudioContext)();
			var analyser = audioCtxLocal.createAnalyser();
			analyser.minDecibels = -90;
			analyser.maxDecibels = -10;
			analyser.smoothingTimeConstant = 0.85;
			gainNodeLocal = audioCtxLocal.createGain();
			//
			// local visualization start
			//
			//var canvas = document.getElementById("audioPlayerLocalOutCanvas");
			//var temp2 = new AudioSpectrogram(analyser, "audioPlayerLocalOutCanvas");
			//temp2.begin();
			//var canvasCtx = canvas.getContext("2d");
			//canvas.setAttribute('width', "480px");
			function visualize() {
				var WIDTH = canvas.width;
				var HEIGHT = canvas.height;
				var drawVisual;
				var visualSetting = "frequencybars";
				//console.log(ts()+visualSetting);
				if (visualSetting === "sinewave") {
					analyser.fftSize = 2048;
					var bufferLength = analyser.fftSize;
					//console.log(ts()+bufferLength);
					var dataArray = new Uint8Array(bufferLength);
					canvasCtx.clearRect(0, 0, WIDTH, HEIGHT);
					var draw = function () {
						drawVisual = requestAnimationFrame(draw);
						analyser.getByteTimeDomainData(dataArray);
						canvasCtx.fillStyle = 'rgb(200, 200, 200)';
						canvasCtx.fillRect(0, 0, WIDTH, HEIGHT);
						canvasCtx.lineWidth = 2;
						canvasCtx.strokeStyle = 'rgb(0, 0, 0)';
						canvasCtx.beginPath();
						var sliceWidth = WIDTH * 1.0 / bufferLength;
						var x = 0;
						for (var i = 0; i < bufferLength; i++) {
							var v = dataArray[i] / 128.0;
							var y = v * HEIGHT / 2;
							if (i === 0) {
								canvasCtx.moveTo(x, y);
							} else {
								canvasCtx.lineTo(x, y);
							}
							x += sliceWidth;
						}
						canvasCtx.lineTo(canvas.width, canvas.height / 2);
						canvasCtx.stroke();
					};
					draw();
				} else if (visualSetting == "frequencybars") {
					//analyser.fftSize = 256;
					analyser.fftSize = 128;
					var bufferLengthAlt = analyser.frequencyBinCount;
					//console.log(ts()+"webrtc: local frequencybars bufferLengthAlt: " + bufferLengthAlt);
					var dataArrayAlt = new Uint8Array(bufferLengthAlt);
					canvasCtx.clearRect(0, 0, WIDTH, HEIGHT);
					var drawAlt = function () {
						drawVisual = requestAnimationFrame(drawAlt);
						analyser.getByteFrequencyData(dataArrayAlt);
						canvasCtx.fillStyle = 'rgb(0, 0, 0)';
						canvasCtx.fillRect(0, 0, WIDTH, HEIGHT);
						var barWidth = (WIDTH / bufferLengthAlt) * 2.5;
						var barHeight;
						var x = 0;
						if (localCodec == "G.711") {
							var i_start = 3;
							var i_max = bufferLengthAlt;
						} else {
							var i_start = 0;
							var i_max = bufferLengthAlt;
						}
						for (var i = i_start; i < i_max; i++) {
							barHeight = dataArrayAlt[i];
							canvasCtx.fillStyle = 'rgb(' + (barHeight + 100) + ',50,50)';
							canvasCtx.fillRect(x, HEIGHT - barHeight / 2, barWidth, barHeight / 2);
							x += barWidth + 1;
						}
					};
					drawAlt();
				} else if (visualSetting == "off") {
					canvasCtx.clearRect(0, 0, WIDTH, HEIGHT);
					canvasCtx.fillStyle = "red";
					canvasCtx.fillRect(0, 0, WIDTH, HEIGHT);
				}
			} // visualize()
			if (streamLocal) {
				console.log(ts() + "webrtc: streamLocal.toString()= " + streamLocal.toString());
				var source = audioCtxLocal.createMediaStreamSource(streamLocal);
				//console.log(ts()+"webrtc: local visualization source:" + source.toString());
				source.connect(gainNodeLocal);
				gainNodeLocal.connect(analyser);
				analyser.connect(audioCtxLocal.destination);
				//console.log(ts()+"webrtc: local gainNodeLocal.gain.minValue = " +  gainNodeLocal.gain.minValue);
				//console.log(ts()+"webrtc: local gainNodeLocal.gain.maxValue = " +  gainNodeLocal.gain.maxValue);
				//console.log(ts()+"webrtc: local gainNodeLocal.gain.value = " +  gainNodeLocal.gain.value);       
				//visualize();
			}
			//
			// local visualization end
			//
		} // if(localAnalyzer == true)
		return streamLocal;
	}).catch(setError);
	if (msg != null && !msg.sdp) {
		console.log(ts() + "webrtc: WARNING: First message wasn't an SDP message!?");
	}
	peer_connection.onicecandidate = (event) => {
		// We have a candidate, send it to the remote party with the
		// same uuid
		if (event.candidate == null) {
			console.log(ts() + "webrtc: ICE Candidate was null, done");
			return;
		}
		ws_conn.send(JSON.stringify({ 'ice': event.candidate }));
	};
	if (msg != null)
		console.log(ts() + "webrtc: Created peer connection for call, waiting for SDP");
	return local_stream_promise;
}
