Object.defineProperty(Date.prototype, 'YYYYMMDDHHMMSSmmm', {
  value: function () {
    function pad2(n) {  // always returns a string
      return (n < 10 ? '0' : '') + n;
    }
    function pad3(n) {  // always returns a string
      if (n < 10) { return '00' + n }
      else if (n < 100) { return '0' + n }
      else { return '' + n }
    }
    return this.getFullYear() + '-' +
      pad2(this.getMonth() + 1) + '-' +
      pad2(this.getDate()) + '_' +
      pad2(this.getHours()) + ':' +
      pad2(this.getMinutes()) + ':' +
      pad2(this.getSeconds()) + '.' +
      pad3(this.getMilliseconds());
  }
});
function ts() {
  return new Date().YYYYMMDDHHMMSSmmm() + " : ";
}
function ts1() {
  return new Date().YYYYMMDDHHMMSSmmm();
}
var s2cSignalTimeout = 30000; // 30000 mSec = 30 sec
var s2cSignalCount = 0 * 1;
var s2cSignalErrorFirst = null;
//var s2cSignalWatchdogFlag	= false;
//var s2cSignalWatchdogReset	= null;
var sentFile = "no_sentFile";
var recvFile = "no_recvFile";
var VMSsendOnOffstate = "off";
var VMSrecvOnOffstate = "off";
//var LE880wssServerMicAlerton = false;
var LE880wssServerMicAlerton = true;
//var alertPORT 		= null;
var alertPORT = "OP1";
var half_full_duplex_state = "half";
var vms_half_full_duplex_state = "full";
var VMSloopbackURL = "not defined";
//
// restart intercom vars
//
var audioCtxRemoteState = null;
var audioCtxLocalState = null;
var pttDown = false;
var demoModeEnabled = false;

function showHidewithObject(object) {
  //console.log("object=" + JSON.stringify(object));
  if (object.target == "playback") {
    if (object.action == "microphone") {
      $("#VMSSettingsRow").hide();
      $("#IntercomSettingsRow").hide();
      $("#volSpeaker").hide();
      $("#VMSvolSpeaker").hide();
      $("div[name='PlaybackDivE2A']").hide();
      $("#btnPlaybackSettings").hide();
    } else {
      $("#VMSSettingsRow").show();
      $("#IntercomSettingsRow").show();
      $("#volSpeaker").show();
      $("#VMSvolSpeaker").show();
      $("div[name='PlaybackDivE2A']").show();
      $("#btnPlaybackSettings").show();
    }
  }
  else if (object.target == "post") {
    if (object.action == "all") {
      for (let i = 0; i <= 5; i++) {
        showHidewithObject({ "target": "post", "action": i })
      }
    } else {
      let i = object.action;
      var selectedValue = $('#OP' + i + '_HTTPS').children("option:selected").val();
      if (selectedValue == "disabled") {
        $("#OP" + i + "_JSON_DIV").hide();
        $("#OP" + i + "_TCP_DIV").hide();
      }
      else if (selectedValue == "https") {
        $("#OP" + i + "_JSON_DIV").show();
        $("#OP" + i + "_TCP_DIV").hide();
      }
      else if (selectedValue == "tcp") {
        $("#OP" + i + "_JSON_DIV").hide();
        $("#OP" + i + "_TCP_DIV").show();
      }
    }
  }
  else if (object.target == "acoustic") {
    if (object.action == "all") {
      for (let i = 0; i <= 5; i++) {
        showHidewithObject({ "target": "acoustic", "action": i });
      }
    } else {
      let i = object.action;
      var selectedValue = $('#OP' + i + '_trig').children("option:selected").val();
      if (selectedValue == "mic") {
        $("#OP" + i + "_button_mic_level").show();
        $("#OP" + i + "_spl_level_div").hide();
      }
      else if (selectedValue == "Explosion&Acoustics") {
        $("#OP" + i + "_spl_level_div").show();
        $("#OP" + i + "_button_mic_level").hide();
      }
      else {
        $("#OP" + i + "_spl_level_div").hide();
        $("#OP" + i + "_button_mic_level").hide();
        $("#OP" + i + "_mic_set").hide();
      }
    }
  }
  else if (object.target == "dropdown") {
    if ($(object.contentContainer).is(":visible")) {
      $(object.buttonIcon).removeClass("fa-caret-square-up").addClass("fa-caret-square-down");
      $(object.contentContainer).hide();
    } else {
      $(object.buttonIcon).removeClass("fa-caret-square-down").addClass("fa-caret-square-up");
      $(object.contentContainer).show();
    }
  }
  else if (object.target == "container") {
    $('.menuButton').removeClass('menuButtonActive');
    $('.hiddenOnload').hide();
    $(object.contentContainer).show();
    $(object.menuButton).addClass('menuButtonActive');
    if (object.menuButton == '#btnOutputSettings') {
      refreshEvent("refreshPlaybackE2A")
      refreshEvent("refreshOutputPort")
      showHidewithObject({ "target": "led", "action": "all" })
    }
    else if (object.menuButton == '#btnAnalyticsSettings') refreshEvent("refreshAnalyticThreats");
    else if (object.menuButton == '#btnRecordingsSettings') refreshEvent("listAudioFiles");
    else if (object.menuButton == '#btnPlaybackSettings') refreshEvent("listPlaybackFiles");
  }
  else if (object.target == "led") {
    if (object.action == "all") {
      for (let i = 0; i <= 5; i++) {
        showHidewithObject({ "target": "led", "action": i })
      }
    } else {
      let i = object.action;
      var selectedPort = $('#OP' + i + '_dest').children("option:selected").val();
      var selectedDuration = $('#OP' + i + '_Duration').val();
      (selectedPort === "OPLED" && selectedDuration == "0") ? $("#OP" + i + "_clearLED").show() : $("#OP" + i + "_clearLED").hide()
    }
  }
  else if (object.target == "output") {

  }
}
function demoMode() {
  demoModeEnabled = true;
  //$("#alertContainer").insertAfter("#audioPlayerLocalIncontent");
  $("#audioPlayerLocalIncontent").insertBefore("#analyticsDisplayBar");
  $("#audioPlayerLocalIncontent").addClass("my-2");
  //$("#alertContainer").addClass("my-2");
  $("#btnHelpSettings").hide();
  $("#paSettingsContent").hide();
  $("#btnUpdateSettings").hide();
  $("#btnPlaybackSettings").hide();
  $("#btnInputSettings").hide();
  intercomOnOff()
  $("#audioSettingsContent").hide();
  $("#audioSettingsContent").hide();
  //showContainer('#btnAudioSettings', '#audioContainer');
  showHidewithObject({ "target": "container", "menuButton": "#btnAnalyticsSettings", "contentContainer": "#analyticsContainer" });
  $("#analyticsDisplayBar").hide();
  $("#messageBar").text("Demo Mode Enabled!");
  showHidewithObject({ "target": "dropdown", "buttonIcon": "#VMSIcon", "contentContainer": "#VMSSettings" });
  //showHide("#VMSIcon", "#VMSSettings");
  showHidewithObject({ "target": "dropdown", "buttonIcon": "#IntIcon", "contentContainer": "#intercomSettings" });
  //showHide("#IntIcon", "#intercomSettings");
}

window.onload = function () {
  document.getElementById('buttonIntercomOnOff').style.backgroundColor = "lightblue";
  $('.playerBox').hide()
  hideAll();
  showHidewithObject({ "target": "post", "action": "all" });
  showHidewithObject({ "target": "acoustic", "action": "all" });
  showHidewithObject({ "target": "led", "action": "all" });
  /*
  for (let i = 0; i <= 5; i++) {
    showHidePOST(i);
  }
  for (let i = 0; i <= 5; i++) {
    showHideMIC(i);
  }
  */
  //document.getElementById("audioSettings").style.display = "block";
  //document.getElementById("audioSettings").style.minHeight = "200px";
  //menuButtonColorAll();
  //document.getElementById('btnAudioSettings').style.backgroundColor = "gray";
  //
  // PTTenable, intercom, and vms PTT buttons
  //
  /*document.getElementById('btn_vms_PTT').style.backgroundColor = "red";
  document.getElementById('btn_vms_PTT').addEventListener("mousedown", vms_PTT_down);
  document.getElementById('btn_vms_PTT').addEventListener("mouseup", vms_PTT_up);*/
  //document.getElementById('btn_PTT').style.backgroundColor = "red";
  //document.getElementById('btn_PTT').addEventListener("mousedown", PTT_down);
  //document.getElementById('btn_PTT').addEventListener("mouseup", PTT_up);
  $("#btn_PTT").bind({
    mousedown: function () {
      pttDown = true;
      volChange("PTT_down", 0);
      document.getElementById('btn_PTT').style.backgroundColor = "green";
      //console.log("PTT DOWN");
    },
    mouseup: function () {
      pttDown = false;
      volChange("PTT_up", 0);
      document.getElementById('btn_PTT').style.backgroundColor = "lightblue";

      //console.log("PTT UP");
    }
  });
  $(document).bind({
    mouseup: function () {
      if (pttDown == true) {
        volChange("PTT_up", 0);
        document.getElementById('btn_PTT').style.backgroundColor = "lightblue";
        //console.log("PTT UP Document");
        pttDown = false;
      }
    }
  });



  var alertButtonSet = document.querySelectorAll("button");
  alertButtonSet.forEach(function (button) {
    //console.log(ts()+"micLevel() button.id : " + button.id);
    if (button.id.search("_button_mic_level") > 0) {
      button.innerHTML = "Set Microphone Level";
    }
  });
  refreshEvent("listAudioFiles");
  refreshEvent("listPlaybackFiles");
  //
  // key listeners
  //
  var eUsername;
  eUsername = document.getElementById("pw_user");
  eUsername.addEventListener("keydown", (event) => {
    const keyName = event.key;
    if (keyName === "Control") {
      // do not alert when only Control key is pressed.
      return;
    }
    if (event.ctrlKey) {
      // Even though event.key is not "Control" (e.g., "a" is pressed),
      // event.ctrlKey may be true if Ctrl key is pressed at the same time.
      //alert(`Combination of ctrlKey + ${keyName}`);
    } else {
      if (keyName == "Enter") { pw_change("user"); };
    }
  }, false);
  eUsername = document.getElementById("pw_admin");
  eUsername.addEventListener("keydown", (event) => {
    const keyName = event.key;
    if (keyName === "Control") {
      // do not alert when only Control key is pressed.
      return;
    }
    if (event.ctrlKey) {
      // Even though event.key is not "Control" (e.g., "a" is pressed),
      // event.ctrlKey may be true if Ctrl key is pressed at the same time.
      //alert(`Combination of ctrlKey + ${keyName}`);
    } else {
      if (keyName == "Enter") { pw_change("admin"); };
    }
  }, false);
  eUsername = document.getElementById("pw_superadmin");
  eUsername.addEventListener("keydown", (event) => {
    const keyName = event.key;
    if (keyName === "Control") {
      // do not alert when only Control key is pressed.
      return;
    }
    if (event.ctrlKey) {
      // Even though event.key is not "Control" (e.g., "a" is pressed),
      // event.ctrlKey may be true if Ctrl key is pressed at the same time.
      //alert(`Combination of ctrlKey + ${keyName}`);
    } else {
      if (keyName == "Enter") { pw_change("superadmin"); };
    }
  }, false);
  //
  // initiate StreamFactory (only run for window.onload)
  //

  $.ajax({
    url: "/StreamFactory",
    type: "POST",
    //timeout : 2000
  })
    .done(function (data) {
      console.log(ts() + "LE880.js window.onload initiate StreamFactory JSON.stringify(data) " + JSON.stringify(data));
      //
      // update OutgoingStreamURL
      //
      document.getElementById("OutgoingAudioURL").innerHTML = data.OutgoingAudioURL;
      //console.log(ts()+"LE880.js window.onload OutgoingAudioURL : " + data.OutgoingAudioURL);
      //document.getElementById("IncomingAudioURL").innerHTML = data.IncomingAudioURL;
      //console.log(ts()+"LE880.js window.onload IncomingAudioURL : " + data.IncomingAudioURL);
      VMSsendOnOffstate = data.VMSsendStatus;
      VMSloopbackURL = data.VMSloopbackURL;
      //if (data.AnalyticsOnly == "true") {
      //  LE880wssServerMicAlerton = false
      //}
      if (data.VMSsendStatus == "on") {
        VMSsendOnOffstate = "on";
        //console.log(ts()+"window.onload VMSsendOnOffstate: On");
        var msg = "Enabled";
        document.getElementById('buttonVMSsendOnOff').innerText = msg;
        document.getElementById('buttonVMSsendOnOff').style.backgroundColor = "green";
      } else {
        VMSsendOnOffstate = "off";
        //console.log(ts()+"window.onload VMSsendOnOffstate: Off");
        var msg = "Disabled";
        document.getElementById('buttonVMSsendOnOff').innerText = msg;
        document.getElementById('buttonVMSsendOnOff').style.backgroundColor = "lightblue";
      }
      showHidewithObject({ "target": "playback", "action": data.DeviceType });
      //console.log(ts()+"LE880.js window.onload VMSsendStatus : " + data.VMSsendStatus);

      /* if(data.LE880toVMSAutoStart == "true"){
         //console.log(ts()+"window.onload LE880toVMSAutoStart: true");
         var msg = "Set Manual Start";
         document.getElementById('buttonLE880toVMSAutoStart').innerText = msg;
         document.getElementById('buttonLE880toVMSAutoStart').style.backgroundColor = "green";
       } else {
         //console.log(ts()+"window.onload LE880toVMSAutoStart: false");
         var msg = "Set Auto Start";
         document.getElementById('buttonLE880toVMSAutoStart').innerText = msg;
         document.getElementById('buttonLE880toVMSAutoStart').style.backgroundColor = "red";
       }
       */
      /* REMOVED DUE TO USING ONVIF BACKCHANNEL ON RTSP SERVER
      VMSrecvOnOffstate = data.VMSrecvStatus;
      if (data.VMSrecvStatus == "on") {
        VMSrecvOnOffstate = "on";
        //console.log(ts()+"window.onload VMSrecvOnOffstate: On");
        //var msg = "Turn Off VMS to LE880 Receive";
        var msg = "Disable";
        document.getElementById('buttonVMSrecvOnOff').innerText = msg;
        document.getElementById('buttonVMSrecvOnOff').style.backgroundColor = "green";
      } else {
        VMSrecvOnOffstate = "off";
        //console.log(ts()+"window.onload VMSrecvOnOffstate: Off");;
        var msg = "Enable";
        document.getElementById('buttonVMSrecvOnOff').innerText = msg;
        document.getElementById('buttonVMSrecvOnOff').style.backgroundColor = "lightblue";
      }*/
      //console.log(ts()+"LE880.js window.onload VMSrecvStatus : " + data.VMSrecvStatus);
      /*
          if(data.VMStoLE880AutoStart == "true"){
            //console.log(ts()+"window.onload VMStoLE880AutoStart: true");
            var msg = "Set Manual Start";
            document.getElementById('buttonVMStoLE880AutoStart').innerText = msg;
            document.getElementById('buttonVMStoLE880AutoStart').style.backgroundColor = "green";
          } else {
            //console.log(ts()+"window.onload VMStoLE880AutoStart: false");
            var msg = "Set Auto Start";
            document.getElementById('buttonVMStoLE880AutoStart').innerText = msg;
            document.getElementById('buttonVMStoLE880AutoStart').style.backgroundColor = "red";
          }
      
      */
      //
      // VMS PTTenable, intercom echo, and vms echo
      //


      /*if (data.vms_half_full_duplex_state == "full") {
        vms_half_full_duplex_state = "full";
        document.getElementById("btn_vms_half_duplex").style.backgroundColor = "red";
        document.getElementById("btn_vms_full_duplex").style.backgroundColor = "green";
        document.getElementById("btn_vms_PTT").disabled = true;
        document.getElementById("btn_vms_PTT").style.backgroundColor = "gray";
      }
      else {
        vms_half_full_duplex_state == "half";
        document.getElementById("btn_vms_half_duplex").style.backgroundColor = "green";
        document.getElementById("btn_vms_full_duplex").style.backgroundColor = "red";
        document.getElementById("btn_vms_PTT").disabled = false;
        document.getElementById("btn_vms_PTT").style.backgroundColor = "red";
      }
  */
      if (data.vmsEcho == "true") {
        document.getElementById("btn_vms_echo").style.backgroundColor = "green";
        document.getElementById("btn_vms_echo").innerHTML = "DSP Enabled";
      } else {
        document.getElementById("btn_vms_echo").style.backgroundColor = "lightblue";
        document.getElementById("btn_vms_echo").innerHTML = "DSP Disabled";
      }
      if (data.intercomDSP == "true") {
        document.getElementById("btn_intercom_dsp").style.backgroundColor = "green";
        document.getElementById("btn_intercom_dsp").innerHTML = "DSP Enabled";
      } else {
        document.getElementById("btn_intercom_dsp").style.backgroundColor = "lightblue";
        document.getElementById("btn_intercom_dsp").innerHTML = "DSP Disabled";
      }
      //
      // Intercom PTTenable, intercom echo, and vms echo
      //
      //if (data.half_full_duplex_state == "full") {
      //  half_full_duplex_state = "full";
      //  document.getElementById("btn_half_duplex").style.backgroundColor = "lightblue";
      //  document.getElementById("btn_full_duplex").style.backgroundColor = "green";
      //  document.getElementById("btn_PTT").disabled = true;
      //  document.getElementById("btn_PTT").style.backgroundColor = "gray";
      //} else {
      half_full_duplex_state = "half";
      document.getElementById("btn_half_duplex").style.backgroundColor = "green";
      document.getElementById("btn_full_duplex").style.backgroundColor = "lightblue";
      document.getElementById("btn_PTT").disabled = false;
      document.getElementById("btn_PTT").style.backgroundColor = "lightblue";
      //}
      if (data.intercomEcho == "true") {
        document.getElementById("btn_intercom_echo").style.backgroundColor = "green";
        document.getElementById("btn_intercom_echo").innerHTML = "Echo Cancel Enabled";
      } else {
        document.getElementById("btn_intercom_echo").style.backgroundColor = "lightblue";
        document.getElementById("btn_intercom_echo").innerHTML = "Echo Cancel Disabled";
      }
      if (data.intercomPossibleFail == "true" && data.intercomRestartFail == "true") {
        //console.log(ts()+"LE880.js window.onload data.intercomRestartFail : " + data.intercomRestartFail);
        $("#messageBar").css("display", "inline-block");
        var msg = '<div class="msgDisplay">Intercom will automatically restart in 5 seconds due to possible loss of communications.</div>';
        $("#messageBar").html(msg);
        setTimeout(function () {
          intercomOnOff();
          $("#messageBar").css("display", "none");
          $("#messageBar").html("");
        }, 5000);
      }
      else if (data.intercomRestartLoad == "true") {
        //console.log(ts()+"LE880.js window.onload data.intercomRestartLoad : " + data.intercomRestartLoad);
        $("#messageBar").css("display", "inline-block");
        var msg = '<div class="msgDisplay">Intercom has been configured to automatically start when browser loads.</div>';
        $("#messageBar").html(msg);
        /*  var msg = "Set Manual Start";
          document.getElementById('buttonIntercomAutoStart').innerText = msg;
          document.getElementById('buttonIntercomAutoStart').style.backgroundColor = "green";
          */
        setTimeout(function () {
          intercomOnOff();
          $("#messageBar").css("display", "none");
          $("#messageBar").html("");
        }, 5000);
      }
      else if (data.intercomRestartLoad == "false") {
        //console.log(ts()+"LE880.js window.onload data.intercomRestartLoad : " + data.intercomRestartLoad);
        /*  
          var msg = "Set Auto Start";
          document.getElementById('buttonIntercomAutoStart').innerText = msg;
          document.getElementById('buttonIntercomAutoStart').style.backgroundColor = "red";
        */
      }
      //
      // initialze functions after values from server loaded by /StreamFactory
      //
      //
      // Initialize Input Ports
      //
      //
      // Initialize Output Ports
      //
      //
      // Initailize Output Port JSON
      //
      jsonP("LED");
      jsonP(1);
      jsonP(2);
      jsonP(3);
      jsonP(4);
      //
      // initialize intercom volume controls
      //



      var sliderSpeaker = document.getElementById("sliderSpeaker");
      var displaySpeaker = document.getElementById("displaySpeaker");
      displaySpeaker.innerHTML = sliderSpeaker.value + "%";
      //console.log("sliderSpeaker.value = " + sliderSpeaker.value);
      //console.log("displaySpeaker.innerHTML = " + displaySpeaker.innerHTML);
      sliderSpeaker.oninput = function () {
        displaySpeaker.innerHTML = this.value + "%";
      }
      sliderSpeaker.onchange = function () {
        //console.log(ts()+"sliderSpeaker.onchange:" + this.value);
        volChange("speaker", this.value);
      }
      var sliderMic = document.getElementById("sliderMic");
      var displayMic = document.getElementById("displayMic");
      displayMic.innerHTML = sliderMic.value + "%";
      //console.log("sliderMic.value 	= " + sliderMic.value);
      //console.log("displayMic.innerHTML 	= " + displayMic.innerHTML);
      sliderMic.oninput = function () {
        displayMic.innerHTML = this.value + "%";
      }
      sliderMic.onchange = function () {
        //console.log(ts()+"sliderMic.onchange:" + this.value);
        volChange("mic", this.value);
      }

      //
      // initialize VMS volume controls
      //
      var VMSsliderSpeaker = document.getElementById("VMSsliderSpeaker");
      var VMSdisplaySpeaker = document.getElementById("VMSdisplaySpeaker");
      VMSdisplaySpeaker.innerHTML = VMSsliderSpeaker.value + "%";
      console.log("VMSsliderSpeaker.value = " + VMSsliderSpeaker.value);
      console.log("VMSdisplaySpeaker.innerHTML = " + VMSdisplaySpeaker.innerHTML);
      VMSsliderSpeaker.oninput = function () {
        VMSdisplaySpeaker.innerHTML = this.value + "%";
      }
      VMSsliderSpeaker.onchange = function () {
        console.log(ts() + "VMSsliderSpeaker.onchange:" + this.value);
        volChange("VMSspeaker", this.value);
      }
      var VMSsliderMic = document.getElementById("VMSsliderMic");
      var VMSdisplayMic = document.getElementById("VMSdisplayMic");
      VMSdisplayMic.innerHTML = VMSsliderMic.value + "%";
      console.log("VMSsliderMic.value 	= " + VMSsliderMic.value);
      console.log("VMSdisplayMic.innerHTML 	= " + VMSdisplayMic.innerHTML);
      VMSsliderMic.oninput = function () {
        VMSdisplayMic.innerHTML = this.value + "%";
      }
      VMSsliderMic.onchange = function () {
        console.log(ts() + "VMSsliderMic.onchange:" + this.value);
        volChange("VMSmic", this.value);
      }

      //
      // initialize intercom players
      //
      //volumeUp("audioPlayerRemoteOut", "init"); // VMS audio to browser is future enhancement
      //volumeUp("audioPlayerRemoteIn", "init");  // VMS audio to browser is future enhancement
      //volumeUp("audioPlayerLocalOut", "init");
      volumeUp("audioPlayerLocalIn", "init");
      //
      // start s2cSignal
      //
      console.log(ts() + "window.onload initiate s2cSignalCount: " + s2cSignalCount);
      var toServer = "to server function from client";
      var toServerJSON = { "toServer": "heartbeat", "toServerJSON": { "heartbeat": "starting", "s2cSignalTimeout": s2cSignalTimeout } };

      // disable 04-14-2021
      s2cSignal(toServer, toServerJSON);
      //
      // webrtc
      //
      websocketServerConnect();
      //
      // LE880wssServerMicAlert
      //
      //if(LE880wssServerMicAlerton && alertPORT != null){
      if (LE880wssServerMicAlerton) {
        LE880wssServerMicAlert_Connect();
      }
    }); // .done StreamFactory
} // window.onload
function hideAll() {
  var x, i;
  x = document.querySelectorAll(".hiddenOnload");
  for (i = 0; i < x.length; i++) {
    x[i].style.display = "none";
    // x[i].style.visibility = "hidden";
  }
}
function menuButtonColorAll() {
  var x, i;
  x = document.querySelectorAll(".menuButton");
  for (i = 0; i < x.length; i++) {
    //x[i].style.backgroundColor = "green";
  }
}
function s2cSignal(toServer, toServerJSON) { // long poll
  if (resetFactoryFlag == true) { return; } // new browserID requires new login
  //console.log(ts()+"s2cSignal()");
  var browserUA = null;
  browserUA = navigator.userAgent;
  //console.log(ts()+"s2cSignal() browserUA: " + browserUA);
  var browserID = null;
  promiseBrowserID.then(function (result) {
    browserID = result;
    //console.log(ts()+"s2cSignal() browserID: " + browserID);
    if (recvFile != "no_recvFile") {
      //console.log(ts()+"s2cSignal() ack recvFile to server: " + recvFile);
    }
    if (audioCtxRemote) {
      audioCtxRemoteState = audioCtxRemote.state;
    } else {
      audioCtxRemoteState = "not defined in browser";
    }
    if (audioCtxLocal) {
      audioCtxLocalState = audioCtxLocal.state;
    } else {
      audioCtxLocalState = "not defined in browser";
    }
    var s2cSignalJSON = {
      "recvFile": recvFile,
      "toServer": toServer,
      "toServerJSON": toServerJSON,
      "browserID": browserID,
      "browserUA": browserUA,
      "s2cSignalCount": s2cSignalCount,
      "audioCtxRemoteState": audioCtxRemoteState,
      "audioCtxLocalState": audioCtxLocalState,
      "ts": ts1()
    };
    //console.log(ts()+"s2cSignal() JSON.stringify(s2cSignalJSON ): " + JSON.stringify(s2cSignalJSON ));
    $.ajax({
      url: "/s2cSignal",
      type: "POST",
      dataType: "json",
      data: s2cSignalJSON,
      timeout: s2cSignalTimeout
    })
      .fail(function (e) {
        //console.log(ts()+"s2cSignal() fail JSON.stringify(e): " + JSON.stringify(e));
        if (e.statusText == "timeout") {
          //$("#messageBar").css("display", "block");
          //$("#messageBar").html(ts()+"s2cSignal() timeout s2cSignalCount: " + s2cSignalCount + ", s2cSignalTimeout: " + s2cSignalTimeout);	
          //console.log(ts()+"s2cSignal() timeout s2cSignalCount: "  + s2cSignalCount + ", s2cSignalTimeout: " + s2cSignalTimeout);	
          if (s2cSignalErrorFirst) {
            s2cSignalErrorFirst = null;
            $("#messageBar").css("display", "block");
            var html = "The browser connected to the LE880 at " + ts1() + ".";
            $("#messageBar").html(html);
            console.log(ts() + html);
            setTimeout(function () { location.reload(); }, 10000);
          }
          recvFile = "no_recvFile"; // timeout did not receive anything
          toServer = "heartbeat timeout";
          toServerJSON = {
            "recvFile": recvFile,
            "toServer": "heartbeat",
            "toServerJSON": {
              "heartbeat": "timeout",
              "webSignalTimeout": s2cSignalTimeout
            }
          };
          //
          // restart heartbeat
          //
          s2cSignalCount++;
          s2cSignal(toServer, toServerJSON);
        } // if(e.statusText == "timeout")
        //
        // network error
        //
        if (e.statusText == "error") {
          if (!s2cSignalErrorFirst) {
            s2cSignalErrorFirst = ts1();
          }
          $("#messageBar").css("display", "block");
          var html = "The browser cannot connect to the LE880."
          html += "<br>The LE880 may have been disconnected from the network.";
          html += "<br>The LE880 may have lost power.";
          html += "<br>There may be a network error.";
          html += "<br>The network may have been reconfigured."
          html += "<br>This loss of communications was first seen at " + s2cSignalErrorFirst + ".";
          html += "<br>This loss of communications was last seen at " + ts1() + ".";
          html += "<br>The browser will attempt to reconnect every 30 seconds.";
          html += "<br>In the event of LE880 reboot, the reconnection may require 1 to 2 minutes.";
          $("#messageBar").html(html);
          console.log(ts() + html.replaceAll('<br>', ' '));
          //
          // try s2cSignal again in 30 seconds
          //
          setTimeout(function () {
            recvFile = "no_recvFile"; // timeout did not receive anything
            toServer = "heartbeat timeout";
            toServerJSON = {
              "recvFile": recvFile,
              "toServer": "heartbeat",
              "toServerJSON": {
                "heartbeat": "timeout",
                "webSignalTimeout": s2cSignalTimeout
              }
            };
            //
            // restart heartbeat
            //
            s2cSignalCount++;
            s2cSignal(toServer, toServerJSON);
          }, 30000);
        } // if(e.statusText == "error")
      }) // .fail
      .done(function (data, textStatus, jqXHR) {
        //console.log(ts()+"\n\ns2cSignal() JSON.stringify(data): " + JSON.stringify(data) + "\n\n");
        if (data.auth === false) {
          window.location.href = "/";
          return;
        }
        if (s2cSignalErrorFirst) {
          s2cSignalErrorFirst = null;
          $("#messageBar").css("display", "block");
          var html = "The browser connected to the LE880 at " + ts1() + ".";
          $("#messageBar").html(html);
          console.log(ts() + html);
          setTimeout(function () { location.reload(); }, 10000);
        }
        /*
        var regex0Log = /\\/g;
        var regex1Log = /\"/g;
              
        var msgLog  = JSON.stringify(data);
      msgLog  = msgLog.replace(regex0Log,"");
      msgLog  = msgLog.replace(regex1Log,"");	
        
        console.log(ts()+"s2cSignal() done JSON.stringify(data): " + JSON.stringify(msgLog));
        */
        //console.log(ts()+"s2cSignal() done JSON.stringify(textStatus): " + JSON.stringify(textStatus));
        //console.log(ts()+"s2cSignal() done JSON.stringify(jqXHR): " + JSON.stringify(jqXHR));
        //console.log(ts()+"s2cSignal() done data.s2cSignalCount = " + data.s2cSignalCount + ", s2cSignalCount = " + s2cSignalCount);
        sentFile = data.sentFile; // from server
        recvFile = sentFile;  // for acknowlegment to server
        if (sentFile != "no_sentFile") {
          //console.log(ts()+"s2cSignal() done sentFile from server: " + sentFile);
        }
        //console.log(ts()+"s2cSignal() data: " + data);
        if (data.messageBar) {
          if (data.messageBar.length > 0) {
            $("#messageBar").css("display", "inline-block");
            var regex0 = /\\/g;
            var regex1 = /\"/g;
            var msg = data.messageBar;
            msg = msg.replace(regex0, "");
            msg = msg.replace(regex1, "");
            var out = '<div class="msgDisplay">' + ts1();
            out += "<br>(quotation marks and backslashes removed)<br><br>";
            out += msg + '</div>';
            $("#messageBar").html(out);
            //console.log(ts()+"s2cSignal() done data.messageBar: " + msg);
          }
        } // if(data.messageBar)
        if (data.toClient) {
          if (data.toClient.length > 0) {
            //console.log(ts()+"s2cSignal() done data.toClient: " + data.toClient);
            if (data.toClient == "levelAlert") {
              $("#messageBar").css("display", "inline-block");
              var msg = '<div class="msgDisplay">levelAlert sentFile : ' + data.sentFile + ', levelAlert: peak_dB = ' + data.peak_dB_double + ', peak_dB_test = ' + data.peak_dB_test_double + '</div>';
              $("#messageBar").html(msg);
            }
          }
        } // if(data.toClient)
        if (data.toClientJSON) {
          if (JSON.stringify(data.toClientJSON).length > 0) {
            //console.log(ts()+"s2cSignal() done JSON.stringify(data.toClientJSON): " + JSON.stringify(data.toClientJSON));
          }
        } // if(data.toClientJSON)

        //
        // intercom
        //
        if (data.sliderSpeakerNow) {
          if (JSON.stringify(data.sliderSpeakerNow).length > 0) {
            var sliderSpeaker = document.getElementById("sliderSpeaker");
            var displaySpeaker = document.getElementById("displaySpeaker");
            //displaySpeaker.innerHTML	= sliderSpeaker.value + "%";
            //console.log(ts()+"s2cSignal() done data.sliderSpeakerNow): " + JSON.stringify(data.sliderSpeakerNow));
            sliderSpeaker.value = data.sliderSpeakerNow;
            displaySpeaker.innerHTML = data.sliderSpeakerNow.toFixed(0) + "%";
            volChange("speaker", data.sliderSpeakerNow);
          }
        } // if(data.sliderSpeakerNow)
        if (data.sliderSpeakerSmooth) {
          if (JSON.stringify(data.sliderSpeakerSmooth).length > 0) {
            var sliderSpeaker = document.getElementById("sliderSpeaker");
            var displaySpeaker = document.getElementById("displaySpeaker");
            //displaySpeaker.innerHTML	= sliderSpeaker.value + "%";
            //console.log(ts()+"s2cSignal() done data.sliderSpeaker): " + JSON.stringify(data));
            var speakerCnt = 0 * 1;
            var speakerCntMax = data.interval_num;
            var speakerIncrement = (data.sliderSpeakerSmooth / data.interval_num).toFixed(3);
            var speakerID = setInterval(function () {
              sliderSpeaker.value = speakerIncrement * speakerCnt;
              displaySpeaker.innerHTML = (speakerIncrement * speakerCnt).toFixed(0) + "%";
              volChange("speaker", (speakerIncrement * speakerCnt).toFixed(1));
              if (speakerCnt >= speakerCntMax) {
                clearInterval(speakerID);
              }
              speakerCnt += 1;
            }, data.interval_mSec);
          }
        } // if(data.sliderSpeakerSmooth)
        if (data.sliderMic) {
          if (JSON.stringify(data.sliderMic).length > 0) {
            var sliderMic = document.getElementById("sliderMic");
            var displayMic = document.getElementById("displayMic");
            console.log(ts() + "s2cSignal() done data.sliderMic: " + JSON.stringify(data.sliderMic));
            sliderMic.value = data.sliderMic;
            displayMic.innerHTML = sliderMic.value + "%";
            volChange("mic", data.sliderMic);
          }
        } // if(data.sliderMic)
        if (data.intercomRestartFail) {
          if (data.intercomRestartFail == "true") {
            console.log(ts() + "s2cSignal() done data.intercomRestartFail: " + JSON.stringify(data.intercomRestartFail));
            var count = 5;
            $("#messageBar").css("display", "inline-block");
            var msg = "Automatic webpage reload and Intercom restart in " + count + " seconds due to possible loss of communications";
            if (data.restartIntercom == "test") {
              msg += " TEST";
            }
            document.getElementById("messageBar").innerHTML = msg;
            function restartIntercomTimer() {
              count = count - 1;
              var msg = "Automatic webpage reload and Intercom restart in " + count + " seconds due to possible loss of communications";
              if (data.restartIntercom == "test") {
                msg += " TEST";
              }
              document.getElementById("messageBar").innerHTML = msg;
              if (count == 0) {
                clearInterval(resetIntercomInterval);
                location.reload();
              }
            }
          }
          var resetIntercomInterval = setInterval(restartIntercomTimer, 1000);
        } // if(data.restartIntercom)

        //
        // VMS
        //
        if (data.VMSsliderSpeakerNow) {
          if (JSON.stringify(data.VMSsliderSpeakerNow).length > 0) {
            var VMSsliderSpeaker = document.getElementById("VMSsliderSpeaker");
            var VMSdisplaySpeaker = document.getElementById("VMSdisplaySpeaker");
            console.log(ts() + "s2cSignal() done data.VMSsliderSpeakerNow): " + JSON.stringify(data.VMSsliderSpeakerNow));
            VMSsliderSpeaker.value = data.VMSsliderSpeakerNow;
            VMSdisplaySpeaker.innerHTML = data.VMSsliderSpeakerNow.toFixed(0) + "%";
            volChange("VMSspeaker", data.VMSsliderSpeakerNow);
          }
        } // if(data.VMSsliderSpeakerNow)
        if (data.VMSsliderSpeakerSmooth) {
          if (JSON.stringify(data.VMSsliderSpeakerSmooth).length > 0) {
            var VMSsliderSpeaker = document.getElementById("VMSsliderSpeaker");
            var VMSdisplaySpeaker = document.getElementById("VMSdisplaySpeaker");
            console.log(ts() + "s2cSignal() done data.VMSsliderSpeaker): " + JSON.stringify(data));
            var VMSspeakerCnt = 0 * 1;
            var VMSpeakerCntMax = data.interval_num;
            var VMSspeakerIncrement = (data.VMSsliderSpeakerSmooth / data.interval_num).toFixed(3);
            var VMSspeakerID = setInterval(function () {
              VMSsliderSpeaker.value = VMSspeakerIncrement * VMSspeakerCnt;
              VMSdisplaySpeaker.innerHTML = (VMSspeakerIncrement * VMSspeakerCnt).toFixed(0) + "%";
              volChange("VMSspeaker", (VMSspeakerIncrement * VMSspeakerCnt).toFixed(1));
              if (VMSspeakerCnt >= VMSspeakerCntMax) {
                clearInterval(speakerID);
              }
              VMSspeakerCnt += 1;
            }, data.interval_mSec);
          }
        } // if(data.VMSsliderSpeakerSmooth)
        if (data.VMSsliderMic) {
          if (JSON.stringify(data.VMSsliderMic).length > 0) {
            var VMSsliderMic = document.getElementById("VMSsliderMic");
            var VMSdisplayMic = document.getElementById("VMSdisplayMic");
            console.log(ts() + "s2cSignal() done data.VMSsliderMic: " + JSON.stringify(data.VMSsliderMic));
            VMSsliderMic.value = data.VMSsliderMic;
            VMSdisplayMic.innerHTML = VMSsliderMic.value + "%";
            volChange("VMSmic", data.VMSsliderMic);
          }
        } // if(data.VMSsliderMic)

        //
        // not applicable for VMS - no webpage reload
        //
        if (data.VMSRestartFail) {
          if (data.VMSRestartFail == "true") {
            console.log(ts() + "s2cSignal() done data.VMSRestartFail: " + JSON.stringify(data.VMSRestartFail));
            var count = 5;
            $("#messageBar").css("display", "inline-block");
            var msg = "Automatic webpage reload and VMS restart in " + count + " seconds due to possible loss of communications";
            if (data.restartVMS == "test") {
              msg += " TEST";
            }
            document.getElementById("messageBar").innerHTML = msg;
            function restartVMSTimer() {
              count = count - 1;
              var msg = "Automatic webpage reload and VMS restart in " + count + " seconds due to possible loss of communications";
              if (data.restartVMS == "test") {
                msg += " TEST";
              }
              document.getElementById("messageBar").innerHTML = msg;
              if (count == 0) {
                clearInterval(resetVMSInterval);
                location.reload();
              }
            }
          }
          var resetVMSInterval = setInterval(restartVMSTimer, 1000);
        } // if(data.restartVMS)      



        if (data.resetFactory) {
          var count = 60;
          $("#messageBar").css("display", "inline-block");
          var msg = data.msg + "<br>Automatic webpage reload in " + count + " seconds";
          document.getElementById("messageBar").innerHTML = msg;
          function resetFactoryTimer() {
            count = count - 1;
            var msg = data.msg + "<br>Automatic webpage reload in " + count + " seconds";
            document.getElementById("messageBar").innerHTML = msg;
            if (count == 0) {
              clearInterval(resetFactoryInterval);
              location.reload();
            }
          }
          var resetFactoryInterval = setInterval(resetFactoryTimer, 1000);
        } // if(data.resetFactory)

        if (data.reboot) {
          var count = 60;
          $("#messageBar").css("display", "inline-block");
          document.getElementById("messageBar").innerHTML = "LE880 is rebooting now.<br><br>Automatic webpage reload in " + count + " seconds.";
          function resetFactoryTimer() {
            count = count - 1;
            document.getElementById("messageBar").innerHTML = "LE880 is rebooting now.<br><br>Automatic webpage reload in " + count + " seconds.";
            if (count == 0) {
              clearInterval(resetFactoryInterval);
              location.reload();
            }
          }
          var resetFactoryInterval = setInterval(resetFactoryTimer, 1000);
        } // if(data.reboot)
        //
        // send s2cSignal again to keep channel alive
        //
        s2cSignalCount++;
        s2cSignal(toServer, toServerJSON);
      }); // .done(function(data, textStatus, jqXHR)

  }, function (err) {
    console.log(ts() + "s2cSignal() ERROR promiseBrowserID JSON.stringify(err): " + JSON.stringify(err));
  });// promiseBrowserID.then  
} // s2cSignal
var promiseBrowserID = new Promise(function (resolve, reject) {
  if (typeof RTCPeerConnection == "undefined") {
    console.log(ts() + 'getBrowserID() RTCPeerConnection == "undefined"');
    reject(Error("Error - typeof RTCPeerConnection == undefined"));
  }
  window.RTCPeerConnection = window.RTCPeerConnection || window.mozRTCPeerConnection || window.webkitRTCPeerConnection; //compatibility for Firefox and chrome
  var pc = new RTCPeerConnection({ iceServers: [] }), noop = function () { };
  pc.createDataChannel('');//create a bogus data channel
  pc.createOffer(pc.setLocalDescription.bind(pc), noop);// create offer and set local description
  pc.onicecandidate = function (ice) {
    if (ice && ice.candidate && ice.candidate.candidate) {
      let browserID = ice.candidate.address;
      //console.log(ts()+"getBrowserID() browserID: " + browserID);
      //console.log(ts()+"getBrowserID() JSON.stringify(ice.candidate): " + JSON.stringify(ice.candidate));	    
      //console.log(ts()+"getBrowserID() JSON.stringify(ice.candidate.address): " + JSON.stringify(ice.candidate.address));
      if (localStorage.getItem('browserID')) {
        browserID = localStorage.getItem('browserID');
      }
      resolve(browserID);
    }
  };
}); // promiseBrowserID
function menu(btn, choice) {
  //console.log(ts()+"menu btn = " + btn + ", choice = " + choice);
  var browserUA = null;
  browserUA = navigator.userAgent;
  //console.log(ts()+"menu() browserUA: " + browserUA);
  var browserID = null;
  promiseBrowserID.then(function (result) {
    browserID = result;
    //console.log(ts()+"ajaxSettings() browserID: " + browserID);
    var jsonObj = { "choice": choice, "browserID": browserID, "browserUA": browserUA };
    //console.log(ts()+"menu() JSON.stringify(jsonObj): " + JSON.stringify(jsonObj));
    $.ajax({
      url: "/menu",
      type: "POST",
      dataType: "json",
      data: jsonObj
    })
      .fail(function (e) {
        console.log(ts() + "ERROR menu() choice: " + choice + ", e: " + e);
      })
      .done(function (data) {
        //console.log(ts()+"menu() data: " + choice + ", JSON.stringify(data): " + JSON.stringify(data));
        if (data.auth) {
          hideAll();
          document.getElementById(choice).style.display = "block";
          document.getElementById(choice).style.minHeight = "200px";
          //menuButtonColorAll();
          //document.getElementById(btn).style.backgroundColor = "gray";
          var choiceRect = document.getElementById(choice).getBoundingClientRect();
          //console.log(ts()+"menu() choiceRect.top : " + choiceRect.top );
          var choiceHeight = document.getElementById(choice).offsetHeight;
          //console.log(ts()+"menu() choiceHeight : " + choiceHeight );
          document.getElementById("footerContainer").top = choiceRect.top + choiceHeight + 8;
          if (choice == "systemSettings") {
            ajaxSettings(choice);
          }
          //
          // close all open micLevels
          //
          var buttons = document.querySelectorAll("button");
          buttons.forEach(function (button) {
            if (button.innerHTML == "Close Microphone Level") {
              button.click();
              console.log(ts() + "menu close all open micLevels() button.id : " + button.id);
            }
          });
        } else { // data.auth != "OK"
          window.location.href = "/";
        }
      }); // .done(function(data)  
  });// promiseBrowserID.then  
  //console.log(ts()+"menu() completed menu choice: " + choice );
} // menu(btn, choice)
function ajaxSettings(choice) {
  var browserUA = null;
  browserUA = navigator.userAgent;
  //console.log(ts()+"ajaxSettings() browserUA: " + browserUA);
  var browserID = null;
  promiseBrowserID.then(function (result) {
    browserID = result;
    //console.log(ts()+"ajaxSettings() browserID: " + browserID);
    var jsonObj = { "choice": choice, "browserID": browserID, "browserUA": browserUA };
    //console.log(ts()+"ajaxSettings() JSON.stringify(jsonObj): " + JSON.stringify(jsonObj));
    $.ajax({
      url: "/Settings",
      type: "POST",
      dataType: "json",
      data: jsonObj
    })
      .fail(function (e) {
        console.log("ERROR ajaxSettings choice: " + choice + ", e: " + e);
      })
      .done(function (data) {
        if (data.auth) {
          //console.log(ts()+"ajaxSettings data: " + choice + ", JSON.stringify(data): " + JSON.stringify(data));
          $("#systemSettingsDeviceIP").html(data.serverIP);
          $("#systemSettingsFirmwareVersion").html(data.FirmwareVersion);
        } else {
          window.location.href = "/";
        }
      });
  }, function (err) {
    console.log(ts() + "ERROR ajaxSettings() promiseBrowserID err: " + err);
  });// promiseBrowserID.then  
}
//
//
//
function volChange(a, v) {
  //console.log(ts()+"volChange(): " + a + " : " + v);
  var browserUA = null;
  browserUA = navigator.userAgent;
  //console.log(ts()+"volChange() browserUA: " + browserUA);
  var browserID = null;
  promiseBrowserID.then(function (result) {
    browserID = result;
    //console.log(ts()+"volChange() browserID: " + browserID);
    var jsonObj = { "a": a, "v": v, "browserID": browserID, "browserUA": browserUA };
    //console.log(ts() + "volChange() JSON.stringify(jsonObj): " + JSON.stringify(jsonObj));
    $.ajax({
      url: "/volChange",
      type: "POST",
      dataType: "json",
      data: jsonObj
    })
      .fail(function (e) {
        console.log("ERROR volChange() : " + a + ", v: " + v);
      })
      .done(function (data) {
        if (data.auth) {
          //console.log(ts()+"volChange() .done JSON.stringify(data): " + JSON.stringify(data));
        } else {
          window.location.href = "/";
        }
      });
  }, function (err) {
    console.log(ts() + "ERROR volChange() promiseBrowserID err: " + err);
  });// promiseBrowserID.then      
} // volChange
//
// intercom media player (VMS media player not implemented)
//
/*
function setAnalyticsOnly() {
  //console.log(ts()+"setAnalyticsOnly(): " + a + " : " + v);
  var browserUA = null;
  browserUA = navigator.userAgent;
  //console.log(ts()+"setAnalyticsOnly() browserUA: " + browserUA);
  var browserID = null;
  let onOff = $('#analyticsOnly').val();

  promiseBrowserID.then(function (result) {
    browserID = result;
    //console.log(ts()+"setAnalyticsOnly() browserID: " + browserID);
    var jsonObj = { "analyticsOnly": onOff, "browserID": browserID, "browserUA": browserUA };
    console.log(ts() + "setAnalyticsOnly() JSON.stringify(jsonObj): " + JSON.stringify(jsonObj));
    $.ajax({
      url: "/setAnalyticsOnly",
      type: "POST",
      dataType: "json",
      data: jsonObj
    })
      .fail(function (e) {
        console.log("ERROR setAnalyticsOnly() d: " + cDate + ", t: " + cTime);
      })
      .done(function (data) {
        if (data.auth) {
          //console.log(ts()+"setAnalyticsOnly() .done JSON.stringify(data): " + JSON.stringify(data));
        } else {
          window.location.href = "/";
        }
      });
  }, function (err) {
    console.log(ts() + "ERROR setAnalyticsOnly() promiseBrowserID err: " + err);
  });// promiseBrowserID.then      
} // setAnalyticsOnly
*/
function setTimeSettings() {
  //console.log(ts()+"setTimeSettings(): " + a + " : " + v);
  var browserUA = null;
  browserUA = navigator.userAgent;
  //console.log(ts()+"setTimeSettings() browserUA: " + browserUA);
  var browserID = null;
  let current = new Date();
  let type = $('#setTime').val();
  let cDate = current.getFullYear() + '-' + (current.getMonth() + 1) + '-' + current.getDate();
  let cTime = current.getHours() + ":" + current.getMinutes() + ":" + current.getSeconds();
  let dateTime = cDate + ' ' + cTime;
  console.log(dateTime);
  promiseBrowserID.then(function (result) {
    browserID = result;
    //console.log(ts()+"setTimeSettings() browserID: " + browserID);
    var jsonObj = { "type": type, "d": cDate, "t": cTime, "browserID": browserID, "browserUA": browserUA };
    console.log(ts() + "setTimeSettings() JSON.stringify(jsonObj): " + JSON.stringify(jsonObj));
    $.ajax({
      url: "/setTimeSettings",
      type: "POST",
      dataType: "json",
      data: jsonObj
    })
      .fail(function (e) {
        console.log("ERROR setTimeSettings() d: " + cDate + ", t: " + cTime);
      })
      .done(function (data) {
        if (data.auth) {
          //console.log(ts()+"setTimeSettings() .done JSON.stringify(data): " + JSON.stringify(data));
        } else {
          window.location.href = "/";
        }
      });
  }, function (err) {
    console.log(ts() + "ERROR setTimeSettings() promiseBrowserID err: " + err);
  });// promiseBrowserID.then      
} // setTimeSettings
function volumeUp(player, live) {
  //console.log(ts()+"volumeUp() player: " + player + ", live: " + live);
  // live == 'live' for user control, live == 'init' for initialization
  let vol = document.getElementById(player).volume;
  let newVol = vol;
  if (live == 'live' && vol <= 0.9) {
    newVol = vol + 0.1;
    document.getElementById(player).volume = newVol;
    document.getElementById(player + "Volume").innerHTML = newVol.toFixed(1);
  }
  if (newVol > 0.9) {
    document.getElementById(player + "Up").disabled = true;
  } else {
    document.getElementById(player + "Up").disabled = false;
  }
  if (newVol < 0.1) {
    document.getElementById(player + "Dn").disabled = true;
  } else {
    document.getElementById(player + "Dn").disabled = false;
  }
}
function volumeDown(player, live) {
  //console.log(ts()+"volumeDown() player: " + player + ", live: " + live);
  // live == 'live' for user control, live == 'init' for initialization
  let vol = document.getElementById(player).volume;
  let newVol = vol;
  if (live == 'live' && vol >= 0.1) {
    newVol = vol - 0.1;
    document.getElementById(player).volume = newVol;
    document.getElementById(player + "Volume").innerHTML = newVol.toFixed(1);
  }
  if (newVol > 0.9) {
    document.getElementById(player + "Up").disabled = true;
  } else {
    document.getElementById(player + "Up").disabled = false;
  }
  if (newVol < 0.1) {
    document.getElementById(player + "Dn").disabled = true;
  } else {
    document.getElementById(player + "Dn").disabled = false;
  }
}
/*
function intercomAutoStart() {
  
  var browserUA = null;
  browserUA = navigator.userAgent;
  //console.log(ts()+"intercomAutoStart() browserUA: " + browserUA);
  var browserID = null;
  promiseBrowserID.then(function(result) {
    browserID = result;
    //console.log(ts()+"intercomAutoStart() browserID: " + browserID);
    if(document.getElementById("buttonIntercomAutoStart").innerHTML == "Set Manual Start"){ // in auto mode
      document.getElementById("buttonIntercomAutoStart").innerHTML = "Set Auto Start";
      document.getElementById('buttonIntercomAutoStart').style.backgroundColor = "red";
      var intercomAutoStart = "false";
    } else if (document.getElementById("buttonIntercomAutoStart").innerHTML == "Set Auto Start"){ // in manual mode
      document.getElementById("buttonIntercomAutoStart").innerHTML = "Set Manual Start";
      document.getElementById('buttonIntercomAutoStart').style.backgroundColor = "green";
      var intercomAutoStart = "true";
    } else {
      console.log(ts()+"intercomAutoStart() ERROR " + document.getElementById("buttonIntercomAutoStart").innerHTML);
      return;
    }
    
    var jsonObj  = { "intercomAutoStart" : intercomAutoStart, "browserID" : browserID, "browserUA" : browserUA };
    
    console.log(ts()+"intercomAutoStart() JSON.stringify(jsonObj): " + JSON.stringify(jsonObj));
    $.ajax({
      url : "/intercomAutoStart",
      type : "POST",
      dataType : "json",
      data : jsonObj
      })
      
    .fail(function(e){
      console.log( "ERROR intercomAutoStart() e: " + JSON.stringify(e));
    })
    .done(function(data){
      
      if(data.auth){
      
  console.log(ts()+"intercomAutoStart(), JSON.stringify(data): " + JSON.stringify(data));
	
      } else {
	
  window.location.href = "/";
      }
    });
  }, function(err) {
  console.log(ts()+"ERROR intercomAutoStart() promiseBrowserID err: " + err);
    
  });// promiseBrowserID.then      
      
} 
*/
// intercomAutoStart()
var intercom = "off";
function intercomOnOff() {
  if (intercom == "off") {
    intercom = "on";
    console.log(ts() + "intercomOnOff: On");
    //var msg = "Turn Off LE880 to Browser Intercom";
    var msg = "Enabled";
    document.getElementById('buttonIntercomOnOff').innerText = msg;
    document.getElementById('buttonIntercomOnOff').style.backgroundColor = "green";
    document.getElementById('audioPlayerLocalInMsg').innerHTML = "LE880 to Browser starting...";
    $('#L2BIcon').removeClass("fa-caret-square-down").addClass("fa-caret-square-up");
    $('#audioPlayerLocalIncontent').show();
    //document.getElementById('audioPlayerLocalOutMsg').innerHTML = "Browser to LE880 starting...";
    //expand("expand", "audioPlayerLocalIn", "playerContainer");
    //
    // browser volume control is not shown and is paused when webrtc starts
    //
    //expand("expand", "audioPlayerLocalOut", "playerContainer");
    //document.getElementById("audioPlayerLocalOut").volume = 0*1;
    //
    // for testing of intercom webrtc failure only
    //
    /*
    setTimeout(function(){
      audioCtxRemote.close();
    }, 45000);
    */
    /*
    setTimeout(function(){
      audioCtxLocal.close();
    }, 45000);
    */
  } else {
    intercom = "off";
    console.log(ts() + "intercomOnOff: Off");
    //var msg = "Turn On LE880 to Browser Intercom";
    var msg = "Disabled";
    document.getElementById('buttonIntercomOnOff').innerText = msg;
    document.getElementById('buttonIntercomOnOff').style.backgroundColor = "lightblue";
    //
    // shut down webrtc
    //
    var html = "Browser will automatically reload.";
    document.getElementById("messageBar").style.display = "block";
    document.getElementById("messageBar").innerHTML = html;
    var msg = "Disabled";
    document.getElementById('buttonIntercomOnOff').innerText = msg;
    document.getElementById('buttonIntercomOnOff').style.backgroundColor = "lightblue";
    //setTimeout(function(){location.reload();}, 2000);
    demoModeEnabled = false;
    setTimeout(function () { location.reload(true); }, 2000);
    //setTimeout(function(){window.location.href = "/";}, 2000); // forces new login
    return;
    /*
    
    if (peer_connection) {
        peer_connection.close();
        peer_connection = null;
  console.log(ts()+"intercomOnOff: peer_connection = null");
    }
    
    //
    // shrink audio players
    //
       
    expand("shrink", "audioPlayerLocalIn", "playerContainer");
    expand("shrink", "audioPlayerLocalOut", "playerContainer");
    
    */
  }
  var browserUA = null;
  browserUA = navigator.userAgent;
  //console.log(ts()+"intercomOnOff() browserUA: " + browserUA);
  var browserID = null;
  promiseBrowserID.then(function (result) {
    browserID = result;
    //console.log(ts()+"intercomOnOff() browserID: " + browserID);
    var jsonObj = { "intercomOnOff": intercom, "browserID": browserID, "browserUA": browserUA };
    //console.log(ts()+"intercomOnOff() JSON.stringify(jsonObj): " + JSON.stringify(jsonObj));
    $.ajax({
      url: "/intercomOnOff",
      type: "POST",
      dataType: "json",
      data: jsonObj
    })
      .fail(function (e) {
        console.log("ERROR intercomOnOff() intercomOnOff: " + intercom + ", e: " + e);
      })
      .done(function (data) {
        if (data.auth) {
          //console.log(ts()+"intercomOnOff() .done data: " + intercom + ", JSON.stringify(data): " + JSON.stringify(data));
        } else {
          window.location.href = "/";
        }
      });
  }, function (err) {
    console.log(ts() + "ERROR intercomOnOff() promiseBrowserID err: " + err);
  });// promiseBrowserID.then    
} // intercomOnOff()
/*
function LE880toVMSAutoStart() {
  
  var browserUA = null;
  browserUA = navigator.userAgent;
  //console.log(ts()+"LE880toVMSAutoStart() browserUA: " + browserUA);
  var browserID = null;
  promiseBrowserID.then(function(result) {
    browserID = result;
    //console.log(ts()+"LE880toVMSAutoStart() browserID: " + browserID);
    if(document.getElementById("buttonLE880toVMSAutoStart").innerHTML == "Set Manual Start"){ // in auto mode
      document.getElementById("buttonLE880toVMSAutoStart").innerHTML = "Set Auto Start";
      document.getElementById('buttonLE880toVMSAutoStart').style.backgroundColor = "red";
      var LE880toVMSAutoStart = "false";
    } else if (document.getElementById("buttonLE880toVMSAutoStart").innerHTML == "Set Auto Start"){ // in manual mode
      document.getElementById("buttonLE880toVMSAutoStart").innerHTML = "Set Manual Start";
      document.getElementById('buttonLE880toVMSAutoStart').style.backgroundColor = "green";
      var LE880toVMSAutoStart = "true";
    } else {
      console.log(ts()+"LE880toVMSAutoStart() ERROR " + document.getElementById("buttonLE880toVMSAutoStart").innerHTML);
      return;
    }
    
    var jsonObj  = { "LE880toVMSAutoStart" : LE880toVMSAutoStart, "browserID" : browserID, "browserUA" : browserUA };
    
    //console.log(ts()+"LE880toVMSAutoStart() JSON.stringify(jsonObj): " + JSON.stringify(jsonObj));
    $.ajax({
      url : "/LE880toVMSAutoStart",
      type : "POST",
      dataType : "json",
      data : jsonObj
      })
      
    .fail(function(e){
      console.log( "ERROR LE880toVMSAutoStart() e: " + JSON.stringify(e));
    })
    .done(function(data){
      
      if(data.auth){
      
  //console.log(ts()+"LE880toVMSAutoStart(), JSON.stringify(data): " + JSON.stringify(data));
	
      } else {
	
  window.location.href = "/";
      }
    });
  }, function(err) {
  console.log(ts()+"ERROR LE880toVMSAutoStart() promiseBrowserID err: " + err);
    
  });// promiseBrowserID.then      
      
} 
*/
// LE880toVMSAutoStart()
//var VMSsendOnOffstate = "off";
function VMSsendOnOff() {
  if (VMSsendOnOffstate == "off") {
    VMSsendOnOffstate = "on";
    //console.log(ts()+"VMSsendOnOffstate: On");
    //var msg = "Turn Off LE880 to VMS Send";
    var msg = "Enabled";
    document.getElementById('buttonVMSsendOnOff').innerText = msg;
    document.getElementById('buttonVMSsendOnOff').style.backgroundColor = "green";
  } else {
    VMSsendOnOffstate = "off";
    //console.log(ts()+"VMSsendOnOffstate: Off");
    //var msg = "Turn On LE880 to VMS Send";
    var msg = "Disabled";
    document.getElementById('buttonVMSsendOnOff').innerText = msg;
    document.getElementById('buttonVMSsendOnOff').style.backgroundColor = "lightblue";
  }
  var browserUA = null;
  browserUA = navigator.userAgent;
  //console.log(ts()+"VMSsendOnOff() browserUA: " + browserUA);
  var browserID = null;
  promiseBrowserID.then(function (result) {
    browserID = result;
    //console.log(ts()+"VMSsendOnOff() browserID: " + browserID);
    var RTSPUsername = document.getElementById("RTSPUsername").value;
    var RTSPPassword = document.getElementById("RTSPPassword").value;
    var RTSPPort = document.getElementById("RTSPPort").value;
    var OutgoingAudioURL = document.getElementById("OutgoingAudioURL").innerHTML;
    // var OutgoingAudioURL = "rtsp://"+RTSPUsername+":"+RTSPPassword+"@"+""
    var jsonObj = { "VMSsendOnOffstate": VMSsendOnOffstate, " RTSPUsername": RTSPUsername, "RTSPPassword": RTSPPassword, "RTSPPort": RTSPPort, "OutgoingAudioURL": OutgoingAudioURL, "browserID": browserID, "browserUA": browserUA };
    console.log(ts() + "VMSsendOnOff() JSON.stringify(jsonObj): " + JSON.stringify(jsonObj));
    $.ajax({
      url: "/VMSsendOnOff",
      type: "POST",
      dataType: "json",
      data: jsonObj
    })
      .fail(function (e) {
        console.log("ERROR VMSsendOnOff() VMSsendOnOffstate: " + VMSsendOnOffstate + ", e: " + e);
      })
      .done(function (data) {
        console.log(ts() + "VMSsendOnOff() data VMSsendOnOffstate: " + VMSsendOnOffstate + ", JSON.stringify(data): " + JSON.stringify(data));
        if (data.auth) {
          if (data.errorMsg) {
            console.log(ts() + "VMSsendOnOff() data.errorMsg: " + JSON.stringify(data.errorMsg));
            VMSsendOnOffstate = "off";
            //
            // update messageBar
            //
            var html = data.errorMsg;
            document.getElementById("messageBar").style.display = "block";
            document.getElementById("messageBar").innerHTML = html;
            var msg = "Turn On LE880 to VMS Send";
            document.getElementById('buttonVMSsendOnOff').innerText = msg;
            document.getElementById('buttonVMSsendOnOff').style.backgroundColor = "lightblue";
          }
        } else {
          window.location.href = "/";
        }
      });
  }, function (err) {
    console.log(ts() + "ERROR VMSsendOnOff() promiseBrowserID err: " + err);
  });// promiseBrowserID.then   
} // VMSsendOnOff
/*
function VMStoLE880AutoStart() {
  
  var browserUA = null;
  browserUA = navigator.userAgent;
  //console.log(ts()+"VMStoLE880AutoStart() browserUA: " + browserUA);
  var browserID = null;
  promiseBrowserID.then(function(result) {
    browserID = result;
    //console.log(ts()+"VMStoLE880AutoStart() browserID: " + browserID);
    if(document.getElementById("buttonVMStoLE880AutoStart").innerHTML == "Set Manual Start"){ // in auto mode
      document.getElementById("buttonVMStoLE880AutoStart").innerHTML = "Set Auto Start";
      document.getElementById('buttonVMStoLE880AutoStart').style.backgroundColor = "red";
      var VMStoLE880AutoStart = "false";
    } else if (document.getElementById("buttonVMStoLE880AutoStart").innerHTML == "Set Auto Start"){ // in manual mode
      document.getElementById("buttonVMStoLE880AutoStart").innerHTML = "Set Manual Start";
      document.getElementById('buttonVMStoLE880AutoStart').style.backgroundColor = "green";
      var VMStoLE880AutoStart = "true";
    } else {
      console.log(ts()+"VMStoLE880AutoStart() ERROR " + document.getElementById("buttonVMStoLE880AutoStart").innerHTML);
      return;
    }
    
    var jsonObj  = { "VMStoLE880AutoStart" : VMStoLE880AutoStart, "browserID" : browserID, "browserUA" : browserUA };
    
    //console.log(ts()+"VMStoLE880AutoStart() JSON.stringify(jsonObj): " + JSON.stringify(jsonObj));
    $.ajax({
      url : "/VMStoLE880AutoStart",
      type : "POST",
      dataType : "json",
      data : jsonObj
      })
      
    .fail(function(e){
      console.log( "ERROR VMStoLE880AutoStart() e: " + JSON.stringify(e));
    })
    .done(function(data){
      
      if(data.auth){
      
  //console.log(ts()+"VMStoLE880AutoStart(), JSON.stringify(data): " + JSON.stringify(data));
	
      } else {
	
  window.location.href = "/";
      }
    });
  }, function(err) {
  console.log(ts()+"ERROR VMStoLE880AutoStart() promiseBrowserID err: " + err);
    
  });// promiseBrowserID.then      
      
} 
*/
// VMStoLE880AutoStart()
//var VMSrecvOnOffstate = "off";
function VMSrecvOnOff() {
  if (VMSrecvOnOffstate == "off") {
    VMSrecvOnOffstate = "on";
    //console.log(ts()+"VMSrecvOnOffstate: On");
    //var msg = "Turn Off VMS to LE880 Receive";
    var msg = "Enabled";
    document.getElementById('buttonVMSrecvOnOff').innerText = msg;
    document.getElementById('buttonVMSrecvOnOff').style.backgroundColor = "green";
  } else {
    VMSrecvOnOffstate = "off";
    //console.log(ts()+"VMSrecvOnOffstate: Off");
    //var msg = "Turn On VMS to LE880 Receive";
    var msg = "Disabled";
    document.getElementById('buttonVMSrecvOnOff').innerText = msg;
    document.getElementById('buttonVMSrecvOnOff').style.backgroundColor = "lightblue";
  }
  var browserUA = null;
  browserUA = navigator.userAgent;
  //console.log(ts()+"VMSrecvOnOff() browserUA: " + browserUA);
  var browserID = null;
  promiseBrowserID.then(function (result) {
    browserID = result;
    //console.log(ts()+"VMSrecvOnOff() browserID: " + browserID);
    var IncomingAudioURL = document.getElementById("IncomingAudioURL").value;
    var jsonObj = { "VMSrecvOnOffstate": VMSrecvOnOffstate, "IncomingAudioURL": IncomingAudioURL, "browserID": browserID, "browserUA": browserUA };
    //console.log(ts()+"VMSrecvOnOff() JSON.stringify(jsonObj): " + JSON.stringify(jsonObj));
    $.ajax({
      url: "/VMSrecvOnOff",
      type: "POST",
      dataType: "json",
      data: jsonObj
    })
      .fail(function (e) {
        console.log("ERROR VMSrecvOnOff() VMSrecvOnOffstate: " + VMSrecvOnOffstate + ", e: " + e);
      })
      .done(function (data) {
        if (data.auth) {
          //console.log(ts()+"VMSrecvOnOff() data: " + VMSrecvOnOff + ", JSON.stringify(data): " + JSON.stringify(data));
        } else {
          window.location.href = "/";
        }
      });
  }, function (err) {
    console.log(ts() + "ERROR VMSrecvOnOff() promiseBrowserID err: " + err);
  });// promiseBrowserID.then   
} // VMSrecvOnOff
//
// PTT_down and PTT_up
//
/*
function vms_PTT_down() {
  //console.log(ts()+"vms_PTT_down()");
  document.getElementById('btn_vms_PTT').style.backgroundColor = "green";
  volChange("vms_PTT_down", 0);
} // vms_PTT_down()
function vms_PTT_up() {
  //console.log(ts()+"vms_PTT_up()");
  document.getElementById('btn_vms_PTT').style.backgroundColor = "red";
  volChange("vms_PTT_up", 0)
} // vms_PTT_up()
function PTT_down() {
  //console.log(ts()+"PTT_down()");
  document.getElementById('btn_PTT').style.backgroundColor = "green";
  volChange("PTT_down", 0);
} // PTT_down()
function PTT_up() {
  //console.log(ts()+"PTT_up()");
  document.getElementById('btn_PTT').style.backgroundColor = "red";
  volChange("PTT_up", 0)
} // PTT_up()*/

function refreshEvent(event) {
  var browserUA = null;
  browserUA = navigator.userAgent;
  //console.log(ts()+"refreshEvent() browserUA: " + browserUA);
  var browserID = null;
  promiseBrowserID.then(function (result) {
    browserID = result;
    //console.log(ts()+"refreshEvent() browserID: " + browserID);
    var jsonObj = {
      "event": event,
      "browserID": browserID,
      "browserUA": browserUA
    };
    //console.log(ts()+"refreshEvent(), JSON.stringify(jsonObj): " + JSON.stringify(jsonObj));
    $.ajax({
      url: "/refreshEvent",
      type: "POST",
      dataType: "json",
      data: jsonObj
    })
      .fail(function (e) {
        console.log("ERROR refreshEvent() e: " + JSON.stringify(e));
      })
      .done(function (data) {
        if (data.auth) {
          //console.log(ts() + "refreshEvent()" + event + ", JSON.stringify(data): " + JSON.stringify(data));
          if (event == "refreshAnalyticThreats") {
            for (general in data.threatsGeneral) {
              if (data.threatsGeneral[general].on == 'true') $('#threatGeneralMute' + general).prop("checked", true);
              else $('#threatGeneralMute' + general).prop("checked", false);
              $('#ThreatGeneralSpan' + general).text(data.threatsGeneral[general].min_prob);
              $('#ThreatGeneralSlider' + general).val(data.threatsGeneral[general].min_prob);
            }
            for (individual in data.threats) {
              if (data.threats[individual].on == 'true') $('#threatMute' + general).prop("checked", true);
              else $('#threatMute' + individual).prop("checked", false);
              $('#ThreatSpan' + individual).text((data.threats[individual].min_prob * 100).toString().substring(0, 4));
              $('#ThreatSlider' + individual).val(data.threats[individual].min_prob * 100);
            }
          }
          else if (event == "refreshPlaybackE2A") {
            if (data.DeviceType == "microphone") {
              $("div[name='PlaybackDivE2A']").hide();
            }
            else {
              $("div[name='PlaybackDivE2A']").show();
              for (let port = 0; port <= 5; port++) {
                //console.log(port)
                $('#OP' + port + '_playback_files').empty();
                $('#OP' + port + '_playback_files').append(new Option("Disabled", "disabled"));
                for (file of data.arr) {
                  $('#OP' + port + '_playback_files').append(new Option(file, file));
                }
              }
            }
          }
          else if (event == "listPlaybackFiles") document.getElementById("divListPlaybackFiles").innerHTML = data.html;
          else if (event == "listAudioFiles") document.getElementById("divListAudioFiles").innerHTML = data.html;
          else if (event == "refreshOutputPort") {
            for (let port = 0; port <= 5; port++) {
              $('#OP' + port + '_trig').val(data.configUser["OP" + port + "_trig_checked"]);
              if (data.configUser["OP" + port + "_trig_checked"] == "mic") {
                $("#OP" + port + "_button_mic_level").show();
                $("#OP" + port + "_spl_level_div").hide();
              }
              else if (data.configUser["OP" + port + "_trig_checked"] == "Explosion&Acoustics") {
                $("#OP" + port + "_spl_level_div").show();
                $("#OP" + port + "_button_mic_level").hide();
              }
              else{
                $("#OP" + port + "_spl_level_div").hide();
                $("#OP" + port + "_button_mic_level").hide();
                $("#OP" + port + "_mic_set").hide();
              }
              (data.configUser["OP" + port + "_active_checked"] == "enabled") ? $('#OP' + port + '_active').prop("checked", true) : $('#OP' + port + '_active').prop("checked", false)
              $('#OP' + port + '_dest').val(data.configUser["OP" + port + "_dest_checked"]);
              $('#OP' + port + '_Duration').val(data.configUser["OP" + port + "_Duration"]);
              // Recording
              (data.configUser["OP" + port + "_recording_checked"] == "enabled") ? $('#OP' + port + '_recording').prop("checked", true) : $('#OP' + port + '_recording').prop("checked", false)
              $('#OP' + port + '_recording_duration_before').val(data.configUser["OP" + port + "_recording_duration_before"]);
              $('#OP' + port + '_recording_duration_after').val(data.configUser["OP" + port + "_recording_duration_after"]);
              // Post
              $('#OP' + port + '_HTTPS').val(data.configUser["OP" + port + "_HTTPS_checked"]);
              $('#OP' + port + '_POST_URL').val(data.configUser["OP" + port + "_POST_URL"]);
              for (let i = 0; i <= 4; i++) {
                $('#OP' + port + '_k' + i).text(data.configUser['#OP' + port + '_k' + i]);
                $('#OP' + port + '_v' + i).text(data.configUser['#OP' + port + '_v' + i]);
              }
              $('#OP' + port + '_TCP_URL').val(data.configUser["OP" + port + "_TCP_URL"]);
              $('#OP' + port + '_tcp1').val(data.configUser["OP" + port + "_tcp1"]);
              $('#OP' + port + '_tcp2').val(data.configUser["OP" + port + "_tcp2"]);
              //Playback
              (data.configUser["OP" + port + "_playback_checked"] == "enabled") ? $('#OP' + port + '_playback').prop("checked", true) : $('#OP' + port + '_playback').prop("checked", false)
              $('#OP' + port + '_playback_files').val(data.configUser["OP" + port + "_playback_file"]);
              $('#OP' + port + '_playback_volume').val(data.configUser["OP" + port + "_playback_volume"]);
            }
          }
        }
      });
  }, function (err) {
    console.log(ts() + "ERROR refreshEvent() promiseBrowserID err: " + err);
  });// promiseBrowserID.then      
} // refreshEvent()



//
// download audio file
//
function ad(fn) {
  var browserUA = null;
  browserUA = navigator.userAgent;
  //console.log(ts()+"ad() browserUA: " + browserUA);
  var browserID = null;
  promiseBrowserID.then(function (result) {
    browserID = result;
    //console.log(ts()+"ad() browserID: " + browserID);
    var jsonObj = {
      "fn": fn,
      "browserID": browserID,
      "browserUA": browserUA
    };
    //console.log(ts()+"ad(), JSON.stringify(jsonObj): " + JSON.stringify(jsonObj));
    $.ajax({
      url: "/ad",
      type: "POST",
      dataType: "json",
      data: jsonObj
    })
      .fail(function (e) {
        console.log("ERROR ad() e: " + JSON.stringify(e));
      })
      .done(function (data) {
        if (data.auth) {
          //console.log(ts()+"ad(), JSON.stringify(data): " + JSON.stringify(data));
          //console.log(ts()+"ad(), file: " + fn + ", length: " + data.fdata.data.length);
          function typedArrayToURL(typedArray, mimeType) {
            return URL.createObjectURL(new Blob([typedArray.buffer], { type: mimeType }))
          }
          var bytes = new Uint8Array(data.fdata.data);
          var downloadUrl = typedArrayToURL(bytes, 'audio/wav');
          var a = document.createElement("a");
          a.href = downloadUrl;
          a.download = data.fn;
          document.body.appendChild(a);
          a.click();
          document.getElementById("divListAudioFiles").innerHTML = "<p>File downloaded: " + data.fn + ", file length = " + data.fdata.data.length + "</p>";
        } else {
          window.location.href = "/";
        }
      });
  }, function (err) {
    console.log(ts() + "ERROR ad() promiseBrowserID err: " + err);
  });// promiseBrowserID.then      
} // ad()  
//
// remove audio file
//
function rmaf(fn) {
  var browserUA = null;
  browserUA = navigator.userAgent;
  //console.log(ts()+"rmaf() browserUA: " + browserUA);
  var browserID = null;
  promiseBrowserID.then(function (result) {
    browserID = result;
    //console.log(ts()+"rmaf() browserID: " + browserID);
    var jsonObj = {
      "fn": fn,
      "browserID": browserID,
      "browserUA": browserUA
    };
    //console.log(ts()+"rmaf(), JSON.stringify(jsonObj): " + JSON.stringify(jsonObj));
    $.ajax({
      url: "/rmaf",
      type: "POST",
      dataType: "json",
      data: jsonObj
    })
      .fail(function (e) {
        console.log("ERROR rmaf() e: " + JSON.stringify(e));
      })
      .done(function (data) {
        if (data.auth) {
          //console.log(ts()+"rmaf(), JSON.stringify(data): " + JSON.stringify(data));
          document.getElementById("divListAudioFiles").innerHTML = "<p>File deleted: " + data.fn + "</p>";
          setTimeout(function () {
            listAudioFiles();
          }, 2000);
        } else {
          window.location.href = "/";
        }
      });
  }, function (err) {
    console.log(ts() + "ERROR rmaf() promiseBrowserID err: " + err);
  });// promiseBrowserID.then      
} // rmaf()

function rmafPlayback(fn) {
  var browserUA = null;
  browserUA = navigator.userAgent;
  //console.log(ts()+"rmaf() browserUA: " + browserUA);
  var browserID = null;
  promiseBrowserID.then(function (result) {
    browserID = result;
    //console.log(ts()+"rmaf() browserID: " + browserID);
    var jsonObj = {
      "fn": fn,
      "browserID": browserID,
      "browserUA": browserUA
    };
    //console.log(ts()+"rmaf(), JSON.stringify(jsonObj): " + JSON.stringify(jsonObj));
    $.ajax({
      url: "/rmafPlayback",
      type: "POST",
      dataType: "json",
      data: jsonObj
    })
      .fail(function (e) {
        console.log("ERROR rmaf() e: " + JSON.stringify(e));
      })
      .done(function (data) {
        if (data.auth) {
          //console.log(ts()+"rmaf(), JSON.stringify(data): " + JSON.stringify(data));
          document.getElementById("divListPlaybackFiles").innerHTML = "<p>File deleted: " + data.fn + "</p>";
          setTimeout(function () {
            listPlaybackFiles();
          }, 2000);
        } else {
          window.location.href = "/";
        }
      });
  }, function (err) {
    console.log(ts() + "ERROR rmaf() promiseBrowserID err: " + err);
  });// promiseBrowserID.then      
} // rmaf()
//
// system functions
//
function logout() {
  console.log(ts() + "logout()");
  var browserUA = null;
  browserUA = navigator.userAgent;
  //console.log(ts()+"logout() browserUA: " + browserUA);
  var browserID = null;
  promiseBrowserID.then(function (result) {
    browserID = result;
    //console.log(ts()+"logout() browserID: " + browserID);
    var jsonObj = { "logout": true, "browserID": browserID, "browserUA": browserUA };
    $.ajax({
      url: "/logout",
      type: "POST",
      dataType: "json",
      data: jsonObj
    })
      .fail(function (e) {
        console.log("ERROR logout() e: " + e);
      })
      .done(function (data) {
        if (data.auth) {
          //
          // no action
          //
        } else {
          $("#messageBar").css("display", "block");
          $("#messageBar").html("Logging Out");
          setTimeout(function () {
            localStorage.removeItem('browserID');
            window.location.href = "/";
          }, 3000);
        }

      });
  }, function (err) {
    console.log(ts() + "ERROR logout() promiseBrowserID err: " + err);
  });// promiseBrowserID.then        
} // logout
var pw_count = Number(1);
var pw1Hash = null;
var account1 = null;
function pw_change(account) {
  //console.log(ts()+"pw_change() account: " + account);
  var browserUA = null;
  browserUA = navigator.userAgent;
  //console.log(ts()+"pw_change() browserUA: " + browserUA);
  var browserID = null;
  promiseBrowserID.then(function (result) {
    browserID = result;
    //console.log(ts()+"pw_change() browserID: " + browserID);
    var currentUser = document.getElementById("currentUser").innerHTML;
    //console.log(ts()+"pw_change() currentUser: " + currentUser);
    if (currentUser == "user") {
      if (account == "admin" || account == "superadmin") {
        $("#messageBar").css("display", "block");
        $("#messageBar").html("user may not change password for admin or superadmin");
        return;
      }
    }
    if (currentUser == "admin") {
      if (account == "superadmin") {
        $("#messageBar").css("display", "block");
        $("#messageBar").html("admin may not change password for superadmin");
        return;
      }
    }
    var password;
    var passwordHash;
    var n = 2;
    let special = "!-\/:-@[-`{-~";
    var constructedRegEx = `^(?=(.*[a-z]){${n},})(?=(.*[A-Z]){${n},})(?=(.*\\d){${n},})(?=(.*[${special}]){${n},})[A-Za-z\\d${special}]{8,}$`

    //var constructedRegEx = "^(?=(?:.*[0-9]){" + n + ",})(?=(?:.*[a-z]){" + n + ",})(?=(?:.*[A-Z]){" + n + ",})(?=(?:.*[!-\/:-@[-`{-~]){" + n + ",}).+$";
    var PasswordRegEx = new RegExp(constructedRegEx, 'm');

    // (?=(?:.*[!-\/:-@[-`{-~]){"2",})
    // (?=(?:.*[a-z]){"2",})(?=(?:.*[A-Z]){"2",})
    if (pw_count == 1) {
      account1 = account;
      password = document.getElementById("pw_" + account).value;
      //console.log(ts()+"pw_change() 0 password: " + password);
      passwordHash = hex_md5(password);
      //console.log(ts()+"pw_change() 0 passwordHash: " + password);
      //
      // password must contains 2 of each: lower case, upper case, numbers, special characters
      //
      if (!PasswordRegEx.test(password)) {
        console.log(ts() + "login() password 1 test failed");
        let msg = "Password for " + account + " must contain 2 of each: lower case, upper case, numbers, special characters.";
        $("#messageBar").css("display", "block");
        $("#messageBar").html(msg);
        return;
      }
      pw1Hash = passwordHash;
      pw_count = Number(2);
      $("#messageBar").css("display", "block");
      $("#messageBar").html("Please enter the password for \"" + account + "\" again to confirm.");
      document.getElementById("pw_" + account).value = "";
      return;
    }
    if (pw_count == 2) {
      if (account != account1) {
        $("#messageBar").css("display", "block");
        $("#messageBar").html("Usernames do not match, please try again");
        pw1Hash = null;
        account1 = null;
        pw_count = Number(1);
        document.getElementById("pw_" + account).value = "";
        return;
      }
      password = document.getElementById("pw_" + account).value;
      //console.log(ts()+"pw_change() 2 pw: " + password);
      passwordHash = hex_md5(password);
      //console.log(ts()+"pw_change() 0 passwordHash: " + password);
      if (hex_md5(password) != pw1Hash) {
        $("#messageBar").css("display", "block");
        $("#messageBar").html("Passwords do not match, please try again");
        pw1Hash = null;
        account1 = null;
        pw_count = Number(1);
        document.getElementById("pw_" + account).value = "";
        return;
      }
      //
      // password must contains 2 of each: lower case, upper case, nunbers, special characters
      //
      if (!PasswordRegEx.test(password)) {
        console.log(ts() + "login() password 2 test failed");
        let msg = "Password for " + account + " must contain 2 of each: lower case, upper case, numbers, special characters.";
        $("#messageBar").css("display", "block");
        $("#messageBar").html(msg);
        return;
      }
      pw1Hash = null;
      account1 = null;
      pw_count = Number(1);
    }
    var jsonObj = { "pw_change": true, "account": account, "passwordHash": passwordHash, "browserID": browserID, "browserUA": browserUA };
    $.ajax({
      url: "/pw_change",
      type: "POST",
      dataType: "json",
      data: jsonObj
    })
      .fail(function (e) {
        console.log("ERROR pw_change() e: " + e);
      })
      .done(function (data) {
        if (data.auth) {
          //console.log(ts()+"pw_change(), JSON.stringify(data): " + JSON.stringify(data));
          if (data.msg) {
            $("#messageBar").css("display", "block");
            $("#messageBar").html(data.msg);
          } // if(data.msg)
        } else {
          if (data.msg) {
            $("#messageBar").css("display", "block");
            $("#messageBar").html(data.msg);
            setTimeout(function () {
              window.location.href = "/";
            }, 3000)
          } else {
            window.location.href = "/";
          }
        }
      });
  }, function (err) {
    console.log(ts() + "ERROR pw_change() promiseBrowserID err: " + err);
  });// promiseBrowserID.then       
} // pw_change()
function setDhcpStatic() {
  var browserUA = null;
  browserUA = navigator.userAgent;
  //console.log(ts()+"setDhcpStatic() browserUA: " + browserUA);
  var browserID = null;
  promiseBrowserID.then(function (result) {
    browserID = result;
    //console.log(ts()+"setDhcpStatic() browserID: " + browserID);

    var ee = document.querySelectorAll('input[name="dhcpStatic"]');
    var dhcpStaticSelected;
    for (const e of ee) {
      if (e.checked) {
        dhcpStaticSelected = e.value;
        break;
      }
    }
    var setStatic = document.getElementById("setStatic").value;
    var setMask = $('#setMask').children("option:selected").val();
    var setRouter = document.getElementById("setRouter").value;
    var setDNS = document.getElementById("setDNS").value;
    var jsonObj = {
      "setDhcpStatic": true,
      "dhcpStaticSelected": dhcpStaticSelected,
      "setStatic": setStatic,
      "setMask": setMask,
      "setRouter": setRouter,
      "setDNS": setDNS,
      "browserID": browserID,
      "browserUA": browserUA
    };
    console.log(ts() + "setDhcpStatic(), JSON.stringify(jsonObj): " + JSON.stringify(jsonObj));
    $.ajax({
      url: "/setDhcpStatic",
      type: "POST",
      dataType: "json",
      data: jsonObj
    })
      .fail(function (e) {
        console.log("ERROR setDhcpStatic() e: " + e);
      })
      .done(function (data) {
        if (data.auth) {
          console.log(ts() + "setDhcpStatic(), JSON.stringify(data): " + JSON.stringify(data));
          if (data.msg) {
            $("#messageBar").css("display", "block");
            //$("#messageBar").html(data.msg);
            var count = 60;
            document.getElementById("messageBar").innerHTML = data.msg + "<br>Automatic page reload in " + count + " seconds";
            function setDhcpStaticTimer() {
              count = count - 1;
              document.getElementById("messageBar").innerHTML = data.msg + "<br>Automatic page reload in " + count + " seconds";
              if (count == 0) {
                clearInterval(setDhcpStaticInterval);
                location.reload();
              }
            }
            var setDhcpStaticInterval = setInterval(setDhcpStaticTimer, 1000);
          } // if(data.msg)
        } else {
          window.location.href = "/";
        }
      });
  }, function (err) {
    console.log(ts() + "ERROR setDhcpStatic() promiseBrowserID err: " + err);
  });// promiseBrowserID.then      

} // setDhcpStatic()
function reboot() {
  var browserUA = null;
  browserUA = navigator.userAgent;
  //console.log(ts()+"reboot() browserUA: " + browserUA);
  var browserID = null;
  promiseBrowserID.then(function (result) {
    browserID = result;
    //console.log(ts()+"reboot() browserID: " + browserID);
    var jsonObj = { "reboot": true, "browserID": browserID, "browserUA": browserUA };
    $.ajax({
      url: "/reboot",
      type: "POST",
      dataType: "json",
      data: jsonObj
    })
      .fail(function (e) {
        console.log("ERROR reboot() e: " + e);
      })
      .done(function (data) {
        if (data.auth) {
          //
          // admin or superadmin required
          //
          if (data.rebootAuthError) {
            window.scrollTo(0, top);
            $("#messageBar").css("display", "block");
            $("#messageBar").html(data.reboot);
            return;
          }
          //console.log(ts()+"reboot(), JSON.stringify(data): " + JSON.stringify(data));
          if (data.msg) {
            $("#messageBar").css("display", "block");
            //$("#messageBar").html(data.msg);
            window.scrollTo(0, top);
            var count = 60;
            document.getElementById("messageBar").innerHTML = "LE880 is rebooting now.<br><br>Automatic webpage reload in " + count + " seconds.";
            function rebootTimer() {
              count = count - 1;
              document.getElementById("messageBar").innerHTML = "LE880 is rebooting now.<br><br>Automatic webpage reload in " + count + " seconds.";
              if (count == 0) {
                clearInterval(rebootInterval);
                location.reload();
              }
            }
            var rebootInterval = setInterval(rebootTimer, 1000);
          } // if(data.msg)
        } else {
          window.location.href = "/";
        }
      });
  }, function (err) {
    console.log(ts() + "ERROR reboot() promiseBrowserID err: " + err);
  });// promiseBrowserID.then     
} // reboot()
var resetFactoryFlag = false;
function resetFactory() {
  var browserUA = null;
  browserUA = navigator.userAgent;
  //console.log(ts()+"resetFactory() browserUA: " + browserUA);
  var browserID = null;
  promiseBrowserID.then(function (result) {
    browserID = result;
    //console.log(ts()+"resetFactory() browserID: " + browserID);
    var jsonObj = { "resetFactory": true, "browserID": browserID, "browserUA": browserUA };
    $.ajax({
      url: "/resetFactory",
      type: "POST",
      dataType: "json",
      data: jsonObj
    })
      .fail(function (e) {
        console.log("ERROR resetFactory() e: " + e);
      })
      .done(function (data) {
        if (data.auth) {
          //console.log(ts()+"resetFactory(), JSON.stringify(data): " + JSON.stringify(data));
          //
          // admin or superadmin required
          //
          if (data.resetFactoryAuthError) {
            window.scrollTo(0, top);
            $("#messageBar").css("display", "block");
            $("#messageBar").html(data.resetFactory);
            return;
          }
          resetFactoryFlag = true;
          var count = 60;
          var msg = "Reset to Factory Defaults and Reboot in process.";
          msg += "<br>DHCP is enabled by Reset to Factory Defaults and Reboot.";
          msg += "<br>If a static IP address was in use it may be changed by DHCP.";
          msg += "<br>If a static IP address was in use, you may need to manually enter a new IP address in your browser.";
          msg += "<br>New security tokens being generated. Please login in " + count + " seconds.";
          window.scrollTo(0, top);
          $("#messageBar").css("display", "block");
          $("#messageBar").html(msg);
          function resetFactoryTimer() {
            count = count - 1;
            var msg = "Reset to Factory Defaults and Reboot in process.";
            msg += "<br>DHCP is enabled by Reset to Factory Defaults and Reboot.";
            msg += "<br>If a static IP address was in use it may be changed by DHCP.";
            msg += "<br>If a static IP address was in use, you may need to manually enter a new IP address in your browser.";
            msg += "<br>New security tokens being generated. Please login in " + count + " seconds.";
            $("#messageBar").html(msg);
            if (count == 0) {
              clearInterval(resetFactoryInterval);
              //location.reload();
              window.location.href = "/"; // new browserID requires new login
            }
          }
          var resetFactoryInterval = setInterval(resetFactoryTimer, 1000);
        } else {
          window.location.href = "/";
        }
      });
  }, function (err) {
    console.log(ts() + "ERROR resetFactory() promiseBrowserID err: " + err);
  });// promiseBrowserID.then     
} // resetFactory()
var readFileDone = false;
var readFileData = null;
function readFile(event) {
  readFileDone = false;
  readFileData = null;
  //console.log(ts()+"readFile JSON.stringify(event): " + JSON.stringify(event));
  var file = event.target.files.item(0);
  //console.log(ts()+"readFile file.: " + file);
  //console.log(ts()+"readFile typeof file.: " + typeof file);
  //console.log(ts()+"readFile JSON.stringify(file): " + JSON.stringify(file));
  //console.log(ts()+"readFile file.toString(): " + file.toString());
  var reader = new FileReader();
  reader.onload = function () {
    readFileData = reader.result;
    console.log(ts() + "readFile readFileData.length: " + readFileData.length);
    readFileDone = true;
  }
  reader.readAsBinaryString(file);
} // readFile
var readFilePlaybackDone = false;
var readFilePlaybackData = null;
function readFilePlayback(event) {
  readFilePlaybackDone = false;
  readFilePlaybackData = null;
  //console.log(ts()+"readFilePlayback JSON.stringify(event): " + JSON.stringify(event));
  var file = event.target.files.item(0);
  //console.log(ts()+"readFilePlayback file.: " + file);
  //console.log(ts()+"readFilePlayback typeof file.: " + typeof file);
  //console.log(ts()+"readFilePlayback JSON.stringify(file): " + JSON.stringify(file));
  //console.log(ts()+"readFilePlayback file.toString(): " + file.toString());
  var reader = new FileReader();
  reader.onload = function () {
    readFilePlaybackData = reader.result;
    console.log(ts() + "readFilePlayback readFilePlaybackData.length: " + readFilePlaybackData.length);
    readFilePlaybackDone = true;
  }
  reader.readAsBinaryString(file);
} // readFilePlayback
function UploadSoftwareUpdateFile() {
  $("#messageBar").css("display", "block");
  $("#messageBar").html("Software upload and update starting.");
  var swuploadFileNameWQ = document.getElementById('file_swupload').value;
  //console.log(ts()+"UploadSoftwareUpdateFile() swuploadFileNameWQ: " + swuploadFileNameWQ);
  if (swuploadFileNameWQ == "" || swuploadFileNameWQ == null) {
    window.scrollTo(0, top);
    $("#messageBar").css("display", "block");
    $("#messageBar").html("Please select a file that starts with \"LE880\" and ends with \".deb\"");
    return;
  }
  var swuploadFileNameNQ = swuploadFileNameWQ.replace(/"/g, ''); // remove double quotes
  //console.log(ts()+"UploadSoftwareUpdateFile() swuploadFileNameNQ: " + swuploadFileNameNQ);
  var swuploadFileNameArr = swuploadFileNameNQ.split("\\");
  //console.log(ts()+"UploadSoftwareUpdateFile() swuploadFileNameArr.toString(): " + swuploadFileNameArr.toString());
  var swuploadFileName = swuploadFileNameArr[2];
  //console.log(ts()+"UploadSoftwareUpdateFile() swuploadFileName: " + swuploadFileName);
  if (!(swuploadFileName.substr(0, 5) == "le880" && swuploadFileName.substr(-4) == ".deb")) {
    window.scrollTo(0, top);
    $("#messageBar").css("display", "block");
    $("#messageBar").html("Please select a file that starts with \"le880\" and ends with \".deb\"");
    return;
  }
  if (readFileDone == true) {
    console.log(ts() + "UploadSoftwareUpdateFile() SUCCESS readFileDone == true");
  } else {
    console.log(ts() + "UploadSoftwareUpdateFile() ERROR  readFileDone != true");
    return;
  }
  var browserUA = null;
  browserUA = navigator.userAgent;
  //console.log(ts()+"UploadSoftwareUpdateFile() browserUA: " + browserUA);
  var browserID = null;
  promiseBrowserID.then(function (result) {
    browserID = result;
    //console.log(ts()+"UploadSoftwareUpdateFile() browserID: " + browserID);
    var jsonObj = {
      "swupload": true,
      "browserID": browserID,
      "browserUA": browserUA,
      "swuploadFileName": swuploadFileName,
      "swuploadFileLength": readFileData.length,
      "swuploadFileContents": readFileData
    };
    //console.log(ts()+"UploadSoftwareUpdateFile() JSON.stringify(jsonObj): " + JSON.stringify(jsonObj));
    $.ajax({
      url: "/swupload",
      type: "POST",
      dataType: "json",
      data: jsonObj
    })
      .fail(function (e) {
        console.log("ERROR UploadSoftwareUpdateFile() e: " + e);
      })
      .done(function (data) {
        //console.log(ts()+"UploadSoftwareUpdateFile() JSON.stringify(data): " + JSON.stringify(data));
        readFileDone = false;
        readFileData = null;
        if (data.successMsg) {
          window.scrollTo(0, top);
          $("#messageBar").css("display", "block");
          $("#messageBar").html(data.successMsg);
        }
        else if (data.msg) {
          window.scrollTo(0, top);
          $("#messageBar").css("display", "block");
          $("#messageBar").html(data.msg);
        }
      })
  }, function (err) {
    console.log(ts() + "ERROR UploadSoftwareUpdateFile() promiseBrowserID err: " + err);
  });// promiseBrowserID.then     
} // UploadSoftwareUpdateFile()
function UploadPlaybackFile() {
  $("#messageBar").css("display", "block");
  $("#messageBar").html("Playback upload starting.");
  var playbackFileNameWQ = document.getElementById('file_playback').value;
  //console.log(ts()+"UploadPlaybackFile() playbackFileNameWQ: " + playbackFileNameWQ);
  var playbackFileNameNQ = playbackFileNameWQ.replace(/"/g, ''); // remove double quotes
  //console.log(ts()+"UploadPlaybackFile() playbackFileNameNQ: " + playbackFileNameNQ);
  var playbackFileNameArr = playbackFileNameNQ.split("\\");
  //console.log(ts()+"UploadPlaybackFile() playbackFileNameArr.toString(): " + playbackFileNameArr.toString());
  var playbackFileName = playbackFileNameArr[2];
  //console.log(ts()+"UploadPlaybackFile() playbackFileName: " + playbackFileName);
  if (!(playbackFileName.substr(-4) == ".wav" || playbackFileName.substr(-4) == ".mp3")) {
    window.scrollTo(0, top);
    $("#messageBar").css("display", "block");
    $("#messageBar").html("Please select a file wav or mp3");
    return;
  }
  if (!(readFilePlaybackData.length < 1048576)) {
    window.scrollTo(0, top);
    console.log(ts() + "readFilePlayback readFilePlaybackData.length: " + readFilePlaybackData.length);
    $("#messageBar").css("display", "block");
    $("#messageBar").html("File must be less than 1MB");
    return;
  }
  if (readFilePlaybackDone == true) {
    console.log(ts() + "UploadPlaybackFile() SUCCESS readFilePlaybackDone == true");
  } else {
    console.log(ts() + "UploadPlaybackFile() ERROR  readFilePlaybackDone != true");
    return;
  }
  var browserUA = null;
  browserUA = navigator.userAgent;
  //console.log(ts()+"UploadPlaybackFile() browserUA: " + browserUA);
  var browserID = null;
  promiseBrowserID.then(function (result) {
    browserID = result;
    //console.log(ts()+"UploadPlaybackFile() browserID: " + browserID);
    var jsonObj = {
      "playback": true,
      "browserID": browserID,
      "browserUA": browserUA,
      "playbackFileName": playbackFileName,
      "playbackFileLength": readFilePlaybackData.length,
      "playbackFileContents": readFilePlaybackData
    };
    //console.log(ts()+"UploadPlaybackFile() JSON.stringify(jsonObj): " + JSON.stringify(jsonObj));
    $.ajax({
      url: "/playbackupload",
      type: "POST",
      dataType: "json",
      data: jsonObj
    })
      .fail(function (e) {
        console.log("ERROR UploadPlaybackFile() e: " + e);
      })
      .done(function (data) {
        //console.log(ts()+"UploadPlaybackFile() JSON.stringify(data): " + JSON.stringify(data));
        readFilePlaybackDone = false;
        readFilePlaybackData = null;
        if (data.successMsg) {
          window.scrollTo(0, top);
          $("#messageBar").css("display", "block");
          $("#messageBar").html(data.successMsg);
        }
        else if (data.msg) {
          window.scrollTo(0, top);
          $("#messageBar").css("display", "block");
          $("#messageBar").html(data.msg);
        }
        listPlaybackFiles();
      })
  }, function (err) {
    console.log(ts() + "ERROR UploadPlaybackFile() promiseBrowserID err: " + err);
  });// promiseBrowserID.then     
} // UploadPlaybackFile()
//
// outputSettings start
//

// expand
function micLevel(port) {
  var html = document.getElementById(port + "_button_mic_level").innerHTML;
  console.log(ts() + "micLevel() port : " + port + ", button html: " + html);
  var sl = document.querySelectorAll(".setLevel");
  sl.forEach(function (td) {
    //console.log(ts()+"micLevel() td.id : " + td.id);
    td.style.display = "none";
  });
  var buttons = document.querySelectorAll("button");
  buttons.forEach(function (button) {
    //console.log(ts()+"micLevel() button.id : " + button.id);
    if (button.id.search("_button_mic_level") > 0) {
      if (button.innerHTML.trim() == "Close Microphone Level") {
        button.innerHTML = "Set Microphone Level";
      }
    }
  });

  if (html == "Set Microphone Level") {
    alertPORT = port;
    var readyState = LE880wssServerMicAlert_conn.readyState;
    //console.log(ts()+"micLevel() port : " + port + ", LE880wssServerMicAlert_conn.readyState: " + readyState);
    if (LE880wssServerMicAlert_conn) {
      if (readyState != 1) {
        /*
        LE880wssServerMicAlert_conn.clients.forEach((socket) => {
          
          // Soft close
          socket.close();
      
          process.nextTick(() => {
            
            if ([socket.OPEN, socket.CLOSING].includes(socket.readyState)) {
              
              // Socket still hangs, hard close
              socket.terminate();
            }
          });
        });
        */
        LE880wssServerMicAlert_conn.close();
        LE880wssServerMicAlert_Connect();
      }
    }
    console.log(ts() + "micLevel() Set Microphone Level port : " + port);
    document.getElementById(port + "_mic_set").style.display = "block";
    //
    // change button text
    //
    document.getElementById(port + "_button_mic_level").innerText = "Close Microphone Level";
  } // Set Microphone Level
  else if (html == "Close Microphone Level") {
    console.log(ts() + "micLevel() Close Microphone Level port : " + port);
    document.getElementById(port + "_mic_set").style.display = "none";
    //
    // change button text
    //
    document.getElementById(port + "_button_mic_level").innrText = "Set Microphone Level";
  } // Close Microphone Level
  /* WebSocketStream is NOT supported
  if ('WebSocketStream' in window) {
    document.getElementById(port).style.display = "block";
    document.getElementById(port).innerHTML     = "WebSocketStream is supported";  
  }  else {
    document.getElementById(port).style.display = "block";
    document.getElementById(port).innerHTML     = "WebSocketStream is NOT supported";      
    
  }
  */
} // micLevel(port)
/*
function streamLevel(id){
  
  console.log(ts()+"streamLevel() id : " + id);
  $("#" + id).css("display", "block");
  
  var msg = "streamLevel(" + id + ") is  Under Construction";
  $("#messageBar").css("display", "block");
  $("#messageBar").html(msg);    
  
}
*/
/* not needed
<button onclick="confIn('OP{{portNumber}}', 1)">Configure Input Port 2</button>
* 
function confIn(op, ip){
  
  var msg = "OnfIn(" + op + ", " + ip + ") is  Under Construction";
  $("#messageBar").css("display", "block");
  $("#messageBar").html(msg);    
  
}
*/
function durUp(port) {
  var dur = Number(document.getElementById("OP" + port + "_Duration").value);
  if (dur >= 59) {
    document.getElementById("OP" + port + "_Duration").value = 60;
  } else {
    document.getElementById("OP" + port + "_Duration").value = dur + 1;
  }
  showHidewithObject({ "target": "led", "action": port })
} // durUp
function durDown(port) {
  var dur = Number(document.getElementById("OP" + port + "_Duration").value);
  if (dur <= 1) {
    document.getElementById("OP" + port + "_Duration").value = 0 * 1;
  } else {
    document.getElementById("OP" + port + "_Duration").value = dur - 1;
  }
  showHidewithObject({ "target": "led", "action": port })
} // volDown
function volUp(port) {
  var dur = Number(document.getElementById(port + "_playback_volume").value);
  if (dur >= 9) {
    document.getElementById(port + "_playback_volume").value = 10;
  } else {
    document.getElementById(port + "_playback_volume").value = dur + 1;
  }
} // volUp
function volDown(port) {
  var dur = Number(document.getElementById(port + "_playback_volume").value);
  if (dur <= 1) {
    document.getElementById(port + "_playback_volume").value = 0 * 1;
  } else {
    document.getElementById(port + "_playback_volume").value = dur - 1;
  }
} // durDown
function splUp(port) {
  var dur = Number(document.getElementById(port + "_spl_level").value);
  document.getElementById(port + "_spl_level").value = dur + 1;

} // splUp
function splDown(port) {
  var dur = Number(document.getElementById(port + "_spl_level").value);
    document.getElementById(port + "_spl_level").value = dur - 1;
} // durDown
function recDurBeforeUp(port) {
  var dur = Number(document.getElementById(port + "_recording_duration_before").value);
  if (dur >= 59) {
    document.getElementById(port + "_recording_duration_before").value = 60;
  } else {
    document.getElementById(port + "_recording_duration_before").value = dur + 1;
  }
} // recDurBeforeUp
function recDurBeforeDown(port) {
  var dur = Number(document.getElementById(port + "_recording_duration_before").value);
  if (dur <= 1) {
    document.getElementById(port + "_recording_duration_before").value = 0 * 1;
  } else {
    document.getElementById(port + "_recording_duration_before").value = dur - 1;
  }
} // recDurBeforeDown
function recDurAfterUp(port) {
  var dur = Number(document.getElementById(port + "_recording_duration_after").value);
  if (dur >= 59) {
    document.getElementById(port + "_recording_duration_after").value = 60;
  } else {
    document.getElementById(port + "_recording_duration_after").value = dur + 1;
  }
} // recDurAfterUp
function recDurAfterDown(port) {
  var dur = Number(document.getElementById(port + "_recording_duration_after").value);
  if (dur <= 1) {
    document.getElementById(port + "_recording_duration_after").value = 0 * 1;
  } else {
    document.getElementById(port + "_recording_duration_after").value = dur - 1;
  }
} // recDurAfterDown
function jsonP(port) {
  var jsonStr = '{ ';
  jsonStr += '"' + $("#OP" + port + "_k1").val() + '" : "' + $("#OP" + port + "_v1").val() + '", ';
  jsonStr += '"' + $("#OP" + port + "_k2").val() + '" : "' + $("#OP" + port + "_v2").val() + '", ';
  jsonStr += '"' + $("#OP" + port + "_k3").val() + '" : "' + $("#OP" + port + "_v3").val() + '", ';
  jsonStr += '"' + $("#OP" + port + "_k4").val() + '" : "' + $("#OP" + port + "_v4").val() + '"';
  jsonStr += ' }';
  //console.log("LE880.js jsonP(" + port + "): " + jsonStr);
  $("#json" + port).html(jsonStr);
  return jsonStr;
} // jsonP(port)
function testPOST(port) {
  var url = $("#OP" + port + "_POST_URL").val();
  console.log("LE880.js testPOST(" + port + "), url: " + url);
  $("#OP" + port + "_testPOST").html("waiting for test, timestamp = " + ts1());
  var jsonObj = JSON.parse(jsonP(port));
  jsonObj.url = url;
  console.log("LE880.js testPOST(" + port + "), JSON.stringify(jsonObj): " + JSON.stringify(jsonObj));
  // authenticate here if desired
  $.ajax({
    url: "/testPOST",
    type: "POST",
    dataType: "json",
    data: jsonObj
  })
    .fail(function (e) {
      console.log(ts() + "testPOST(" + port + ") fail");
    })
    .done(function (data) {
      if (data.auth) {
        console.log(ts() + "testPOST(" + port + " JSON.stringify(data): " + JSON.stringify(data));
        var html = "The data below was sent from the browser to LE880 /testPOST.<br>";
        html += "The LE880 then sent the data to " + url + " via POST :<br><br>";
        html += JSON.stringify(data);
        $("#OP" + port + "_testPOST").html(html);
      } else {
        window.location.href = "/";
      }
    });
} // testPOST(port)
function testTCP(port) {
  var url = $("#OP" + port + "_TCP_URL").val();
  console.log("LE880.js testTCP(" + port + "), url: " + url);
  // $("#OP" + port + "_testTCP").html("waiting for test, timestamp = " + ts1());
  var jsonObj = { "url": url, "port": port }
  console.log("LE880.js testTCP(" + port + "), JSON.stringify(jsonObj): " + JSON.stringify(jsonObj));
  // authenticate here if desired
  $.ajax({
    url: "/testTCP",
    type: "POST",
    dataType: "json",
    data: jsonObj
  })
    .fail(function (e) {
      console.log(ts() + "testTCP(" + port + ") fail");
    })
    .done(function (data) {
      if (data.auth) {
        console.log(ts() + "testTCP(" + port + " JSON.stringify(data): " + JSON.stringify(data));
        var html = "The data below was sent from the browser to LE880 /testTCP.<br>";
        html += "The LE880 then sent the data to " + url + " via TCP :<br><br>";
        html += JSON.stringify(data);
        $("#OP" + port + "_testTCP").html(html);
      } else {
        window.location.href = "/";
      }
    });
} // testTCP(port)

function toggleLED(status) {
  var browserUA = null;
  browserUA = navigator.userAgent;
  var browserID = null;
  promiseBrowserID.then(function (result) {
    browserID = result;
    var jsonObj = { "toggleLED": status, "browserID": browserID, "browserUA": browserUA }
    $.ajax({
      url: "/toggleLED",
      type: "POST",
      dataType: "json",
      data: jsonObj
    })
      .fail(function (e) {
        console.log(ts() + "toggleLED() fail");
      })
      .done(function (data) {
        if (data.auth) {
          if (status == "off") {
            console.log(ts() + "toggleLED() JSON.stringify(data): " + JSON.stringify(data));
            var html = "The LED has been cleared!";
            $("#messageBar").html(html);
          } else if (status == "on") {
            console.log(ts() + "toggleLED() JSON.stringify(data): " + JSON.stringify(data));
            var html = "The LED has been enabled!";
            $("#messageBar").html(html);
          }
        } else {
          //window.location.href = "/";
        }
      });
  });
} // toggleLED(port)

function testPlayback(port) {
  var browserUA = null;
  browserUA = navigator.userAgent;
  var file = $("#OP" + port + "_playback_files").val();

  var volume = $("#OP" + port + "_playback_volume").val();
  console.log("LE880.js testPlayback(" + port + "), file: " + file + " volume: " + volume);
  var browserID = null;
  promiseBrowserID.then(function (result) {
    browserID = result;
    /*
    var url = $("#OP" + port + "_playback_test").val();
    console.log("LE880.js testTCP(" + port + "), url: " + url);
    // $("#OP" + port + "_testTCP").html("waiting for test, timestamp = " + ts1());
    var jsonObj = { "url": url, "port": port }
    console.log("LE880.js testTCP(" + port + "), JSON.stringify(jsonObj): " + JSON.stringify(jsonObj));
    */
    var jsonObj = { "port": port, "file": file, "volume": volume, "browserID": browserID, "browserUA": browserUA }
    // authenticate here if desired
    $.ajax({
      url: "/testPlayback",
      type: "POST",
      dataType: "json",
      data: jsonObj
    })
      .fail(function (e) {
        console.log(ts() + "testPlayback(" + port + ") fail");
      })
      .done(function (data) {
        if (data.auth) {
          console.log(ts() + "testPlayback(" + port + " JSON.stringify(data): " + JSON.stringify(data));
          var html = "The data below was sent from the browser to LE880 /testPlayback.<br>";
          //html += "The LE880 then sent the data to " + url + " via TCP :<br><br>";
          //html += JSON.stringify(data);
          //$("#OP" + port + "_testTCP").html(html);
        } else {
          //window.location.href = "/";
        }
      });
  });
} // testPlayback(port)
//
// outputSettings end
//
async function uploadPlaybackFile() {
  //creating form data object and append file into that form data
  let formData = new FormData();
  formData.append("file", fileupload.files[0]);
  //network request using POST method of fetch
  await fetch('uploadPlaybackFile', {
    method: "POST",
    body: formData
  });
  alert('You have successfully upload the file!');
}

function ajaxUserChangeSettings(content) {
  //console.log("LE880.js ajaxUserChangeSettings() start content: " + content);
  var browserUA = null;
  browserUA = navigator.userAgent;
  //console.log(ts()+"ajaxUserChangeSettings() browserUA: " + browserUA);
  var browserID = null;
  promiseBrowserID.then(function (result) {
    browserID = result;
    //console.log(ts()+"ajaxUserChangeSettings() browserID: " + browserID);
    if (content == "btn_half_duplex" ||
      content == "btn_full_duplex" ||
      content == "btn_intercom_dsp" ||
      content == "btn_intercom_echo" ||
      content == "btn_vms_echo" ||
      content == "btn_vms_half_duplex" ||
      content == "btn_vms_full_duplex") {
      var RTSPUsername = document.getElementById("RTSPUsername").value;
      console.log("LE880.js ajaxUserChangeSettings RTSPUsername: " + RTSPUsername);
      var RTSPPassword = document.getElementById("RTSPPassword").value;
      console.log("LE880.js ajaxUserChangeSettings RTSPPassword: " + RTSPPassword);
      var RTSPPort = document.getElementById("RTSPPort").value;
      console.log("LE880.js ajaxUserChangeSettings RTSPPort: " + RTSPPort);
      var OutgoingAudioURL = document.getElementById("OutgoingAudioURL").innerHTML;
      console.log("LE880.js ajaxUserChangeSettings OutgoingAudioURL : " + OutgoingAudioURL);
      if (content == "btn_half_duplex" || content == "btn_full_duplex") {
        if (content == "btn_half_duplex") {
          half_full_duplex_state = "half";
          document.getElementById("btn_half_duplex").style.backgroundColor = "green";
          document.getElementById("btn_full_duplex").style.backgroundColor = "lightblue";
          document.getElementById("btn_PTT").style.backgroundColor = "lightblue";
          document.getElementById("btn_PTT").disabled = false;
          //var PTTenable = "false"; // change state
        }
        else if (content == "btn_full_duplex") {
          half_full_duplex_state = "full";
          document.getElementById("btn_half_duplex").style.backgroundColor = "lightblue";
          document.getElementById("btn_full_duplex").style.backgroundColor = "green";
          document.getElementById("btn_PTT").style.backgroundColor = "gray";
          document.getElementById("btn_PTT").disabled = true;
          //var PTTenable = "true"; // change state
        }
        else {
          console.log(ts() + "ajaxUserChangeSettings() ERROR illegal half_full_duplex_state");
        }
      }
      else if (content == "btn_intercom_dsp") {
        if (document.getElementById("btn_intercom_dsp").style.backgroundColor == "green") {
          var dspState = "false"; // change state
          document.getElementById("btn_intercom_dsp").style.backgroundColor = "lightblue";
          document.getElementById("btn_intercom_dsp").innerHTML = "DSP Disabled";
        } else {
          var dspState = "true";
          document.getElementById("btn_intercom_dsp").style.backgroundColor = "green";
          document.getElementById("btn_intercom_dsp").innerHTML = "DSP Enabled";
        }
      }
      else if (content == "btn_intercom_echo") {
        if (document.getElementById("btn_intercom_echo").style.backgroundColor == "green") {
          var echoState = "false"; // change state
          document.getElementById("btn_intercom_echo").style.backgroundColor = "lightblue";
          document.getElementById("btn_intercom_echo").innerHTML = "Echo Cancel Disabled";
        } else {
          var echoState = "true";
          document.getElementById("btn_intercom_echo").style.backgroundColor = "green";
          document.getElementById("btn_intercom_echo").innerHTML = "Echo Cancel Enabled";
        }
      }
      else if (content == "btn_vms_echo") {
        if (document.getElementById("btn_vms_echo").style.backgroundColor == "green") {
          var echoState = "false"; // change state
          document.getElementById("btn_vms_echo").style.backgroundColor = "lightblue";
          document.getElementById("btn_vms_echo").innerHTML = "DSP Disabled";
        } else {
          var echoState = "true";
          document.getElementById("btn_vms_echo").style.backgroundColor = "green";
          document.getElementById("btn_vms_echo").innerHTML = "DSP Enabled";
        }
      }

      else if (content == "btn_vms_half_duplex" || content == "btn_vms_full_duplex") {
        if (content == "btn_vms_half_duplex") {
          vms_half_full_duplex_state = "half";
          document.getElementById("btn_vms_half_duplex").style.backgroundColor = "green";
          document.getElementById("btn_vms_full_duplex").style.backgroundColor = "lightblue";
          document.getElementById("btn_vms_PTT").style.backgroundColor = "lightblue";
          document.getElementById("btn_vms_PTT").disabled = false;
        }
        else if (content == "btn_vms_full_duplex") {
          vms_half_full_duplex_state = "full";
          document.getElementById("btn_vms_half_duplex").style.backgroundColor = "lightblue";
          document.getElementById("btn_vms_full_duplex").style.backgroundColor = "green";
          document.getElementById("btn_vms_PTT").style.backgroundColor = "gray";
          document.getElementById("btn_vms_PTT").disabled = true;
        }
        else {
          console.log(ts() + "ajaxUserChangeSettings() ERROR illegal vms_half_full_duplex_state");
        }
      }
      else {
        console.error(ts() + "ajaxUserChangeSettings() ERROR btn_intercom_echo btn_vms_echo");
        return;
      }
      var jsonObj = {
        "content": content,
        "RTSPUsername": RTSPUsername,
        "RTSPPassword": RTSPPassword,
        "RTSPPort": RTSPPort,
        "OutgoingAudioURL": OutgoingAudioURL,
        "half_full_duplex_state": half_full_duplex_state,
        "vms_half_full_duplex_state": vms_half_full_duplex_state,
        "dspState": dspState,
        "echoState": echoState,
        "browserID": browserID,
        "browserUA": browserUA
      };
      //console.log("LE880.js ajaxUserChangeSettings JSON.stringify(jsonObj) : " + JSON.stringify(jsonObj));
      $.ajax({
        url: "/UserChangeSettings",
        type: "POST",
        dataType: "json",
        data: jsonObj
      })
        .fail(function (e) {
          console.log("ERROR LE880.js ajaxUserChangeSettings e:" + e);
        })
        .done(function (data) {
          console.log("LE880.js ajaxUserChangeSettings done JSON.stringify(data): " + JSON.stringify(data));
          if (data.auth) {
            // do nothing
          } else { // if(data.auth)
            window.location.href = "/";
          }
        }); // .done(function(data)
    } // if(content == "btn_PTTenable" || content == "btn_intercom_echo" || content == "btn_vms_echo")
    if (content == "onvif") {
      //
      // audio update LE880userConfig.json
      //
      var DeviceType = document.getElementById("DeviceType").value;
      console.log("LE880.js ajaxUserChangeSettings DeviceType: " + DeviceType);
      let obj = { "target": "playback", "action": DeviceType };
      showHidewithObject(obj);
      var DeviceLocation = document.getElementById("DeviceLocation").value;
      console.log("LE880.js ajaxUserChangeSettings DeviceLocation: " + DeviceLocation);
      var VMSConfiguration = document.getElementById("VMSConfiguration").value;
      console.log("LE880.js ajaxUserChangeSettings VMSConfiguration: " + VMSConfiguration);
      var RTSPUsername = document.getElementById("RTSPUsername").value;
      console.log("LE880.js ajaxUserChangeSettings RTSPUsername: " + RTSPUsername);
      var RTSPPassword = document.getElementById("RTSPPassword").value;
      console.log("LE880.js ajaxUserChangeSettings RTSPPassword: " + RTSPPassword);
      var RTSPPort = document.getElementById("RTSPPort").value;
      console.log("LE880.js ajaxUserChangeSettings RTSPPort: " + RTSPPort);
      var OutgoingAudioURL = document.getElementById("OutgoingAudioURL").innerHTML;
      console.log("LE880.js ajaxUserChangeSettings OutgoingAudioURL : " + OutgoingAudioURL);
      //var IncomingAudioURL = document.getElementById("IncomingAudioURL").value;
      //console.log("LE880.js ajaxUserChangeSettings IncomingAudioURL : " + IncomingAudioURL);
      var OutgoingUDPMulticastIP = document.getElementById("OutgoingUDPMulticastIP").value;
      console.log("LE880.js ajaxUserChangeSettings OutgoingUDPMulticastIP : " + OutgoingUDPMulticastIP);
      var OutgoingUDPMulticastPort = document.getElementById("OutgoingUDPMulticastPort").value;
      console.log("LE880.js ajaxUserChangeSettings OutgoingUDPMulticastPort : " + OutgoingUDPMulticastPort);
      var LowPassFilter_checked = ($('#LowPassFilter_checked').prop("checked") == true) ? "enabled" : "disabled";
      //var LowPassFilter_checked = document.getElementById("LowPassFilter_checked").value;
      console.log("LE880.js ajaxUserChangeSettings LowPassFilter_checked : " + LowPassFilter_checked);
      var LowPassFilter = document.getElementById("LowPassFilter").value;
      console.log("LE880.js ajaxUserChangeSettings LowPassFilter : " + LowPassFilter);
      var HighPassFilter_checked = ($('#HighPassFilter_checked').prop("checked") == true) ? "enabled" : "disabled";
      //var HighPassFilter_checked = document.getElementById("HighPassFilter_checked").value;
      console.log("LE880.js ajaxUserChangeSettings HighPassFilter_checked : " + HighPassFilter_checked);
      var HighPassFilter = document.getElementById("HighPassFilter").value;
      console.log("LE880.js ajaxUserChangeSettings HighPassFilter : " + HighPassFilter);
      var jsonObj = {
        "content": content,
        "DeviceType": DeviceType,
        "DeviceLocation": DeviceLocation,
        "VMSConfiguration": VMSConfiguration,
        "RTSPUsername": RTSPUsername,
        "RTSPPassword": RTSPPassword,
        "RTSPPort": RTSPPort,
        "OutgoingAudioURL": OutgoingAudioURL,
        //"IncomingAudioURL": IncomingAudioURL,
        "OutgoingUDPMulticastIP": OutgoingUDPMulticastIP,
        "OutgoingUDPMulticastPort": OutgoingUDPMulticastPort,
        "LowPassFilter_checked": LowPassFilter_checked,
        "LowPassFilter": LowPassFilter,
        "HighPassFilter_checked": HighPassFilter_checked,
        "HighPassFilter": HighPassFilter,
        "browserID": browserID,
        "browserUA": browserUA
      };
      console.log("LE880.js ajaxUserChangeSettings JSON.stringify(jsonObj) : " + JSON.stringify(jsonObj));
      $.ajax({
        url: "/UserChangeSettings",
        type: "POST",
        dataType: "json",
        data: jsonObj
      })
        .fail(function (e) {
          console.log("ERROR LE880.js ajaxUserChangeSettings e:" + e);
        })
        .done(function (data) {
          //console.log("LE880.js ajaxUserChangeSettings done JSON.stringify(data): " + JSON.stringify(data));
          if (data.auth) {
            //alert("Please reboot the device for all optimizations to take effect.")
            if (data.errorMsg) {
              var pageMsg = document.getElementById("OutgoingAudioURL").innerHTML;
              if (pageMsg.includes(data.errorMsg) === false) {
                document.getElementById("OutgoingAudioURL").innerHTML += "<br>" + data.errorMsg;
              }
              /*
              //
              // update messageBar
              //
              
              var html  = data.errorMsg;
              document.getElementById("messageBar").style.display = "block";
              document.getElementById("messageBar").innerHTML     = html;
              */
              //return;
            }
            document.getElementById("OutgoingAudioURL").innerHTML = data.OutgoingAudioURL;
            //document.getElementById("IncomingAudioURL").value = data.IncomingAudioURL;
            document.getElementById("OutgoingUDPMulticastIP").value = data.OutgoingUDPMulticastIP;
            document.getElementById("OutgoingUDPMulticastPort").value = data.OutgoingUDPMulticastPort;
            //
            // update messageBar
            //
            var html = "";
            //html     += "Audio Settings: Encoder = " + AudioOptionsMedia2EncoderChecked;
            //html += "Streaming Container = " + AudioOptionsStreamingContainerChecked;
            html += "<br/>Outgoing Stream URL = " + data.OutgoingAudioURL;
            //html     += "<br/>Outgoing Audio Stream = " + data.IncludeVideoOnvifChecked;
            //html += "<br/>Incoming Stream URL = " + data.IncomingAudioURL;
            html += "<br/>Send UDP Multicast IP = " + data.OutgoingUDPMulticastIP;
            html += "<br/>Send UDP Multicast Port = " + data.OutgoingUDPMulticastPort;
            document.getElementById("messageBar").style.display = "block";
            document.getElementById("messageBar").innerHTML = html;
            setTimeout(function () {
              $("#messageBar").css("display", "inline-block");
              var msg = '<div class="msgDisplay">Updated Credentials.</div>';
              $("#messageBar").html(msg);
              setTimeout(function () {
                $("#messageBar").css("display", "none");
                $("#messageBar").html("");
                VMSsendOnOff();
              }, 2000);
            }, 2000);
            VMSsendOnOff();
          } else { // if(data.auth)
            window.location.href = "/";
          }
        }); // .done(function(data)
    } // if(content == "onvif")
    /*if (content == "audio") {
      //
      // AudioOptionsMedia2Encoder
      //
      var ee = document.querySelectorAll('input[name="AudioOptionsMedia2Encoder"]');
      var AudioOptionsMedia2EncoderChecked;
      for (const e of ee) {
        if (e.checked) {
          AudioOptionsMedia2EncoderChecked = e.value;
          break;
        }
      }
      //console.log("ajaxUserChangeSettings AudioOptionsMedia2EncoderChecked : " + AudioOptionsMedia2EncoderChecked);    
      //
      // AudioOptionsStreamingContainer
      //
      var ss = document.querySelectorAll('input[name="AudioOptionsStreamingContainer"]');
      var AudioOptionsStreamingContainerChecked;
      for (const s of ss) {
        if (s.checked) {
          AudioOptionsStreamingContainerChecked = s.value;
          break;
        }
      }
      //console.log("LE880.js ajaxUserChangeSettings AudioOptionsStreamingContainer : " + AudioOptionsStreamingContainerChecked);
      //
      // AudioOptionsStreamingContainer
      //
      var ss = document.querySelectorAll('input[name="IncludeVideoOnvif"]');
      var IncludeVideoOnvifChecked;
      for (const s of ss) {
        if (s.checked) {
          IncludeVideoOnvifChecked = s.value;
          break;
        }
      }
      //
      // audio update LE880userConfig.json
      //
      var DeviceType = document.getElementById("DeviceType").value;
      console.log("LE880.js ajaxUserChangeSettings DeviceType: " + DeviceType);
      let obj = { "target": "playback", "action": DeviceType };
      showHidewithObject(obj);



      var VMSConfiguration = document.getElementById("VMSConfiguration").value;
      console.log("LE880.js ajaxUserChangeSettings VMSConfiguration: " + VMSConfiguration);
      var RTSPUsername = document.getElementById("RTSPUsername").value;
      console.log("LE880.js ajaxUserChangeSettings RTSPUsername: " + RTSPUsername);
      var RTSPPassword = document.getElementById("RTSPPassword").value;
      console.log("LE880.js ajaxUserChangeSettings RTSPPassword: " + RTSPPassword);
      var RTSPPort = document.getElementById("RTSPPort").value;
      console.log("LE880.js ajaxUserChangeSettings RTSPPort: " + RTSPPort);
      var OutgoingAudioURL = document.getElementById("OutgoingAudioURL").innerHTML;
      console.log("LE880.js ajaxUserChangeSettings OutgoingAudioURL : " + OutgoingAudioURL);
      var IncomingAudioURL = document.getElementById("IncomingAudioURL").value;
      console.log("LE880.js ajaxUserChangeSettings IncomingAudioURL : " + IncomingAudioURL);
      var OutgoingUDPMulticastIP = document.getElementById("OutgoingUDPMulticastIP").value;
      console.log("LE880.js ajaxUserChangeSettings OutgoingUDPMulticastIP : " + OutgoingUDPMulticastIP);
      var OutgoingUDPMulticastPort = document.getElementById("OutgoingUDPMulticastPort").value;
      console.log("LE880.js ajaxUserChangeSettings OutgoingUDPMulticastPort : " + OutgoingUDPMulticastPort);
      var jsonObj = {
        "content": content,
        "AudioOptionsMedia2Encoder": AudioOptionsMedia2EncoderChecked,
        "AudioOptionsStreamingContainer": AudioOptionsStreamingContainerChecked,
        "IncludeVideoOnvif": IncludeVideoOnvifChecked,
        "DeviceType": DeviceType,
        "VMSConfiguration": VMSConfiguration,
        "RTSPUsername": RTSPUsername,
        "RTSPPassword": RTSPPassword,
        "RTSPPort": RTSPPort,
        "OutgoingAudioURL": OutgoingAudioURL,
        "IncomingAudioURL": IncomingAudioURL,
        "OutgoingUDPMulticastIP": OutgoingUDPMulticastIP,
        "OutgoingUDPMulticastPort": OutgoingUDPMulticastPort,
        "browserID": browserID,
        "browserUA": browserUA
      };
      console.log("LE880.js ajaxUserChangeSettings JSON.stringify(jsonObj) : " + JSON.stringify(jsonObj));
      $.ajax({
        url: "/UserChangeSettings",
        type: "POST",
        dataType: "json",
        data: jsonObj
      })
        .fail(function (e) {
          console.log("ERROR LE880.js ajaxUserChangeSettings e:" + e);
        })
        .done(function (data) {
          //console.log("LE880.js ajaxUserChangeSettings done JSON.stringify(data): " + JSON.stringify(data));
          if (data.auth) {
            //alert("Please reboot the device for all optimizations to take effect.")
            if (data.errorMsg) {
              var pageMsg = document.getElementById("OutgoingAudioURL").innerHTML;
              if (pageMsg.includes(data.errorMsg) === false) {
                document.getElementById("OutgoingAudioURL").innerHTML += "<br>" + data.errorMsg;
              }
              //return;
            }
            document.getElementById("OutgoingAudioURL").innerHTML = data.OutgoingAudioURL;
            document.getElementById("IncomingAudioURL").value = data.IncomingAudioURL;
            document.getElementById("OutgoingUDPMulticastIP").value = data.OutgoingUDPMulticastIP;
            document.getElementById("OutgoingUDPMulticastPort").value = data.OutgoingUDPMulticastPort;

            //
            // update messageBar
            //
            var html = "";
            //html     += "Audio Settings: Encoder = " + AudioOptionsMedia2EncoderChecked;
            html += "Streaming Container = " + AudioOptionsStreamingContainerChecked;
            html += "<br/>Outgoing Stream URL = " + data.OutgoingAudioURL;
            //html     += "<br/>Outgoing Audio Stream = " + data.IncludeVideoOnvifChecked;
            html += "<br/>Incoming Stream URL = " + data.IncomingAudioURL;
            html += "<br/>Send UDP Multicast IP = " + data.OutgoingUDPMulticastIP;
            html += "<br/>Send UDP Multicast Port = " + data.OutgoingUDPMulticastPort;
            document.getElementById("messageBar").style.display = "block";
            document.getElementById("messageBar").innerHTML = html;

            setTimeout(function () {
              $("#messageBar").css("display", "inline-block");
              var msg = '<div class="msgDisplay">Updated Credentials.</div>';
              $("#messageBar").html(msg);
              setTimeout(function () {
                $("#messageBar").css("display", "none");
                $("#messageBar").html("");
                VMSsendOnOff();
              }, 2000);
            }, 2000);
            VMSsendOnOff();


          } else { // if(data.auth)
            window.location.href = "/";
          }
        }); // .done(function(data)
    } // if(content == "audio")*/
    //
    // Hostname
    //
    if (content == "hostname") {
      //console.log(ts()+content+"_deb checked = " + deb_checked);	
      var jsonObj = {
        "content": content,
        "browserID": browserID,
        "browserUA": browserUA
      };
      //console.log("LE880.js ajaxUserChangeSettings JSON.stringify(jsonObj) : " + JSON.stringify(jsonObj));
      $.ajax({
        url: "/UserChangeSettings",
        type: "POST",
        dataType: "json",
        data: jsonObj
      })
        .fail(function (e) {
          console.log("ERROR LE880.js ajaxUserChangeSettings e:" + e);
        })
        .done(function (data) {
          //console.log( "LE880.js ajaxUserChangeSettings done JSON.stringify(data): " + JSON.stringify(data));
          if (data.auth) {
            //no action
          } else { // if(data.auth)
            window.location.href = "/";
          }
        }); // .done(function(data)
    } // InputPort
    //
    // Input Ports
    //
    if (content.substr(0, 2) == "IP") {
      console.log("LE880.js ajaxUserChangeSettings Input Port content : " + content);
      var RTSPUsername = document.getElementById("RTSPUsername").value;
      console.log("LE880.js ajaxUserChangeSettings RTSPUsername: " + RTSPUsername);
      var RTSPPassword = document.getElementById("RTSPPassword").value;
      console.log("LE880.js ajaxUserChangeSettings RTSPPassword: " + RTSPPassword);
      var RTSPPort = document.getElementById("RTSPPort").value;
      console.log("LE880.js ajaxUserChangeSettings RTSPPort: " + RTSPPort);
      var pu = document.querySelectorAll('input[name="' + content + '_pupd"]');
      for (const s of pu) {
        if (s.checked) {
          var pupd_checked = s.value;
          break;
        }
      }
      //console.log(ts()+content+"_pupd checked = " + pupd_checked);
      var deb = document.querySelectorAll('input[name="' + content + '_deb"]');
      for (const t of deb) {
        if (t.checked) {
          var deb_checked = t.value;
          break;
        }
      }
      //console.log(ts()+content+"_deb checked = " + deb_checked);	
      var jsonObj = {
        "content": content,
        "RTSPUsername": RTSPUsername,
        "RTSPPassword": RTSPPassword,
        "RTSPPort": RTSPPort,
        "pupd_checked": pupd_checked,
        "deb_checked": deb_checked,
        "browserID": browserID,
        "browserUA": browserUA
      };
      //console.log("LE880.js ajaxUserChangeSettings JSON.stringify(jsonObj) : " + JSON.stringify(jsonObj));
      $.ajax({
        url: "/UserChangeSettings",
        type: "POST",
        dataType: "json",
        data: jsonObj
      })
        .fail(function (e) {
          console.log("ERROR LE880.js ajaxUserChangeSettings e:" + e);
        })
        .done(function (data) {
          //console.log( "LE880.js ajaxUserChangeSettings done JSON.stringify(data): " + JSON.stringify(data));
          if (data.auth) {
            //no action
          } else { // if(data.auth)
            window.location.href = "/";
          }
        }); // .done(function(data)
    } // InputPort
    //
    // Output Ports
    //
    if (content.substr(0, 2) == "OP") {
      //console.log("LE880.js ajaxUserChangeSettings Output Port content : " + content);
      //var tr = document.querySelectorAll('input[name="' + content + '_trig"]');
      console.log(content + '_trig');
      var trig_checked = $('#' + content + '_trig').val();
      console.log(trig_checked);
      var dest_checked = $('#' + content + '_dest').val();
      console.log(dest_checked);
      //for (const a of tr) {
      //  if (a.checked) {
      //    var trig_checked = a.value;
      //    break;
      //  }
      //}
      //console.log(ts()+content+"_trig checked = " + trig_checked);
      var RTSPUsername = document.getElementById("RTSPUsername").value;
      console.log("LE880.js ajaxUserChangeSettings RTSPUsername: " + RTSPUsername);
      var RTSPPassword = document.getElementById("RTSPPassword").value;
      console.log("LE880.js ajaxUserChangeSettings RTSPPassword: " + RTSPPassword);
      var RTSPPort = document.getElementById("RTSPPort").value;
      console.log("LE880.js ajaxUserChangeSettings RTSPPort: " + RTSPPort);
      var mic_alertLevel0 = document.getElementById(content + '_mic_alertLevel0').innerText.trim();
      var mic_alertLevel1 = document.getElementById(content + '_mic_alertLevel1').innerText.trim();
      var mic_alertLevel2 = document.getElementById(content + '_mic_alertLevel2').innerText.trim();
      //var active_checked = $('#' + content + '_active').val();
      //
      //var active_checked = $('#' + content + '_active').val();
      //console.log(content);
      var active_checked = ($('#' + content + '_active').prop("checked") == true) ? "enabled" : "disabled";
      /*var active = document.querySelectorAll('input[name="' + content + '_active"]');
      for (const b of active) {
        if (b.checked) {
          var active_checked = b.value;
          break;
        }
      }*/
      //var OL = document.querySelectorAll('input[name="' + content + '_OL"]');
      //for (const b of OL) {
      //  if (b.checked) {
      //    var OL_checked = b.value;
      //    break;
      //  }
      //}
      //console.log(ts()+content+"_OL checked = " + OL_checked);		
      var Duration = document.getElementById(content + '_Duration').value;
      var spl_level = $('#' + content + '_spl_level').val();
      //console.log(ts()+content+"_Duration  = " + Duration);		
      //
      // recording
      //
      var recording_checked = ($('#' + content + '_recording').prop("checked") == true) ? "enabled" : "disabled";
      //var recording_checked = $('#' + content + '_recording').val();
      /*var recording = document.querySelectorAll('input[name="' + content + '_recording"]');
      for (const c of recording) {
        if (c.checked) {
          var recording_checked = c.value;
          break;
        }
      }*/
      //console.log(ts()+content+"_recording checked = " + recording_checked);	
      var recording_duration_before = document.getElementById(content + '_recording_duration_before').value;
      //console.log(ts()+content+"_recording_duration_before  = " + recording_duration_before);		
      var recording_duration_after = document.getElementById(content + '_recording_duration_after').value;
      //console.log(ts()+content+"_recording_duration_after  = " + recording_duration_after);
      //
      // HTTP POST
      //
      var HTTPS_checked = $('#' + content + '_HTTPS').val();
      //var HTTPS = document.querySelectorAll('input[name="' + content + '_HTTPS"]');
      //for (const c of HTTPS) {
      //  if (c.checked) {
      //    var HTTPS_checked = c.value;
      //    break;
      //  }
      //}
      //console.log(ts()+content+"_HTTPS checked = " + HTTPS_checked);		
      var POST_URL = document.getElementById(content + '_POST_URL').value;
      //console.log(ts()+content+"_POST_URL  = " + POST_URL);	
      var k1 = document.getElementById(content + '_k1').value;
      //console.log(ts()+content+"_k1  = " + k1);	
      var v1 = document.getElementById(content + '_v1').value;
      //console.log(ts()+content+"_v1  = " + v1);
      var k2 = document.getElementById(content + '_k2').value;
      //console.log(ts()+content+"_k2  = " + k2);	
      var v2 = document.getElementById(content + '_v2').value;
      //console.log(ts()+content+"_v2  = " + v2);
      var k3 = document.getElementById(content + '_k3').value;
      //console.log(ts()+content+"_k3  = " + k3);	
      var v3 = document.getElementById(content + '_v3').value;
      //console.log(ts()+content+"_v3  = " + v3);
      var k4 = document.getElementById(content + '_k4').value;
      //console.log(ts()+content+"_k4  = " + k4);	
      var v4 = document.getElementById(content + '_v4').value;
      //console.log(ts()+content+"_v4  = " + v4);
      var TCP_URL = document.getElementById(content + '_TCP_URL').value;
      //console.log(ts()+content+"_POST_URL  = " + POST_URL);	
      var tcp1 = document.getElementById(content + '_tcp1').value;
      //console.log(ts()+content+"_k1  = " + k1);	
      var tcp2 = document.getElementById(content + '_tcp2').value;
      //console.log(ts()+content+"_v1  = " + v1);

      //var playback_checked = $('#' + content + '_playback').val();
      var playback_checked = ($('#' + content + '_playback').prop("checked") == true) ? "enabled" : "disabled";
      //var playback_files = document.querySelectorAll('input[name="' + content + '_playback_files"]');
      var playback_file = $('#' + content + '_playback_files').val();
      var playback_volume = $('#' + content + '_playback_volume').val();
      console.log("SPL LEVEL: " + spl_level);
      if (trig_checked == "Explosion&Acoustics"){
        alert("If Explosion&Acoustics wasn't selected at startup this setting will require reboot. If you decide to remove this setting you will have to also reboot for the analytics to run properly.");
      }
      //for (const c of playback_files) {
      //  if (c.checked) {
      //    var playback_file = c.value;
      //    break;
      //  }
      //}
      var jsonObj = {
        "content": content,
        "RTSPUsername": RTSPUsername,
        "RTSPPassword": RTSPPassword,
        "RTSPPort": RTSPPort,
        "trig_checked": trig_checked,
        "dest_checked": dest_checked,
        "active_checked": active_checked,
        "mic_alertLevel0": mic_alertLevel0,
        "mic_alertLevel1": mic_alertLevel1,
        "mic_alertLevel2": mic_alertLevel2,
        "Duration": Duration,
        "spl_level": spl_level,
        "recording_checked": recording_checked,
        "recording_duration_before": recording_duration_before,
        "recording_duration_after": recording_duration_after,
        "HTTPS_checked": HTTPS_checked,
        "POST_URL": POST_URL,
        "k1": k1,
        "v1": v1,
        "k2": k2,
        "v2": v2,
        "k3": k3,
        "v3": v3,
        "k4": k4,
        "v4": v4,
        "TCP_URL": TCP_URL,
        "tcp1": tcp1,
        "tcp2": tcp2,
        "playback_checked": playback_checked,
        "playback_file": playback_file,
        "playback_volume": playback_volume,
        "browserID": browserID,
        "browserUA": browserUA
      };
      console.log("LE880.js ajaxUserChangeSettings JSON.stringify(jsonObj) : " + JSON.stringify(jsonObj));
      $.ajax({
        url: "/UserChangeSettings",
        type: "POST",
        dataType: "json",
        data: jsonObj
      })
        .fail(function (e) {
          console.log("ERROR LE880.js ajaxUserChangeSettings e:" + e);
        })
        .done(function (data) {
          //console.log( "LE880.js ajaxUserChangeSettings done JSON.stringify(data): " + JSON.stringify(data));
          if (data.auth) {
            //no action
          } else { // if(data.auth)
            window.location.href = "/";
          }
        }); // .done(function(data)      
    } // OutputPort
    //
    // SIP
    //
    if (content == "SIP") {
      //console.log("LE880.js ajaxUserChangeSettings SIP content : " + content);
      //var tr = document.querySelectorAll('input[name="' + content + '_trig"]');
      var sip_checked = ($('#SIP_checked').prop("checked") == true) ? "enabled" : "disabled";
      var sip_ip = $('#sip_ip').val();
      var sip_user = $('#sip_user').val();
      var sip_pw = $('#sip_pw').val();
      var sip_cp = $('#sip_cp').val();
      var sip_rtp_start = $('#sip_rtp_start').val();
      var sip_rtp_end = $('#sip_rtp_end').val();
      console.log(`Status: ${sip_checked} IP: ${sip_ip} PW: ${sip_pw} CP: ${sip_cp} RTP Start ${sip_rtp_start} RTP End ${sip_rtp_end}`);
      var jsonObj = {
        "content": content,
        "RTSPUsername": RTSPUsername,
        "RTSPPassword": RTSPPassword,
        "RTSPPort": RTSPPort,
        "OutgoingAudioURL": OutgoingAudioURL,
        "sip_checked": sip_checked,
        "sip_ip": sip_ip,
        "sip_user": sip_user,
        "sip_pw": sip_pw,
        "sip_cp": sip_cp,
        "sip_rtp_start": sip_rtp_start,
        "sip_rtp_end": sip_rtp_end,
        "browserID": browserID,
        "browserUA": browserUA
      };
      console.log("LE880.js ajaxUserChangeSettings JSON.stringify(jsonObj) : " + JSON.stringify(jsonObj));
      $.ajax({
        url: "/UserChangeSettings",
        type: "POST",
        dataType: "json",
        data: jsonObj
      })
        .fail(function (e) {
          console.log("ERROR LE880.js ajaxUserChangeSettings e:" + e);
        })
        .done(function (data) {
          //console.log( "LE880.js ajaxUserChangeSettings done JSON.stringify(data): " + JSON.stringify(data));
          if (data.auth) {
            //no action
          } else { // if(data.auth)
            window.location.href = "/";
          }
        }); // .done(function(data)      
    } // SIP
    if (content == "ActiveHigh") {
      var jsonObj = {
        "content": content,
        "browserID": browserID,
        "browserUA": browserUA
      };
      for (let i = 0; i <= 4; i++) {
        if (i == 0) { var active_checked = ($('#OPLED_OL_checked').prop("checked") == true) ? "high" : "low"; }
        else {
          var active_checked = ($('#OP' + i + '_OL_checked').prop("checked") == true) ? "high" : "low";
        }
        jsonObj['OP' + i + '_OL_checked'] = active_checked;
      }
      console.log("LE880.js ajaxUserChangeSettings JSON.stringify(jsonObj) : " + JSON.stringify(jsonObj));
      $.ajax({
        url: "/UserChangeSettings",
        type: "POST",
        dataType: "json",
        data: jsonObj
      })
        .fail(function (e) {
          console.log("ERROR LE880.js ajaxUserChangeSettings e:" + e);
        })
        .done(function (data) {
          //console.log( "LE880.js ajaxUserChangeSettings done JSON.stringify(data): " + JSON.stringify(data));
          if (data.auth) {
            //no action
          } else { // if(data.auth)
            //window.location.href = "/";
          }
        }); // .done(function(data)      
    } // ActiveHigh
  });// promiseBrowserID.then
} // ajaxUserChangeSettings
function VMSloopback() {
  console.log(ts() + "VMSloopback()");
  //var VMSloopbackURL = "not yet defined";
  document.getElementById("IncomingAudioURL").value = VMSloopbackURL;
  ajaxUserChangeSettings("audio");
} // VMSloopback()

//
// LE880wssServerMicAlert_conn
//
if (LE880wssServerMicAlerton) {
  var LE880wssServerMicAlert_conn = null;
  var LE880wssServerMicAlert_connect_attempts = 0 * 1;
  var LE880wssServerMicAlert_server = null;
  var LE880wssServerMicAlert_port = "8445";
  var LE880wssServerMicAlert_peer_id = "880";
  var serverRegistered = false;
  function on_LE880wssServerMicAlert_error(event) {
    console.log(ts() + "on_LE880wssServerMicAlert_error(): " + JSON.stringify(event));
  }
  function on_LE880wssServerMicAlert_message(event) {
    //console.log(ts()+"on_LE880wssServerMicAlert_message(event) unprocessed JSON.stringify(event.data): " + JSON.stringify(event.data));
    //console.dir(event);
    //if(serverRegistered == false && event.data == "LE880wssServerMicAlert acknowledge, JSON now required"){

    if (event.data == "LE880wssServerMicAlert acknowledge, JSON now required") {
      console.log(ts() + "on_LE880wssServerMicAlert_message(event): Registered with server, ready for data");
      //LE880wssServerMicAlert_conn.send(event.data);
      serverRegistered = true;
      return;
    }
    if (!serverRegistered) { return; }
    //
    // after registration we will require JSON
    //
    //console.log(ts()+"on_LE880wssServerMicAlert_message(event) event.data: " + JSON.stringify(event.data));
    //console.log(ts()+"on_LE880wssServerMicAlert_message(event) JSON.stringify(event.data).replace(/\\/g,''): " + JSON.stringify(event.data).replace(/\\/g,''));
    //console.log(ts()+"on_LE880wssServerMicAlert_message(event) event.data.length: " + event.data.length);
    try {
      var jsonObj = JSON.parse(event.data);
    } catch (e) {
      console.error(ts() + e.name + ' for event.data: ' + event.data);
      return;
    }
    if (jsonObj.LE880wssServerMicAlert) {
      //LE880wssServerMicAlert_conn.send( '{"ackBrowser" : ' + ts() + event.data + ' }' );
      //LE880wssServerMicAlert_conn.send( '{"ackBrowser" : "' + ts1() + '" }' );
      return;
    }
    if (jsonObj.audioStream) {
      //LE880wssServerMicAlert_conn.send( '{"ackBrowser" : "' + event.data + '" }' );
      return;
    }
    if (jsonObj.spectrogram) {
      //console.log(ts()+"on_LE880wssServerMicAlert_message(event) alertPORT: " + alertPORT);
      //LE880wssServerMicAlert_conn.send( '{"ackBrowser" : ' + event.data + ' }');
      //LE880wssServerMicAlert_conn.send( '{"ackBrowser" : "spectrogram at ' + ts1() + '"}');
      var arr = jsonObj.spectrogram;
      //document.getElementById(alertPORT + "_mic_data").innerHTML = JSON.stringify(event.data).replace(/\\/g,'');
      var canvas = document.getElementById(alertPORT + "_mic_canvas");
      var canvasCtx = canvas.getContext("2d");
      canvas.setAttribute('height', "200px");
      canvas.setAttribute('width', "300px");
      var WIDTH = canvas.width;
      var HEIGHT = canvas.height;
      canvasCtx.clearRect(0, 0, WIDTH, HEIGHT);
      var xLabel = document.getElementById(alertPORT + "_mic_x_label");
      var html = "<div class='alertSetx'>" + (arr[0].magnitude * 1).toLocaleString('en-US', { maximumFractionDigits: 0 }) + " dB";
      html += "<br>" + (arr[0].freq * 1).toLocaleString('en-US', { maximumFractionDigits: 0 }) + " Hz</div>";
      html += "<div class='alertSetx'>" + (arr[1].magnitude * 1).toLocaleString('en-US', { maximumFractionDigits: 0 }) + " dB";
      html += "<br>" + (arr[1].freq * 1).toLocaleString('en-US', { maximumFractionDigits: 0 }) + " Hz</div>";
      html += "<div class='alertSetx'>" + (arr[2].magnitude * 1).toLocaleString('en-US', { maximumFractionDigits: 0 }) + " dB";
      html += "<br>" + (arr[2].freq * 1).toLocaleString('en-US', { maximumFractionDigits: 0 }) + " Hz</div>";
      html += "<div class='clearBoth'></div>";
      xLabel.innerHTML = html;
      var yLabelTop = document.getElementById(alertPORT + "_mic_y_label_top");
      yLabelTop.innerHTML = "100 dB";
      var yLabelBottom = document.getElementById(alertPORT + "_mic_y_label_bottom");
      yLabelBottom.innerHTML = "0 dB";
      var drawAlt = function () {
        canvasCtx.fillStyle = 'rgb(0, 0, 0)'; // black
        canvasCtx.fillRect(0, 0, WIDTH, HEIGHT);
        var alertBar = 4;
        var alertLevel0 = document.getElementById(alertPORT + "_mic_alertLevel0").innerHTML * 1;
        var alertLevel1 = document.getElementById(alertPORT + "_mic_alertLevel1").innerHTML * 1;
        var alertLevel2 = document.getElementById(alertPORT + "_mic_alertLevel2").innerHTML * 1;
        //
        // freq bands
        //
        var barWidth = (WIDTH / arr.length) * 1;
        var barHeight = 0 * 1;
        var x = 0;
        for (var i = 0; i < arr.length; i++) {
          //console.log(ts()+"on_LE880wssServerMicAlert_message(event) arr[" + i + "].magnitude: " + arr[i].magnitude);
          barHeight = (arr[i].magnitude * 1) * 2;
          switch (i * 1) {
            case 0 * 1:
              //console.log(ts()+"1: " + i + ", arr[" + i + "].magnitude: " + arr[i].magnitude + ", alertLevel0: " + alertLevel0);
              if (arr[i].magnitude < alertLevel0) {
                canvasCtx.fillStyle = 'rgb(0, 255, 0)'; // green
                canvasCtx.fillRect(x, HEIGHT - barHeight, barWidth, barHeight);
              } else {
                canvasCtx.fillStyle = 'rgb(0, 255, 0)'; // green
                canvasCtx.fillRect(x, HEIGHT - (alertLevel0) * 2, barWidth, HEIGHT);
                canvasCtx.fillStyle = 'rgb(255, 255, 0)'; // yellow
                canvasCtx.fillRect(x, HEIGHT - barHeight, barWidth, barHeight - (alertLevel0) * 2);
              }
              x += barWidth + 2;
              break;
            case 1 * 1:
              if (arr[i].magnitude < alertLevel1) {
                canvasCtx.fillStyle = 'rgb(0, 255, 0)'; // green
                canvasCtx.fillRect(x, HEIGHT - barHeight, barWidth, barHeight);
              } else {
                canvasCtx.fillStyle = 'rgb(0, 255, 0)'; // green
                canvasCtx.fillRect(x, HEIGHT - (alertLevel1) * 2, barWidth, HEIGHT);
                canvasCtx.fillStyle = 'rgb(255, 255, 0)'; // yellow
                canvasCtx.fillRect(x, HEIGHT - barHeight, barWidth, barHeight - (alertLevel1) * 2);
              }
              x += barWidth + 2;
              break;
            case 2 * 1:
              if (arr[i].magnitude < alertLevel2) {
                canvasCtx.fillStyle = 'rgb(0, 255, 0)'; // green
                canvasCtx.fillRect(x, HEIGHT - barHeight, barWidth, barHeight);
              } else {
                canvasCtx.fillStyle = 'rgb(0, 255, 0)'; // green
                canvasCtx.fillRect(x, HEIGHT - (alertLevel2) * 2, barWidth, HEIGHT);
                canvasCtx.fillStyle = 'rgb(255, 255, 0)'; // yellow
                canvasCtx.fillRect(x, HEIGHT - barHeight, barWidth, barHeight - (alertLevel2) * 2);
              }
              x += barWidth + 2;
              break;
          }
        } // for
        canvasCtx.fillStyle = 'rgb(255, 0, 0)'; // red alert horiz line
        canvasCtx.fillRect(0, HEIGHT - (alertLevel0) * 2 - alertBar, WIDTH / 3, alertBar);
        canvasCtx.fillRect(1 * (WIDTH / 3) + 2, HEIGHT - (alertLevel1) * 2 - alertBar, WIDTH / 3, alertBar);
        canvasCtx.fillRect(2 * (WIDTH / 3) + 2, HEIGHT - (alertLevel2) * 2 - alertBar, WIDTH / 3, alertBar);
      }; // drawAlt
      drawAlt();
      return;
    }

  } // on_LE880wssServerMicAlert_message(event)
  function on_LE880wssServerMicAlert_close(event) {
    console.log(ts() + "on_LE880wssServerMicAlert_close(): " + JSON.stringify(event));
  }
  function LE880wssServerMicAlert_Connect() {
    LE880wssServerMicAlert_connect_attempts++;
    if (LE880wssServerMicAlert_connect_attempts > 3) {
      setError(ts() + "LE880wssServerMicAlertConnect() Too many connection attempts, aborting. Refresh page to try again");
      return;
    }
    if (window.location.protocol.startsWith("file")) {
      LE880wssServerMicAlert_server = LE880wssServerMicAlert_server || "127.0.0.1";
    } else if (window.location.protocol.startsWith("http")) {
      LE880wssServerMicAlert_server = LE880wssServerMicAlert_server || window.location.hostname;
    } else {
      throw new Error(ts() + "LE880wssServerMicAlert_Connect() Don't know how to connect to the signalling server with uri" + window.location);
    }
    var LE880wssServerMicAlert_url = 'wss://' + LE880wssServerMicAlert_server + ':' + LE880wssServerMicAlert_port + '/browser';
    //var LE880wssServerMicAlert_url = 'wss://' + LE880wssServerMicAlert_server + ':' + LE880wssServerMicAlert_port;
    console.log(ts() + "LE880wssServerMicAlertConnect(): Connecting to server " + LE880wssServerMicAlert_url);
    LE880wssServerMicAlert_conn = new WebSocket(LE880wssServerMicAlert_url);
    /* When connected, immediately contact the server */
    LE880wssServerMicAlert_conn.addEventListener('open', (event) => {
      //console.log(ts()+"LE880wssServerMicAlert_conn.addEventListener('open', (event): " + JSON.stringify(event));
      //LE880wssServerMicAlert_conn.send('HELLO ' + LE880wssServerMicAlert_peer_id);
      LE880wssServerMicAlert_conn.send('Hello from browser');
      //console.log(ts()+"wssConnect(): Registering with server, peer_id: " + LE880wssServerMicAlert_peer_id + ", port: " + LE880wssServerMicAlert_port);
    });
    LE880wssServerMicAlert_conn.addEventListener('error', on_LE880wssServerMicAlert_error);
    LE880wssServerMicAlert_conn.addEventListener('message', on_LE880wssServerMicAlert_message);
    LE880wssServerMicAlert_conn.addEventListener('close', on_LE880wssServerMicAlert_close);
  } // LE880wssServerMicAlert_Connect()
} // if(LE880wssServerMicAlerton)
function setAlert(alertPORT, band, upDn) {
  //document.getElementById("messageBar").style.display = "block";
  //document.getElementById("messageBar").innerHTML     = "setAlert alertPORT: " + alertPORT + ", band: " + band + ", upDn: " + upDn; 
  var level = document.getElementById(alertPORT + "_mic_alertLevel" + band).innerHTML * 1;
  if (upDn == "up" && level < 100) {
    level += 1;
    document.getElementById(alertPORT + "_mic_alertLevel" + band).innerHTML = level;
    return;
  } else if (upDn == "up" && level >= 100) {
    level = 100;
    document.getElementById(alertPORT + "_mic_alertLevel" + band).innerHTML = level;
    return;
  }
  if (upDn == "down" && level > 0) {
    level -= 1;
    document.getElementById(alertPORT + "_mic_alertLevel" + band).innerHTML = level;
    return;
  } else if (upDn == "down" && level >= 0) {
    level = 0;
    document.getElementById(alertPORT + "_mic_alertLevel" + band).innerHTML = level;
    return;
  }
} // setAlert(alertPORT, band, upDn)
var upReset = null;
var downReset = null;
function changeAlert(alertPORT, band, upDn, inOut) {
  //console.log(ts()+"changeAlert alertPORT: " + alertPORT + ", band: " + band + ", upDn: " + upDn + ", inOut: " + inOut);
  if (inOut == "out") {
    clearInterval(upReset);
    clearInterval(downReset);
    return;
  }
  var level = document.getElementById(alertPORT + "_mic_alertLevel" + band).innerHTML * 1;
  if (upDn == "up" && level < 100 && inOut == "in") {
    upReset = setInterval(function () {
      if (level < 100) {
        level += 1;
        document.getElementById(alertPORT + "_mic_alertLevel" + band).innerHTML = level;
      } else {
        clearInterval(upReset);
        return;
      }
    }, 100);
  }
  if (upDn == "down" && level > 0 && inOut == "in") {
    downReset = setInterval(function () {
      if (level > 0) {
        level -= 1;
        document.getElementById(alertPORT + "_mic_alertLevel" + band).innerHTML = level;
      } else {
        clearInterval(downReset);
        return;
      }
    }, 100);
  }
} // changeLevel(alertPORT, band, upDn)
