"use strict";
var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
const os_1 = require('os');
const child_process_1 = require('child_process');
const events_1 = require("events");
const stream_1 = require("stream");
const crypto = require("crypto");
const clc = require('cli-color');
const { exec, execSync } = require("child_process");
var Utils;

function ts() {
    return new Date().YYYYMMDDHHMMSSmmm() + " : ";
}

function ts1() {
    return new Date().YYYYMMDDHHMMSSmmm();
}


(function (Utils) {
    (function (logLevel) {
        logLevel[logLevel["None"] = 0] = "None";
        logLevel[logLevel["Error"] = 1] = "Error";
        logLevel[logLevel["Warn"] = 2] = "Warn";
        logLevel[logLevel["Info"] = 3] = "Info";
        logLevel[logLevel["Debug"] = 4] = "Debug";
        logLevel[logLevel["Detail"] = 5] = "Detail";
    })(Utils.logLevel || (Utils.logLevel = {}));
    var logLevel = Utils.logLevel;
    var DummyProcess = (function (_super) {
        __extends(DummyProcess, _super);
        function DummyProcess() {
            _super.call(this);
            this.stdin = new stream_1.Writable();
            this.stderr = this.stdout = new DummyReadable();
        }
        DummyProcess.prototype.kill = function (signal) { };
        ;
        DummyProcess.prototype.send = function (message, sendHandle) { };
        ;
        DummyProcess.prototype.disconnect = function () { };
        ;
        DummyProcess.prototype.unref = function () { };
        ;
        return DummyProcess;
    }(events_1.EventEmitter));
    var DummyReadable = (function (_super) {
        __extends(DummyReadable, _super);
        function DummyReadable() {
            _super.apply(this, arguments);
        }
        DummyReadable.prototype.read = function () { return null; };
        return DummyReadable;
    }(stream_1.Readable));

    var utils = (function () {
        function utils() {
        }

        utils.setConfig = function (config) {
            this.config = config;
        };

        utils.getSerial = function () {
            var cpuserial = "0000000000000000";
            try {
                var f = execSync('cat /proc/cpuinfo').toString();
                cpuserial = f.match(/Serial[\t]*: ([0-9a-f]{16})/)[1];
            }
            catch (ex) {
                this.log.error("Failed to read serial : %s", ex.message);
                cpuserial = "ERROR000000000";
            }
            return cpuserial;
        };
        utils.getMac = function () {
            var cpumac = "00:00:00:00:00:00";
            try {
                cpumac = execSync('cat /sys/class/net/eth0/address').toString().trim();
                cpumac = cpumac.split(':').join('-').trim();
            } catch (e) {
                this.log.error("Failed to read mac : %s", e.message);
            }
            //try {
            //    cpumac = utils.execSync('cat /sys/class/net/eth0/address').toString();
            //    //cpuserial = f.match(/Serial[\t]*: ([0-9a-f]{16})/)[1];
            //}
            //catch (ex) {
            //    this.log.error("Failed to read serial : %s", ex.message);
            //    cpuserial = "ERROR000000000";
            //}
            return cpumac;
        };

        utils.testIpAddress = function () {
            var ip, interfaces = os_1.networkInterfaces();
            for (var _i = 0, _a = this.config.NetworkAdapters; _i < _a.length; _i++) {
                var inf = _a[_i];
                ip = this.getAddress(interfaces[inf], "IPv4");
                if (!ip)
                    utils.log.debug(ts() + "utils.js utils.testIpAddress Read IP address from %s failed", inf);
                else {
                    utils.log.info(ts() + "utils.js utils.testIpAddress Read IP address %s from %s", ip, inf);
                    return;
                }
            }
            utils.log.info(ts() + "utils.js Using IP address from config: %s", this.config.IpAddress);
        };
        utils.getIpAddress = function (type) {
            type = type || "IPv4";
            var interfaces = os_1.networkInterfaces();
            for (var _i = 0, _a = this.config.NetworkAdapters; _i < _a.length; _i++) {
                var inf = _a[_i];
                var ip = this.getAddress(interfaces[inf], type);
                //console.log(ts()+"utils.js utils.getIpAddress ip: " + ip.toString() + ", type: " + type.toString());
                if (ip)
                    return ip;
            }
            return this.config.IpAddress;
        };

        utils.isPi = function () {
            try {
                var f = utils.execSync('cat /proc/device-tree/model').toString();
                if (f.includes('Raspberry Pi'))
                    return true;
            }
            catch (ex) {
                try {
                    var model = require('rpi-version')();
                    if (typeof model != "undefined")
                        return true;
                }
                catch (ex) {
                }
            }
            return false;
        };
        utils.isPi3 = function () {
            try {
                let f = execSync('sudo cat /proc/device-tree/model').toString();
                if (f.includes('Raspberry Pi 3'))
                    return true;
            }
            catch (ex) {
                return false;
            }
            return false;
        };
        utils.isPi4 = function () {
            try {
                let f = execSync('sudo cat /proc/device-tree/model').toString();
                if (f.includes('Raspberry Pi 4'))
                    return true;
            }
            catch (ex) {
                return false;
            }
            return false;
        };
        utils.notPi = function () {
            return /^win/.test(process.platform) || /^darwin/.test(process.platform);
        };

        utils.isWindows = function () {
            return /^win/.test(process.platform);
        };

        utils.isLinux = function () {
            return /^linux/.test(process.platform);
        };

        utils.isMac = function () {
            return /^darwin/.test(process.platform);
        };

        //utils.execSync = function (cmd) {
        //    utils.log.debug(ts() + "utils.js execSync('" + cmd + "'");
        //    return utils.notPi() ? "" : require('child_process').execSync(cmd);
        //};

        utils.spawn = function (cmd, args, options) {
            utils.log.debug(ts() + "utils.js spawn(" + cmd + ", " + args + ", " + options + ")");
            if (utils.notPi()) {
                return new DummyProcess();
            }
            else {
                return child_process_1.spawn(cmd, args, options);
            }
        };

        utils.cleanup = function (callback) {
            callback = callback || (function () { });
            process.on('cleanup', callback);
            process.on('exit', function () {
                process.emit('cleanup');
            });
            process.on('SIGINT', function () {
                console.log(ts() + 'Ctrl-C...');
                process.exit(2);
            });
            process.on('uncaughtException', function (e) {
                utils.log.error(ts() + 'utils.js Uncaught Exception... : %s', e.stack);
                process.exit(99);
            });
        };

        utils.uuid5 = function (str) {
            var out = crypto.createHash("sha1").update(str).digest();
            out[8] = out[8] & 0x3f | 0xa0;
            out[6] = out[6] & 0x0f | 0x50;
            var hex = out.toString("hex", 0, 16);
            return [
                hex.substring(0, 8),
                hex.substring(8, 12),
                hex.substring(12, 16),
                hex.substring(16, 20),
                hex.substring(20, 32)
            ].join("-");
        };

        utils.getAddress = function (ni, type) {
            ni = ni || [];
            var address = "";
            for (var _i = 0, ni_1 = ni; _i < ni_1.length; _i++) {
                var nif = ni_1[_i];
                if (nif.family == type)
                    address = nif.address;
            }
            return address;
        };
        utils.ts = function () {
            return ts();
        };
        utils.ts1 = function () {
            return ts1();
        };
        utils.logMemory = function logMemory() {
            if (typeof process != 'undefined') {
                let temp1 = `${ts1()}   -   Node: ${process.memoryUsage().heapUsed / Math.pow(1000, 2)} MB\n`
                fs.appendFile(process.cwd() + this.config.LOG + "LE880-node-memory.log", temp1, (err) => { if (err) throw err; });
            } else if (performance) {
                let temp2 = `${ts1()}   -   Browser: ${performance.memory.usedJSHeapSize / Math.pow(1000, 2)} MB\n`
                fs.appendFile(process.cwd() + this.config.LOG + "LE880-node-memory.log", temp2, (err) => { if (err) throw err; });
            }
        }
        utils.benchmarkPi = function () {
            let cmdCPU = "";
            cmdCPU = "vmstat ";
            cmdCPU += "10 ";
            cmdCPU += ">> " + this.config.LOG + "LE880-cpu-usage.log 2>&1 &";
            exec(cmdCPU, (error, stdout, stderr) => {
                if (error) {
                    utils.log.error(ts() + `utils.js benchmarkPi cmdCPU 3 error: ${error.message}, cmdCPU: ` + cmdCPU);
                    return;
                }
                if (stderr) {
                    utils.log.error(ts() + `utils.js benchmarkPi stderr: cmdCPU 3 ${stderr}, cmdCPU: ` + cmdCPU);
                    return;
                }
                utils.log.info(ts() + `utils.js benchmarkPi cmdCPU 3 stdout: ${stdout}, cmdCPU: ` + cmdCPU);
            });
        }
        utils.benchmarkNode = function benchmarkNode() {
            setInterval(function () {
                const arraySize = 25 * Math.pow(1000, 2);
                this.logMemory();
                (function () {
                    const array1 = new Array(arraySize).fill(1.1);
                    this.logMemory();
                })();
                (function () {
                    const array2 = new Array(arraySize).fill(1);
                    this.logMemory()
                })();
                setTimeout(() => {
                    this.logMemory();
                }, 5000);
            }, 10000);
        }
        utils.benchmarkHeat = function () {
            let cmdHEAT = "";
            cmdHEAT = `${this.config.scripts}LE880heat.sh `;
            cmdHEAT += " >> " + this.config.LOG + "LE880-cpu-heat.log 2>&1 &";
            setInterval(function () {
                // Run Command
                exec(cmdHEAT, (error, stdout, stderr) => {
                    if (error) {
                        utils.log.error(ts() + `utils.js cmdHEAT error: ${error.message}, cmdRace: ` + cmdHEAT);
                        return;
                    }
                    if (stderr) {
                        utils.log.error(ts() + `utils.js cmdHEAT stderr ${stderr}, cmdRace: ` + cmdHEAT);
                        return;
                    }
                    //utils.log.info(ts() + `utils.js benchmarkPi cmdRace 3 stdout: ${stdout}, cmdRace: ` + cmdHEAT);
                });
                // Run Command End
            }, 50000); // SetInterval
        }
        utils.execSync = function (callingFile, callingLocation, cmd) {
            //console.log(cmd)
            execSync(cmd, (error, stdout, stderr) => {
                if (error) {
                    utils.log.error(ts() + `${callingFile} ${callingLocation} error: ${error.message}, cmd: ` + cmd);
                    return;
                }
                if (stderr) {
                    utils.log.error(ts() + `${callingFile} ${callingLocation} stderr ${stderr}, cmd: ` + cmd);
                    return;
                }
                utils.log.info(ts() + `${callingFile} ${callingLocation} stdout: ${stdout}, cmd: ` + cmd);
            });
        }
        utils.exec = function (callingFile, callingLocation, cmd) {
            //console.log(cmdExec)
            exec(cmd, (error, stdout, stderr) => {
                if (error) {
                    utils.log.error(ts() + `${callingFile} ${callingLocation} error: ${error.message}, cmd: ` + cmd);
                    return;
                }
                if (stderr) {
                    utils.log.error(ts() + `${callingFile} ${callingLocation} stderr ${stderr}, cmd: ` + cmd);
                    return;
                }
                utils.log.info(ts() + `${callingFile} ${callingLocation} stdout: ${stdout}, cmd: ` + cmd);
            });
        }
        utils.play = function (callingFile, locationFile, playbackVolume) {
            let playFile = `sudo -u '#1000' XDG_RUNTIME_DIR=/run/user/1000 gst-launch-1.0 filesrc location=${locationFile} ! decodebin ! audioconvert ! audioresample ! audio/x-raw, rate=8000, channels=1, format=S32LE ! pulsesink device=alsa_output.platform-soc_sound.analog-stereo volume=${playbackVolume}`
            exec(playFile, (error, stdout, stderr) => {
                if (error) {
                    utils.log.error(ts() + `${callingFile} playFilePlayback error: ${error.message}, playFileRace: ` + playFile);
                    return;
                }
                if (stderr) {
                    utils.log.error(ts() + `${callingFile} playFilePlayback stderr ${stderr}, playFileRace: ` + playFile);
                    return;
                }
                utils.log.info(ts() + `${callingFile} playFilePlayback stdout: ${stdout}, playFileRace: ` + playFile);
            });
        }
        utils.log = {
            level: logLevel.Error,
            error: function (message) {
                var args = [];
                for (var _i = 1; _i < arguments.length; _i++) {
                    args[_i - 1] = arguments[_i];
                }
                if (utils.log.level > logLevel.None) {
                    message = clc.red(message);
                    console.log.apply(this, [message].concat(args));
                }
            },

            warn: function (message) {
                var args = [];
                for (var _i = 1; _i < arguments.length; _i++) {
                    args[_i - 1] = arguments[_i];
                }
                if (utils.log.level > logLevel.Error) {
                    message = clc.yellow(message);
                    console.log.apply(this, [message].concat(args));
                }
            },

            info: function (message) {
                var args = [];
                for (var _i = 1; _i < arguments.length; _i++) {
                    args[_i - 1] = arguments[_i];
                }
                if (utils.log.level > logLevel.Warn)
                    console.log.apply(this, [message].concat(args));
            },

            debug: function (message) {
                var args = [];
                for (var _i = 1; _i < arguments.length; _i++) {
                    args[_i - 1] = arguments[_i];
                }
                if (utils.log.level > logLevel.Info) {
                    message = clc.green(message);
                    console.log.apply(this, [message].concat(args));
                }
            },

            detail: function (message) {
                var args = [];
                for (var _i = 1; _i < arguments.length; _i++) {
                    args[_i - 1] = arguments[_i];
                }
                if (utils.log.level > logLevel.Debug) {
                    message = clc.cyan(message);
                    console.log.apply(this, [message].concat(args));
                }
            }

        };

        return utils;

    }());

    Utils.utils = utils;

})(Utils = exports.Utils || (exports.Utils = {}));

//# sourceMappingURL=utils.js.map
