"use strict";
const utils_1 = require('./utils');
const soap = require('soap');
const utils = utils_1.Utils.utils;
const fs = require('fs');
const util = require('util'); // inspect
const xmlFormat = require('xml-formatter');
function ts() {
    return new Date().YYYYMMDDHHMMSSmmm() + " : ";
}
function ts1() {
    return new Date().YYYYMMDDHHMMSSmmm();
}
var NOT_IMPLEMENTED = {
    Fault: {
        attributes: {
            'xmlns:ter': 'http://www.onvif.org/ver10/error',
        },
        Code: {
            Value: "soap:Sender",
            Subcode: {
                Value: "ter:NotAuthorized",
            },
        },
        Reason: {
            Text: {
                attributes: {
                    'xml:lang': 'en',
                },
                $value: 'Sender not Authorized',
            }
        }
    }
};

var SoapService = (function () {
    //function SoapService(config, server) {
    //function SoapService(config, configUser, server) {
    function SoapService(config, server) {
        utils.log.info(ts() + "SoapService.js function SoapService");
        //this.webserver = server;
        this.server = server;
        //utils.log.info(ts()+"SoapService.js server 1: " + util.inspect(server, {showHidden: false, depth: null}));
        this.config = config;
        //utils.log.info(ts()+"SoapService.js config 1: " + util.inspect(config, {showHidden: false, depth: null}));
        //delete require.cache[require.resolve(process.cwd() + "/LE880userConfig.json")];
        //var configUser 	= require(process.cwd() + "/LE880userConfig.json");
        //utils.log.info(ts()+"SoapService.js configUser : " + util.inspect(configUser, {showHidden: false, depth: null}));	
        //this.configUser = configUser;
        this.serviceInstance = null;
        this.startedCallbacks = [];
        this.isStarted = false;
        this.serviceOptions = {
            path: '',
            services: null,
            xml: null,
            wsdlPath: '',
            uri: '',
            onReady: function () { }
        };
    }
    SoapService.prototype.starting = function () { };
    SoapService.prototype.started = function () { };
    SoapService.prototype.start = function () {
        var _this = this;
        this.starting();
        //utils.log.info(ts() + "SoapService.js this.server 2: " + util.inspect(this.server, { showHidden: false, depth: null }));
        //this.config = config;
        //utils.log.info(ts()+"SoapService.js start this.config 2: " + util.inspect(this.config, {showHidden: false, depth: null}));
        utils.log.info(ts() + "SoapService.js start Binding %s to " + this.config.OnvifHTTPorHTTPS + "://%s:%s%s", this.constructor.name, utils.getIpAddress(), this.config.OnvifServicePort, this.serviceOptions.path);
        var onReady = this.serviceOptions.onReady;
        this.serviceOptions.onReady = function () {
            utils.log.info(ts() + "SoapService.js onReady");
            _this._started();
            onReady();
        };
        //utils.log.info(ts()+"SoapService.js this.server 3: " + this.server);
        //this.serviceInstance = soap.listen(this.webserver, this.serviceOptions);
        this.serviceInstance = soap.listen(this.server, this.serviceOptions);
        this.serviceInstance.on('headers', function (headers, methodName) {
            //utils.log.detail("SoapService.js current headers:" + JSON.stringify(headers));
            //utils.log.detail("SoapService.js current methodName:" + methodName);
            //utils.log.info("SoapService.js current methodName:" + methodName);
            delete require.cache[require.resolve("/home/pi/LE880-Profile-T/LE880userConfig.json")];
            let configUser = require("/home/pi/LE880-Profile-T/LE880userConfig.json");
            /* return if preAuth functions */
            let preAuthFunctions = ["GetSystemDateAndTime", "GetHostname", "GetCapabilities", "Capabilities","GetEndpointReference","GetServiceCapabilities","GetServices","GetScopes"]
            if (preAuthFunctions.includes(methodName)) {
                //utils.log.detail("SoapService.js preAuthFunction contains methodName:" + methodName);
                return;
            }
            /*
            if (configUser.VMSConfiguration == "salient")
                return;
            */
            if (configUser.VMSConfiguration == "bosch" && (methodName === "GetUsers"
                || methodName === "GetDeviceInformation" || methodName === "GetDiscoveryMode" || methodName === "GetProfiles"
                || methodName === "GetNetworkDefaultGateway" || methodName === "GetNetworkInterfaces" || methodName === "GetNetworkProtocols"
                || methodName === "GetVideoSourceConfigurations" || methodName === "GetVideoEncoderConfigurations"
                || methodName === "GetAudioSourceConfigurations" || methodName === "GetAudioEncoderConfigurations"
                || methodName === "GetAudioEncoderConfigurations")) return;
            //if (configUser.VMSConfiguration == "bosch" && !(methodName === "GetDeviceInformation" || methodName === "GetCapabilities" || methodName === "GetRelayOutputs" || methodName === "GetProfiles")) return;
            /*
            || methodName === "GetVideoSources" || methodName === "GetProfiles"
            || methodName === "GetDiscoveryMode" || methodName === "GetNetworkProtocols" || methodName === "GetHostname" || methodName === "GetNetworkDefaultGateway" || methodName === "GetNetworkInterfaces" || methodName === "GetRelayOutputs"))
                return;
                */
            if (_this.config.RTSPUsername) {
                delete require.cache[require.resolve("/home/pi/LE880-Profile-T/LE880factoryConfig.json")];
                let credentials = require("/home/pi/LE880-Profile-T/LE880factoryConfig.json");
                if (headers.Security == undefined) throw NOT_IMPLEMENTED;
                let token = headers.Security.UsernameToken;
                let user = token.Username;
                //utils.log.debug(ts() + "SoapService.js user: " + user);
                let password = (token.Password.$value || token.Password);
                //utils.log.debug(ts() + "SoapService.js password: " + password);
                let nonce = (token.Nonce.$value || token.Nonce);
                let created = token.Created;
                //var onvif_username = _this.config.Username;
                let onvif_username = credentials.RTSPUsername;
                //utils.log.debug(ts() + "SoapService.js onvif_username: " + onvif_username);
                //var onvif_password = _this.config.Password;
                let onvif_password = credentials.RTSPPassword;
                //utils.log.debug(ts() + "SoapService.js onvif_password: " + onvif_password);
                let crypto = require('crypto');
                let pwHash = crypto.createHash('sha1');
                let rawNonce = new Buffer.from(nonce || '', 'base64');
                let combined_data = Buffer.concat([rawNonce,
                    Buffer.from(created, 'ascii'), Buffer.from(onvif_password, 'ascii')]);
                pwHash.update(combined_data);
                let generated_password = pwHash.digest('base64');
                //utils.log.debug(ts() + "SoapService.js generated_password: " + generated_password);
                let password_ok = (user === onvif_username && password === generated_password);
                if (password_ok == false) {
                    utils.log.info(ts() + 'SoapService.js Invalid username/password with ' + methodName);
                    throw NOT_IMPLEMENTED;
                } /*else {
                    utils.log.info(ts() + 'SoapService.js Valid username/password with ' + methodName);
                }*/
            }
        });
        this.serviceInstance.on("request", function (request, methodName) {
            //utils.log.info(ts() + 'SoapService.js %s received request %s', _this.constructor.name, methodName);
            //console.log("REQUEST: " + JSON.stringify(request)); // && methodName != "Unsubscribe"
            // && methodName != "CreatePullPointSubscription" && methodName != "Unsubscribe" && methodName != "Renew"
            if (methodName != "PullMessages") utils.log.info(ts() + 'SoapService.js %s received request %s request.body: %s', _this.constructor.name, methodName, JSON.stringify(request.Body));
            //utils.log.detail(`${ts()} request.body: ${JSON.stringify(request.Body)}`);
        });
        this.serviceInstance.log = function (type, data) {
            //if (_this.config.logSoapCalls){
            if (_this.config.logSoapCalls == "true") {
                if (type == "info") {
                    utils.log.info(ts() + 'SoapService.js %s - Calltype : %s, data : %s', _this.constructor.name, type, data);
                } else {
                    utils.log.debug(ts() + 'SoapService.js %s - Calltype : \n%s, data : %s\n', _this.constructor.name, type, data);
                    if (data) {  // data is object NOT xml
                        try {
                            utils.log.debug(ts() + 'SoapService.js if(data) %s - Calltype : %s, try data :\n\n%s\n\n', _this.constructor.name, type, util.inspect(data, { showHidden: false, depth: null }));
                        }
                        catch (err) {
                            utils.log.debug(ts() + 'SoapService.js if(data) err: %s\n%s - Calltype : %s, catch data :\n\n%s\n\n', err, _this.constructor.name, type, data.toString());
                        }
                    }
                }
            }
        };
    };
    SoapService.prototype.onStarted = function (callback) {
        if (this.isStarted)
            callback();
        else
            this.startedCallbacks.push(callback);
    };
    SoapService.prototype._started = function () {
        this.isStarted = true;
        for (var _i = 0, _a = this.startedCallbacks; _i < _a.length; _i++) {
            var callback = _a[_i];
            callback();
        }
        this.startedCallbacks = [];
        this.started();
    };
    return SoapService;
}());
module.exports = SoapService;
