"use strict";

const { clearTimeout } = require("timers");
const utils_1 = require("./utils");
const utils = utils_1.Utils.utils;
function ts() {
    return new Date().YYYYMMDDHHMMSSmmm() + " : ";
}
const NOT_FOUND = {
    Fault: {
        Code: {
            Value: "soap:client"
        },
        Reason: {
            Text: "ResourceUnknownFault"
        }
    }
};
function tsONVIF(terminationTime) {
    let date = new Date();
    if (terminationTime) {
        //PT1M60S
        try {
            date.setDate(date.getDate() + 1);
            //date.setTime(3600000);
        } catch (e) {
            console.log(e);
        }
        //date.setSeconds(date.getSeconds + 60);
    }
    let string = date.toISOString();
    date = null;
    return string;
}
/*
function NotificationClass(){
    this.subscriptions = {}
}*/
//
// GOING TO EXPAND ALL THIS TO ASYNC ETC BUT IT WORKS FOR NOW 0.2.0
//
let digitalInputs = ["DI1", "DI2"];
let relays = ["OPLED", "OP1", "OP2", "OP3", "OP4"];
function createMessage(data, init) {
    const { state, token } = data;
    let source, topic;
    console.log("createMessage: " + JSON.stringify(data));
    if (digitalInputs.includes(token)) {
        topic = "DigitalInput"
        source = "InputToken"
    }
    else if (relays.includes(token)) {
        topic = "Relay"
        source = "RelayToken"
    } else {
        return;
    }
    let message = {
        CurrentTime: tsONVIF(),
        TerminationTime: tsONVIF('1'),
        NotificationMessage: {
            Topic: `tns1:Device/Trigger/${topic}`,
            Message: {
                Message: {
                    attributes: {
                        UtcTime: tsONVIF(),
                        PropertyOperation: `${(init) ? "Initialized" : "Changed"}`
                    },
                    Source: {
                        SimpleItem: {
                            attributes: {
                                Name: source,
                                Value: `${token}`
                            }
                        }
                    },
                    Data: {
                        SimpleItem: {
                            attributes: {
                                Name: "LogicalState",
                                Value: `${state}`
                            }
                        }
                    }
                }
            }
        }
    };
    return message;
}

let tokens = []

function createToken(token) {
    if (digitalInputs.includes(token)) return {
        topic: "DigitalInput",
        token: token,
        state: "open",
        source: "InputToken",
    }
    else if (digitalInputs.includes(token)) return {
        topic: "Relay",
        token: token,
        state: "open",
        source: "RelayToken",
    }
}
function initialize(array) {
    for (let token of digitalInputs.concat(relays)) {
        array.push(createMessage({ token, state: false }, true));
    }
    console.log("Array :" + array);
}
let notifications = []

class NotificationClass {
    constructor() {
        this.subscriptions = {}
        initialize(notifications);
    };
    unsubscribe(index) {
        delete this.subscriptions[index];
    }
    synchronize(index) {
        let array;
        if (array = this.subscriptions[index]) {
            initialize(array);
        }
    }
    createAlert(token, state) {
        //console.log("NotificationClass createAlert: " + token + " " + state);
        let base = {
            CurrentTime: tsONVIF(),
            TerminationTime: tsONVIF('1'),
            NotificationMessage: {
                Topic: "tns1:Device/Trigger/DigitalInput",
                Message: {
                    Message: {
                        attributes: {
                            UtcTime: tsONVIF(),
                            PropertyOperation: "Changed"
                        },
                        Source: {
                            SimpleItem: {
                                attributes: {
                                    Name: "InputToken",
                                    Value: `${token}`
                                }
                            }
                        },
                        Data: {
                            SimpleItem: {
                                attributes: {
                                    Name: "LogicalState",
                                    Value: `${state}`
                                }
                            }
                        }
                    }
                }
            }
        };
        for (let key of Object.keys(this.subscriptions)) {
            this.subscriptions[key].push(base);
        }
        //this.subscriptions["1"].push(base);
        return;// base;
    };
    async getMessage(subscription, timeout) {
        //console.log("NotificationClass getMessage: " + subscription);
        let _this = this;
        var getMessagePromise = new Promise((resolve, reject) => {
            let count = 0;
            if (_this.subscriptions[subscription] == undefined) {
                _this.createBaseMessage(subscription);
                return resolve(_this.subscriptions[subscription].shift());
            }
            else if (_this.subscriptions[subscription].length > 0) {
                return resolve(_this.subscriptions[subscription].shift());
            }


            const emptyMessage = setTimeout(function () {
                _this.emptyMessage(subscription);
                //}, timeout + 20000, _this, subscription);
            }, (timeout) ? timeout - 1000 : 5000, _this, subscription);


            const checkInterval = setInterval(function () {
                if (_this.subscriptions[subscription] && _this.subscriptions[subscription].length > 0) {
                    clearTimeout(emptyMessage);
                    clearInterval(checkInterval);
                    return resolve(_this.subscriptions[subscription].shift());
                }
            }, 500, _this, subscription, emptyMessage);

            //clearTimeout(emptyMessage);
            /*if (_this.subscriptions[subscription].length > 0) {
                return resolve(_this.subscriptions[subscription].shift());
            }*/
        });
        return await getMessagePromise;
        /*getMessage.then((message) => {
            console.log(JSON.stringify(message));
            return message;
        });*/
        /*const waitingForItem = new Promise((resolve, reject) => {
            while (_this.subscriptions[subscription].length == 0) {

            }
            return resolve(_this.subscriptions[subscription].shift());
        })
        const timeout = new Promise((resolve, reject) => {

        });*/
        /*
                Promise.any([empty, waitingForItem, timeout])
                    .then((message) => {
                        return message;
                    }).catch((e) => {
                        console.log(e);
                    })*/
        /*while (true) {
            if (this.subscriptions[subscription] == undefined) {
                this.createBaseMessage(subscription)
                //return undefined;
                clearTimeout(timeout);
                return this.subscriptions[subscription].shift();
            }
            else if (this.subscriptions[subscription].length > 0) {

                
                clearTimeout(timeout);
                return this.subscriptions[subscription].shift();
            }
        }*/
    };
    createBaseMessage(subscription) {
        //console.log("NotificationClass createBaseMessage: " + subscription);
        this.subscriptions[subscription] = [...notifications];
        return;
        /*for (let i = 1; i <= 2; i++) {
            let base = {
                CurrentTime: tsONVIF(),
                TerminationTime: tsONVIF('1'),
                NotificationMessage: {
                    Topic: "tns1:Device/Trigger/DigitalInput",
                    Message: {
                        Message: {
                            attributes: {
                                UtcTime: tsONVIF(),
                                PropertyOperation: "Initialized"
                            },
                            Source: {
                                SimpleItem: {
                                    attributes: {
                                        Name: "InputToken",
                                        Value: `DI${i}`
                                    }
                                }
                            },
                            Data: {
                                SimpleItem: {
                                    attributes: {
                                        Name: "LogicalState",
                                        Value: false
                                    }
                                }
                            }
                        }
                    }
                }
            };
            this.subscriptions[subscription].push(base);
            */
        //console.log('Arry:' + i + " " + this.subscriptions[subscription]);
        //};
        //console.log('Arry:' + this.subscriptions[subscription]);
        //this.subscriptions[subscription].append(base);
        //return;
    };
    emptyMessage(subscription) {
        //console.log("NotificationClass emptyMessage");
        let base = {
            CurrentTime: tsONVIF(),
            TerminationTime: tsONVIF('1')
        };
        try {
            this.subscriptions[subscription].push(base);
        } catch (e) {
            utils.log.error(ts() + `NotificationProducer.js emptyMessage subscription: ${subscription} error: ${e}`);
            throw NOT_FOUND;
        }
        return;
        //return base;
    };
}
/*
NotificationClass.prototype.getMessage = function (subscription) {
    console.log("NotificationClass getMessage: " + subscription);
    if (this.subscriptions[subscription] == undefined) {
        this.createBaseMessage(subscription)
        return this.subscriptions[subscription].pop();
    }
    else if (this.subscriptions[subscription].length > 0) {
        return this.subscriptions[subscription].pop();
    }
    else {
        return undefined;
    }
};
NotificationClass.prototype.createBaseMessage = function (subscription) {
    console.log("NotificationClass createBaseMessage: " + subscription);
    this.subscriptions[subscription] = new Array();
    for (let i = 1; i <= 2; i++) {
        let base = '<?xml version="1.0" encoding="utf-8"?>'
        base += '<soap:Envelope xmlns:soap="http://www.w3.org/2003/05/soap-envelope" xmlns:i0="http://www.onvif.org/ver10/events/wsdl" xmlns:tns="http://tempuri.org/" xmlns:tns1="http://www.onvif.org/ver10/topics" xmlns:tm="http://microsoft.com/wsdl/mime/textMatching/" xmlns:wsntw="http://docs.oasis-open.org/wsn/bw-2" xmlns:wsnt="http://docs.oasis-open.org/wsn/b-2" xmlns:wstop="http://docs.oasis-open.org/wsn/t-1" xmlns:tev="http://www.onvif.org/ver10/events/wsdl" xmlns:wsrf-rw="http://docs.oasis-open.org/wsrf/rw-2" xmlns:tt="http://www.onvif.org/ver10/schema" xmlns:wsrf-r="http://docs.oasis-open.org/wsrf/r-2">'
        base += '<soap:Body>'
        base += '<tev:PullMessagesResponse xmlns:tev="http://www.onvif.org/ver10/events/wsdl" xmlns="http://www.onvif.org/ver10/events/wsdl">'
        base += `<tev:CurrentTime>${tsONVIF()}</tev:CurrentTime>`
        base += `<tev:TerminationTime>${tsONVIF(1)}</tev:TerminationTime>`
        base += '<wsnt:NotificationMessage xmlns:wsnt="http://docs.oasis-open.org/wsn/b-2">'
        base += '<wsnt:Topic>tns1:Device/Trigger/DigitalInput</wsnt:Topic>'
        base += '<wsnt:Message>'
        base += '<tt:Message '
        base += `UtcTime="${tsONVIF()}" `
        base += 'PropertyOperation="Initialized" xmlns:tt="http://www.onvif.org/ver10/schema">'
        base += '<tt:Source>'
        base += `<tt:SimpleItem Name="InputToken" Value="DI${i}"></tt:SimpleItem>`
        base += '</tt:Source>'
        base += '<tt:Data>'
        base += '<tt:SimpleItem Name="LogicalState" Value="false">'
        base += '</tt:SimpleItem>'
        base += '</tt:Data>'
        base += '</tt:Message>'
        base += '</wsnt:Message>'
        base += '</wsnt:NotificationMessage>'
        base += '</tev:PullMessagesResponse>'
        base += '</soap:Body>'
        base += '</soap:Envelope>'
        this.subscriptions[subscription].push(base);
        console.log('Arry:' + i + " " + this.subscriptions[subscription]);
    }
    //console.log('Arry:' + this.subscriptions[subscription]);
    //this.subscriptions[subscription].append(base);
    return;
};
NotificationClass.prototype.emptyMessage = function () {
    console.log("NotificationClass emptyMessage");
    let base = '<?xml version="1.0" encoding="utf-8"?>'
    base += '<soap:Envelope xmlns:soap="http://www.w3.org/2003/05/soap-envelope" xmlns:i0="http://www.onvif.org/ver10/events/wsdl" xmlns:tns="http://tempuri.org/" xmlns:tns1="http://www.onvif.org/ver10/topics" xmlns:tm="http://microsoft.com/wsdl/mime/textMatching/" xmlns:wsntw="http://docs.oasis-open.org/wsn/bw-2" xmlns:wsnt="http://docs.oasis-open.org/wsn/b-2" xmlns:wstop="http://docs.oasis-open.org/wsn/t-1" xmlns:tev="http://www.onvif.org/ver10/events/wsdl" xmlns:wsrf-rw="http://docs.oasis-open.org/wsrf/rw-2" xmlns:tt="http://www.onvif.org/ver10/schema" xmlns:wsrf-r="http://docs.oasis-open.org/wsrf/r-2">'
    base += '<soap:Body>'
    base += '<tev:PullMessagesResponse xmlns:tev="http://www.onvif.org/ver10/events/wsdl" xmlns="http://www.onvif.org/ver10/events/wsdl">'
    base += `<tev:CurrentTime>${tsONVIF()}</tev:CurrentTime>`
    base += `<tev:TerminationTime>${tsONVIF(1)}</tev:TerminationTime>`
    base += '<wsnt:NotificationMessage xmlns:wsnt="http://docs.oasis-open.org/wsn/b-2">'
    base += '<wsnt:Topic>tns1:Device/Trigger/DigitalInput</wsnt:Topic>'
    base += '<wsnt:Message>'
    base += '</wsnt:Message>'
    base += '</wsnt:NotificationMessage>'
    base += '</tev:PullMessagesResponse>'
    base += '</soap:Body>'
    base += '</soap:Envelope>'
    return base;
};*/
/*
NotificationClass.prototype.createAlert = function (token, state) {
    console.log("NotificationClass createAlert: " + token + " " + state);
    let base = '<?xml version="1.0" encoding="utf-8"?>'
    base += '<soap:Envelope xmlns:soap="http://www.w3.org/2003/05/soap-envelope" xmlns:i0="http://www.onvif.org/ver10/events/wsdl" xmlns:tns="http://tempuri.org/" xmlns:tns1="http://www.onvif.org/ver10/topics" xmlns:tm="http://microsoft.com/wsdl/mime/textMatching/" xmlns:wsntw="http://docs.oasis-open.org/wsn/bw-2" xmlns:wsnt="http://docs.oasis-open.org/wsn/b-2" xmlns:wstop="http://docs.oasis-open.org/wsn/t-1" xmlns:tev="http://www.onvif.org/ver10/events/wsdl" xmlns:wsrf-rw="http://docs.oasis-open.org/wsrf/rw-2" xmlns:tt="http://www.onvif.org/ver10/schema" xmlns:wsrf-r="http://docs.oasis-open.org/wsrf/r-2">'
    base += '<soap:Body>'
    base += '<tev:PullMessagesResponse xmlns:tev="http://www.onvif.org/ver10/events/wsdl" xmlns="http://www.onvif.org/ver10/events/wsdl">'
    base += `<tev:CurrentTime>${tsONVIF()}</tev:CurrentTime>`
    base += `<tev:TerminationTime>${tsONVIF(1)}</tev:TerminationTime>`
    base += '<wsnt:NotificationMessage xmlns:wsnt="http://docs.oasis-open.org/wsn/b-2">'
    base += '<wsnt:Topic>tns1:Device/Trigger/DigitalInput</wsnt:Topic>'
    base += '<wsnt:Message>'
    base += '<tt:Message '
    base += `UtcTime="${tsONVIF()}" `
    base += 'PropertyOperation="Changed" xmlns:tt="http://www.onvif.org/ver10/schema">'
    base += '<tt:Source>'
    base += `<tt:SimpleItem Name="InputToken" Value="${token}"></tt:SimpleItem>`
    base += '</tt:Source>'
    base += '<tt:Data>'
    base += `<tt:SimpleItem Name="LogicalState" Value="${state}">`
    base += '</tt:SimpleItem>'
    base += '</tt:Data>'
    base += '</tt:Message>'
    base += '</wsnt:Message>'
    base += '</wsnt:NotificationMessage>'
    base += '</tev:PullMessagesResponse>'
    base += '</soap:Body>'
    base += '</soap:Envelope>'
    for (let key in Object.keys(this.subscriptions)) {
        this.subscriptions[key].push(base);
    }
    //this.subscriptions["1"].push(base);
    return base;
};*/
/*
NotificationClass.prototype.triggerAlert = function (index) {
    let that = this;
    that.createAlert(index, "true");
    setTimeout(function () {
        that.createAlert(index, "false");
    }, 10000, that);
};
*/


var NotificationProducer = (function () {
    function NotificationProducer(webserver, nc) {
        if (webserver == null) {
            console.log("Webserver is null");

        }
        if (nc == null) {
            console.log("NC is null");
        }
        this.server = webserver;
        let NotificationClass = nc;
        //const NC = require('./NotificationProducer').NotificationClass;
        //var NotificationClass = new NC();
        this.server.post('/onvif/subscription_service', function (req, res) {
            //console.log(req.body.toString());
            res.set('Content-Type', 'application/soap+xml');
            if (req && req.query && req.query.idx) {
                let timeout;
                if (req && req.body && req.body.timeout) {
                    timeout = req.body.timeout;
                } else {
                    timeout = 5000;
                }
                let message = NotificationClass.getMessage(req.query.idx);
                if (message == undefined) {
                    setTimeout(function () {
                        res.send(NotificationClass.emptyMessage());
                    }, timeout);
                } else {
                    //if (message != undefined) {
                    setTimeout(function () {
                        res.send(message);
                    }, 50);
                    //}
                }

            }

            /*let response = '<?xml version="1.0" encoding="utf-8"?>'
            response += '<soap:Envelope xmlns:soap="http://www.w3.org/2003/05/soap-envelope" xmlns:i0="http://www.onvif.org/ver10/events/wsdl" xmlns:tns="http://tempuri.org/" xmlns:tns1="http://www.onvif.org/ver10/topics" xmlns:tm="http://microsoft.com/wsdl/mime/textMatching/" xmlns:wsntw="http://docs.oasis-open.org/wsn/bw-2" xmlns:wsnt="http://docs.oasis-open.org/wsn/b-2" xmlns:wstop="http://docs.oasis-open.org/wsn/t-1" xmlns:tev="http://www.onvif.org/ver10/events/wsdl" xmlns:wsrf-rw="http://docs.oasis-open.org/wsrf/rw-2" xmlns:tt="http://www.onvif.org/ver10/schema" xmlns:wsrf-r="http://docs.oasis-open.org/wsrf/r-2">'
            response += '<soap:Body>'
            response += '<tev:PullMessagesResponse xmlns:tev="http://www.onvif.org/ver10/events/wsdl" xmlns="http://www.onvif.org/ver10/events/wsdl">'
            response += '<tev:CurrentTime> 2023-03-27T18:00:58.519Z </tev:CurrentTime>'
            response += '<tev:TerminationTime>2023-03-28T18:00:58.519Z</tev:TerminationTime>'
            response += '<wsnt:NotificationMessage xmlns:wsnt="http://docs.oasis-open.org/wsn/b-2">'
            response += '<wsnt:Topic>tns1:Device/Trigger/DigitalInput</wsnt:Topic>'
            response += '<wsnt:Message>'
            response += '<tt:Message '
            response += 'UtcTime="2023-03-27T18:00:58.519Z" '
            response += 'PropertyOperation="Changed" xmlns:tt="http://www.onvif.org/ver10/schema">'
            response += '<tt:Source>'
            response += '<tt:SimpleItem Name="InputToken" Value="IP1"></tt:SimpleItem>'
            response += '</tt:Source>'
            response += '<tt:Data>'
            response += '<tt:SimpleItem Name="LogicalState" Value="true">'
            response += '</tt:SimpleItem>'
            response += '</tt:Data>'
            response += '</tt:Message>'
            response += '</wsnt:Message>'
            response += '</wsnt:NotificationMessage>'
            response += '</tev:PullMessagesResponse>'
            response += '</soap:Body>'
            response += '</soap:Envelope>'
            //response = response.replace(/\n/g, " ");*/
            /*setTimeout(function () {
                res.send(response);
            }, 5000);*/
            return;
        });
        /*setInterval(function () {
            NotificationClass.triggerAlert(1);
        }, 30000)*/

    }//NotificationProducer
    return NotificationProducer;
}());
module.exports = NotificationProducer;
module.exports.NotificationClass = NotificationClass;
