"use strict";
var utils_1 = require(process.cwd() + '/lib/utils');
const fs = require('fs');
const parser = require('body-parser');
const utils = utils_1.Utils.utils;
const util = require('util'); // inspect



module.exports.onvif = function (userSettings) {
  var filePath = process.cwd() + "/views/components/onvif.html";
  var content = fs.readFileSync(filePath);
  var html = content.toString();
  return html;
}; // OnvifExport.prototype.buildOnvifHTML


module.exports.help = function (userSettings) {
  var filePath = process.cwd() + "/views/components/help.html";
  var content = fs.readFileSync(filePath);
  var html = content.toString();
  return html;
}; // HelpExport.prototype.buildHelpHTML

module.exports.update = function () {
  var filePath = process.cwd() + "/views/components/update.html";
  var content = fs.readFileSync(filePath);
  var html = content.toString();
  return html;
}; // UpdateExport.prototype.buildUpdateHTML

module.exports.system = function (userSettings) {
  var filePath = process.cwd() + "/views/components/system.html";
  var content = fs.readFileSync(filePath);
  var html = content.toString();
  html = html.replace("{{deviceIP}}", utils.getIpAddress());
  delete require.cache[require.resolve(process.cwd() + "/LE880factoryConfig.json")];
  var factoryConfig = require(process.cwd() + "/LE880factoryConfig.json");
  html = html.replace("{{firmwareVersion}}", factoryConfig["DeviceInformation"].FirmwareVersion);
  delete require.cache[require.resolve(process.cwd() + "/LE880userConfig.json")];
  var userConfig = require(process.cwd() + "/LE880userConfig.json");
  let currVal = "";
  if (userConfig['setMask'] == "") {
    currVal = "24";
  }
  else currVal = userConfig['setMask'];
  for (let i = 8; i <= 32; i++) {
    var currMask = (i == currVal) ? "selected" : "";
    html = html.replace('{{SM' + i + '_selected}}', currMask);
  }
  return html;
}; // SystemExport.prototype.buildSystemHTML
module.exports.onvif = function (userSettings) {
  delete require.cache[require.resolve("../public/ajax/userSettings.json")];
  var userSettings = require("../public/ajax/userSettings.json");
  var filePath = process.cwd() + "/views/components/onvif.html";
  //utils.log.info(ts()+"onvifPlayers.js filePath: " + filePath);
  var content = fs.readFileSync(filePath);
  //utils.log.info(ts()+"onvifPlayers.js content: " + content);
  var html = content.toString();
  html = html.replace('{{onvifHTML}}', content);
  return html;
}; // onvifPlayersExport.prototype.buildonvifPlayersHTML

module.exports.pa = function (userSettings) {
  delete require.cache[require.resolve("../public/ajax/userSettings.json")];
  var userSettings = require("../public/ajax/userSettings.json");
  var filePath = process.cwd() + "/views/components/pa.html";
  //utils.log.info(ts()+"paPlayers.js filePath: " + filePath);
  var content = fs.readFileSync(filePath);
  //utils.log.info(ts()+"paPlayers.js content: " + content);
  var html = content.toString();
  html = html.replace('{{paHTML}}', content);
  return html;
}; // paPlayersExport.prototype.buildpaPlayersHTML

module.exports.recordings = function (userSettings) {
  var filePath = process.cwd() + "/views/components/recordings.html";
  //utils.log.info(ts()+"MediaPlayers.js filePath: " + filePath);
  var content = fs.readFileSync(filePath);
  //utils.log.info(ts()+"MediaPlayers.js content: " + content);
  var html = content.toString();
  //html = html.replace('{{recordingsHTML}}', content);
  return html;
}; // MediaPlayersExport.prototype.buildMediaPlayersHTML

module.exports.playback = function () {
  var filePath = process.cwd() + "/views/components/playback.html";
  var content = fs.readFileSync(filePath);
  var html = content.toString();
  return html;
}; // UpdateExport.prototype.buildUpdateHTML

module.exports.sip = function () {
  delete require.cache[require.resolve(process.cwd() + "/LE880userConfig.json")];
  var configUser = require(process.cwd() + "/LE880userConfig.json");
  var configSip = configUser["SIPInformation"]
  var filePath = process.cwd() + "/views/components/sip.html";
  var content = fs.readFileSync(filePath);
  var html = content.toString();
  html = html.replace('{{enable_sip_checked}}', (configSip['auto_start'] == 'enabled') ? 'checked' : "")
  html = html.replace('{{sip_ip}}', configSip['ip'] || "")
  html = html.replace('{{sip_user}}', configSip['username'] || "")
  html = html.replace('{{sip_pw}}', configSip['password'] || "")
  html = html.replace('{{sip_cp}}', configSip['control_port'] || "")
  html = html.replace('{{sip_rtp_start}}', configSip['rtp_start'] || "")
  html = html.replace('{{sip_rtp_end}}', configSip['rtp_end'] || "")
  return html;
}; // UpdateExport.prototype.buildUpdateHTML
