/* GStreamer
 * Copyright (C) 2008 Wim Taymans <wim.taymans at gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin St, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */
 /*
  * compile:
  *
  * cd ~/LE880-Profile-T/c
  *
  * gcc LE880-rtsp-server-02BAK.c $(pkg-config --cflags --libs gstreamer-rtsp-server-1.0 gstreamer-webrtc-1.0 gstreamer-app-1.0 gstreamer-sdp-1.0 libsoup-2.4 json-glib-1.0) -o LE880-rtsp-server-02 -lgstrtsp-1.0
  * 
cd ~/LE880-Profile-T/c && gcc LE880-rtsp-server-02.c $(pkg-config --cflags --libs gstreamer-1.0 gstreamer-rtsp-server-1.0 gstreamer-webrtc-1.0 gstreamer-app-1.0 gstreamer-sdp-1.0 libsoup-2.4 json-glib-1.0) -o LE880-rtsp-server-02 -lgstrtsp-1.0
  * run: -lgstrtsp-1.0
  *
  * see LE888main.js LE880export.prototype.startRtsp
  *
  */

#include <gst/gst.h>
#include <gst/gstelement.h>
#include <gst/gstbin.h>
#include <gst/audio/audio.h>
#include <gst/base/gstpushsrc.h>
#include <gst/base/gstbasesrc.h>
//#include <gst/core/gstfilesrc.h>
//#include <plugins/elements/gstfilesrc.h>
#include <gst/audio/gstaudiobasesrc.h>
#include <gst/gstmultifilesrc.h>
#include <gst/rtsp-server/rtsp-client.h>
#include <gst/rtsp-server/rtsp-server.h>
#include <gst/rtsp-server/rtsp-media.h>
#include <gst/rtsp-server/rtsp-media-factory.h>
#include <gst/rtsp-server/rtsp-stream.h>
#include <gst/rtsp-server/rtsp-onvif-server.h>
#include <gst/rtsp-server/rtsp-context.h>
#include <gst/rtsp-server/rtsp-sdp.h>
#include <gst/rtsp-server/rtsp-params.h>
#include <gst/app/gstappsrc.h>
#include <gst/app/gstappsink.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#define DEFAULT_RTSP_ADDRESS "localhost"
#define DEFAULT_RTSP_PORT "8998"
#define DEFAULT_DISABLE_RTCP FALSE
#define DEFAULT_ENABLE_GEN_KEY FALSE
#define DEFAULT_ENABLE_DSP FALSE
#define DEFAULT_ENABLE_HALF_DUPLEX FALSE
#define DEFAULT_ENABLE_ALAW FALSE
#define DEFAULT_RTSP_USERNAME "LE880"
#define DEFAULT_RTSP_PASSWORD "LE880"
GST_DEBUG_CATEGORY_STATIC (my_category);
#define GST_CAT_DEFAULT my_category
#define GST_RTSP_MEDIA_FACTORY_LOCK(f)           (g_mutex_lock(GST_RTSP_MEDIA_FACTORY_GET_LOCK(f)))
#define GST_RTSP_MEDIA_FACTORY_UNLOCK(f)         (g_mutex_unlock(GST_RTSP_MEDIA_FACTORY_GET_LOCK(f)))
#define S16LE_8000_CAPS             gst_caps_from_string("audio/x-raw, format=(string)S16LE, layout=(string)interleaved, rate=(int)8000, channels=(int)1")
#define S16LE_16000_CAPS             gst_caps_from_string("audio/x-raw, format=(string)S16LE, layout=(string)interleaved, rate=(int)16000, channels=(int)1")
#define MULAW_CAPS             gst_caps_from_string("audio/x-mulaw, rate=(int)8000, channels=(int)1")
#define H264_CAPS             gst_caps_from_string("video/x-h264, stream-format=(string)avc, alignment=(string)au")

//#define gst_pipeline_parent_class parent_class G_DEFINE_TYPE_WITH_CODE (GstPipeline, gst_pipeline, GST_TYPE_BIN, G_ADD_PRIVATE (GstPipeline) _do_init);

#define gst_rtsp_media_parent_class parent_class G_DEFINE_TYPE_WITH_CODE (GstRTSPMedia, gst_rtsp_media, GST_TYPE_BIN, _do_init);

typedef struct _GstBinClass GstBinClass;
typedef struct
{
  GstElement *appsink, *appsrc;
  guint sourceid;
  GstCaps *caps;
} AppSinkSrcData;

typedef struct
{
  guint count;
  gboolean flag;
  guint trans;
} StreamData;

typedef struct
{
  guint id;
  GstBin *bin;
  GstElement *pulsesrc;
  gboolean mute;
  guint timeout;
} HalfDuplex;

typedef struct _PipelineData
{
  GstElement *videosink, *audiosink;
  GstElement *pipeline;
  gchar *multicastip;
  GstBin *audiobin, *videobin;
  GstElement *audiot, *videot;
  GList *audiolist;
  GList *videolist;
  GstPad *videopad, *audiopad;
  gint index;
  GstRTSPStreamTransport * ptrans;
  GstRTSPSessionMedia * pmedia;
  GObject * rtpsess;
} PipelineData;
typedef struct _GstAppSrcPrivate
{
  GstCaps * current_caps;
} GstAppSrcPrivate;

typedef struct _GstRTSPClientPrivate
{
   GstRTSPMedia * media;
   GstRTSPClientSendFunc send_func;
   GstRTSPClientSendMessagesFunc send_messages_func;
   gpointer send_data;
} GstRTSPClientPrivate;

typedef struct _StreamTransData
{
  GstRTSPStream * stream;
  GstRTSPStreamTransport * trans;
} StreamTransData;


static char * address = (char * ) DEFAULT_RTSP_ADDRESS;
static char * port = (char * ) DEFAULT_RTSP_PORT;
static char * username = (char * ) DEFAULT_RTSP_USERNAME;
static char * password = (char * ) DEFAULT_RTSP_PASSWORD;
static char * framerate = (char * ) "";
static gboolean enable_gen_key = DEFAULT_ENABLE_GEN_KEY;
static gboolean enable_dsp = DEFAULT_ENABLE_DSP;
static gboolean enable_half_duplex = DEFAULT_ENABLE_HALF_DUPLEX;
static gboolean disable_rtcp = DEFAULT_DISABLE_RTCP;
static char * h264_pipeline = "";
static char * pulse_pipeline = "";
static char * g711_pipeline = "";
static char * aac_pipeline = "";
static char * backchannel_pipeline = "";
static char * http_pipeline = "";
static char * multicast_ip = "";
//static char * ending_octets = "";
GstRTSPServer * server;

static GstPadProbeReturn
appsrc_pad_probe (GstPad * pad, GstPadProbeInfo * info, gpointer user_data);
static GstPadProbeReturn
appsink_pad_probe (GstPad * pad, GstPadProbeInfo * info, gpointer user_data);
void need_data (GstAppSrc * appsrc, guint length, gpointer * user_data);
void enough_data (GstAppSrc * appsrc, gpointer * user_data);


GstElement * gst_rtsp_latency_bin_new (GstElement * element);
static gboolean setup_rtpbin(GstRTSPMedia * media, GstElement * rtpbin);
void
gst_rtsp_media_set_enable_rtcp (GstRTSPMedia * media, gboolean enable);

static gboolean
gst_base_src_default_query (GstBaseSrc * src, GstQuery * query);
static void
gst_base_src_class_init (GstBaseSrcClass * klass);
#define gst_push_src_parent_class push_parent_class G_DEFINE_TYPE_WITH_CODE (GstPushSrc, gst_push_src, GST_TYPE_BASE_SRC, _do_init);
typedef struct _GstRTSPMediaPrivate
{
  gboolean enable_rtcp;
} GstRTSPMediaPrivate;

#define TRICKMODE_FLAGS (GST_SEEK_FLAG_TRICKMODE | GST_SEEK_FLAG_TRICKMODE_KEY_UNITS | GST_SEEK_FLAG_TRICKMODE_FORWARD_PREDICTED)
/*
G_DEFINE_TYPE_WITH_PRIVATE (GstPulsePullSrc, gst_pulsepullsrc, GstPulseSrc);

struct _GstAudioSrcRingBufferClass
{
  GstPulsePullSrcClass parent_class;
};*/
/*
#define gst_pulsepullsrc_parent_class parent_class G_DEFINE_TYPE_WITH_CODE (GstPulsePullSrc, gst_pulsepullsrc, GstPulseSrc, _do_init);
/*#define _do_init \
    GST_DEBUG_CATEGORY_INIT (gst_pulse_pull_src_debug, "pulsepullsrc", 0, \
        "pulsepullsrc element");*/
/*GST_DEBUG_CATEGORY_STATIC (gst_pulse_pull_src_debug);
#define GST_CAT_DEFAULT gst_pulse_pull_src_debug*/
/*
G_DECLARE_FINAL_TYPE (GstPulsePullSrc, gst_pulsepullsrc, GST, PULSEPULLSRC, GstPulseSrc)
struct _GstPulsePullSrc{
  GstPulseSrc src;
}

struct _GstPulsePullSrcClass {
  GstPulseSrcClass parent_class;

  gpointer _gst_reserved[GST_PADDING];
};
*/
typedef struct _GstPulseSrcClass
{
  GstAudioSrcClass parent_class;
} GstPulseSrcClass;
/*
struct _GstMultiFileSrcClass
{
  GstPushSrcClass parent_class;
} GstMultiFileSrcClass;
*/
